/*
 * Decompiled with CFR 0.152.
 */
package ddf.mimin.javasound;

import ddf.mimin.javasound.BasicMetaData;
import ddf.mimin.javasound.JSAudioRecording;
import ddf.mimin.javasound.JSAudioRecordingClip;
import ddf.mimin.javasound.JSAudioSample;
import ddf.mimin.javasound.JSAudioStream;
import ddf.mimin.javasound.JSAudioSynthesizer;
import ddf.mimin.javasound.JSBaseAudioRecordingStream;
import ddf.mimin.javasound.JSBufferedSampleRecorder;
import ddf.mimin.javasound.JSMPEGAudioRecordingStream;
import ddf.mimin.javasound.JSPCMAudioRecordingStream;
import ddf.mimin.javasound.JSStreamingSampleRecorder;
import ddf.mimin.javasound.MP3MetaData;
import ddf.mimin.javasound.MpegAudioFileReader;
import ddf.mimin.javasound.MpegAudioFileReaderWorkaround;
import ddf.mimin.javasound.SampleSignal;
import ddf.minim.AudioSample;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.Recordable;
import ddf.minim.spi.AudioRecording;
import ddf.minim.spi.AudioRecordingStream;
import ddf.minim.spi.AudioStream;
import ddf.minim.spi.AudioSynthesizer;
import ddf.minim.spi.MinimServiceProvider;
import ddf.minim.spi.SampleRecorder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import processing.core.PApplet;

public class JSMinim
implements MinimServiceProvider {
    private boolean debug = false;
    private PApplet app;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public JSMinim(PApplet parent) {
        this.app = parent;
    }

    public void start() {
    }

    public void stop() {
    }

    public void debugOn() {
        this.debug = true;
    }

    public void debugOff() {
        this.debug = false;
    }

    void debug(String s) {
        if (this.debug) {
            PApplet.println((String)"==== JavaSound Minim Debug ====");
            String[] lines = s.split("\n");
            int i = 0;
            while (i < lines.length) {
                PApplet.println((String)("==== " + lines[i]));
                ++i;
            }
            PApplet.println();
        }
    }

    void error(String s) {
        PApplet.println((String)"==== JavaSound Minim Error ====");
        String[] lines = s.split("\n");
        int i = 0;
        while (i < lines.length) {
            PApplet.println((String)("==== " + lines[i]));
            ++i;
        }
        PApplet.println();
    }

    public SampleRecorder getSampleRecorder(Recordable source, String fileName, boolean buffered) {
        String ext = fileName.substring(fileName.indexOf(46) + 1).toLowerCase();
        this.debug("createRecorder: file extension is " + ext + ".");
        AudioFileFormat.Type fileType = null;
        if (ext.equals(Minim.WAV.getExtension())) {
            fileType = Minim.WAV;
        } else if (ext.equals(Minim.AIFF.getExtension()) || ext.equals("aif")) {
            fileType = Minim.AIFF;
        } else if (ext.equals(Minim.AIFC.getExtension())) {
            fileType = Minim.AIFC;
        } else if (ext.equals(Minim.AU.getExtension())) {
            fileType = Minim.AU;
        } else if (ext.equals(Minim.SND.getExtension())) {
            fileType = Minim.SND;
        } else {
            this.error("The extension " + ext + " is not a recognized audio file type.");
            return null;
        }
        Object recorder = null;
        recorder = buffered ? new JSBufferedSampleRecorder(this, this.app.sketchPath(fileName), fileType, source.getFormat(), source.bufferSize()) : new JSStreamingSampleRecorder(this, this.app.sketchPath(fileName), fileType, source.getFormat(), source.bufferSize());
        return recorder;
    }

    public AudioRecordingStream getAudioRecordingStream(String filename, int bufferSize) {
        JSBaseAudioRecordingStream mstream = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        this.debug("Reading from " + ais.getClass().toString());
        if (ais != null) {
            this.debug("File format is: " + ais.getFormat().toString());
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                AudioInputStream decAis = this.getAudioInputStream(format, ais);
                SourceDataLine line = this.getSourceDataLine(format, bufferSize);
                if (decAis != null && line != null) {
                    Long dur;
                    Map props = this.getID3Tags(filename);
                    long lengthInMillis = -1L;
                    if (props.containsKey("duration") && (dur = (Long)props.get("duration")) > 0L) {
                        lengthInMillis = dur / 1000L;
                    }
                    MP3MetaData meta = new MP3MetaData(filename, lengthInMillis, props);
                    mstream = new JSMPEGAudioRecordingStream(this, meta, ais, decAis, line, bufferSize);
                }
            } else {
                SourceDataLine line = this.getSourceDataLine(format, bufferSize);
                if (line != null) {
                    long length = AudioUtils.frames2Millis((long)ais.getFrameLength(), (AudioFormat)format);
                    BasicMetaData meta = new BasicMetaData(filename, length);
                    mstream = new JSPCMAudioRecordingStream(this, meta, ais, line, bufferSize);
                }
            }
        }
        return mstream;
    }

    private Map getID3Tags(String filename) {
        this.debug("Getting the properties.");
        Map props = new HashMap();
        try {
            MpegAudioFileReader reader = new MpegAudioFileReader(this);
            InputStream stream = this.app.createInput(filename);
            AudioFileFormat baseFileFormat = reader.getAudioFileFormat(stream, stream.available());
            stream.close();
            if (baseFileFormat instanceof TAudioFileFormat) {
                TAudioFileFormat fileFormat = (TAudioFileFormat)baseFileFormat;
                props = fileFormat.properties();
                if (props.size() == 0) {
                    this.error("No file properties available for " + filename + ".");
                } else {
                    this.debug("File properties: " + props.toString());
                }
            }
        }
        catch (UnsupportedAudioFileException e) {
            this.error("Couldn't get the file format for " + filename + ": " + e.getMessage());
        }
        catch (IOException e) {
            this.error("Couldn't access " + filename + ": " + e.getMessage());
        }
        return props;
    }

    public AudioStream getAudioStream(int type, int bufferSize, float sampleRate, int bitDepth) {
        if (bitDepth != 8 && bitDepth != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat format = new AudioFormat(sampleRate, bitDepth, type, true, false);
        TargetDataLine line = this.getTargetDataLine(format, bufferSize * 4);
        if (line != null) {
            return new JSAudioStream(line, bufferSize);
        }
        return null;
    }

    public AudioSample getAudioSample(String filename, int bufferSize) {
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            BasicMetaData meta = null;
            AudioFormat format = ais.getFormat();
            FloatSampleBuffer samples = null;
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
                Map props = this.getID3Tags(filename);
                long dur = (Long)props.get("duration");
                int toRead = (int)AudioUtils.millis2Bytes((long)(dur / 1000L), (AudioFormat)format);
                samples = this.loadFloatAudio(ais, toRead);
                meta = new MP3MetaData(filename, dur / 1000L, props);
            } else {
                samples = this.loadFloatAudio(ais, (int)ais.getFrameLength() * format.getFrameSize());
                long length = AudioUtils.frames2Millis((long)samples.getSampleCount(), (AudioFormat)format);
                meta = new BasicMetaData(filename, length);
            }
            AudioSynthesizer out = this.getAudioSynthesizer(format.getChannels(), bufferSize, format.getSampleRate(), format.getSampleSizeInBits());
            if (out != null) {
                SampleSignal ssig = new SampleSignal(samples);
                out.setAudioSignal((AudioSignal)ssig);
                return new JSAudioSample(meta, ssig, out);
            }
            this.error("Couldn't acquire an output.");
        }
        return null;
    }

    public AudioSynthesizer getAudioSynthesizer(int type, int bufferSize, float sampleRate, int bitDepth) {
        if (bitDepth != 8 && bitDepth != 16) {
            throw new IllegalArgumentException("Unsupported bit depth, use either 8 or 16.");
        }
        AudioFormat format = new AudioFormat(sampleRate, bitDepth, type, true, false);
        SourceDataLine sdl = this.getSourceDataLine(format, bufferSize);
        if (sdl != null) {
            return new JSAudioSynthesizer(sdl, bufferSize);
        }
        return null;
    }

    public AudioRecording getAudioRecordingClip(String filename) {
        Clip clip = null;
        BasicMetaData meta = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            DataLine.Info info;
            Class<?> clazz;
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("javax.sound.sampled.Clip");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (AudioSystem.isLineSupported(info = new DataLine.Info(clazz, ais.getFormat()))) {
                try {
                    clip = (Clip)AudioSystem.getLine(info);
                    clip.open(ais);
                }
                catch (Exception e) {
                    this.error("Error obtaining Javasound Clip: " + e.getMessage());
                    return null;
                }
                Map props = this.getID3Tags(filename);
                long lengthInMillis = -1L;
                if (props.containsKey("duration")) {
                    Long dur = (Long)props.get("duration");
                    lengthInMillis = dur / 1000L;
                }
                meta = new MP3MetaData(filename, lengthInMillis, props);
            } else {
                this.error("File format not supported.");
                return null;
            }
        }
        if (meta == null) {
            meta = new BasicMetaData(filename, clip.getMicrosecondLength() / 1000L);
        }
        return new JSAudioRecordingClip(clip, meta);
    }

    public AudioRecording getAudioRecording(String filename) {
        BasicMetaData meta = null;
        AudioInputStream ais = this.getAudioInputStream(filename);
        if (ais != null) {
            byte[] samples;
            AudioFormat format = ais.getFormat();
            if (format instanceof MpegAudioFormat) {
                AudioFormat baseFormat = format;
                format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
                ais = this.getAudioInputStream(format, ais);
                Map props = this.getID3Tags(filename);
                long dur = (Long)props.get("duration");
                int toRead = (int)AudioUtils.millis2Bytes((long)(dur / 1000L), (AudioFormat)format);
                samples = this.loadByteAudio(ais, toRead);
                meta = new MP3MetaData(filename, dur / 1000L, props);
            } else {
                samples = this.loadByteAudio(ais, (int)ais.getFrameLength() * format.getFrameSize());
                long length = AudioUtils.bytes2Millis((long)samples.length, (AudioFormat)format);
                meta = new BasicMetaData(filename, length);
            }
            SourceDataLine line = this.getSourceDataLine(format, 2048);
            if (line != null) {
                return new JSAudioRecording(samples, line, meta);
            }
        }
        return null;
    }

    FloatSampleBuffer loadFloatAudio(AudioInputStream ais, int toRead) {
        FloatSampleBuffer samples = new FloatSampleBuffer();
        int totalRead = 0;
        byte[] rawBytes = new byte[toRead];
        try {
            while (totalRead < toRead) {
                int actualRead = ais.read(rawBytes, totalRead, toRead - totalRead);
                if (actualRead < 1) break;
                totalRead += actualRead;
            }
            ais.close();
        }
        catch (Exception ioe) {
            this.error("Error loading file into memory: " + ioe.getMessage());
        }
        this.debug("Needed to read " + toRead + " actually read " + totalRead);
        this.debug("ais format is " + ais.getFormat().toString());
        samples.initFromByteArray(rawBytes, 0, totalRead, ais.getFormat());
        return samples;
    }

    byte[] loadByteAudio(AudioInputStream ais, int toRead) {
        int totalRead = 0;
        byte[] rawBytes = new byte[toRead];
        try {
            while (totalRead < toRead) {
                int actualRead = ais.read(rawBytes, totalRead, toRead - totalRead);
                if (actualRead < 1) break;
                totalRead += actualRead;
            }
            ais.close();
        }
        catch (Exception ioe) {
            this.error("Error loading file into memory: " + ioe.getMessage());
        }
        this.debug("Needed to read " + toRead + " actually read " + totalRead);
        return rawBytes;
    }

    AudioInputStream getAudioInputStream(String filename) {
        AudioInputStream ais = null;
        BufferedInputStream bis = null;
        if (filename.startsWith("http")) {
            try {
                ais = this.getAudioInputStream(new URL(filename));
            }
            catch (MalformedURLException e) {
                this.error("Bad URL: " + e.getMessage());
            }
            catch (UnsupportedAudioFileException e) {
                this.error("URL is in an unsupported audio file format: " + e.getMessage());
            }
            catch (IOException e) {
                Minim.error((String)("Error reading the URL: " + e.getMessage()));
            }
        } else {
            try {
                InputStream is = this.app.createInput(filename);
                this.debug("Base input stream is: " + is.toString());
                bis = new BufferedInputStream(is);
                ais = this.getAudioInputStream(bis);
                ais.mark(ais.available());
                this.debug("Acquired AudioInputStream.\nIt is " + ais.getFrameLength() + " frames long.\n" + "Marking support: " + ais.markSupported());
            }
            catch (IOException ioe) {
                this.error("IOException: " + ioe.getMessage());
            }
            catch (UnsupportedAudioFileException uafe) {
                this.error("Unsupported Audio File: " + uafe.getMessage());
            }
        }
        return ais;
    }

    AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        return new MpegAudioFileReaderWorkaround(this).getAudioInputStream(url, null);
    }

    AudioInputStream getAudioInputStream(InputStream is) throws UnsupportedAudioFileException, IOException {
        try {
            return AudioSystem.getAudioInputStream(is);
        }
        catch (Exception iae) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            return new MpegAudioFileReader(this).getAudioInputStream(is);
        }
    }

    AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        try {
            return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
        }
        catch (IllegalArgumentException iae) {
            this.debug("Using AppletMpegSPIWorkaround to get codec");
            try {
                Class.forName("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider");
                return new MpegFormatConversionProvider().getAudioInputStream(targetFormat, sourceStream);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("Mpeg codec not properly installed");
            }
        }
    }

    SourceDataLine getSourceDataLine(AudioFormat format, int bufferSize) {
        DataLine.Info info;
        SourceDataLine line = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.sound.sampled.SourceDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (AudioSystem.isLineSupported(info = new DataLine.Info(clazz, format))) {
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(format, bufferSize * format.getFrameSize() * 4);
                if (line.isOpen()) {
                    this.debug("SourceDataLine is " + line.getClass().toString() + "\n" + "Buffer size is " + line.getBufferSize() + " bytes.\n" + "Format is " + line.getFormat().toString() + ".");
                    return line;
                }
            }
            catch (LineUnavailableException e) {
                this.error("Couldn't open the line: " + e.getMessage());
            }
        }
        this.error("Unable to return a SourceDataLine: unsupported format - " + format.toString());
        return line;
    }

    TargetDataLine getTargetDataLine(AudioFormat format, int bufferSize) {
        DataLine.Info info;
        TargetDataLine line = null;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.sound.sampled.TargetDataLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (AudioSystem.isLineSupported(info = new DataLine.Info(clazz, format))) {
            try {
                line = (TargetDataLine)AudioSystem.getLine(info);
                line.open(format, bufferSize * format.getFrameSize());
                this.debug("TargetDataLine buffer size is " + line.getBufferSize() + "\n" + "TargetDataLine format is " + line.getFormat().toString() + "\n" + "TargetDataLine info is " + line.getLineInfo().toString());
            }
            catch (Exception e) {
                this.error("Error acquiring TargetDataLine: " + e.getMessage());
            }
        } else {
            this.error("Unable to return a TargetDataLine: unsupported format - " + format.toString());
        }
        return line;
    }
}

