/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.util.FPSAnimator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class VApplication {
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int DONT_CARE = -1;
    private JFrame frame;
    private GLCanvas glCanvas;
    private FPSAnimator animator;
    private boolean _fullscreen;
    private int _width;
    private int _height;
    private GraphicsDevice usedDevice;
    private VExceptionHandler exceptionHandler = new VExceptionHandler();

    public static VApplication createGLDisplay(String title) {
        return VApplication.createGLDisplay(title, new GLCapabilities());
    }

    public static VApplication createGLDisplay(String title, GLCapabilities caps) {
        boolean fullscreen = false;
        return new VApplication(title, 800, 600, fullscreen, caps);
    }

    private VApplication(String title, int width, int height, boolean fullscreen, GLCapabilities caps) {
        this.glCanvas = new GLCanvas(caps);
        this.glCanvas.setSize(width, height);
        this.glCanvas.setIgnoreRepaint(true);
        this.init(title, width, height, fullscreen);
    }

    public VApplication(int width, int height, boolean fullscreen) {
        GLCapabilities glCaps = new GLCapabilities();
        this._width = width;
        this._height = height;
        this._fullscreen = fullscreen;
        this.glCanvas = new GLCanvas(glCaps);
        this.glCanvas.setSize(width, height);
        this.glCanvas.setIgnoreRepaint(true);
    }

    public void init(String title, int width, int height, boolean fullscreen) {
        this.frame = new JFrame(title);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.glCanvas, "Center");
        this._fullscreen = fullscreen;
        this._width = width;
        this._height = height;
        this.animator = new FPSAnimator((GLAutoDrawable)this.glCanvas, 60);
        this.animator.setRunAsFastAsPossible(false);
    }

    public void start() {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setUndecorated(this._fullscreen);
            this.frame.addWindowListener(new VWindowAdapter());
            if (this._fullscreen) {
                this.usedDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                this.usedDevice.setFullScreenWindow(this.frame);
                this.usedDevice.setDisplayMode(this.findDisplayMode(this.usedDevice.getDisplayModes(), this._width, this._height, this.usedDevice.getDisplayMode().getBitDepth(), this.usedDevice.getDisplayMode().getRefreshRate()));
            } else {
                this.frame.setSize(this.frame.getContentPane().getPreferredSize());
                this.frame.setLocation((screenSize.width - this.frame.getWidth()) / 2, (screenSize.height - this.frame.getHeight()) / 2);
                this.frame.setVisible(true);
            }
            this.glCanvas.requestFocus();
            this.animator.start();
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
        }
    }

    public void stop() {
        try {
            try {
                this.animator.stop();
                if (this._fullscreen) {
                    this.usedDevice.setFullScreenWindow(null);
                    this.usedDevice = null;
                }
                this.frame.dispose();
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    private DisplayMode findDisplayMode(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        DisplayMode displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, requestedDepth, requestedRefreshRate);
        if (displayMode == null) {
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, requestedHeight, -1, -1);
        }
        if (displayMode == null) {
            displayMode = this.findDisplayModeInternal(displayModes, requestedWidth, -1, -1, -1);
        }
        if (displayMode == null) {
            displayMode = this.findDisplayModeInternal(displayModes, -1, -1, -1, -1);
        }
        return displayMode;
    }

    private DisplayMode findDisplayModeInternal(DisplayMode[] displayModes, int requestedWidth, int requestedHeight, int requestedDepth, int requestedRefreshRate) {
        DisplayMode displayModeToUse = null;
        int i = 0;
        while (i < displayModes.length) {
            DisplayMode displayMode = displayModes[i];
            if (!(requestedWidth != -1 && displayMode.getWidth() != requestedWidth || requestedHeight != -1 && displayMode.getHeight() != requestedHeight || requestedHeight != -1 && displayMode.getRefreshRate() != requestedRefreshRate || requestedDepth != -1 && displayMode.getBitDepth() != requestedDepth)) {
                displayModeToUse = displayMode;
            }
            ++i;
        }
        return displayModeToUse;
    }

    public void addGLEventListener(GLEventListener Listener) {
        this.glCanvas.addGLEventListener(Listener);
    }

    public void addKeyListener(KeyListener Listener) {
        this.glCanvas.addKeyListener(Listener);
    }

    private class VExceptionHandler {
        private VExceptionHandler() {
        }

        public void handleException(final Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    e.printStackTrace(printWriter);
                    JOptionPane.showMessageDialog(VApplication.this.frame, stringWriter.toString(), "Exception occurred", 0);
                    VApplication.this.stop();
                }
            });
        }
    }

    private class VWindowAdapter
    extends WindowAdapter {
        private VWindowAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            VApplication.this.stop();
        }
    }
}

