/*
 * Decompiled with CFR 0.152.
 */
package vitamin.scenesimple;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import vitamin.VTexture;
import vitamin.math.Matrix;
import vitamin.math.Vector2;
import vitamin.math.Vector3;
import vitamin.scenesimple.Material;
import vitamin.scenesimple.MeshChunk;
import vitamin.scenesimple.MultiMaterial;
import vitamin.scenesimple.Object;
import vitamin.scenesimple.StandardMaterial;
import vitamin.scenesimple.Triangle;
import vitamin.scenesimple.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mesh
extends Object {
    String _matName;
    Material _mat;
    ArrayList<Vertex> _vertexList;
    ArrayList<Triangle> _triangleList;
    ArrayList<Vector3> _triNormals;
    ArrayList<MeshChunk> _chunkList;
    boolean _hasTriStrip;
    int[] _triStripList;
    boolean _isVisble;

    public Mesh() {
        this._name = "Mesh";
        this._hasTriStrip = false;
        this._vertexList = null;
        this._triangleList = null;
        this._triNormals = null;
        this._chunkList = null;
        this._localMatrix = new Matrix();
    }

    public Mesh(String name) {
        this._name = name;
        this._hasTriStrip = false;
        this._vertexList = null;
        this._triangleList = null;
        this._triNormals = null;
        this._chunkList = null;
        this._localMatrix = new Matrix();
    }

    public void addVertex(float x, float y, float z) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(x, y, z);
        this._vertexList.add(v);
    }

    public void addVertex(Vector3 p) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(p);
        this._vertexList.add(v);
    }

    public void addVertex(Vector3 p, Vector3 n, Vector2 tex) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        Vertex v = new Vertex(p, n, tex);
        this._vertexList.add(v);
    }

    public void addVertex(Vertex v) {
        if (this._vertexList == null) {
            this._vertexList = new ArrayList();
        }
        this._vertexList.add(v);
    }

    public void addTriangle(int a, int b, int c) {
        if (this._triangleList == null) {
            this._triangleList = new ArrayList();
        }
        Triangle t = new Triangle(a, b, c);
        this._triangleList.add(t);
    }

    public void addTriangle(Triangle tri) {
        if (this._triangleList == null) {
            this._triangleList = new ArrayList();
        }
        this._triangleList.add(tri);
    }

    public void setMaterial(Material mat) {
        this._mat = mat;
        this._matName = this._mat._name;
    }

    public void computeNormals() {
        Vector3[] tmpNormals = new Vector3[this._triangleList.size()];
        this._triNormals = new ArrayList();
        int i = 0;
        while (i < this._triangleList.size()) {
            Triangle f = this._triangleList.get(i);
            Vector3 p0 = this._vertexList.get((int)f._a)._position;
            Vector3 p1 = this._vertexList.get((int)f._b)._position;
            Vector3 p2 = this._vertexList.get((int)f._c)._position;
            Vector3 e0 = Vector3.sub(p1, p0);
            Vector3 e1 = Vector3.sub(p2, p0);
            Vector3 normal = Vector3.cross(e1, e0);
            tmpNormals[i] = normal.copy();
            normal.normalize();
            this._triNormals.add(normal);
            ++i;
        }
        Vector3 n = new Vector3();
        int num = 0;
        int vi = 0;
        while (vi < this._vertexList.size()) {
            Vertex vertex = this._vertexList.get(vi);
            n.set(0.0f, 0.0f, 0.0f);
            int fi = 0;
            while (fi < this._triangleList.size()) {
                Triangle f = this._triangleList.get(fi);
                if (vi == f._a || vi == f._b || vi == f._c) {
                    ++num;
                    n.add(tmpNormals[fi]);
                }
                ++fi;
            }
            if (num > 1) {
                n.mul(1.0f / (float)num);
            }
            n.normalize();
            vertex._normal = n.copy();
            ++vi;
        }
        tmpNormals = null;
    }

    boolean ComputeTBNMatrix() {
        Vector3[] tan1 = new Vector3[this._vertexList.size()];
        Vector3[] tan2 = new Vector3[this._vertexList.size()];
        int i = 0;
        while (i < this._vertexList.size()) {
            tan1[i] = new Vector3();
            tan2[i] = new Vector3();
            ++i;
        }
        int fi = 0;
        fi = 0;
        while (fi < this._triangleList.size()) {
            Triangle t = this._triangleList.get(fi);
            int i1 = t._a;
            int i2 = t._b;
            int i3 = t._c;
            Vertex vert1 = this._vertexList.get(t._a);
            Vertex vert2 = this._vertexList.get(t._b);
            Vertex vert3 = this._vertexList.get(t._c);
            Vector3 v1 = vert1._position.copy();
            Vector3 v2 = vert2._position.copy();
            Vector3 v3 = vert3._position.copy();
            Vector2 w1 = vert1.getTexCoord();
            Vector2 w2 = vert2.getTexCoord();
            Vector2 w3 = vert3.getTexCoord();
            float Px = v2.x - v1.x;
            float Py = v2.y - v1.y;
            float Pz = v2.z - v1.z;
            float Qx = v3.x - v1.x;
            float Qy = v3.y - v1.y;
            float Qz = v3.z - v1.z;
            float s1 = w2.x - w1.x;
            float t1 = w2.y - w1.y;
            float s2 = w3.x - w1.x;
            float t2 = w3.y - w1.y;
            float r = 1.0f / (s1 * t2 - s2 * t1);
            Vector3 T = new Vector3((t2 * Px - t1 * Qx) * r, (t2 * Py - t1 * Qy) * r, (t2 * Pz - t1 * Qz) * r);
            Vector3 B = new Vector3((-s2 * Px + s1 * Qx) * r, (-s2 * Py + s2 * Qy) * r, (-s2 * Pz + s2 * Qz) * r);
            tan1[i1].add(T);
            tan1[i2].add(T);
            tan1[i3].add(T);
            tan2[i1].add(B);
            tan2[i2].add(B);
            tan2[i3].add(B);
            ++fi;
        }
        int vi = 0;
        vi = 0;
        while (vi < this._vertexList.size()) {
            Vector3 T = tan1[vi];
            Vector3 N = this._vertexList.get(vi).getPosition();
            float fDot = N.dot(T);
            Vector3 newT = T.copy();
            Vector3 Ntmp = Vector3.mul(N, fDot);
            newT.sub(Ntmp);
            newT.normalize();
            this._vertexList.get(vi).setTangent(newT.x, newT.y, newT.z);
            ++vi;
        }
        tan1 = null;
        tan2 = null;
        return true;
    }

    public void processChunks() {
        this._chunkList = new ArrayList();
        if (this._mat._type == Material.eMaterialType.STANDARD) {
            MeshChunk mc = new MeshChunk();
            mc._owner = this;
            mc._mat = this._mat;
            mc._numOfVertices = this._vertexList.size();
            mc._numOfTris = this._triangleList.size();
            mc._numOfIndices = this._triangleList.size() * 3;
            int i = 0;
            i = 0;
            while (i < this._triangleList.size()) {
                Triangle t = this._triangleList.get(i);
                mc._triList.add(t);
                mc._indexList.add(t._a);
                mc._indexList.add(t._b);
                mc._indexList.add(t._c);
                ++i;
            }
            this._chunkList.add(mc);
        } else if (this._mat._type == Material.eMaterialType.MULTI) {
            MultiMaterial mmat = (MultiMaterial)this._mat;
            int mi = 0;
            mi = 0;
            while (mi < mmat._numSubMaterials) {
                MeshChunk mc = new MeshChunk();
                mc._owner = this;
                mc._mat = (StandardMaterial)mmat._matList.get(mi);
                int i = 0;
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    if (mi == t._matId) {
                        mc._triList.add(t);
                        mc._indexList.add(t._a);
                        mc._indexList.add(t._b);
                        mc._indexList.add(t._c);
                    }
                    ++i;
                }
                this._chunkList.add(mc);
                ++mi;
            }
        }
    }

    public void renderChunks(GL gl) {
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                boolean hasTex = true;
                int i = 0;
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    }
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    }
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    }
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                MultiMaterial mmat = (MultiMaterial)this._mat;
                int i = 0;
                i = 0;
                while (i < mmat._numSubMaterials) {
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(i);
                    boolean hasTex = false;
                    try {
                        VTexture tex = smat._texList.get(0);
                        gl.glEnable(3553);
                        if (tex != null) {
                            gl.glBindTexture(3553, tex.getId());
                        }
                        hasTex = true;
                    }
                    catch (Exception e) {
                        hasTex = false;
                        gl.glDisable(3553);
                        gl.glBindTexture(3553, 0);
                    }
                    float[] emis = new float[]{smat._emissive.x, smat._emissive.y, smat._emissive.z, smat._emissive.w};
                    float[] amb = new float[]{smat._ambient.x, smat._ambient.y, smat._ambient.z, smat._ambient.w};
                    float[] diff = new float[]{smat._diffuse.x, smat._diffuse.y, smat._diffuse.z, smat._diffuse.w};
                    float[] spec = new float[]{smat._specular.x, smat._specular.y, smat._specular.z, smat._specular.w};
                    float[] shininess = new float[]{smat._specularLevel};
                    FloatBuffer fb = FloatBuffer.wrap(emis);
                    gl.glMaterialfv(1032, 5632, fb);
                    fb = FloatBuffer.wrap(amb);
                    gl.glMaterialfv(1032, 4608, fb);
                    fb = FloatBuffer.wrap(diff);
                    gl.glMaterialfv(1032, 4609, fb);
                    fb = FloatBuffer.wrap(spec);
                    gl.glMaterialfv(1032, 4610, fb);
                    fb = FloatBuffer.wrap(shininess);
                    gl.glMaterialfv(1032, 5633, fb);
                    MeshChunk mc = this._chunkList.get(i);
                    int ti = 0;
                    gl.glBegin(4);
                    ti = 0;
                    while (ti < mc._triList.size()) {
                        Triangle t = mc._triList.get(ti);
                        Vertex v0 = this._vertexList.get(t._a);
                        Vertex v1 = this._vertexList.get(t._b);
                        Vertex v2 = this._vertexList.get(t._c);
                        gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                        gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                        }
                        gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                        gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                        gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                        }
                        gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                        gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                        gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                        }
                        gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                        ++ti;
                    }
                    gl.glEnd();
                    ++i;
                }
            }
        }
    }

    public void renderChunksRaw(GL gl) {
        if (this._mat != null) {
            if (this._mat._type == Material.eMaterialType.STANDARD) {
                boolean hasTex = true;
                StandardMaterial smat = (StandardMaterial)this._mat;
                try {
                    VTexture tex = smat._texList.get(0);
                    gl.glEnable(3553);
                    if (tex != null) {
                        gl.glBindTexture(3553, tex.getId());
                    }
                    hasTex = true;
                }
                catch (Exception e) {
                    hasTex = false;
                    gl.glDisable(3553);
                    gl.glBindTexture(3553, 0);
                }
                int i = 0;
                gl.glBegin(4);
                i = 0;
                while (i < this._triangleList.size()) {
                    Triangle t = this._triangleList.get(i);
                    Vertex v0 = this._vertexList.get(t._a);
                    Vertex v1 = this._vertexList.get(t._b);
                    Vertex v2 = this._vertexList.get(t._c);
                    gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                    gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                    }
                    gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                    gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                    gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                    }
                    gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                    gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                    gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                    if (hasTex) {
                        gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                    }
                    gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                    ++i;
                }
                gl.glEnd();
            } else if (this._mat._type == Material.eMaterialType.MULTI) {
                MultiMaterial mmat = (MultiMaterial)this._mat;
                int i = 0;
                i = 0;
                while (i < mmat._numSubMaterials) {
                    StandardMaterial smat = (StandardMaterial)mmat._matList.get(i);
                    boolean hasTex = false;
                    try {
                        VTexture tex = smat._texList.get(0);
                        gl.glEnable(3553);
                        if (tex != null) {
                            gl.glBindTexture(3553, tex.getId());
                        }
                        hasTex = true;
                    }
                    catch (Exception e) {
                        hasTex = false;
                        gl.glDisable(3553);
                        gl.glBindTexture(3553, 0);
                    }
                    MeshChunk mc = this._chunkList.get(i);
                    int ti = 0;
                    gl.glBegin(4);
                    ti = 0;
                    while (ti < mc._triList.size()) {
                        Triangle t = mc._triList.get(ti);
                        Vertex v0 = this._vertexList.get(t._a);
                        Vertex v1 = this._vertexList.get(t._b);
                        Vertex v2 = this._vertexList.get(t._c);
                        gl.glColor4f(v0._color.x, v0._color.y, v0._color.z, v0._color.w);
                        gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v0._tangent.x, v0._tangent.y, v0._tangent.z);
                        gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
                        gl.glColor4f(v1._color.x, v1._color.y, v1._color.z, v1._color.w);
                        gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v1._tangent.x, v1._tangent.y, v1._tangent.z);
                        gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
                        gl.glColor4f(v2._color.x, v2._color.y, v2._color.z, v2._color.w);
                        gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
                        if (hasTex) {
                            gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
                        }
                        gl.glMultiTexCoord3f(33985, v2._tangent.x, v2._tangent.y, v2._tangent.z);
                        gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
                        ++ti;
                    }
                    gl.glEnd();
                    ++i;
                }
            }
        }
    }

    public void render(GL gl) {
        int i = 0;
        gl.glBegin(4);
        i = 0;
        while (i < this._triangleList.size()) {
            Triangle t = this._triangleList.get(i);
            Vertex v0 = this._vertexList.get(t._a);
            Vertex v1 = this._vertexList.get(t._b);
            Vertex v2 = this._vertexList.get(t._c);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
            gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
            gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
            gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
            gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glTexCoord2f(v2._texCoord.x, v2._texCoord.y);
            gl.glNormal3f(v2._normal.x, v2._normal.y, v2._normal.z);
            gl.glVertex3f(v2._position.x, v2._position.y, v2._position.z);
            ++i;
        }
        gl.glEnd();
    }

    public void renderStrips(GL gl) {
        int i = 0;
        gl.glBegin(5);
        i = 0;
        while (i < this._triStripList.length - 1) {
            int j = this._triStripList[i];
            int j1 = this._triStripList[i + 1];
            Vertex v0 = this._vertexList.get(j);
            Vertex v1 = this._vertexList.get(j1);
            gl.glNormal3f(v0._normal.x, v0._normal.y, v0._normal.z);
            gl.glTexCoord2f(v0._texCoord.x, v0._texCoord.y);
            gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
            gl.glNormal3f(v1._normal.x, v1._normal.y, v1._normal.z);
            gl.glTexCoord2f(v1._texCoord.x, v1._texCoord.y);
            gl.glVertex3f(v1._position.x, v1._position.y, v1._position.z);
            ++i;
        }
        gl.glEnd();
    }

    public void renderVertexNormals(GL gl, float scal) {
        gl.glDisable(2896);
        gl.glDisable(3553);
        int i = 0;
        i = 0;
        while (i < this._vertexList.size()) {
            Vertex v0 = this._vertexList.get(i);
            Vector3 N = Vector3.mul(v0._normal, scal);
            gl.glBegin(1);
            gl.glColor4f(1.0f, 0.0f, 1.0f, 0.75f);
            gl.glVertex3f(v0._position.x, v0._position.y, v0._position.z);
            gl.glVertex3f(v0._position.x + N.x, v0._position.y + N.y, v0._position.z + N.z);
            gl.glEnd();
            ++i;
        }
    }

    public void debug() {
        System.out.println("(Mesh)  ----------------------------");
        System.out.println("(Mesh)  mesh name: " + this._name);
        System.out.println("(Mesh)  num of vertices: " + this._vertexList.size());
        System.out.println("(Mesh)  num of triangles: " + this._triangleList.size());
        if (this._hasTriStrip) {
            System.out.println("(Mesh)  num of tristrips: " + this._triStripList.length);
        }
        System.out.println("(Mesh)  ----------------------------\n");
    }

    public String getName() {
        return this._name;
    }

    public boolean isVisible() {
        return this._isVisble;
    }

    public int getVertexCount() {
        return this._vertexList.size();
    }

    public int getTriangleCount() {
        return this._triangleList.size();
    }

    public Vertex getVertex(int idx) {
        return this._vertexList.get(idx);
    }

    public Triangle getTriangle(int idx) {
        return this._triangleList.get(idx);
    }

    public ArrayList<Vertex> getVertexList() {
        return this._vertexList;
    }

    public ArrayList<Triangle> getTriList() {
        return this._triangleList;
    }
}

