/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.awt.AWTException;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Robot;
import processing.core.PApplet;
import vitamin.math.Quaternion;
import vitamin.math.Vector3;
import vitamin.scenegraph.Camera;

public class VCamera
extends Camera {
    Vector3 _strafe;
    float _rotationAngle;
    float _speed;
    float _sensitivity;
    float _mx;
    float _my;
    float _mxdrag;
    float _mydrag;
    private PApplet parent;
    private Robot robot;

    public VCamera(PApplet p) {
        this._name = "DefaultCamera";
        this.parent = p;
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this._rotationAngle = 0.0f;
        this._position = new Vector3(0.0f, 0.0f, 10.0f);
        this._target = new Vector3();
        this._up = new Vector3(0.0f, 1.0f, 0.0f);
        this._strafe = new Vector3();
        this._speed = 5.0f;
        this._sensitivity = 0.2f;
    }

    public VCamera(PApplet p, String name) {
        this._name = name;
        this.parent = p;
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this._rotationAngle = 0.0f;
        this._position = new Vector3(0.0f, 0.0f, 10.0f);
        this._target = new Vector3();
        this._up = new Vector3(0.0f, 1.0f, 0.0f);
        this._strafe = new Vector3();
        this._speed = 5.0f;
        this._sensitivity = 0.2f;
    }

    public VCamera(PApplet p, String name, float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._name = name;
        this.parent = p;
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this._rotationAngle = 0.0f;
        this._position = new Vector3(ex, ey, ez);
        this._target = new Vector3(tx, ty, tz);
        this._up = new Vector3(ux, uy, uz);
        this._strafe = new Vector3();
        this._speed = 5.0f;
        this._sensitivity = 0.2f;
    }

    public VCamera(PApplet p, float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._name = "DefaultCamera";
        this.parent = p;
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this._rotationAngle = 0.0f;
        this._position = new Vector3(ex, ey, ez);
        this._target = new Vector3(tx, ty, tz);
        this._up = new Vector3(ux, uy, uz);
        this._strafe = new Vector3();
        this._speed = 5.0f;
        this._sensitivity = 0.2f;
    }

    public void move() {
        Vector3 eyeDirection = Vector3.sub(this._target, this._position);
        eyeDirection.normalize();
        this.update(eyeDirection, this._speed);
    }

    public void move(float speed) {
        Vector3 eyeDirection = Vector3.sub(this._target, this._position);
        eyeDirection.normalize();
        this.update(eyeDirection, speed);
    }

    public void lift() {
        Vector3 lift = new Vector3(0.0f, 1.0f, 0.0f);
        this.update(lift, this._speed);
    }

    public void lift(float speed) {
        Vector3 lift = new Vector3(0.0f, 1.0f, 0.0f);
        this.update(lift, speed);
    }

    public void strafe() {
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        this._strafe = Vector3.cross(view, this._up);
        this._strafe.normalize();
        this.update(this._strafe, this._speed);
    }

    public void strafe(float speed) {
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        this._strafe = Vector3.cross(view, this._up);
        this._strafe.normalize();
        this.update(this._strafe, speed);
    }

    private void update(Vector3 vdir, float speed) {
        Vector3 tmp = vdir.copy();
        tmp.mul(speed);
        this._position.add(tmp);
        this._target.add(tmp);
    }

    public void rotateQuat(Vector3 axis, float rotAngle) {
        Quaternion qRotate = new Quaternion();
        Quaternion qView = new Quaternion();
        qRotate.rotateAxis(axis, rotAngle);
        Vector3 view = Vector3.sub(this._target, this._position);
        qView.set(0.0f, view);
        Quaternion newView = Quaternion.mul(qRotate, qView);
        qRotate.conjugate();
        newView = Quaternion.mul(newView, qRotate);
        this._target.x = this._position.x + newView.x;
        this._target.y = this._position.y + newView.y;
        this._target.z = this._position.z + newView.z;
    }

    public void rotateByMouse(int mousePosX, int mousePosY, int midX, int midY) {
        float yDirection = 0.0f;
        float yRotation = 0.0f;
        if (this.parent.firstMouse) {
            return;
        }
        if (mousePosX == midX && mousePosY == midY) {
            return;
        }
        yDirection = (float)(midX - mousePosX) * this._sensitivity;
        yRotation = (float)(midY - mousePosY) * this._sensitivity;
        this._rotationAngle -= yRotation;
        if (this._rotationAngle > 90.0f) {
            this._rotationAngle = 90.0f;
            return;
        }
        if (this._rotationAngle < -90.0f) {
            this._rotationAngle = -90.0f;
            return;
        }
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        Vector3 axis = Vector3.cross(view, this._up);
        axis.normalize();
        this.rotateQuat(axis, yRotation * (float)Math.PI / 180.0f);
        this.rotateQuat(this._up, yDirection * (float)Math.PI / 180.0f);
        this.setToCenter();
    }

    public void rotateByMouse(int mouseX, int mouseY) {
        float yDirection = 0.0f;
        float yRotation = 0.0f;
        float mouseDeltaX = (this._mx - (float)mouseX) * this._sensitivity;
        float mouseDeltaY = (this._my - (float)mouseY) * this._sensitivity;
        yDirection = mouseDeltaX;
        yRotation = mouseDeltaY;
        this._rotationAngle -= yRotation;
        if (this._rotationAngle >= 80.0f) {
            this._rotationAngle = 80.0f;
            return;
        }
        if (this._rotationAngle <= -80.0f) {
            this._rotationAngle = -80.0f;
            return;
        }
        Vector3 view = Vector3.sub(this._target, this._position);
        view.normalize();
        Vector3 axis = Vector3.cross(view, this._up);
        axis.normalize();
        this.rotateQuat(axis, yRotation * (float)Math.PI / 180.0f);
        this.rotateQuat(this._up, yDirection * (float)Math.PI / 180.0f);
        this.updateRotate();
    }

    private void updateRotate() {
        this._mx = (float)((double)this._mx + (double)(this._mxdrag - this._mx) * 0.75);
        this._my = (float)((double)this._my + (double)(this._mydrag - this._my) * 0.75);
    }

    public void mousePressed() {
        this._mx = this.parent.mouseX;
        this._my = this.parent.mouseY;
        this._mxdrag = this.parent.mouseX;
        this._mydrag = this.parent.mouseY;
    }

    public void mouseDragged() {
        this._mxdrag = this.parent.mouseX;
        this._mydrag = this.parent.mouseY;
    }

    public void setSensitivity(float sense) {
        this._sensitivity = sense;
    }

    public void setSpeed(float speed) {
        this._speed = speed;
    }

    public void setPosition(float x, float y, float z) {
        this._position.x = x;
        this._position.y = y;
        this._position.z = z;
    }

    public void setPosition(Vector3 v) {
        this._position.x = v.x;
        this._position.y = v.y;
        this._position.z = v.z;
    }

    public void setMousePosition(float xScale, float yScale) {
        Point p = this.getWindowTopLeft();
        try {
            this.robot.mouseMove((int)(xScale * (float)this.parent.width + (float)p.x), (int)(yScale * (float)this.parent.height + (float)p.y));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setToCenter() {
        this.setMousePosition(0.5f, 0.5f);
    }

    public Vector3 getRelativePosition() {
        if (this.parent.firstMouse || this.parent.mouseX == 0 && this.parent.mouseY == 0) {
            return new Vector3(0.5f, 0.5f, 0.0f);
        }
        return new Vector3((float)this.parent.mouseX / (float)this.parent.width, (float)this.parent.mouseY / (float)this.parent.height, 0.0f);
    }

    public Point getWindowTopLeft() {
        Point p;
        try {
            p = this.parent.getLocationOnScreen();
        }
        catch (IllegalComponentStateException i) {
            p = new Point(this.parent.screen.width / 2 - this.parent.width / 2, this.parent.screen.height / 2 - this.parent.height / 2);
        }
        return p;
    }

    public Vector3 getPosition() {
        return this._position;
    }

    public Vector3 getTarget() {
        return this._target;
    }

    public Vector3 getUp() {
        return this._up;
    }
}

