/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import vitamin.Shader;
import vitamin.ShaderManager;
import vitamin.VGLext;
import vitamin.VLogger;
import vitamin.VSamplerState;
import vitamin.VStringUtil;
import vitamin.VTexture;
import vitamin.eFaceType;
import vitamin.math.Matrix;
import vitamin.math.Vector3;
import vitamin.math.Vector4;
import vitamin.scenesimple.MMLoader;
import vitamin.scenesimple.Scene;

public class VGL {
    public static final float BLACK = 0.0f;
    public static final float WHITE = 1.0f;
    public static final int PROJECTION = 0;
    public static final int MODELVIEW = 1;
    public static final int TEXTURE = 2;
    private static VGL _singleton;
    private boolean _debugMode;
    private VGLext _extensions;
    private boolean vSyncEnabled;
    boolean _useProcessing;
    private PApplet _parent;
    private GL _gl;
    private GLU _glu;
    public float _r;
    public float _g;
    public float _b;
    public float _a;
    boolean _flipV;
    private float _uScale;
    private float _vScale;
    private float _uOffset;
    private float _vOffset;
    private ShaderManager _shaderMan;
    private int _numTextures;
    private Map<Integer, VTexture> _texturePool;
    Matrix _projMatrix;
    Matrix _viewMatrix;
    Matrix _transposeProjMatrix;
    Matrix _transposeViewMatrix;

    private VGL() {
        this.init(null, null, null, false);
    }

    public VGL(PApplet parent) {
        this.init(parent, ((PGraphicsOpenGL)parent.g).gl, ((PGraphicsOpenGL)parent.g).glu, true);
    }

    public VGL(PApplet parent, boolean debugMode) {
        this.init(parent, ((PGraphicsOpenGL)parent.g).gl, ((PGraphicsOpenGL)parent.g).glu, true, debugMode);
    }

    public VGL(GL gl, GLU glu) {
        this.init(null, gl, glu, false);
    }

    public VGL(GL gl, GLU glu, boolean debugMode) {
        this.init(null, gl, glu, false, debugMode);
    }

    public void init(PApplet parent, GL gl, GLU glu, boolean useProcessingGL) {
        this._useProcessing = useProcessingGL;
        this._debugMode = false;
        if (useProcessingGL) {
            this._parent = parent;
            this._gl = gl;
            this._glu = glu;
        } else {
            this._parent = null;
            this._gl = gl;
            this._glu = glu;
        }
        this._uScale = 1.0f;
        this._vScale = 1.0f;
        this._flipV = false;
        this._uOffset = 0.0f;
        this._vOffset = 0.0f;
        this._r = 1.0f;
        this._g = 1.0f;
        this._b = 1.0f;
        this._a = 1.0f;
        this._extensions = new VGLext(this);
        this._shaderMan = new ShaderManager(this._gl);
    }

    public void init(PApplet parent, GL gl, GLU glu, boolean useProcessingGL, boolean debugMode) {
        this._useProcessing = useProcessingGL;
        this._debugMode = debugMode;
        if (debugMode) {
            VLogger.getSingleton().setFileName("vitamin.txt");
        }
        if (useProcessingGL) {
            this._parent = parent;
            this._gl = gl;
            this._glu = glu;
        } else {
            this._parent = null;
            this._gl = gl;
            this._glu = glu;
        }
        this._uScale = 1.0f;
        this._vScale = 1.0f;
        this._flipV = false;
        this._uOffset = 0.0f;
        this._vOffset = 0.0f;
        this._r = 1.0f;
        this._g = 1.0f;
        this._b = 1.0f;
        this._a = 1.0f;
        this._extensions = new VGLext(this);
        this._shaderMan = new ShaderManager(this._gl);
    }

    public GL gl() {
        return this._gl;
    }

    public GLU glu() {
        return this._glu;
    }

    public void setGL(GL gl) {
        this._gl = gl;
    }

    public void setGLU(GLU glu) {
        this._glu = glu;
    }

    public void begin() {
        if (this._parent == null && this._glu == null && this._glu == null) {
            System.err.println("(VGL)  Renderer hasn't been initialized. init() must be called before use.");
            return;
        }
        if (this._useProcessing) {
            this._glu = ((PGraphicsOpenGL)this._parent.g).glu;
            this._gl = ((PGraphicsOpenGL)this._parent.g).beginGL();
        }
    }

    public void begin(GL gl) {
        if (this._parent == null && this._glu == null && this._glu == null) {
            System.err.println("(VGL)  Renderer hasn't been initialized. init() must be called before use.");
            return;
        }
        if (this._useProcessing) {
            this._glu = ((PGraphicsOpenGL)this._parent.g).glu;
            this._gl = gl;
        }
    }

    public void end() {
        if (this._useProcessing) {
            ((PGraphicsOpenGL)this._parent.g).endGL();
        }
    }

    public void background(float c) {
        this._gl.glClearColor(c, c, c, 1.0f);
        this._gl.glClear(16640);
    }

    public void background(float r, float g, float b) {
        this._gl.glClearColor(r, g, b, 1.0f);
        this._gl.glClear(16640);
    }

    public void background(float r, float g, float b, float a) {
        this._gl.glClearColor(r, g, b, a);
        this._gl.glClear(16640);
    }

    public void ortho(float left, float right, float top, float bottom, float near, float far) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)near, (double)far);
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public void ortho() {
        this.ortho(-1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
    }

    public void ortho(float left, float right, float top, float bottom) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._gl.glOrtho((double)left, (double)right, (double)bottom, (double)top, -1.0, 1.0);
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._projMatrix = this.getProjMatrix();
        this._viewMatrix = this.getViewMatrix();
    }

    public void perspective(float fovy, float aspect, float nearZ, float farZ) {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
        this._glu.gluPerspective((double)fovy, (double)aspect, (double)nearZ, (double)farZ);
        this._projMatrix = this.getProjMatrix();
    }

    public void camera(float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)ex, (double)ey, (double)ez, (double)tx, (double)ty, (double)tz, (double)ux, (double)uy, (double)uz);
        this._viewMatrix = this.getViewMatrix();
    }

    public void camera(Vector3 e, Vector3 t, Vector3 u) {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
        this._glu.gluLookAt((double)e.x, (double)e.y, (double)e.z, (double)t.x, (double)t.y, (double)t.z, (double)u.x, (double)u.y, (double)u.z);
        this._viewMatrix = this.getViewMatrix();
    }

    public void viewport(int x2, int y2) {
        this.viewport(0, 0, x2, y2);
    }

    public void viewport(int x1, int y1, int x2, int y2) {
        this._gl.glViewport(x1, y1, x2, y2);
    }

    public void identity() {
        this.identity(1);
    }

    public void identity(int mode) {
        switch (mode) {
            case 0: {
                this._gl.glMatrixMode(5889);
                this._gl.glLoadIdentity();
                break;
            }
            case 1: {
                this._gl.glMatrixMode(5888);
                this._gl.glLoadIdentity();
                break;
            }
            case 2: {
                this._gl.glMatrixMode(5890);
                this._gl.glLoadIdentity();
                break;
            }
            default: {
                System.err.println("(VGL)  identity: parameter is not supported");
            }
        }
    }

    public void setProjectionMode() {
        this._gl.glMatrixMode(5889);
    }

    public void setViewMode() {
        this._gl.glMatrixMode(5888);
    }

    public void clearProjectionMatrix() {
        this._gl.glMatrixMode(5889);
        this._gl.glLoadIdentity();
    }

    public void clearViewMatrix() {
        this._gl.glMatrixMode(5888);
        this._gl.glLoadIdentity();
    }

    public void setMatrixState(int mode) {
        switch (mode) {
            case 0: {
                this._gl.glMatrixMode(5889);
                break;
            }
            case 1: {
                this._gl.glMatrixMode(5888);
                break;
            }
            case 2: {
                this._gl.glMatrixMode(5890);
                break;
            }
            default: {
                System.err.println("(VGL)  setMatrixState: parameter is not supported");
            }
        }
    }

    public Matrix getMatrix(int type) {
        Matrix m = new Matrix();
        m.identity();
        switch (type) {
            case 0: {
                this._gl.glGetFloatv(2983, m.getFloatBuffer());
                break;
            }
            case 1: {
                this._gl.glGetFloatv(2982, m.getFloatBuffer());
                break;
            }
            case 2: {
                this._gl.glGetFloatv(2984, m.getFloatBuffer());
                break;
            }
            default: {
                System.err.println("(VGL)  getMatrix: parameter is not supported");
            }
        }
        return m;
    }

    public Matrix getProjMatrix() {
        return this.getMatrix(0);
    }

    public Matrix getViewMatrix() {
        return this.getMatrix(1);
    }

    public Matrix getTextureMatrix() {
        return this.getMatrix(2);
    }

    public Matrix getTransposeProjMatrix() {
        Matrix m = new Matrix();
        this._gl.glGetFloatv(34020, m.getFloatBuffer());
        return m;
    }

    public Matrix getTransposeViewMatrix() {
        Matrix m = new Matrix();
        this._gl.glGetFloatv(34019, m.getFloatBuffer());
        return m;
    }

    public float[] getTransposeProjMatrixArray() {
        float[] m = new float[16];
        this._gl.glGetFloatv(34020, m, 0);
        return m;
    }

    public float[] getTransposeViewMatrixArray() {
        float[] m = new float[16];
        this._gl.glGetFloatv(34019, m, 0);
        return m;
    }

    public void translate(float x, float y) {
        this._gl.glTranslatef(x, y, 0.0f);
    }

    public void translate(float x, float y, float z) {
        this._gl.glTranslatef(x, y, z);
    }

    public void translate(Vector3 v) {
        this._gl.glTranslatef(v.x, v.y, v.z);
    }

    public void translate(Vector4 v) {
        this._gl.glTranslatef(v.x, v.y, v.z);
    }

    public void rotate(float a) {
        this._gl.glRotatef(a, 1.0f, 1.0f, 1.0f);
    }

    public void rotate(float a, float x, float y, float z) {
        this._gl.glRotatef(a, x, y, z);
    }

    public void rotate(float a, Vector3 v) {
        this._gl.glRotatef(a, v.x, v.y, v.z);
    }

    public void rotate(Vector4 v) {
        this._gl.glRotatef(v.w, v.x, v.y, v.z);
    }

    public void rotateX(float a) {
        this._gl.glRotatef(a, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float a) {
        this._gl.glRotatef(a, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float a) {
        this._gl.glRotatef(a, 0.0f, 0.0f, 1.0f);
    }

    public void scale(float sx, float sy, float sz) {
        this._gl.glScalef(sx, sy, sz);
    }

    public void scale(float s) {
        this._gl.glScalef(s, s, s);
    }

    public void loadMatrix(DoubleBuffer m) {
        this._gl.glLoadMatrixd(m);
    }

    public void loadMatrix(FloatBuffer m) {
        this._gl.glLoadMatrixf(m);
    }

    public void loadMatrix(Matrix m) {
        this._gl.glLoadMatrixf(m.getFloatBuffer());
    }

    public void multMatrix(DoubleBuffer m) {
        this._gl.glMultMatrixd(m);
    }

    public void multMatrix(FloatBuffer m) {
        this._gl.glMultMatrixf(m);
    }

    public void multMatrix(Matrix m) {
        FloatBuffer fb = FloatBuffer.wrap(m._M);
        this._gl.glMultMatrixf(fb);
    }

    public void pushMatrix() {
        this._gl.glPushMatrix();
    }

    public void popMatrix() {
        this._gl.glPopMatrix();
    }

    public void enableBlend() {
        this._gl.glEnable(3042);
    }

    public void disableBlend() {
        this._gl.glDisable(3042);
    }

    public void setBlend(boolean f) {
        if (f) {
            this._gl.glEnable(3042);
        } else {
            this._gl.glDisable(3042);
        }
    }

    public void setAlphaBlend() {
        this._gl.glBlendFunc(770, 771);
    }

    public void setAdditiveBlend() {
        this._gl.glBlendFunc(770, 1);
    }

    public void setOneBlend() {
        this._gl.glBlendFunc(1, 1);
    }

    public void enableLighting(boolean f) {
        if (f) {
            this._gl.glEnable(2896);
        } else {
            this._gl.glDisable(2896);
        }
    }

    public void enableTexture(boolean f) {
        if (f) {
            this._gl.glEnable(3553);
        } else {
            this._gl.glDisable(3553);
        }
    }

    public void setDepthWrite(boolean f) {
        if (f) {
            this._gl.glEnable(2929);
        } else {
            this._gl.glDisable(2929);
        }
    }

    public void setDepthMask(boolean f) {
        this._gl.glDepthMask(f);
    }

    public void fill(float c) {
        this._r = c;
        this._g = c;
        this._b = c;
        this._a = 1.0f;
    }

    public void fill(float c, float a) {
        this._r = c;
        this._g = c;
        this._b = c;
        this._a = a;
    }

    public void fill(float r, float g, float b) {
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = 1.0f;
    }

    public void fill(float r, float g, float b, float a) {
        this._r = r;
        this._g = g;
        this._b = b;
        this._a = a;
    }

    public void quad(float posx, float posy, float z, float s) {
        this._gl.glBegin(7);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(0.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + -1.0f * s, posy + 1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(1.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * s, posy + 1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(1.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * s, posy + -1.0f * s, z);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glTexCoord2f(0.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + -1.0f * s, posy + -1.0f * s, z);
        this._gl.glEnd();
    }

    public void quad(float s) {
        this.quad(0.0f, 0.0f, 0.0f, s);
    }

    public void rect(float posx, float posy, float z, float sx, float sy) {
        if (this._flipV) {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset * -1.0f);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        } else {
            this._gl.glBegin(7);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 0.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + -1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(1.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glColor4f(this._r, this._g, this._b, this._a);
            this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this._gl.glTexCoord2f(0.0f * this._uScale + this._uOffset, 1.0f * this._vScale + this._vOffset);
            this._gl.glVertex3f(posx + -1.0f * sx, posy + 1.0f * sy, z);
            this._gl.glEnd();
        }
    }

    public void rect(float posx, float posy, float sx, float sy) {
        this._gl.glBegin(7);
        this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(0.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 0.0f * sx, posy + 0.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(1.0f * this._uScale, 0.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * sx, posy + 0.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(1.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 1.0f * sx, posy + 1.0f * sy, 0.0f);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glTexCoord2f(0.0f * this._uScale, 1.0f * this._vScale);
        this._gl.glVertex3f(posx + 0.0f * sx, posy + 1.0f * sy, 0.0f);
        this._gl.glEnd();
    }

    public void rect(float sx, float sy) {
        this.rect(0.0f, 0.0f, 0.0f, sx, sy);
    }

    public void drawGrid(float x, float y, float z, float wid, float hei, int xCells, int yCells) {
        Vector3 p1 = new Vector3();
        Vector3 p2 = new Vector3();
        float xstep = wid / (float)xCells;
        float ystep = hei / (float)yCells;
        float invXCells = 1.0f / (float)xCells;
        float invYCells = 1.0f / (float)yCells;
        int j = 0;
        while (j < yCells - 1) {
            this._gl.glBegin(8);
            int i = 0;
            while (i < xCells) {
                p1.set(x + (float)i * xstep - wid * 0.5f, y + (float)j * ystep - hei * 0.5f, z);
                p2.set(x + (float)i * xstep - wid * 0.5f, y + (float)(j + 1) * ystep - hei * 0.5f, z);
                float u = (float)i * invXCells * this._uScale + this._uOffset;
                float v1 = (float)j * invYCells * this._vScale + this._vOffset;
                float v2 = (float)(j + 1) * invYCells * this._vScale + this._vOffset;
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
                this._gl.glTexCoord2f(u, v1);
                this._gl.glVertex3f(p1.x, p1.y, p1.z);
                this._gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                this._gl.glNormal3f(0.0f, 0.0f, 1.0f);
                this._gl.glTexCoord2f(u, v2);
                this._gl.glVertex3f(p2.x, p2.y, p2.z);
                ++i;
            }
            this._gl.glEnd();
            ++j;
        }
    }

    public void texCoordScale(float uScale, float vScale) {
        this._uScale = uScale;
        this._vScale = vScale;
    }

    public void texCoordOffset(float uo, float vo) {
        this._uOffset = uo;
        this._vOffset = vo;
    }

    public void line(Vector3 p1, Vector3 p2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, float i1, float i2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(i1, i1, i1, i1);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(i2, i2, i2, i2);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(r1, g1, b1, a1);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(r2, g2, b2, a2);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(Vector3 p1, Vector3 p2, Vector4 col1, Vector4 col2) {
        this._gl.glBegin(1);
        this._gl.glColor4f(col1.x, col1.y, col1.z, col1.w);
        this._gl.glVertex3f(p1.x, p1.y, p1.z);
        this._gl.glColor4f(col2.x, col2.y, col2.z, col2.w);
        this._gl.glVertex3f(p2.x, p2.y, p2.z);
        this._gl.glEnd();
    }

    public void line(float p1x, float p1y, float p1z, float p2x, float p2y, float p2z) {
        this._gl.glBegin(1);
        this._gl.glColor4f(this._r, this._g, this._b, this._a);
        this._gl.glVertex3f(p1x, p1y, p1z);
        this._gl.glVertex3f(p2x, p2y, p2z);
        this._gl.glEnd();
    }

    public void beginShape(eFaceType ft) {
        switch (ft) {
            case POINTS: {
                this._gl.glBegin(0);
                break;
            }
            case LINES: {
                this._gl.glBegin(1);
                break;
            }
            case TRIANGLES: {
                this._gl.glBegin(4);
                break;
            }
            case QUADS: {
                this._gl.glBegin(7);
                break;
            }
            case LINE_STRIP: {
                this._gl.glBegin(3);
                break;
            }
            case TRIANGLE_STRIP: {
                this._gl.glBegin(5);
                break;
            }
            case QUAD_STRIP: {
                this._gl.glBegin(8);
                break;
            }
            default: {
                this._gl.glBegin(0);
            }
        }
    }

    public void endShape() {
        this._gl.glEnd();
    }

    public void vertex(float x, float y, float z) {
        this._gl.glVertex3f(x, y, z);
    }

    public void vertex(Vector3 v) {
        this._gl.glVertex3f(v.x, v.y, v.z);
    }

    public boolean isvSyncEnabled() {
        return this.vSyncEnabled;
    }

    public void setVSync(boolean val) {
        this.vSyncEnabled = val;
        int flag = 1;
        if (!val) {
            flag = 0;
        }
        this._gl.setSwapInterval(flag);
    }

    public int addEffectFromFile(String effectFilename) {
        return this._shaderMan.addEffect(effectFilename, effectFilename);
    }

    public int addShaderFromFile(String vfile, String ffile) {
        return this._shaderMan.addShader(vfile, vfile, ffile);
    }

    public void setShader(int idx) {
        this._shaderMan.enable(idx);
    }

    public void enableShader(int idx) {
        this._shaderMan.enable(idx);
    }

    public void disableShader() {
        this._shaderMan.disable();
    }

    public void setTextureParameter(String param, int val) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setTextureParameter(param, val);
        }
    }

    public void setParameter1f(String param, float val) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter1f(param, val);
        }
    }

    public void setParameter2f(String param, float x, float y) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter2f(param, x, y);
        }
    }

    public void setParameter3f(String param, float x, float y, float z) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3f(param, x, y, z);
        }
    }

    public void setParameter3f(String param, Vector3 v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter3f(param, v.x, v.y, v.z);
        }
    }

    public void setParameter4f(String param, float x, float y, float z, float w) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4f(param, x, y, z, w);
        }
    }

    public void setParameter4f(String param, Vector4 v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4f(param, v.x, v.y, v.z, v.w);
        }
    }

    public void setParameter4x4fBySemantic(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, matrix, matrixType);
        }
    }

    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, matrix, matrixType);
        }
    }

    public void setMatrixParameterSemantic(String param, float[] v) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setMatrixParameterSemantic(param, v);
        }
    }

    public void setParameter4x4f(String param, int matrix, int matrixType) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.setParameter4x4f(param, matrix, matrixType);
        }
    }

    public void setParameter4x4f(String param, Matrix m) {
        if (this._shaderMan.getActiveShader() != null) {
            this._shaderMan.getActiveShader().setParameter4x4f(param, m.getArray());
        }
    }

    public Shader getActiveShader() {
        return this._shaderMan.getActiveShader();
    }

    public int createTexture(String filename) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = new VTexture(this._gl);
        tex.loadImageFromFile(VStringUtil.dataPath(filename), true);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL)  Failed to load texture: " + filename);
            return 0;
        }
    }

    public int createRenderTarget(int target, int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = new VTexture(this._gl);
        tex.create(target, w, h, format, sampler);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int createRenderDepth(int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = new VTexture(this._gl);
        tex.createDepth(w, h, format, sampler);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int addTexture(String filename) {
        if (this._texturePool == null || this._texturePool.size() <= 0) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
        VTexture tex = null;
        tex = this._useProcessing ? new VTexture(this._gl, this._parent.dataPath(filename)) : new VTexture(this._gl, VStringUtil.dataPath(filename));
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to load texture: " + filename);
            return 0;
        }
    }

    public void removeTexture(int texid) {
        VTexture tex = this._texturePool.get(texid);
        if (tex._targetID != 0) {
            if (tex._targetID == 36161) {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteRenderbuffersEXT(1, tmp, 0);
            } else {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteTextures(1, tmp, 0);
            }
            tex._id = 0;
        }
    }

    public Scene loadScene(String filename) {
        if (filename == null) {
            System.out.println("(VGL) Scene filename is null. Try with a real filename");
            return null;
        }
        String[] ext = filename.split("\\.");
        if (ext[ext.length - 1].equals("3ds")) {
            System.err.println("(VGL)  3ds file format is not supported yet.");
            return null;
        }
        if (ext[ext.length - 1].equals("mm")) {
            MMLoader mm = null;
            mm = new MMLoader(this._gl);
            Scene scene = new Scene(this._gl);
            boolean res = mm.load(filename, scene);
            if (!res) {
                return null;
            }
            return scene;
        }
        return null;
    }

    public void release() {
        if (this._texturePool != null) {
            this._texturePool.clear();
        }
        if (this._shaderMan != null) {
            this._shaderMan.release();
        }
        this._parent = null;
        this._gl = null;
        this._glu = null;
    }

    public boolean checkExtension(String ext) {
        return this._extensions.checkExtension(ext);
    }

    public ShaderManager getShaderManager() {
        return this._shaderMan;
    }

    public PApplet getParent() {
        return this._parent;
    }

    public void setFlipV(boolean f) {
        this._flipV = f;
    }

    public boolean DEBUG() {
        return this._debugMode;
    }

    public static VGL getSingleton() {
        if (_singleton == null) {
            _singleton = new VGL();
        }
        return _singleton;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

