/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import vitamin.math.Vector3;

public class VParticle {
    private Vector3 _origin;
    public Vector3 _pos;
    public Vector3 _oldPos;
    public Vector3 _force;
    public Vector3 _vel;
    public Vector3 _accel;
    public float _friction;
    public float _age;
    public float _timeToLive;
    public float _mass;
    public float _invMass;
    public float _speed;

    public VParticle() {
        this._origin = new Vector3();
        this._pos = new Vector3();
        this._oldPos = new Vector3();
        this._vel = new Vector3();
        this._accel = new Vector3();
        this._age = 0.0f;
        this._timeToLive = 0.0f;
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
    }

    public VParticle(Vector3 pos, Vector3 vel, Vector3 accel, float maxage) {
        this._origin = pos.copy();
        this._pos = pos;
        this._oldPos = pos;
        this._vel = vel;
        this._accel = accel;
        this._age = 0.0f;
        this._timeToLive = maxage;
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
    }

    public void position(Vector3 p) {
        this._pos = p;
    }

    public void setPosition(Vector3 p) {
        this._pos = p;
    }

    public void setPosition(float x, float y, float z) {
        this._pos.set(x, y, z);
    }

    public void addPosition(Vector3 f) {
        this._pos.add(f);
    }

    public void addPosition(float x, float y, float z) {
        this._pos.add(x, y, z);
    }

    public void velocity(Vector3 v) {
        this._accel = v;
    }

    public void setVelocity(Vector3 v) {
        this._vel = v;
    }

    public void setVelocity(float x, float y, float z) {
        this._vel.set(x, y, z);
    }

    public void accel(Vector3 a) {
        this._accel = a;
    }

    public void setAcceleration(Vector3 a) {
        this._accel = a;
    }

    public void setAcceleration(float x, float y, float z) {
        this._accel.set(x, y, z);
    }

    public void applyForce(Vector3 f) {
        this._force = f;
    }

    public void applyForce(float x, float y, float z) {
        this._force.set(x, y, z);
    }

    public void setMaxAge(float age) {
        this._timeToLive = age;
    }

    public void setFriction(float f) {
        this._friction = f;
    }

    public Vector3 getOrigin() {
        return this._origin;
    }

    public float getTimeToLive() {
        return this._timeToLive;
    }

    public float getAge() {
        return this._age;
    }

    public float getSpeed() {
        return this._speed;
    }

    public boolean isDead() {
        return !(this._age <= this._timeToLive);
    }

    public void update(float dt) {
        this._oldPos = this._pos.copy();
        this._accel = Vector3.mul(this._force, this._invMass);
        this._vel.add(Vector3.mul(this._accel, dt));
        this._vel.mul(this._friction);
        this._pos.add(Vector3.mul(this._vel, dt));
        this._force.mul(0.0f);
        this._speed = this._vel.length();
        this._age += dt;
    }
}

