/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;

public class Color3 {
    public static final Color3 WHITE = new Color3(1.0f, 1.0f, 1.0f);
    public static final Color3 BLACK = new Color3(0.0f, 0.0f, 0.0f);
    public float r;
    public float g;
    public float b;

    public Color3() {
        this.b = 0.0f;
        this.g = 0.0f;
        this.r = 0.0f;
    }

    public Color3(float xx, float yy, float zz) {
        this.r = xx;
        this.g = yy;
        this.b = zz;
    }

    public Color3(Color3 v) {
        this.r = v.r;
        this.g = v.g;
        this.b = v.b;
    }

    public void set(float xx, float yy, float zz) {
        this.r = xx;
        this.g = yy;
        this.b = zz;
    }

    public void reset() {
        this.r = 0.0f;
        this.g = 0.0f;
        this.b = 0.0f;
    }

    public Color3 copy() {
        return new Color3(this.r, this.g, this.b);
    }

    public void add(Color3 v) {
        this.r += v.r;
        this.g += v.g;
        this.b += v.b;
    }

    public void sub(Color3 v) {
        this.r -= v.r;
        this.g -= v.g;
        this.b -= v.b;
    }

    public void mul(Color3 v) {
        this.r *= v.r;
        this.g *= v.g;
        this.b *= v.b;
    }

    public void div(Color3 v) {
        this.r /= v.r;
        this.g /= v.g;
        this.b /= v.b;
    }

    public void mul(float s) {
        this.r *= s;
        this.g *= s;
        this.b *= s;
    }

    public void div(float s) {
        float inv = 1.0f / s;
        this.r *= inv;
        this.g *= inv;
        this.b *= inv;
    }

    public float dot(Color3 v) {
        return this.r * v.r + this.g * v.g + this.b * v.b;
    }

    public float length() {
        return (float)Math.sqrt(this.r * this.r + this.g * this.g + this.b * this.b);
    }

    public float lengthSqr() {
        return this.r * this.r + this.g * this.g + this.b * this.b;
    }

    public void normalize() {
        float m = this.length();
        if (m > 0.0f) {
            this.div(m);
        }
    }

    public Color3 lerp(Color3 V1, float s) {
        return new Color3(this.r + s * (V1.r - this.r), this.g + s * (V1.g - this.g), this.b + s * (V1.b - this.b));
    }

    public Color3 transform(Matrix m) {
        float xr = this.r * m._M[0] + this.g * m._M[4] + this.b * m._M[8];
        float yg = this.r * m._M[1] + this.g * m._M[5] + this.b * m._M[9];
        float zb = this.r * m._M[2] + this.g * m._M[6] + this.b * m._M[10];
        return new Color3(xr, yg, zb);
    }

    public static Color3 add(Color3 a, Color3 b) {
        return new Color3(a.r + b.r, a.g + b.g, a.b + b.b);
    }

    public static Color3 sub(Color3 a, Color3 b) {
        return new Color3(a.r - b.r, a.g - b.g, a.b - b.b);
    }

    public static Color3 mul(Color3 a, Color3 b) {
        return new Color3(a.r * b.r, a.g * b.g, a.b * b.b);
    }

    public static Color3 mul(Color3 a, float f) {
        return new Color3(a.r * f, a.g * f, a.b * f);
    }

    public static float distance(Color3 v1, Color3 v2) {
        float dr = v1.r - v2.r;
        float dg = v1.g - v2.g;
        float db = v1.b - v2.b;
        return (float)Math.sqrt(dr * dr + dg * dg + db * db);
    }

    public void debug() {
        System.out.println(String.valueOf(this.r) + ", " + this.g + ", " + this.b);
    }
}

