/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import java.nio.FloatBuffer;
import vitamin.math.Vector3;

public class Matrix {
    public float[] _M;

    public Matrix() {
        this._M = new float[16];
        this.identity();
    }

    public Matrix(Matrix m) {
        this.copy(m);
    }

    public void copy(Matrix m) {
        this._M[0] = m._M[0];
        this._M[4] = m._M[4];
        this._M[8] = m._M[8];
        this._M[12] = m._M[12];
        this._M[1] = m._M[1];
        this._M[5] = m._M[5];
        this._M[9] = m._M[9];
        this._M[13] = m._M[13];
        this._M[2] = m._M[2];
        this._M[6] = m._M[6];
        this._M[10] = m._M[10];
        this._M[14] = m._M[14];
        this._M[3] = m._M[3];
        this._M[7] = m._M[7];
        this._M[11] = m._M[11];
        this._M[15] = m._M[15];
    }

    public Matrix copy() {
        Matrix m = new Matrix();
        m.copy(this);
        return m;
    }

    public void identity() {
        this._M[0] = 1.0f;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = 1.0f;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = 1.0f;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void scale(float s) {
        this._M[0] = this._M[0] * s;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = this._M[5] * s;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = this._M[10] * s;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void translate(float X, float Y, float Z) {
        this._M[12] = X;
        this._M[13] = Y;
        this._M[14] = Z;
        this._M[15] = 1.0f;
    }

    public void rotateX(float a) {
        float ca = (float)Math.cos(a);
        float sa = (float)Math.sin(a);
        this._M[0] = 1.0f;
        this._M[4] = 0.0f;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = ca;
        this._M[9] = sa;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = -sa;
        this._M[10] = ca;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void rotateY(float a) {
        float ca = (float)Math.cos(a);
        float sa = (float)Math.sin(a);
        this._M[0] = ca;
        this._M[4] = 0.0f;
        this._M[8] = sa;
        this._M[12] = 0.0f;
        this._M[1] = 0.0f;
        this._M[5] = 1.0f;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = -sa;
        this._M[6] = 0.0f;
        this._M[10] = ca;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void rotateZ(float a) {
        float ca = (float)Math.cos(a);
        float sa = (float)Math.sin(a);
        this._M[0] = ca;
        this._M[4] = -sa;
        this._M[8] = 0.0f;
        this._M[12] = 0.0f;
        this._M[1] = sa;
        this._M[5] = ca;
        this._M[9] = 0.0f;
        this._M[13] = 0.0f;
        this._M[2] = 0.0f;
        this._M[6] = 0.0f;
        this._M[10] = 0.0f;
        this._M[14] = 0.0f;
        this._M[3] = 0.0f;
        this._M[7] = 0.0f;
        this._M[11] = 0.0f;
        this._M[15] = 1.0f;
    }

    public Matrix rotate(float Yaw, float Pitch, float Roll) {
        Matrix m = new Matrix();
        float sinY = (float)Math.sin(Yaw);
        float cosY = (float)Math.cos(Yaw);
        float sinP = (float)Math.sin(Pitch);
        float cosP = (float)Math.cos(Pitch);
        float sinR = (float)Math.sin(Roll);
        float cosR = (float)Math.cos(Roll);
        float ux = cosY * cosR + sinY * sinP * sinR;
        float uy = sinR * cosP;
        float uz = cosY * sinP * sinR - sinY * cosR;
        float vx = sinY * sinP * cosR - cosY * sinR;
        float vy = cosR * cosP;
        float vz = sinR * sinY + cosR * cosY * sinP;
        float nx = cosP * sinY;
        float ny = -sinP;
        float nz = cosP * cosY;
        m._M[0] = ux;
        m._M[1] = uy;
        m._M[2] = uz;
        m._M[3] = 0.0f;
        m._M[4] = vx;
        m._M[5] = vy;
        m._M[6] = vz;
        m._M[7] = 0.0f;
        m._M[8] = nx;
        m._M[9] = ny;
        m._M[10] = nz;
        m._M[11] = 0.0f;
        m._M[12] = 0.0f;
        m._M[13] = 0.0f;
        m._M[14] = 0.0f;
        m._M[15] = 1.0f;
        return m;
    }

    public void add(Matrix m) {
        this._M[0] = this._M[0] + m._M[0];
        this._M[4] = this._M[4] + m._M[1];
        this._M[8] = this._M[8] + m._M[2];
        this._M[12] = this._M[12] + m._M[3];
        this._M[1] = this._M[1] + m._M[4];
        this._M[5] = this._M[5] + m._M[5];
        this._M[9] = this._M[9] + m._M[6];
        this._M[13] = this._M[13] + m._M[7];
        this._M[2] = this._M[2] + m._M[8];
        this._M[6] = this._M[6] + m._M[9];
        this._M[10] = this._M[10] + m._M[10];
        this._M[14] = this._M[14] + m._M[11];
        this._M[3] = this._M[3] + m._M[12];
        this._M[7] = this._M[7] + m._M[13];
        this._M[11] = this._M[11] + m._M[14];
        this._M[15] = this._M[15] + m._M[15];
    }

    public Matrix mul(Matrix m) {
        Matrix mat = new Matrix();
        mat._M[0] = this._M[0] * m._M[0] + this._M[4] * m._M[1] + this._M[8] * m._M[2] + this._M[12] * m._M[3];
        mat._M[1] = this._M[0] * m._M[4] + this._M[4] * m._M[5] + this._M[8] * m._M[6] + this._M[12] * m._M[7];
        mat._M[2] = this._M[0] * m._M[8] + this._M[4] * m._M[9] + this._M[8] * m._M[10] + this._M[12] * m._M[11];
        mat._M[3] = this._M[0] * m._M[12] + this._M[4] * m._M[13] + this._M[8] * m._M[15] + this._M[12] * m._M[15];
        mat._M[4] = this._M[1] * m._M[0] + this._M[5] * m._M[1] + this._M[9] * m._M[2] + this._M[13] * m._M[3];
        mat._M[5] = this._M[1] * m._M[4] + this._M[5] * m._M[5] + this._M[9] * m._M[6] + this._M[13] * m._M[7];
        mat._M[6] = this._M[1] * m._M[8] + this._M[5] * m._M[9] + this._M[9] * m._M[10] + this._M[13] * m._M[11];
        mat._M[7] = this._M[1] * m._M[12] + this._M[5] * m._M[13] + this._M[9] * m._M[15] + this._M[13] * m._M[15];
        mat._M[8] = this._M[2] * m._M[0] + this._M[6] * m._M[1] + this._M[10] * m._M[2] + this._M[14] * m._M[3];
        mat._M[9] = this._M[2] * m._M[4] + this._M[6] * m._M[5] + this._M[10] * m._M[6] + this._M[14] * m._M[7];
        mat._M[10] = this._M[2] * m._M[8] + this._M[6] * m._M[9] + this._M[10] * m._M[10] + this._M[14] * m._M[11];
        mat._M[11] = this._M[2] * m._M[12] + this._M[6] * m._M[13] + this._M[10] * m._M[15] + this._M[14] * m._M[15];
        mat._M[12] = this._M[3] * m._M[0] + this._M[7] * m._M[1] + this._M[11] * m._M[2] + this._M[15] * m._M[3];
        mat._M[13] = this._M[3] * m._M[4] + this._M[7] * m._M[5] + this._M[11] * m._M[6] + this._M[15] * m._M[7];
        mat._M[14] = this._M[3] * m._M[8] + this._M[7] * m._M[9] + this._M[11] * m._M[10] + this._M[15] * m._M[11];
        mat._M[15] = this._M[3] * m._M[12] + this._M[7] * m._M[13] + this._M[11] * m._M[15] + this._M[15] * m._M[15];
        return mat;
    }

    public Matrix mul2(Matrix m) {
        Matrix mat = new Matrix();
        mat._M[0] = this._M[0] * m._M[0] + this._M[1] * m._M[4] + this._M[2] * m._M[8] + this._M[3] * m._M[12];
        mat._M[1] = this._M[0] * m._M[1] + this._M[1] * m._M[5] + this._M[2] * m._M[9] + this._M[3] * m._M[13];
        mat._M[2] = this._M[0] * m._M[2] + this._M[1] * m._M[6] + this._M[2] * m._M[10] + this._M[3] * m._M[14];
        mat._M[3] = this._M[0] * m._M[3] + this._M[1] * m._M[7] + this._M[2] * m._M[11] + this._M[3] * m._M[15];
        mat._M[4] = this._M[4] * m._M[0] + this._M[5] * m._M[4] + this._M[6] * m._M[8] + this._M[7] * m._M[12];
        mat._M[5] = this._M[4] * m._M[1] + this._M[5] * m._M[5] + this._M[6] * m._M[9] + this._M[7] * m._M[13];
        mat._M[6] = this._M[4] * m._M[2] + this._M[5] * m._M[6] + this._M[6] * m._M[10] + this._M[7] * m._M[14];
        mat._M[7] = this._M[4] * m._M[3] + this._M[5] * m._M[7] + this._M[6] * m._M[11] + this._M[7] * m._M[15];
        mat._M[8] = this._M[8] * m._M[0] + this._M[9] * m._M[4] + this._M[10] * m._M[8] + this._M[11] * m._M[12];
        mat._M[9] = this._M[8] * m._M[1] + this._M[9] * m._M[5] + this._M[10] * m._M[9] + this._M[11] * m._M[13];
        mat._M[10] = this._M[8] * m._M[2] + this._M[9] * m._M[6] + this._M[10] * m._M[10] + this._M[11] * m._M[14];
        mat._M[11] = this._M[8] * m._M[3] + this._M[9] * m._M[7] + this._M[10] * m._M[11] + this._M[11] * m._M[15];
        mat._M[12] = this._M[12] * m._M[0] + this._M[13] * m._M[4] + this._M[14] * m._M[8] + this._M[15] * m._M[12];
        mat._M[13] = this._M[12] * m._M[1] + this._M[13] * m._M[5] + this._M[14] * m._M[9] + this._M[15] * m._M[13];
        mat._M[14] = this._M[12] * m._M[2] + this._M[13] * m._M[6] + this._M[14] * m._M[10] + this._M[15] * m._M[14];
        mat._M[15] = this._M[12] * m._M[3] + this._M[13] * m._M[7] + this._M[14] * m._M[11] + this._M[15] * m._M[15];
        return mat;
    }

    public void mul(float s) {
        this._M[0] = this._M[0] * s;
        this._M[4] = this._M[4] * s;
        this._M[8] = this._M[8] * s;
        this._M[12] = this._M[12] * s;
        this._M[1] = this._M[1] * s;
        this._M[5] = this._M[5] * s;
        this._M[9] = this._M[9] * s;
        this._M[13] = this._M[13] * s;
        this._M[2] = this._M[2] * s;
        this._M[6] = this._M[6] * s;
        this._M[10] = this._M[10] * s;
        this._M[14] = this._M[14] * s;
        this._M[3] = this._M[3] * s;
        this._M[7] = this._M[7] * s;
        this._M[11] = this._M[11] * s;
        this._M[15] = this._M[15] * s;
    }

    public void transpose() {
        Matrix m = new Matrix();
        m.copy(this);
        this._M[0] = m._M[0];
        this._M[4] = m._M[1];
        this._M[8] = m._M[2];
        this._M[12] = m._M[3];
        this._M[1] = m._M[4];
        this._M[5] = m._M[5];
        this._M[9] = m._M[6];
        this._M[13] = m._M[7];
        this._M[2] = m._M[8];
        this._M[6] = m._M[9];
        this._M[10] = m._M[10];
        this._M[14] = m._M[11];
        this._M[3] = m._M[12];
        this._M[7] = m._M[13];
        this._M[11] = m._M[14];
        this._M[15] = m._M[15];
    }

    public void buildViewMatrix(float eyex, float eyey, float eyez, float centerx, float centery, float centerz, float upx, float upy, float upz) {
        Vector3 x = new Vector3();
        Vector3 y = new Vector3();
        Vector3 z = new Vector3();
        Vector3 eye = new Vector3(eyex, eyey, eyez);
        Vector3 target = new Vector3(centerx, centery, centerz);
        z = Vector3.sub(target, eye);
        z.normalize();
        y.set(upx, upy, upz);
        x = Vector3.cross(z, y);
        y = Vector3.cross(z, x);
        x.normalize();
        y.normalize();
        this._M[0] = x.x;
        this._M[1] = x.y;
        this._M[2] = x.z;
        this._M[3] = -x.x * eyex + -x.y * eyey + -x.z * eyez;
        this._M[4] = y.x;
        this._M[5] = y.y;
        this._M[6] = y.z;
        this._M[7] = -y.x * eyex + -y.y * eyey + -y.z * eyez;
        this._M[8] = z.x;
        this._M[9] = z.y;
        this._M[10] = z.z;
        this._M[11] = -z.x * eyex + -z.y * eyey + -z.z * eyez;
        this._M[12] = 0.0f;
        this._M[13] = 0.0f;
        this._M[14] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void buildPerspectiveMatrix(float fieldOfView, float aspectRatio, float zNear, float zFar) {
        float radians = fieldOfView / 2.0f * ((float)Math.PI / 180);
        float deltaZ = zFar - zNear;
        float sine = (float)Math.sin(radians);
        float cotangent = (float)Math.cos(radians) / sine;
        this._M[0] = cotangent / aspectRatio;
        this._M[1] = 0.0f;
        this._M[2] = 0.0f;
        this._M[3] = 0.0f;
        this._M[4] = 0.0f;
        this._M[5] = cotangent;
        this._M[6] = 0.0f;
        this._M[7] = 0.0f;
        this._M[8] = 0.0f;
        this._M[9] = 0.0f;
        this._M[10] = -(zFar + zNear) / deltaZ;
        this._M[11] = -2.0f * zNear * zFar / deltaZ;
        this._M[12] = 0.0f;
        this._M[13] = 0.0f;
        this._M[14] = -1.0f;
        this._M[15] = 0.0f;
    }

    public void buildRotationMatrix(float angle, float ax, float ay, float az) {
        Vector3 axis = new Vector3(ax, ay, az);
        axis.normalize();
        float radians = angle * (float)Math.PI / 180.0f;
        float sine = (float)Math.sin(radians);
        float cosine = (float)Math.cos(radians);
        float ab = axis.x * axis.y * (1.0f - cosine);
        float bc = axis.y * axis.z * (1.0f - cosine);
        float ca = axis.z * axis.x * (1.0f - cosine);
        float tx = axis.x * axis.x;
        float ty = axis.y * axis.y;
        float tz = axis.z * axis.z;
        this._M[0] = tx + cosine * (1.0f - tx);
        this._M[1] = ab + axis.z * sine;
        this._M[2] = ca - axis.y * sine;
        this._M[3] = 0.0f;
        this._M[4] = ab - axis.z * sine;
        this._M[5] = ty + cosine * (1.0f - ty);
        this._M[6] = bc + axis.x * sine;
        this._M[7] = 0.0f;
        this._M[8] = ca + axis.y * sine;
        this._M[9] = bc - axis.x * sine;
        this._M[10] = tz + cosine * (1.0f - tz);
        this._M[11] = 0.0f;
        this._M[12] = 0.0f;
        this._M[13] = 0.0f;
        this._M[14] = 0.0f;
        this._M[15] = 1.0f;
    }

    public void rotationAxis(float x, float y, float z, float a) {
        float c = (float)Math.cos(a);
        float s = (float)Math.sin(a);
        float t = 1.0f - c;
        this._M[0] = t * x * x + c;
        this._M[1] = t * x * y - s * z;
        this._M[2] = t * x * z + s * y;
        this._M[4] = t * x * y + s * z;
        this._M[5] = t * y * y + c;
        this._M[6] = t * y * z - s * x;
        this._M[8] = t * x * z - s * y;
        this._M[9] = t * y * z + s * x;
        this._M[10] = t * z * z + c;
    }

    public void rotationAxis(Vector3 v, float a) {
        this.rotationAxis(v.x, v.y, v.z, a);
    }

    public Vector3 transform(Vector3 v) {
        float xx = v.x * this._M[0] + v.y * this._M[4] + v.z * this._M[8] + this._M[12];
        float yy = v.x * this._M[1] + v.y * this._M[5] + v.z * this._M[9] + this._M[13];
        float zz = v.x * this._M[2] + v.y * this._M[6] + v.z * this._M[10] + this._M[14];
        return new Vector3(xx, yy, zz);
    }

    public Vector3 transformNormal(Vector3 v) {
        float xx = v.x * this._M[0] + v.y * this._M[4] + v.z * this._M[8];
        float yy = v.x * this._M[1] + v.y * this._M[5] + v.z * this._M[9];
        float zz = v.x * this._M[2] + v.y * this._M[6] + v.z * this._M[10];
        return new Vector3(xx, yy, zz);
    }

    public void debug() {
        System.out.println("[0] = " + this._M[0] + ", " + this._M[1] + ", " + this._M[2] + ", " + this._M[3]);
        System.out.println("[1] = " + this._M[4] + ", " + this._M[5] + ", " + this._M[6] + ", " + this._M[7]);
        System.out.println("[2] = " + this._M[8] + ", " + this._M[9] + ", " + this._M[10] + ", " + this._M[11]);
        System.out.println("[3] = " + this._M[12] + ", " + this._M[13] + ", " + this._M[14] + ", " + this._M[15]);
    }

    public static Vector3 transform(Vector3 v, float[] m) {
        float xx = v.x * m[0] + v.y * m[4] + v.z * m[8] + m[12];
        float yy = v.x * m[1] + v.y * m[5] + v.z * m[9] + m[13];
        float zz = v.x * m[2] + v.y * m[6] + v.z * m[10] + m[14];
        return new Vector3(xx, yy, zz);
    }

    public static Matrix transpose(Matrix m) {
        Matrix rm = new Matrix();
        rm._M[0] = m._M[0];
        rm._M[4] = m._M[1];
        rm._M[8] = m._M[2];
        rm._M[12] = m._M[3];
        rm._M[1] = m._M[4];
        rm._M[5] = m._M[5];
        rm._M[9] = m._M[6];
        rm._M[13] = m._M[7];
        rm._M[2] = m._M[8];
        rm._M[6] = m._M[9];
        rm._M[10] = m._M[10];
        rm._M[14] = m._M[11];
        rm._M[3] = m._M[12];
        rm._M[7] = m._M[13];
        rm._M[11] = m._M[14];
        rm._M[15] = m._M[15];
        return rm;
    }

    public static Matrix mul(Matrix m1, Matrix m2) {
        return m1.mul2(m2);
    }

    public FloatBuffer getFloatBuffer() {
        FloatBuffer fb = FloatBuffer.wrap(this._M);
        return fb;
    }

    public float[] getArray() {
        return this._M;
    }
}

