/*
 * Decompiled with CFR 0.152.
 */
package ddf.mimin.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.spi.AudioRecording;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

class JSAudioRecording
implements AudioRecording,
Runnable {
    private AudioMetaData meta;
    private byte[] samples;
    private Thread iothread;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    private byte[] rawBytes;
    private int totalBytesRead;
    protected AudioFormat format;
    private SourceDataLine line;
    private boolean finished;

    JSAudioRecording(byte[] samps, SourceDataLine sdl, AudioMetaData mdata) {
        this.samples = samps;
        this.meta = mdata;
        this.format = sdl.getFormat();
        this.finished = false;
        this.line = sdl;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned((long)this.meta.length(), (AudioFormat)this.format);
        this.rawBytes = new byte[sdl.getBufferSize() / 8];
        this.iothread = null;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        ** GOTO lbl12
        {
            this.sleep(10);
            do {
                if (this.line.available() < this.rawBytes.length) continue block0;
                if (this.play) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                    this.writeBytes();
                }
                this.sleep(10);
lbl12:
                // 2 sources

            } while (!this.finished);
        }
        this.line.drain();
        this.line.close();
        this.line = null;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void readBytes() {
        int samplesLeft = this.samples.length - this.totalBytesRead;
        if (samplesLeft < this.rawBytes.length) {
            this.readBytes(samplesLeft, 0);
            int i = samplesLeft;
            while (i < this.rawBytes.length) {
                this.rawBytes[i] = 0;
                ++i;
            }
            this.play = false;
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private synchronized void readBytesLoop() {
        int toLoopEnd = this.loopEnd - this.totalBytesRead;
        if (toLoopEnd <= 0) {
            this.setMillisecondPosition(this.loopBegin);
            this.readBytesLoop();
            return;
        }
        if (toLoopEnd < this.rawBytes.length) {
            this.readBytes(toLoopEnd, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.play = false;
            } else if (this.loop) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytes(this.rawBytes.length - toLoopEnd, toLoopEnd);
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
            }
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private void readBytes(int toRead, int offset) {
        System.arraycopy(this.samples, this.totalBytesRead, this.rawBytes, offset, toRead);
        this.totalBytesRead += toRead;
    }

    /*
     * Unable to fully structure code
     */
    private void writeBytes() {
        actualWrit = this.line.write(this.rawBytes, 0, this.rawBytes.length);
        ** GOTO lbl7
        {
            this.sleep(10);
            do {
                if (this.line.available() < this.rawBytes.length - actualWrit) continue block0;
                actualWrit += this.line.write(this.rawBytes, actualWrit, this.rawBytes.length - actualWrit);
lbl7:
                // 2 sources

            } while (actualWrit != this.rawBytes.length);
        }
    }

    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void pause() {
        this.line.stop();
        this.play = false;
    }

    public void loop(int n) {
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.setMillisecondPosition(this.loopBegin);
        this.line.start();
    }

    public void open() {
        this.iothread = new Thread(this);
        this.finished = false;
        this.iothread.start();
    }

    public void close() {
        this.line.stop();
        this.finished = true;
        try {
            this.iothread.join(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.iothread = null;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getLoopCount() {
        return this.numLoops;
    }

    public synchronized void setLoopPoints(int start, int stop) {
        this.loopBegin = start <= 0 || start > stop ? 0 : start;
        this.loopEnd = stop <= this.getMillisecondLength() && stop > start ? (int)AudioUtils.millis2BytesFrameAligned((long)stop, (AudioFormat)this.format) : (int)AudioUtils.millis2BytesFrameAligned((long)this.getMillisecondLength(), (AudioFormat)this.format);
    }

    public int getMillisecondPosition() {
        return (int)AudioUtils.bytes2Millis((long)this.totalBytesRead, (AudioFormat)this.format);
    }

    public synchronized void setMillisecondPosition(int millis) {
        this.totalBytesRead = millis <= 0 ? 0 : (millis > this.getMillisecondLength() ? this.samples.length : (int)AudioUtils.millis2BytesFrameAligned((long)millis, (AudioFormat)this.format));
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }
}

