.model small
.stack 10h
.286
jumps

.data

trans dw 0,0,0,0,0,0,0,8000h,0,0,0,0,0,0,0,0
      dw 0,0,0,0,0,0,0,8000h,1,0,0,0,0,0,0,0
      dw 0,0,0,0,0,0,8000h,4000h,1,0,0,0,0,0,0,0
      dw 0,0,0,0,0,0,8000h,4000h,2,1,0,0,0,0,0,0
      dw 0,0,0,0,0,8000h,4000h,2000h,2,1,0,0,0,0,0,0
      dw 0,0,0,0,0,8000h,4000h,2000h,4,2,1,0,0,0,0,0
      dw 0,0,0,0,8000h,4000h,2000h,1000h,4,2,1,0,0,0,0,0
      dw 0,0,0,0,8000h,4000h,2000h,1000h,8,4,2,1,0,0,0,0
      dw 0,0,0,8000h,4000h,2000h,1000h,800h,8,4,2,1,0,0,0,0
      dw 0,0,0,8000h,4000h,2000h,1000h,800h,10h,8,4,2,1,0,0,0
      dw 0,0,8000h,4000h,2000h,1000h,800h,400h,10h,8,4,2,1,0,0,0
      dw 0,0,8000h,4000h,2000h,1000h,800h,400h,20h,10h,8,4,2,1,0,0
      dw 0,8000h,4000h,2000h,1000h,800h,400h,200h,20h,10h,8,4,2,1,0,0
      dw 0,8000h,4000h,2000h,1000h,800h,400h,200h,40h,20h,10h,8,4,2,1,0
      dw 8000h,4000h,2000h,1000h,800h,400h,200h,100h,40h,20h,10h,8,4,2,1,0
      dw 8000h,4000h,2000h,1000h,800h,400h,200h,100h,80h,40h,20h,10h,8,4,2,1

trans2         dw 17*16 dup(0)
turn           db  42 dup(0)

line_number    dw  0
start_x        dw  0
xor_val        db  0
virtual_screen db  80*8 dup(0)
trans_index    dw  trans
text_index     dw  TheText
include lfont.inc

TheText        db  'SAA ER DER ENDELIG KOMMET ET',0
               db  'NYT DATAMEKANIKER BBS, SOM BESTYRES',0
               db  'AF CLAUS STEGMANN.',0
               db  1
               db  'NU SKAL VI BARE HAVE GANG I',0
               db  'FIL OG BREV UDVEKSLINGEN.',0
               db  'SOM I NOK KAN SE ER DETTE OGSAA ET',0
               db  'ISDN BBS SOM BRUGES AF XXXXXXXXXXXX.',0
               db  1
               db  'HER ER DE 3 NUMRE SOM DU KAN BRUGE :',0
               db  'NODE 1 (PSTN) : XXXXXXXX',0
               db  'NODE 2 (ISDN) : XXXXXXXX',0
               db  'NODE 3 (ISDN) : XXXXXXXX',0
               db  1,2

.code


;############################################################
;############################################################
init:
  mov     ax,@DATA
  mov     ds,ax
  mov     es,ax
  mov     ax,0010h     ; (640x200x16) (double buffer)
  int     10h

  call   reset_turn_to_start
  call   make_rotation

  call   start_up
  mov    ah,6
  call   select_plan

  call    run
  call    done
  ret


;############################################################
; input    : none.
; output   : none.
; destroys : ax,bx,cx,dx,si,di.
;############################################################
start_up:
  mov     dx,0afafh
  mov     cx,75
su_loop:
  push    cx

  mov     ah,1111b
  call    select_plan

  mov     bl,dh
  xor     bh,bh
  mov     cx,dx
  call    wait_vr
  mov     dx,cx
  mov     cx,80
  mov     ax,0ffffh
  call    fill_area

  mov     bp,bx
  mov     bl,dl
  mov     cx,80
  mov     ax,0ffffh
  call    fill_area

  mov     ah,1110b
  call    select_plan

  dec     bx
  mov     cx,80
  xor     ax,ax
  call    fill_area

  inc     bp
  mov     bx,bp
  mov     cx,80
  xor     ax,ax
  call    fill_area

  dec     dh
  inc     dl
  pop     cx
  loop    su_loop
  ret


;############################################################
; input    : none.
; output   : none.
; destroys : ax,bx,cx,dx,si,di.
;############################################################
make_rotation:
  mov     di,offset trans2
  mov     si,offset trans2 - (2*16)
  mov     bx,si
  mov     dx,16
mr_loop:
  mov     si,bx
  mov     cx,16
  rep     movsw
  sub     bx,2*16
  dec     dx
  jnz     mr_loop
  ret

;############################################################
; input    : bx = y pos,cx = length,xx = 0 (clear) ffffh = (fill).
; output   : none.
; destroys : ax,cx.
;############################################################
fill_area:
  push    bx di
  mov     di,0a000h
  mov     es,di
  shl     bx,6
  mov     di,bx
  shr     bx,2
  add     di,bx
  rep     stosb
  pop     di bx
  ret

;############################################################
; input    : ah = bit 0 = pl0, b1 = pl1 ect.
; output   : none.
; destroys : ax.
;############################################################
select_plan:
  push    dx
  mov     dx,03c4h
  mov     al,02h
  out     dx,ax
  pop     dx
  ret

;############################################################
; input    : none.
; output   : none.
; destroys : none.
;############################################################
reset_turn_to_16:
  push    di cx ax
  mov     di,offset turn
  mov     cx,41
  mov     al,16
rt16:
  stosb
  loop    rt16
  pop     ax cx di
  ret


;############################################################
; input    : none.
; output   : none.
; destroys : none.
;############################################################
reset_turn_to_start:
  push    di cx ax
  mov     di,offset turn
  mov     cx,41
  mov     al,0
rtstart:
  stosb
  dec     al
  loop    rtstart
  pop     ax cx di
  ret


;############################################################
; input    : cx = antal tegn som skal gennem ses
; output   : cx = 0 (en hel linie er tegnet frdigt)
; destroys : cx.
;############################################################
valid_down_turn:
  push    si bx ax
  mov     si,offset turn
  mov     bx,cx
dvt_l:
  lodsb
  cmp     al,16
  je      dnot_done_rot
  inc     byte ptr ds:[si-1]
dnot_done_rot:
  loop    dvt_l

  mov     si,offset turn
  mov     cx,bx
dcheck:
  lodsb
  cmp     al,16
  jne     dnot_finished
  loop    dcheck
dnot_finished:
  pop     ax bx si
  ret


;############################################################
; input    : cx = antal tegn som skal gennem ses
; output   : cx = 0 (en hel linie er tegnet frdigt)
; destroys : cx.
;############################################################
valid_up_turn:
  push    si bx ax
  mov     si,offset turn
  mov     bx,cx
uvt_l:
  lodsb
  cmp     al,34
  je      unot_done_rot
  inc     al
unot_done_rot:
  mov     byte ptr ds:[si-1],al
udo_nothing:
  loop    uvt_l

  mov     si,offset turn
  mov     cx,bx
ucheck:
  lodsb
  cmp     al,34
  jne     unot_finished
  loop    ucheck
unot_finished:
  pop     ax bx si
  ret



;############################################################
; input    : ds:si -> string to search.
; output   : cx = length of string.
; destroys : cx,si.
;############################################################
strlen:
  push    ax
  mov     cx,1
l_loop:
  lodsb
  xor     al,0
  jz      exit_strlen
  inc     cx
  jmp     l_loop
exit_strlen:
  pop     ax
  ret



;############################################################
; input    : cx = number of characters.
; output   : cx = x position to start drawing.
; destroys : cx.
;############################################################
calc_x_pos:
  push    ax
  mov     ax,41
  sub     ax,cx
  mov     cx,ax
  pop     ax
  ret


;############################################################
; input    : none.
; output   : none.
; destroys : ax,dx.
;############################################################
wait_vr:
  mov     dx,3dah
w1:
  in      al,dx
  test    al,8
  jne     w1
w2:
  in      al,dx
  test    al,8
  je      w2
  ret

;############################################################
; input    : cx = number of frames to pause.
; output   : ax = 0 means ESC pressed.
; destroys : cx,ax.
;############################################################
pause_vr:
  push   dx
ploop:
  call   wait_vr
  in     al,[60h]
  cmp    al,1
  je     exit_pause
  loop   ploop
exit_pause:
  pop    dx
  ret

;############################################################
; input    : none.
; output   : none.
; destroys : none.
;############################################################
show:
  push    es ax cx di si
  mov     ax,0a000h
  mov     es,ax
  mov     ax,line_number
  shl     ax,4
  shl     ax,6
  mov     di,ax
  shr     ax,2
  add     di,ax
  add     di,(80*117)
  mov     si,offset virtual_screen
  mov     cx,80*8
  rep     movsb
  pop     si di cx ax es
  ret

;############################################################
; ds:bp -> tekst index
; ds:si -> font offset
; ds:di -> virtual screen segment:offset
; ds:bx -> trans buffer
;############################################################
char_num dw 0

writeln:
  mov     di,offset virtual_screen
  add     di,start_x
  mov     dx,di
  mov     char_num,0
next_char:
  mov     di,dx
  mov     si,offset font
  mov     al,byte ptr ds:[bp]      ; get character to write
  xor     al,0
  jz      exit_writeln             ; if it's zero then end of string (exit proc)
  sub     al,32                    ; calc index numer in font buffer
  xor     ah,ah                    ; clear ah
  shl     ax,4                     ; ax = (char-64)*16 = char offset in font buf
  add     si,ax                    ; make ds:si -> font to draw.

  mov     bx,char_num
  add     bx,offset turn
  mov     al,byte ptr ds:[bx]
  cmp     al,0
  jl      exit_writeln
  xor     ah,ah
  shl     ax,5
  add     ax,offset trans
  mov     trans_index,ax

  mov     cl,8                     ; number of lines to draw
next_line:
  mov     bx,trans_index           ; get offset to trans buffer
  lodsw                            ; get bitmap
  mov     ch,16                     ; number of pixels to draw
next_pixel:
  shl     word ptr ds:[di],1       ;
  push    ax
  and     ax,word ptr ds:[bx]      ; trans[bx]
  jz      no_pixel                 ; put a pixel ?
  inc     word ptr ds:[di]         ; yes -> set bit in virtual_screen
no_pixel:
  pop     ax
  add     bx,2
  dec     ch                       ; any pixels left ?
  jnz     next_pixel               ; yes -> then take the next one
  mov     ax,word ptr ds:[di]
  xchg    ah,al
  mov     word ptr ds:[di],ax
  add     di,80                    ; point one line beneath current line
  dec     cl
  jnz     next_line                ; cx = number of lines left.
  inc     char_num
  inc     bp                       ; point to next char to write
  add     dx,2
  jmp     next_char                ; check the next char.

exit_writeln:
  inc     bp
  ret                              ; return to caller


;############################################################
; input    : none.
; output   : none.
; destroys : none.
;############################################################
clear_v_screen:
  push   ax cx di
  mov    di,offset virtual_screen
  mov    ax,ds
  mov    es,ax
  mov    cx,(80*8)/2
  xor    ax,ax
  rep    stosw
  pop    di cx ax
  ret

;############################################
; input    : none.
; output   : none.
; destroys : none.
;############################################
string_length      dw ?
direction          dw ?
restore_text_index dw ?

run:
  mov    direction,1
  mov    bp,offset TheText
  mov    Text_index,bp
  mov    restore_text_index,bp
labelme:
  mov    bp,text_index
  cmp    byte ptr ds:[bp],2
  jne    not_eot
  mov    ax,offset TheText
  mov    text_index,ax
not_eot:
  call   clear_v_screen

  mov    si,text_index
  call   strlen
  mov    string_length,cx
  call   calc_x_pos
  mov    start_x,cx
  mov    bp,text_index
  call   writeln

  cmp    direction,0
  je     up
  mov    cx,string_length
  call   valid_down_turn
  cmp    cx,0
  jne    draw_to_screen

  call   reset_turn_to_start
  inc    line_number       ;** bruges til linie nummer som der skal tegnes p**
  mov    ax,string_length
  add    text_index,ax
  mov    bp,text_index
  cmp    byte ptr ds:[bp],1        ; end of lines on one screen
  jne    labelme

  inc    text_index
scr_done:
  xor    direction,1
  mov    cx,line_number
  shl    cx,7
  call   pause_vr
  cmp    al,0
  je     exit_run
  mov    ax,restore_text_index
  mov    text_index,ax
  mov    line_number,0
  call   reset_turn_to_16
  jmp    labelme
up:
  mov    cx,string_length
  call   valid_up_turn
  cmp    cx,0
  jne    draw_to_screen

  inc    line_number
  mov    ax,string_length
  add    text_index,ax
  call   reset_turn_to_16
  mov    bp,text_index
  cmp    byte ptr ds:[bp],1        ; end of lines on one screen
  jne    labelme

  mov    line_number,0
  inc    text_index
  mov    ax,text_index
  mov    restore_text_index,ax
  xor    direction,1
  call   reset_turn_to_start
  jmp    labelme
draw_to_screen:
  call   wait_vr
  call   show
ck:
  in     al,[60h]
  cmp    al,1
  jnz    labelme
exit_run:
  ret




;############################################################
;############################################################
Done:
  mov     ax,0003h
  int     10h

  mov     ax,4c00h
  int     21h
  ret

END
