/*
 * $Id: c64_state.cpp 150 2007-11-08 23:44:59Z ehaase $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#include "c64_state.hpp"
#include "main.hpp"

#include "audio/audio.h"
#include "bitmap/bitmap.hpp"
#include "keyboard.hpp"


c64_state::c64_state(void)
{
    this->c64screen = NULL;
	/* Load the C64 screen bitmap */
    this->c64screen = new Bitmap(lpdd, std::string("gfx_c64"));
	
	this->lightBlue.peRed = 0;
	this->lightBlue.peGreen = 156;
	this->lightBlue.peBlue = 255;
	this->lightBlue.peFlags = PC_RESERVED;

	this->darkBlue.peRed = 49;
	this->darkBlue.peGreen = 49;
	this->darkBlue.peBlue = 189;
	this->darkBlue.peFlags = PC_RESERVED;

	full.left = 0;
    full.top = 0;
    full.right = SCREEN_WIDTH;
    full.bottom = SCREEN_HEIGHT;    

	knownElapsed = 0;
}

c64_state::~c64_state(void)
{
    if (c64screen != NULL)
    {
        delete c64screen;
        c64screen = NULL;
    }
}

void
c64_state::enterState(void)
{
	//MessageBeep(MB_OK);

	if (knownElapsed == 0) // only the very first time coming in here...
	{
		ACloseVoices();
		AStopModule();
		ACloseAudio();
	}

	timer.init(knownElapsed);










        // create and attach palette
    const int num_col = 1<<SCREEN_DEPTH;   


    // create palette data
    PALETTEENTRY            palette[num_col];         // color palette
    
    


    // now load the palette entries    
    LPPALETTEENTRY sourcePal = c64screen->getPaletteEntries();        
    for (int index=0; index<num_col; index++)
    {
        // set flags
        sourcePal[index].peFlags = PC_NOCOLLAPSE;
    } // end for index	

	sourcePal[COLIDX_UPPERTEXT_AND_BORDER]	= lightBlue;
	sourcePal[COLIDX_BACKGROUND]			= darkBlue;
	sourcePal[COLIDX_CURSOR]				= darkBlue;
	sourcePal[COLIDX_LOWERTEXT]             = darkBlue;

    for (int n=0; n<num_col; n++)
    {
        palette[n] = sourcePal[n];
    }
    // now create the palette object
    HRESULT createPal = lpdd->CreatePalette(DDPCAPS_8BIT | DDPCAPS_INITIALIZE | DDPCAPS_ALLOW256, palette, &lpddpal, NULL);
    if (createPal != DD_OK)
    {
        throwException("Could not create palette.", createPal);
    }
   
    HRESULT setPal = lpddsprimary->SetPalette(lpddpal);
    if (setPal == DDERR_SURFACELOST)
    {
        lpddsprimary->Restore();
        setPal = lpddsprimary->SetPalette(lpddpal);
    }
    if (setPal != DD_OK)
    {
        throwException("Could not set palette.", setPal);
    }

    clearSurfaces();
}

void
c64_state::exitState(void)
{
	knownElapsed = timer.elapsed();
}

void
c64_state::update(void)
{
	// check if user is trying to exit
    if (keyPressed(VK_ESCAPE) || keyPressed(VK_SPACE) || keyPressed(VK_RETURN))
    {
        PostMessage(main_window_handle, WM_APP, APPMSG_ADVANCE_STATE, APPMSG_ADVANCE_STATE);
        return;
    }

    lpddpal->SetEntries(0, COLIDX_UPPERTEXT_AND_BORDER, 1, &lightBlue);
	DWORD now = timer.elapsed();
	if (timer.elapsed() > 2000) // do not reveal everything immediately
	{
		// text: light blue now.
		lpddpal->SetEntries(0, COLIDX_LOWERTEXT, 1, &lightBlue);
		
		PALETTEENTRY cursorColor;
		if (((now / 500) % 2) == 0)
		{
			cursorColor = lightBlue;
		}
		else
		{
			cursorColor = darkBlue;
		}
		lpddpal->SetEntries(0, COLIDX_CURSOR, 1, &cursorColor);
	}



    c64screen->Blit(lpddsback, full);

    HRESULT flipRes = lpddsprimary->Flip(NULL, DDFLIP_WAIT);
    if (flipRes != DD_OK)
    {
        throwException("Flip problem?", flipRes);
    }
}

