/*
 * $Id: exceptions.cpp 149 2007-11-08 23:43:53Z hangman $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



//
// Includes.
//

#include "exceptions.hpp"



//
// Implementation.
//

GameException::GameException(std::string reason)
{
    this->reason = reason;
    this->result = RESULT_UNSET;
}

GameException::GameException(std::string reason, HRESULT res)
{
    static const int BUF_MAX = 256;
    char buf[BUF_MAX];
    _ltoa_s(res, buf, 16); // HRESULT is really a LONG
    this->reason = (reason+std::string(" Error: 0x")+std::string(buf)+std::string("."));
    this->result = res;
}

std::string GameException::getReason(void)
{
    return this->reason;
}

HRESULT GameException::getResult(void)
{
    return this->result;
}

const char * GameException::what(void) const throw()
{
    return this->reason.c_str();
}

BitmapCreateError::BitmapCreateError(std::string reason) : GameException(reason) /* superclass constructor */
{
    // empty...
}

void throwException(std::string error) throw (GameException)
{
    throw GameException(error);
}

void throwException(std::string error, HRESULT res) throw (GameException)
{
    if (res == DD_OK)
    {
        return; /* Assert? */
    }    
    else{
        throw GameException(error, res);
    }
}
