/*
 * $Id: iofile.h 82 2007-07-20 10:47:43Z hangman $
 *
 * Input/Output file stream routines.
 *
 * Copyright (C) 1995-1999 Carlos Hasan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef __IOFILE_H
#define __IOFILE_H

#ifdef __GNUC__
#include <unistd.h>
#include <memory.h>
#else
#include <stdio.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define IO_ERROR_NONE                0x0000
#define IO_ERROR_FILENOTFOUND        0x0001

    unsigned int IOOpenFile(LPSTR lpszFileName);
    unsigned int IOCloseFile(VOID);
    unsigned int IOSeekFile(LONG dwOffset, UINT nWhere);
    unsigned int IOReadFile(LPVOID lpData, UINT nSize);
    unsigned int IOReadChar(LPBYTE lpData);
    unsigned int IOReadShort(LPWORD lpData);
    unsigned int IOReadLong(LPDWORD lpData);
    unsigned int IOReadCharM(LPBYTE lpData);
    unsigned int IOReadShortM(LPWORD lpData);
    unsigned int IOReadLongM(LPDWORD lpData);

#ifdef __cplusplus
};
#endif

#endif
