
/********************************************************
 *							*
 *							*
 *	Do-Prg: Creation d'un PRG atari a partir d'un	*
 *	BIN genere par le PC.				*
 *							*
 *	(C)oderight OXYGENE 1995 by lo.		*
 *							*
 *							*
 ********************************************************/


// includes.
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

typedef	unsigned long	UD;
typedef	long		SD;
typedef unsigned int	UW;
typedef int		SW;
typedef unsigned char	UB;
typedef char		SB;


#define	BLOCK_SIZE	1024


char	mydrive[_MAX_DRIVE];
char	mydir[_MAX_DIR];
char	mypath[_MAX_PATH];

/********************************************************************
			SECTION CODE
 ********************************************************************/



UD	file_size(FILE *handle)
 {
 UD	size,pos;

	pos=ftell(handle);
	fseek(handle,0,SEEK_END);
	size=ftell(handle);
	fseek(handle,pos,SEEK_SET);
	return size;
}






void	do_prg(char *name,char *orgstr,int argc)
 {
 UD	org;
 SW	i;
 UW	s;
 UD	digit;
 FILE	*runner,*in,*out;
 UD	run_size,bin_size;
 UD	a;
 UB	*buffer;
 char	*ptr;
 char	name2[128];






 //----------------------------------------------------------
 // Get le ORG.
 //----------------------------------------------------------
	if (argc==2)
	  org=0x5000;
	else {
	  orgstr=strupr(orgstr);
	  org=0;
	  s=0;
	  for (i=strlen(orgstr)-1;i>=0;i--) {

	    digit=orgstr[i];
	    if ((digit>='0') && (digit<='9')) {
	      digit-='0';
	    } else {
	      if ((digit>='A') && (digit<='F')) {
		digit-='A';
		digit+=10;
	      } else {
		printf("Erreur dans format hexa de ORG.\n");
		exit(1);
	      }
	    }
	    org+=digit<<s;
	    s+=4;
	    if (org>0x7fffff) {
	      printf("ORG impossible. ($%X)\n",org);
	      exit(1);
	    }
	  }
	}




 //------------------------------------------------------------
 // Ouverture du BIN
 //------------------------------------------------------------
	in=fopen(name,"rb");
	if (!in) {
	  printf("ERROR: Unable to open %s\n",name);
	  exit(1);
	}
	bin_size=file_size(in);
	bin_size+=1;
	bin_size&=-2;

 //------------------------------------------------------------
 // Ouverture du PRG
 //------------------------------------------------------------
	strcpy(name2,name);
	ptr = strrchr(name2,'.');
	if (ptr==0)
	  strcat(name2,".PRG");
	else
	  strcpy(ptr,".PRG");
	out=fopen(name2,"wb");
	if (!out) {
	  printf("ERROR: Unable to create %s\n",name2);
	  exit(1);
	}

	printf("Creating %s (ST executable)\n",name2);
	printf("ORG assumed:$%08X\n",org);

 //------------------------------------------------------------
 //------------------------------------------------------------

	_makepath(mypath,mydrive,mydir,"DOPRG",".DAT");
	runner=fopen(mypath,"rb");
	if (!runner) {
	  printf("ERROR: Unable to open \"%s\"\n",mypath);
	  exit(1);
	}


	run_size=file_size(runner);

	buffer=(UB *)malloc(run_size);
	if (!buffer) {
	  printf("ERROR: MALLOC error for %d bytes.\n",run_size);
	  exit(1);
	}
	fread(buffer,1,run_size,runner);
	fclose(runner);


	// Poke la taille section text.
	a=(run_size+bin_size-0x1c);

	buffer[2]=(a>>24)&255;
	buffer[3]=(a>>16)&255;
	buffer[4]=(a>>8)&255;
	buffer[5]=(a)&255;

	// ecrit entete du PRG.
	fwrite(buffer,1,run_size-8,out);


	// Ecrit taille du BIN.
	fputc((bin_size>>24)&255,out);
	fputc((bin_size>>16)&255,out);
	fputc((bin_size>>8)&255,out);
	fputc((bin_size)&255,out);

	// ecrit ORG
	fputc((org>>24)&255,out);
	fputc((org>>16)&255,out);
	fputc((org>>8)&255,out);
	fputc((org)&255,out);


	while (bin_size--) {
	  fputc(fgetc(in),out);
	}

	fputc(0,out);
	fputc(0,out);
	fputc(0,out);
	fputc(0,out);

	fclose(out);
	free(buffer);



 }







void	main(int argc,char *argv[])
 {




	printf(	"DOPRG.\n"
		"Make an Atari executable file.\n"
		"(C)OXYGENE 1995 by Leonard.\n\n");


	if ((argc<2) || (argc>3)) {
	  printf("USAGE:\n\n"
	  	 "   DOPRG <binary name> [ORG (hex)]\n"
		 "   (Ex: DOPRG mandel.bin 2A00)\n");

	  exit(0);
	}

	_splitpath(argv[0],mydrive,mydir,NULL,NULL);

	do_prg(argv[1],argv[2],argc);


 }




