UNIT GRAPHICS;
INTERFACE
{Uses pretest;}
CONST VGASEG = $A000;

TYPE Palette = Array[0..255,0..2] OF BYTE;
     Screentype= ARRAY [0..199,0..319] OF BYTE;
     ScreenPtr=^Screentype;

Var VirtScrn, Virt2: ScreenPtr;
    VirtOffset, virtsegment, virt2offset, virt2Segment: Word;
    R_Pal: Palette;
    Ch : Char;
    davy : integer;
    ddt, dd, d : Array [0..255] of byte;


PROCEDURE CallMode(Mode : Byte);

PROCEDURE FastPutPixel(x,y : Integer; Color : Byte;Vscrn : ScreenPtr);

PROCEDURE ClearScrn;

PROCEDURE SetColor(color,red,green,blue:BYTE);

PROCEDURE GetPal(ColorNo : Byte; Var R,G,B : Byte);

PROCEDURE WritePaletBlok(Pal:Palette);

PROCEDURE OpenScrn(VAR naam:ScreenPtr; VAR segm, ofset : Word);

PROCEDURE CloseScrn(VAR naam:ScreenPtr);

PROCEDURE CopyScrn(From, Tow : Word);

PROCEDURE ReadRawPic(lengte, grootte : integer; spr : array of byte; x,y, rich : integer);

PROCEDURE ReadPal(Name: String);

PROCEDURE LoadRAW (FileName :  string; ScrPtr : pointer);

PROCEDURE LoadSprite(name: String; hoogte, breedte, x, y:integer);

PROCEDURE WRetrace;

PROCEDURE FadeOut;

PROCEDURE FadeIn;

PROCEDURE LoadSpriteIn(name: String; hoogte, breedte, x, y:integer);

IMPLEMENTATION

PROCEDURE CallMode(Mode : Byte); Assembler;
ASM
   mov ah,0
   mov al,mode
   int 10h
END;

PROCEDURE FastPutPixel(x,y : Integer; Color : Byte;Vscrn : ScreenPtr);
Begin
     Vscrn^[y,x]:=Color;
End;

PROCEDURE ClearScrn;
Begin
     Fillchar(mem[$a000:0],64000,0);
End;

PROCEDURE SetColor(color,red,green,blue:BYTE);
Begin
     Port[$3C8]:=Color;
     Port[$3C9]:=Red;
     Port[$3C9]:=Green;
     Port[$3C9]:=Blue;
End;

PROCEDURE GetPal(ColorNo : Byte; Var R,G,B : Byte);
Begin
   Port[$3c7] := ColorNo;
   R := Port[$3c9];
   G := Port[$3c9];
   B := Port[$3c9];
End;
PROCEDURE WritePaletBlok(Pal:Palette);
VAR i : Byte;
Begin
     FOR i:=0 TO 255 DO
         SetColor(i,Pal[i,0],Pal[i,1],Pal[i,2]);
End;

PROCEDURE OpenScrn(VAR naam:ScreenPtr; VAR segm, ofset : Word);
Begin
     GetMem(naam,64000);
     segm  := seg(naam^);
     ofset := ofs(naam^);
End;

PROCEDURE CloseScrn(VAR naam:ScreenPtr);
Begin
     FreeMem(naam,64000);
End;

PROCEDURE CopyScrn(From, Tow : Word); Assembler;
ASM
   push ds
   mov ax,[From]
   mov ds,ax
   mov ax,[Tow]
   mov es,ax
   xor di,di
   xor si,si
   mov cx,32000
   rep movsw
   pop ds
End;

PROCEDURE ReadPal(Name: String);
type
  DACType = array [0..255] of record
                                R, G, B : byte;
                              end;
var
  DAC : DACType;
  Fil : file of DACType;
  f: text;
  I: integer;

begin
     assign (Fil, Name);
     reset (Fil);
     read (Fil, DAC);
     close (Fil);
     for I := 0 to 255 do begin
           R_PAL[i,0] := DAC [I].R;
           R_PAL[i,1] := DAC [I].G;
           R_PAL[i,2] := DAC [I].B;
     end;
end;

PROCEDURE ReadRawPic(lengte, grootte : integer; spr : array of byte; x,y, rich : integer);

VAR
    i: Integer;
    l: integer;
{    sprit : spr;}
    sec : word;
begin
 {    virtsegment := 0;}
 sec := 0;
     i:= 0;
     l:= 0;
                             For i := y to lengte + y do
                             Begin
                             For l := x to grootte + x do
                                                 Begin
                                  if (spr[sec] > 00) and (rich = 1) then FastPutPixel(l,i,spr[sec],VirtScrn);
                                  if (spr[sec] > 00) and (rich = 2) then FastPutPixel(320-l,i,spr[sec],VirtScrn);
                                                         { FastPutPixel(l,i,spr[sec],VirtScrn);}
                                                      inc(sec);
                                                 End;
                             End;

End;

PROCEDURE LoadRaw (FileName :  string; ScrPtr : pointer);
var
  Fil : file;
  Buf : array [1..1024] of byte;
  BlocksRead, Count : word;

begin
  assign (Fil, FileName);
  reset (Fil, 1);
  BlockRead (Fil, Buf, 0);
  Count := 0; BlocksRead := $FFFF;
  while (not eof (Fil)) and (BlocksRead <> 0) do begin
   BlockRead (Fil,mem [seg (ScrPtr^): ofs (ScrPtr^) + Count], 1024, BlocksRead);
     Count := Count + 1024;
  end;
  close (Fil);
end;

PROCEDURE LoadSprite(name: String; hoogte, breedte, x, y:integer);
VAR F: Text;
    i: Integer;
    l,Davide: integer;

Begin
{     VirtScrn^ := virt2^;}
{     VirtSegment :=virtSegment +320;}
     Assign(F, name);
     Reset(F);
     While not Eof(F) do
                        Begin
                             For i := y to hoogte + y do
                             Begin
                             For l := x to breedte + x do
                                                 Begin
                                                      Read(F,Ch);
                                                      davide := ord(ch);
                                                      if davide > 00 then FastPutPixel(l,i,davide,VirtScrn);
                                                     End;
                             End;
                        End;
          Close(f);
End;

PROCEDURE LoadSpriteIn(name: String; hoogte, breedte, x, y:integer);
VAR F: Text;
    i: Integer;
    l,Davide: integer;

Begin
{     VirtScrn^ := virt2^;}
{     VirtSegment :=virtSegment +320;}
     Assign(F, name);
     Reset(F);
     While not Eof(F) do
                        Begin
                             For i := y to hoogte + y do
                             Begin
                             For l := x to breedte + x do
                                                 Begin
                                                      Read(F,Ch);
                                                      davide := ord(ch);
                                                      if davide > 00 then FastPutPixel(320-l,i,davide,VirtScrn);
                                                     End;
                             End;
                        End;
          Close(f);
End;

PROCEDURE WRetrace; assembler;
label
  l1, l2;
asm
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
end;

Procedure FadeOut;
VAR loop1,loop2, davy:integer;
    Tmp : Array [1..3] of byte;
BEGIN
     for davy:=1 to 255 do BEGIN
     Getpal (davy,ddt[davy],dd[davy],d[davy]);
     END;
     For loop1:=1 to 64 do BEGIN
     WRetrace;
     For loop2:=1 to 255 do BEGIN
     Getpal (loop2,Tmp[1],Tmp[2],Tmp[3]);

      If Tmp[1]>0 then dec (Tmp[1]);
      If Tmp[2]>0 then dec (Tmp[2]);
      If Tmp[3]>0 then dec (Tmp[3]);
      SetColor(loop2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;

Procedure FadeIn;
VAR loop1,loop2:integer;
    Tmp : Array [1..3] of byte;
BEGIN
  For loop1:=1 to 64 do BEGIN
    WRetrace;
    For loop2:=1 to 255 do BEGIN
      Getpal (loop2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]<ddt[loop2] then inc (Tmp[1]);
      If Tmp[2]<dd[loop2] then inc (Tmp[2]);
      If Tmp[3]<d[loop2] then inc (Tmp[3]);
      SetColor(loop2,Tmp[1],Tmp[2],Tmp[3]);
    END;
  END;
END;



BEGIN
END.
