//--------------------------------------------------------------------------//
// iq . 2003/2008 . code for 64 kb intros by RGBA                           //
//--------------------------------------------------------------------------//


#include "sys/msys.h"
#include "resources/resource.h"
#include "intro.h"

#define M_PI       3.14159265358979323846

typedef struct
{
    long    mTo;
	int     mSeed;
}IntroObject;

xfader* fader;
xscroller* scroller;

//--------------------------------------------------------
static IntroObject intro;

//
// gluPerspective no longer exists in openGL, we use this version now.
//
void gluPerspective(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar)
{
   GLdouble xmin, xmax, ymin, ymax;

   ymax = zNear * tan(fovy * M_PI / 360.0);
   ymin = -ymax;
   xmin = ymin * aspect;
   xmax = ymax * aspect;


   glFrustum(xmin, xmax, ymin, ymax, zNear, zFar);
}

int intro_init(int nomusic, IntroProgressDelegate *pd, SCREEN_INFO *screenInfo )
{
    // progress report, (from 0 to 200)
    pd->func( pd->obj, 0 );

    
    // init your stuff here (mzk player, intro, ...)
    // remember to call pd->func() regularly to update the loading bar


    pd->func( pd->obj, 200 );

    intro.mTo = msys_timerGet();
	fader = new xfader();
	scroller = new xscroller("This is an entry by > for the % $Wireframe$ demo comp. This is my first attempt at OpenGL and the first time I've been near C++ in about 10 years (which has caused me to pull out quite a bit of hair and shed a few tears - hehe). This took longer than I thought and I've run out a time a bit but nevermind as it was great fun [ ... Developing in C# has spoiled me lately, but it's good to get back into learning new things again. Hopefully this rush job isn't too bad and I'll make sure I start coding earlier next time! I've used iq's RGBA 64k framework as a base for this demo, so hopefully it's fairly compatible with most machines. I've also used MiniFMod for the excellent music by LizardKing. I hoped to have the XM file embedded in the intro, but hit some snags and ran out of time for that (must practice C++). Big hellos to Shockwave, Benny, Jim, Padman, Kirl, CombatKing, HotShot, Xetick, Hellfire, Ferris, Rdc, LittleWhite, DrDeath, Zawran, Moroboshisan, Pixel Outlaw, TinDragon and any other DBF guys I've forgotten to mention. That's about it for this time. I'm sorry if I've given you eye ache with this thing. Staring at it for hours on end has really fried my retinas too! Scrolltext loops now - thanks very much for watching! $ [[[ $   % rules...  >...                ", fader, 1.0f, 1.0f, 1.0f);
    
	// set up GL stuff
	glClearDepth(1.f);
    glClearColor(0.f, 0.f, 0.f, 0.f);
    // Enable Z-buffer read and write
    glEnable(GL_DEPTH_TEST);
    glDepthMask(GL_TRUE);
    // Setup a perspective projection
    glMatrixMode(GL_PROJECTION);
	if (screenInfo->widescreen)
	{
		// 16:9 = 1.77:1
		gluPerspective(90.0f, 1.77f, 1.0f, 500.f);
	}else{
		gluPerspective(90.0f, 1.2f, 1.0f, 500.f);
	}

	if (!nomusic)
	{
		// load and play XM file from resource
		loadAndPlayMod(IDR_XMAUDIO1);
	}
	
	return 1;
}

void intro_end( void )
{    
    // deallicate your stuff here
}


//---------------------------------------------------------------------


int intro_do( void )
{
    float time = (1.0f/1000.0f) * (float)(msys_timerGet() - intro.mTo);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	scroller->Render(time);

	return( 0 );
}