#include "xscroller.h"
#include "sinus.h"

xscroller::xscroller(char* scrolltext, xfader* fader, float ypos, float scale, float speed)
{
	this->_speed = speed;
	this->_scale = scale;
	this->fader = fader;
	// store scrolltext
	this->_scrolltext = scrolltext;
	// create font
	this->_font = new xfont();
	this->_ypos = ypos;
	_numChars = strlen(scrolltext);
	_offset = 0;
	zoomingIn = false;
	zoom = 10.0f;
	zoomInc = 0.35f;
	zoomMax = 50;
	zoomMin = 0;
	sindex1=0;
	sindex2=0;		
	chars = (xscrollerChar*)msys_mallocAlloc(sizeof(xscrollerChar) * _numChars);

	// create the scoller characters
	for(unsigned int i=0; i<strlen(scrolltext); i++)
	{	
		xscrollerChar* ch = new xscrollerChar(this->_font->getChar(scrolltext[i]), scrolltext[i], fader, &SinTab1[0], sindex1, sindex2);
		chars[i] = *ch;
		
		sindex1+=16;
		sindex2+=54;
		sindex1 = sindex1 % 511;
		sindex2 = sindex2 % 511;
	}
}

void xscroller::RenderScroller(float time)
{
	if (_offset < -1909044926)
	{
		_offset = 100;
	}
	int offset = 100;
	int rendered = 0;
	for(int i=0; i<_numChars; i++)
	{
		xscrollerChar* xchar = &chars[i];
		xchar->Render(offset+_offset, _ypos, _scale);
		rendered++;

		offset+=xchar->width();
		if (xchar->thisCharValue == ' ')
		{
			offset+=8;
		}

		if (xchar->thisCharValue == 'a')
		{
			offset++;
		}
	}
	rendered = rendered+1;
	_offset-=0.75f*_speed;
}

void xscroller::Render(float time)
{
	// Apply some transformations
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(0.f, 0.f, -15.0f/_scale);

	if (!zoomingIn)
	{
		if (zoom > zoomMin)
		{
			zoom-=zoomInc;
		}else{
			zoomingIn = true;
		}
	}else{
		if (zoom < zoomMax)
		{
			zoom+=zoomInc/5;
		}else{
			zoomingIn = false;
		}
	}
	glPushMatrix();
	// correct viewing angle
	glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
	glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
	//glRotatef(20.0f, 0.0f, 0.0f, 1.0f);
	glRotatef(-25.0f, 1.0f, 0.0f, 0.0f);

	//glRotatef(time * 50, 0.0f, 1.0f, 0.0f);

	float zval = abs(zoomMin) / 10.0f;
	float zval2 = zval - (abs(zoom)/10.0f);
	float lw = zval2 * 2.0f;
	if (lw < 1.0f) lw = 1.0f;
	glLineWidth(lw);
	glEnable(GL_LINE_SMOOTH);

	// render
	RenderScroller(time);
	glPopMatrix();
}

xscroller::~xscroller(void)
{
}