#pragma once

#include "../sys/msys.h"
#include "../resources/resource.h"
#include "../sys/extra/msys_extra.h"
#include "../sys/extra/RNG.h"
#include "../sys/textureGen/textureGen.h"

// stuff for drawing the logo made of blocks at start of intro

class logoBlock
{
	public:
		vertex targetPos;
		vertex crossPos;
		vertex currentPos;
		float ax, ay, az;
		color4f color;
		float speed;
		float startTime;
		float percent, percent2;
		float height;
		float rotSpeed;
		float scalex, scaley, scalez;
};

struct CubeSettings {
	float sourcePos[3];
	float targetPos[3];
	float blockCol[3];
	float  percentDone;
};

class logo
{
public:

	fbo *fboFullscreen, *fboFullscreen2, *fbo512_2;

	vertex *bpTarget, *bpStart, *bpCurrent, *bn, *bnt;
	vertex *angleTarget, *angleCurrent, *angleStart;
	GLint _shaderIdLogo, _shaderIdRays;
	GLuint tbuffer;
	GLuint vboVerts3, vboNormals, vboColors, vboTexCoords1, vboTexCoords2, vboTexCoords3;
	int *indices;

	RNG *rng;
	vertex pixelSize;
	float *pct;
	bool *bactive;
	color4f *bc;
	vertex *transforms;

	float cubeSize;

	vertex4 *verts4, *tc4_1, *tc4_2, *tc4_3;
	color4f *vertCols;
	
	int numblocks;
	logoBlock **blocks;
	static GLuint textureId, lookupTextureId;
	logo(void);
	void GodRays();
	void logo::move(float time);
	void draw(double timeIn);
	int logo::createCube(int idx, int cubeNumVal, color4f color);
	void getBlocks(GLbyte* pixels);
	void logo::drawCube(float offsetX, float offsetY, float offsetZ, color4f color);
	~logo(void);
};

