/*
uniform sampler2D texture; 
uniform vec2 resolution;
uniform float time; 
uniform float value; 
uniform float deform_value; 
 
float PI=3.14159265358979323846; 
float lens=PI/deform_value; 
 
float x=-1.0; 
float y=-1.0; 
float m; 
 
vec3 deform(in sampler2D tex,in vec2 p) 
	{ 
	vec2 uv; 
	float radius=0.25; 
	float zoom=radius*cos(p.x*PI/lens)+radius*cos(p.y*PI/lens); 
	uv.x=p.x*zoom-0.5; 
	uv.y=p.y*zoom-0.5; 
	return texture2D(tex,uv).xyz; 
	} 
	
void main(void)
{
    vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;
    vec2 uv;

    float a = atan(p.y,p.x);
    float r = sqrt(dot(p,p));

    uv.x = cos(0.6+time) + cos(cos(1.2+time)+a)/r;
    uv.y = cos(0.3+time) + sin(cos(2.0+time)+a)/r;

    vec3 col =  texture2D(texture,uv*.25).xyz;

    gl_FragColor = vec4(col*r*r,1.0);
}
*/

/*
uniform sampler2D texture; 
uniform vec2 resolution;
uniform float time; 
uniform int value; 
uniform float deform_value; 
 
float PI=3.14159265358979323846; 
float lens=PI/deform_value; 
 
float plasma_angle1=0.11; 
float plasma_angle2=0.05; 
float plasma_angle3=0.09; 
float plasma_angle4=0.13; 
 
float v=1.0; 
 
vec2 deform(in vec2 p) 
	{ 
	float radius=1.5; 
	float zoom=radius*cos(p.x*PI/lens)+radius*cos(p.y*PI/lens); 
	return vec2(p.x*zoom-0.5,p.y*zoom-0.5); 
	} 
 
void main(void) 
	{ 
	vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy;
 
	p=deform(p); 
 
	vec3 color; 
	float r,b,c; 
 
	float plasma_a=p.x*cos(p.x*plasma_angle1+time*0.0625); 
	float plasma_b=p.x*sin(p.x*plasma_angle2+time*0.0250); 
	float plasma_c=p.y*cos(p.y*plasma_angle3+time*0.0375); 
	float plasma_d=p.y*sin(p.y*plasma_angle4+time*0.0500); 
 
	float a_a=p.x*cos(plasma_a+plasma_b+time*(plasma_angle1-plasma_angle2))*0.875; 
	float a_b=p.y*sin(plasma_b+plasma_c+time*(plasma_angle3-plasma_angle4))*0.750; 
	float a_c=p.x*cos(plasma_c+plasma_d+time*(plasma_angle1-plasma_angle3))*0.500; 
	float a_d=p.y*sin(plasma_d+plasma_a+time*(plasma_angle2-plasma_angle4))*0.625; 
	float a_e=(p.x*plasma_angle1*a_a+v)*cos(p.x*plasma_angle2*a_b); 
	float a_f=(p.y*plasma_angle3*a_c+v)*sin(p.y*plasma_angle4*a_d); 
	float a1=0.25*cos(a_a-a_c); 
	float a2=0.25*sin(a_b-a_d); 
	float a3=0.25*cos(a_e); 
	float a4=0.25*sin(a_f); 
 
	r=a1+a2-a3+a4; 
	b=-a1-a2+a3; 
 
	if(value==0) 
		{ 
		color=texture2D(texture,vec2(r,b)*2.0).xyz; 
		} 
	else 
		{ 
		color=texture2D(texture,vec2(r*cos(PI*p.x),b*cos(PI*p.y))).xyz; 
		} 
 
	color=color*color; 
	c=(color.r+color.g+color.b)*2.0; 
	color=vec3(c+r*0.5,c-(r+b)*0.5,c+b*0.5); 
 
	gl_FragColor=vec4(color,1.0); 
	} 
*/


uniform sampler2D texture; 
uniform vec2 resolution;
uniform float time; 
uniform float value; 
uniform float deform_value; 
 
float PI=3.14159265358979323846; 
float lens=PI/deform_value; 
 
float x=-1.0; 
float y=-1.0; 
//float m; 
 
vec3 deform(in sampler2D tex,in vec2 p) 
	{ 
	vec2 uv; 
	float radius=0.25; 
	float zoom=radius*cos(p.x*PI/lens)+radius*cos(p.y*PI/lens); 
	uv.x=p.x*zoom-0.5; 
	uv.y=p.y*zoom-0.5; 
	return texture2D(tex,uv).xyz; 
	} 
	
	
vec3 deformRadial( in vec2 p )
{
    vec2 uv;

    vec2 q = vec2( sin(1.1*time+p.x),sin(1.2*time+p.y) );

    float a = atan(q.y,q.x);
    float r = sqrt(dot(q,q));

    uv.x = sin(0.0+1.0*time)+p.x*sqrt(r*r+1.0);
    uv.y = sin(0.6+1.1*time)+p.y*sqrt(r*r+1.0);

    return texture2D(texture,uv*.5).xyz;
}	

void radialBlur(vec2 p)
{
    vec2 s = p;

    vec3 total = vec3(0.0);
    vec2 d = (vec2(0.0,0.0)-p)/40.0;
    float w = 1.0;
    for( int i=0; i<40; i++ )
    {
        vec3 res = deform(s);
        res = smoothstep(0.1,1.0,res*res);
        total += w*res;
        w *= .99;
        s += d;
    }
    total /= 40.0;
    float r = 1.5/(1.0+dot(p,p));
    return vec4( total*r,1.0);
}
 
 
void main(void) 
	{ 
	vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy; 
	vec2 uv; 
 
	float a=atan(p.x,p.y); 
	float r=dot(p+p,p+p); 
 
	uv.x=cos(4.0+time)+sin(cos(3.0+time)+a)/r; 
	uv.y=cos(3.0+time)+cos(sin(4.0+time)+a)/r; 
 
	vec3 color=deform(texture,uv*0.5).xyz; 
 
	//color=vec3(1.0-color.x,1.0-color.y,1.0-color.z); // invert color 
	
	color*=0.975+0.025*sin(time*77.7*cos(time*191.1));	// flickering 
	color*=0.9+0.1*sin(p.y*resolution.x*2+time*4.0);	// scanline 	
	color*=0.5+0.5*14.0*p.x*(1.0-p.x)*p.y*(1.0-p.y);		// vignetting
	gl_FragColor=vec4(color*r,1.0); 
	} 


/*
uniform sampler2D texture; 
uniform vec2 resolution;
uniform float time; 
uniform float value; 
 
float radius=2.0/float(resolution.x); 
float rand(in vec2 p) 
	{ 
	return fract(sin(dot(p.xy,vec2(12.9898,78.233)))*43758.5453); 
	} 
 
void main(void) 
	{ 
	vec2 p = -1.0 + 2.0 * gl_FragCoord.xy / resolution.xy; 
	vec3 source=texture2D(texture,p).xyz; 
 
	float rnd1=rand(vec2(p.x+time,p.y-time)); 
	float rnd2=rand(vec2(p.x-time,p.y+time)); 
	float disp=rnd1*radius; 
 
	vec3 color; 
	color.r=texture2D(texture,vec2(p.x+disp+radius,p.y)).x; 
	color.g=texture2D(texture,vec2(p.x+disp       ,p.y)).y; 
	color.b=texture2D(texture,vec2(p.x+disp-radius,p.y)).z; 
	color+=value; // flash 
	color-=vec3(rnd1,rnd1,rnd1)*0.1-vec3(rnd2,rnd2,rnd2)*0.1; 
	color=clamp(color*0.5+0.5*color*1.5,0.0,1.0); 
	//color*=0.5+0.5*24.0*p.x*(1.0-p.x)*p.y*(1.0-p.y);		// vignetting 
	color*=0.9+0.1*sin(p.y*resolution.x*2+time*4.0);	// scanline 
	//color*=0.975+0.025*sin(time*77.7*cos(time*191.1));	// flicking 
	color=mix(color,source,clamp(-1.0+1.0*p.x,0.0,1.0)); 
	gl_FragColor=vec4(color,1.0); 
	} 
	*/