#include "stacks.h"

vertexStack::vertexStack(int size)
{	
	max = size;
	items = new vertex[max];
	count = 0;
}

void vertexStack::push(vertex* v)
{
	copyVertex(&items[count++], v);
}

void vertexStack::pop()
{
	count--;
}

vertexStack::~vertexStack(void)
{
	delete(items);
}

/////////////////////////////

texCoordStack::texCoordStack(int size)
{
	max = size;
	items = new vertexTexCoord[max];	
	count = 0;
}

void texCoordStack::push(vertexTexCoord* tc)
{
	items[count].u = tc->u;
	items[count].v = tc->v;
	count++;
}

void texCoordStack::pop()
{
	count--;
}

texCoordStack::~texCoordStack(void)
{
	delete(items);
}

/////////////////////////////

colorStack::colorStack(int size)
{
	max = size;
	items = new color4f[max];	
	count = 0;
}

void colorStack::push(color4f* tc)
{
	items[count].r = tc->r;
	items[count].g = tc->g;
	items[count].b = tc->b;
	items[count].a = tc->a;
	count++;
}

void colorStack::pop()
{
	count--;
}

colorStack::~colorStack(void)
{
	delete(items);
}

/////////////////////////////

indexStack::indexStack(int size)
{
	max = size;
	items = new GLuint[max];	
	count = 0;
}

void indexStack::push(GLuint i)
{
	items[count++] = i;
}

void indexStack::pop()
{
	count--;
}

indexStack::~indexStack(void)
{
	delete(items);
}

/////////////////////////////

objectStack::objectStack(int size)
{
	max = size;
	items = new void*[max];	
	count = 0;
}

void objectStack::push(void* i)
{
	items[count++] = i;
}

void objectStack::pop()
{
	count--;
}

objectStack::~objectStack(void)
{
	delete(items);
}




