﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Pixels3d
{
    public partial class Form1 : Form
    {
        private Image _image;
        private Image _heightImage;

        public Form1()
        {
            InitializeComponent();
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "face.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "face_depthMask.png"));
            ProcessImages();
            Application.Idle += Application_Idle;
        }

        void Application_Idle(object sender, EventArgs e)
        {
            while (glControl1.IsIdle)
            {
                GlSurface.Instance.Render();
            }
        }

        /// <summary>
        /// Load image from filesys
        /// </summary>
        /// <param name="filepath"></param>
        /// <returns></returns>
        private Image LoadImage(string filepath)
        {
            var img = Image.FromFile(filepath);
            return img;
        }

        /// <summary>
        /// Convert the image and height map image into pixels list
        /// </summary>
        private void ProcessImages()
        {
            if (_image == null)
            {
                MessageBox.Show("Image not loaded!");
                return;
            }

            if (_heightImage == null)
            {
                MessageBox.Show("Height Image not loaded!");
                return;
            }

            if (_heightImage.Width != _image.Width || _heightImage.Height != _image.Height)
            {
                MessageBox.Show("Image and Height Image have different dimensions!");
                return;
            }

            // all good, process the pixels
            PixelList.CurrentList = PixelList.ListFromImageAndHeightMap(_image, _heightImage);
        }

        /// <summary>
        /// Get a file - prompts user to chose a PNG or JPG file
        /// </summary>
        /// <returns></returns>
        private string GetFile()
        {
            var fo = new OpenFileDialog();

            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            fo.InitialDirectory = appPath;
            fo.Filter = "JPG files|*.jpg;|PNG files|*.png;|All files (*.*)|*.*";
            if (fo.ShowDialog() != DialogResult.Cancel)
            {
                return fo.FileName;
            }
            return null;
        }

        private void loadImageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string filename = GetFile();
            _image = LoadImage(filename);
        }

        private void loadHeightmapImageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string filename = GetFile();
            _heightImage = LoadImage(filename);
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            GlSurface.Instance.SetControl(glControl1);
        }

        private void glControl1_MouseMove(object sender, MouseEventArgs e)
        {
            GlSurface.Instance.MouseMove(e);
        }

        private void glControl1_MouseDown(object sender, MouseEventArgs e)
        {
            GlSurface.Instance.MouseDown(e);
        }

        private void glControl1_MouseUp(object sender, MouseEventArgs e)
        {
            GlSurface.Instance.MouseUp(e);
        }

        private void fileToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void raizorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "face.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "face_depthMask.png"));
            ProcessImages();
        }

        private void ballToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "ball.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "ball.png"));
            ProcessImages();
        }

        private void girlToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "girl.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "girl.png"));
            ProcessImages();
        }

        private void emoGirlToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "emoGirl.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "emoGirl.png"));
            ProcessImages();

        }

        private void puppyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string appPath = System.IO.Path.GetDirectoryName(Application.ExecutablePath);
            string imagePath = Path.Combine(appPath, "images");
            _image = LoadImage(Path.Combine(imagePath, "puppy.png"));
            _heightImage = LoadImage(Path.Combine(imagePath, "puppy_dm.png"));
            ProcessImages();
        }

        private void processLoadedImagesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ProcessImages();
        }
    }
}
