#pragma once
#include "GetValueForm.h"
#include "Instruments.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;
#define MessageBoxA MessageBox
#define GetObjectA GetObject


namespace Buzzic
{
	/// <summary> 
	/// Summary for BytePatternsEditor
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class BytePatternsEditor : public System::Windows::Forms::Form
	{
		TextBox* tb[];
		TextBox* tb1[];
		bool suppressTextChange;
		int interpSelection;
		System::Int32 interpSelectedBoxes[];
		int interpPattern;
		int copiedPattern;
		int lastNoteGotFromNoteTextBox;
	public: static String* bytePatternNames[];
	private: System::Windows::Forms::ImageList *  imageList1;
	private: System::Windows::Forms::ToolTip *  toolTip1;
	private: System::Windows::Forms::Button *  btnInterpolate;
	private: System::Windows::Forms::Label *  lblRem;
	private: System::Windows::Forms::Button *  pbRename;
	private: System::Windows::Forms::ContextMenu *  contextMenu1;
	private: System::Windows::Forms::MenuItem *  menuItemCopyPattern;
	private: System::Windows::Forms::MenuItem *  menuItemPastePattern;
	private: System::Windows::Forms::Panel *  panelPatternNotes;
	private: System::Windows::Forms::Label *  label2;
	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::Label *  label4;
	private: System::Windows::Forms::NumericUpDown *  dfOctave;
	private: bool suppressCurrentPatternChange;
	public: 
		BytePatternsEditor(void)
		{
			InitializeComponent();
			tb = new TextBox*[16];
			tb1 = new TextBox*[16];
			suppressTextChange = false;
			suppressCurrentPatternChange = false;
			copiedPattern = interpSelection = -1;
			interpSelectedBoxes = new System::Int32[2];
		}
		static BytePatternsEditor ( ) {
			bytePatternNames = new String*[MAX_PATTERNS];
		}
        
	protected: 
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::ComboBox *  cmbCurPattern;
	private: System::Windows::Forms::Button *  btnAddPattern;
	private: System::Windows::Forms::Button *  btnRemovePattern;
	private: System::Windows::Forms::Panel *  panelPattern;
	private: System::ComponentModel::IContainer *  components;

	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = new System::ComponentModel::Container();
			System::Resources::ResourceManager *  resources = new System::Resources::ResourceManager(__typeof(Buzzic::BytePatternsEditor));
			this->label1 = new System::Windows::Forms::Label();
			this->cmbCurPattern = new System::Windows::Forms::ComboBox();
			this->contextMenu1 = new System::Windows::Forms::ContextMenu();
			this->menuItemCopyPattern = new System::Windows::Forms::MenuItem();
			this->menuItemPastePattern = new System::Windows::Forms::MenuItem();
			this->btnAddPattern = new System::Windows::Forms::Button();
			this->imageList1 = new System::Windows::Forms::ImageList(this->components);
			this->btnRemovePattern = new System::Windows::Forms::Button();
			this->panelPattern = new System::Windows::Forms::Panel();
			this->toolTip1 = new System::Windows::Forms::ToolTip(this->components);
			this->btnInterpolate = new System::Windows::Forms::Button();
			this->pbRename = new System::Windows::Forms::Button();
			this->lblRem = new System::Windows::Forms::Label();
			this->panelPatternNotes = new System::Windows::Forms::Panel();
			this->label2 = new System::Windows::Forms::Label();
			this->label3 = new System::Windows::Forms::Label();
			this->label4 = new System::Windows::Forms::Label();
			this->dfOctave = new System::Windows::Forms::NumericUpDown();
			(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dfOctave))->BeginInit();
			this->SuspendLayout();
			// 
			// label1
			// 
			this->label1->Location = System::Drawing::Point(8, 8);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(48, 16);
			this->label1->TabIndex = 0;
			this->label1->Text = S"Pattern:";
			// 
			// cmbCurPattern
			// 
			this->cmbCurPattern->Anchor = (System::Windows::Forms::AnchorStyles)((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Left) 
				| System::Windows::Forms::AnchorStyles::Right);
			this->cmbCurPattern->ContextMenu = this->contextMenu1;
			this->cmbCurPattern->DropDownStyle = System::Windows::Forms::ComboBoxStyle::DropDownList;
			this->cmbCurPattern->Location = System::Drawing::Point(8, 32);
			this->cmbCurPattern->MaxDropDownItems = 24;
			this->cmbCurPattern->Name = S"cmbCurPattern";
			this->cmbCurPattern->Size = System::Drawing::Size(129, 21);
			this->cmbCurPattern->TabIndex = 0;
			this->cmbCurPattern->SelectedIndexChanged += new System::EventHandler(this, cmbCurPattern_SelectedIndexChanged);
			// 
			// contextMenu1
			// 
			System::Windows::Forms::MenuItem* __mcTemp__1[] = new System::Windows::Forms::MenuItem*[2];
			__mcTemp__1[0] = this->menuItemCopyPattern;
			__mcTemp__1[1] = this->menuItemPastePattern;
			this->contextMenu1->MenuItems->AddRange(__mcTemp__1);
			// 
			// menuItemCopyPattern
			// 
			this->menuItemCopyPattern->Index = 0;
			this->menuItemCopyPattern->Text = S"Copy Pattern";
			this->menuItemCopyPattern->Click += new System::EventHandler(this, menuItemCopyPattern_Click);
			// 
			// menuItemPastePattern
			// 
			this->menuItemPastePattern->Index = 1;
			this->menuItemPastePattern->Text = S"Paste Pattern";
			this->menuItemPastePattern->Click += new System::EventHandler(this, menuItemPastePattern_Click);
			// 
			// btnAddPattern
			// 
			this->btnAddPattern->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right);
			this->btnAddPattern->ImageIndex = 1;
			this->btnAddPattern->ImageList = this->imageList1;
			this->btnAddPattern->Location = System::Drawing::Point(152, 4);
			this->btnAddPattern->Name = S"btnAddPattern";
			this->btnAddPattern->Size = System::Drawing::Size(40, 23);
			this->btnAddPattern->TabIndex = 2;
			this->toolTip1->SetToolTip(this->btnAddPattern, S"Add pattern");
			this->btnAddPattern->Click += new System::EventHandler(this, btnAddPattern_Click);
			// 
			// imageList1
			// 
			this->imageList1->ColorDepth = System::Windows::Forms::ColorDepth::Depth24Bit;
			this->imageList1->ImageSize = System::Drawing::Size(18, 18);
			this->imageList1->ImageStream = (__try_cast<System::Windows::Forms::ImageListStreamer *  >(resources->GetObject(S"imageList1.ImageStream")));
			this->imageList1->TransparentColor = System::Drawing::Color::Teal;
			// 
			// btnRemovePattern
			// 
			this->btnRemovePattern->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right);
			this->btnRemovePattern->ImageIndex = 0;
			this->btnRemovePattern->ImageList = this->imageList1;
			this->btnRemovePattern->Location = System::Drawing::Point(152, 32);
			this->btnRemovePattern->Name = S"btnRemovePattern";
			this->btnRemovePattern->Size = System::Drawing::Size(40, 23);
			this->btnRemovePattern->TabIndex = 3;
			this->toolTip1->SetToolTip(this->btnRemovePattern, S"Remove pattern");
			this->btnRemovePattern->Click += new System::EventHandler(this, btnRemovePattern_Click);
			// 
			// panelPattern
			// 
			this->panelPattern->Anchor = (System::Windows::Forms::AnchorStyles)(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Left) 
				| System::Windows::Forms::AnchorStyles::Right);
			this->panelPattern->Location = System::Drawing::Point(64, 72);
			this->panelPattern->Name = S"panelPattern";
			this->panelPattern->Size = System::Drawing::Size(72, 216);
			this->panelPattern->TabIndex = 1;
			// 
			// btnInterpolate
			// 
			this->btnInterpolate->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right);
			this->btnInterpolate->ImageIndex = 2;
			this->btnInterpolate->ImageList = this->imageList1;
			this->btnInterpolate->Location = System::Drawing::Point(152, 96);
			this->btnInterpolate->Name = S"btnInterpolate";
			this->btnInterpolate->Size = System::Drawing::Size(40, 24);
			this->btnInterpolate->TabIndex = 5;
			this->toolTip1->SetToolTip(this->btnInterpolate, S"Interpolate values");
			this->btnInterpolate->Click += new System::EventHandler(this, btnInterpolate_Click);
			// 
			// pbRename
			// 
			this->pbRename->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right);
			this->pbRename->Location = System::Drawing::Point(152, 64);
			this->pbRename->Name = S"pbRename";
			this->pbRename->Size = System::Drawing::Size(40, 23);
			this->pbRename->TabIndex = 4;
			this->pbRename->Text = S"Ren";
			this->toolTip1->SetToolTip(this->pbRename, S"Rename pattern");
			this->pbRename->Click += new System::EventHandler(this, pbRename_Click);
			// 
			// lblRem
			// 
			this->lblRem->Anchor = (System::Windows::Forms::AnchorStyles)((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Right);
			this->lblRem->Location = System::Drawing::Point(144, 128);
			this->lblRem->Name = S"lblRem";
			this->lblRem->Size = System::Drawing::Size(48, 184);
			this->lblRem->TabIndex = 6;
			// 
			// panelPatternNotes
			// 
			this->panelPatternNotes->Anchor = (System::Windows::Forms::AnchorStyles)((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Left);
			this->panelPatternNotes->Location = System::Drawing::Point(0, 72);
			this->panelPatternNotes->Name = S"panelPatternNotes";
			this->panelPatternNotes->Size = System::Drawing::Size(56, 216);
			this->panelPatternNotes->TabIndex = 7;
			// 
			// label2
			// 
			this->label2->Location = System::Drawing::Point(0, 56);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(48, 16);
			this->label2->TabIndex = 8;
			this->label2->Text = S"Notes:";
			// 
			// label3
			// 
			this->label3->Location = System::Drawing::Point(64, 56);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(56, 16);
			this->label3->TabIndex = 9;
			this->label3->Text = S"Numbers:";
			// 
			// label4
			// 
			this->label4->Location = System::Drawing::Point(0, 296);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(48, 16);
			this->label4->TabIndex = 10;
			this->label4->Text = S"Octave:";
			// 
			// dfOctave
			// 
			this->dfOctave->Location = System::Drawing::Point(64, 296);
			System::Int32 __mcTemp__2[] = new System::Int32[4];
			__mcTemp__2[0] = 10;
			__mcTemp__2[1] = 0;
			__mcTemp__2[2] = 0;
			__mcTemp__2[3] = 0;
			this->dfOctave->Maximum = System::Decimal(__mcTemp__2);
			this->dfOctave->Name = S"dfOctave";
			this->dfOctave->Size = System::Drawing::Size(40, 20);
			this->dfOctave->TabIndex = 11;
			System::Int32 __mcTemp__3[] = new System::Int32[4];
			__mcTemp__3[0] = 4;
			__mcTemp__3[1] = 0;
			__mcTemp__3[2] = 0;
			__mcTemp__3[3] = 0;
			this->dfOctave->Value = System::Decimal(__mcTemp__3);
			// 
			// BytePatternsEditor
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(200, 320);
			this->Controls->Add(this->dfOctave);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->panelPatternNotes);
			this->Controls->Add(this->pbRename);
			this->Controls->Add(this->lblRem);
			this->Controls->Add(this->btnInterpolate);
			this->Controls->Add(this->panelPattern);
			this->Controls->Add(this->btnRemovePattern);
			this->Controls->Add(this->btnAddPattern);
			this->Controls->Add(this->cmbCurPattern);
			this->Controls->Add(this->label1);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::SizableToolWindow;
			this->Name = S"BytePatternsEditor";
			this->ShowInTaskbar = false;
			this->Text = S"Edit Patterns";
			this->Load += new System::EventHandler(this, BytePatternsEditor_Load);
			(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dfOctave))->EndInit();
			this->ResumeLayout(false);

		}		
	private: 
		
		// Creates form controls
		System::Void BytePatternsEditor_Load ( System::Object *  sender, System::EventArgs *  e ) {
			for ( int i = 15; i >= 0; i-- ) {
				// Number
				TextBox *t = new TextBox ( );
				t->Dock = DockStyle::Top;
				panelPattern->Controls->Add ( t );
				if ( !(i%4) )
					t->BackColor = Color::FromArgb ( 240, 240, 240 );
				t->BorderStyle = BorderStyle::None;
				t->TabIndex = 80 + i;
				t->Tag = __box(i);
				tb[i] = t;
				t->add_TextChanged ( new EventHandler ( this, tb_TextChanged ) );
				t->add_KeyDown ( new KeyEventHandler ( this, tb_KeyDown ) );
				t->add_MouseDown ( new MouseEventHandler ( this, tb_MouseDown ) );
				t->add_DoubleClick ( new EventHandler ( this, tb_DoubleClick ) );
				// Notes
				TextBox *t1 = new TextBox ( );
				t1->Dock = DockStyle::Top;
				panelPatternNotes->Controls->Add ( t1 );
				if ( !(i%4) )
					t1->BackColor = Color::FromArgb ( 240, 240, 240 );
				t1->BorderStyle = BorderStyle::None;
				t1->TabIndex = 40 + i;
				t1->Tag = __box(i);
				tb1[i] = t1;
				t1->add_KeyDown ( new KeyEventHandler ( this, tb1_KeyDown ) );
				//t1->add_KeyUp ( new KeyEventHandler ( this, tb1_KeyUp ) );
				t1->add_KeyPress ( new KeyPressEventHandler ( this, tb1_KeyPress ) );
			}
			RefreshPatterns ( 0 );
		}

		// Returns note name by it's code
		System::String* GetNoteName ( int n ) {
			if ( n < 1 )
				return String::Empty;
			int oct = (n - 45)/12 + 4;
			if ( n < 45 )
				oct = 3 - (44 - n)/12;
			if ( oct < 0 )
				return String::Empty;
			int offs = n - (45+12*(oct-4));
			if ( offs < 0 || offs > 11 )
				return S"???";
			System::String* notes[] = { S"C-", S"C#", S"D-", S"D#", S"E-", S"F-", S"F#", S"G-", S"G#", S"A-", S"A#", S"B-" };
			return String::Concat ( notes[offs], Convert::ToString ( oct ) );
		}

		// Displays note name for given row
		void DisplayNoteName ( int k ) {
			int v = 0;
			try {
				v = Convert::ToInt32 ( tb[k]->Text );
			}
			catch ( Exception* ) {
				v = 0;
			}
			tb1[k]->Text = GetNoteName ( v );
		}

		// Processes text change
		System::Void tb_TextChanged ( System::Object *  sender, System::EventArgs *  e ) {
			if ( suppressTextChange )
				return;
			TextBox* t = dynamic_cast<TextBox*>(sender);
			int patRowNo = Convert::ToInt32 ( t->Tag );
			if ( cmbCurPattern->SelectedIndex < 0 ) {
				suppressTextChange = true;
				t->Text = String::Empty;
				tb1[patRowNo]->Text = String::Empty;
				suppressTextChange = false;
				return;
			}
			int k = 0;
			try {
				k = Convert::ToInt32 ( t->Text );
			}
			catch ( Exception* ) {
				k = 0;
			}
			if ( k < 0 )
				k = 0;
			if ( k == 0 )
				t->Text = String::Empty;
			if ( k > 127 ) {
				k = 127;
				suppressTextChange = true;
				t->Text = k.ToString ( );
				suppressTextChange = false;
			}
			g_bytePatterns[cmbCurPattern->SelectedIndex][patRowNo] = k;
			// Write note
			tb1[patRowNo]->Text = GetNoteName ( k );
		}

		// Removes pattern line
		void RemoveLine ( int k ) {
			if ( cmbCurPattern->SelectedIndex < 0 )
				return;
			for ( int t = k; t < 15; t++ )
				tb[t]->Text = tb[t+1]->Text;
			tb[15]->Text = String::Empty;
		}

		// Adds pattern line
		void AddLine ( int k ) {
			if ( cmbCurPattern->SelectedIndex < 0 )
				return;
			for ( int t = 15; t > k; t-- )
				tb[t]->Text = tb[t-1]->Text;
			tb[k]->Text = String::Empty;
		}

		// Processes key press event
		System::Void tb_KeyDown ( Object* sender, KeyEventArgs* e ) {
			TextBox* t = dynamic_cast<TextBox*>(sender);
			int k = Convert::ToInt32 ( t->Tag );
			if ( e->KeyValue == Keys::Down ) {
				tb[(k+1)%16]->Focus ( );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::Up ) {
				TextBox* bb;
				if ( k > 0 )
					bb = tb[(k-1)%16];
				else
					bb = tb[15];
				bb->Focus ( );
				bb->SelectAll ( );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::D && e->Control ) {
				RemoveLine ( k );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::I && e->Control ) {
				AddLine ( k );
				e->Handled = true;
			}
		}

		// Processes key down event on note textbox
		System::Void tb1_KeyDown ( Object* sender, KeyEventArgs* e ) {
			lastNoteGotFromNoteTextBox = -1;
			TextBox* t = dynamic_cast<TextBox*>(sender);
			int k = Convert::ToInt32 ( t->Tag );
			if ( e->KeyValue == Keys::Delete || e->KeyValue == Keys::Back ) {
				lastNoteGotFromNoteTextBox = -1;
				tb[k]->Text = String::Empty;
				DisplayNoteName ( k );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::Down ) {
				tb1[(k+1)%16]->Focus ( );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::Up ) {
				TextBox* bb;
				if ( k > 0 )
					bb = tb1[(k-1)%16];
				else
					bb = tb1[15];
				bb->Focus ( );
				bb->SelectAll ( );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::D && e->Control ) {
				RemoveLine ( k );
				e->Handled = true;
			}
			if ( e->KeyValue == Keys::I && e->Control ) {
				AddLine ( k );
				e->Handled = true;
			}
			// Process note keys
			if ( !e->Handled ) {
				Keys kk[] = {	Keys::Z, Keys::S, Keys::X, Keys::D, Keys::C, Keys::V, Keys::G, Keys::B, Keys::H, Keys::N, Keys::J, Keys::M,
								Keys::Q, Keys::D2, Keys::W, Keys::D3, Keys::E, Keys::R, Keys::D5, Keys::T, Keys::D6, Keys::Y, Keys::D7, Keys::U };
				int base_octave = Convert::ToInt32 ( dfOctave->Value );
				for ( int i = 0; i < 24; i++ )
					if ( kk[i] == e->KeyValue ) {
						lastNoteGotFromNoteTextBox = i + 45 + (base_octave-4)*12;
						if ( lastNoteGotFromNoteTextBox > 127 )
							lastNoteGotFromNoteTextBox = 127;
						e->Handled = true;
					}
			}
		}

		// Processes key press event on note textbox
		System::Void tb1_KeyPress ( Object* sender, KeyPressEventArgs* e ) {
			e->Handled = true;
			TextBox* t = dynamic_cast<TextBox*>(sender);
			t->Text = String::Empty;
			int k = Convert::ToInt32 ( t->Tag );
			if ( lastNoteGotFromNoteTextBox < 0 )
				tb[k]->Text = String::Empty;
			else
				tb[k]->Text = Convert::ToString ( lastNoteGotFromNoteTextBox );
			DisplayNoteName ( k );
			lastNoteGotFromNoteTextBox = -1;
		}

	private: 

		// Adds new byte pattern
		System::Void btnAddPattern_Click ( System::Object *  sender, System::EventArgs *  e ) {
			GetValueForm* f = new GetValueForm ( );
			f->Text = S"Enter pattern name";
			if ( DialogResult::Cancel == f->ShowDialog ( ) )
				return;
			ZeroMemory ( g_bytePatterns[g_bytePatternsCount], 16 );
			bytePatternNames[g_bytePatternsCount++] = f->dfValue->Text;
			RefreshPatterns ( g_bytePatternsCount - 1 );
		}

		// Fills pattern text boxes
		void FillPatternTextBoxes ( ) {
			// Copy data to text boxes
			for ( int i = 0; i < 16; i++ ) {
				if ( cmbCurPattern->SelectedIndex >= 0 && g_bytePatterns[cmbCurPattern->SelectedIndex][i] )
					tb[i]->Text = Convert::ToString ( g_bytePatterns[cmbCurPattern->SelectedIndex][i] );
				else
					tb[i]->Text = String::Empty;
			}
		}

		// Refreshes patterns list
public:	void RefreshFormPatterns ( int curValue ) {
			suppressCurrentPatternChange = true;
			int oldSel = cmbCurPattern->SelectedIndex;
			cmbCurPattern->Items->Clear ( );
			for ( int i = 0; i < g_bytePatternsCount; i++ )
				cmbCurPattern->Items->Add ( bytePatternNames[i] );
			suppressCurrentPatternChange = false;
			if ( oldSel >= cmbCurPattern->Items->Count )
				oldSel = cmbCurPattern->Items->Count - 1;
			if ( curValue >= 0 && curValue < cmbCurPattern->Items->Count ) 
				cmbCurPattern->SelectedIndex = curValue;
			else
				cmbCurPattern->SelectedIndex = oldSel;
			FillPatternTextBoxes ( );
		}

		// Refreshes all patterns list
		void RefreshPatterns ( int curValue ) {
			Form* f = this->Owner;
			for ( int i = 0; i < f->OwnedForms->Count; i++ ) {
				BytePatternsEditor* ed = dynamic_cast<BytePatternsEditor*>(f->OwnedForms[i]);
				if ( ed )
					ed->RefreshFormPatterns ( curValue );
			}
		}

	private: System::Void cmbCurPattern_SelectedIndexChanged ( System::Object *  sender, System::EventArgs *  e ) {
				if ( suppressCurrentPatternChange )
					return;
				FillPatternTextBoxes ( );
			 }

private:
		// Removes pattern
		System::Void btnRemovePattern_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( cmbCurPattern->SelectedIndex < 0 )
				return;
			if ( DialogResult::No == MessageBox::Show ( NULL, S"Remove byte pattern?", S"Removing byte pattern",
				MessageBoxButtons::YesNo, MessageBoxIcon::Question ) )
				return;
			for ( int i = cmbCurPattern->SelectedIndex; i < g_bytePatternsCount - 1; i++ ) {
				bytePatternNames[i] = bytePatternNames[i+1];
				CopyMemory ( g_bytePatterns[i], g_bytePatterns[i+1], 16 );
			}
			g_bytePatternsCount--;
			// Clear all references to this pattern and shift patterns in sequences down
			for ( int s = 0; s < g_byteSequencesCount; s++ ) {
				for ( int k = 0; k < MAX_TEMPLATE_MELODY_LEN; k++ ) {
					if ( g_byteSequences[s][k] == cmbCurPattern->SelectedIndex + 1 )
						g_byteSequences[s][k] = 0;
					if ( g_byteSequences[s][k] > cmbCurPattern->SelectedIndex + 1 )
						g_byteSequences[s][k]--;
				}
			}
			RefreshPatterns ( -1 );
		}

		protected: 

			// Close by ESC key
			bool ProcessCmdKey ( Message* msg, Keys keyData ) {
				if ( keyData == Keys::Escape ) {
					Close ( );
					return true;
				}
				return Form::ProcessCmdKey ( msg, keyData );
			}
		
private:
		// Interpolates values
		System::Void btnInterpolate_Click ( System::Object *  sender, System::EventArgs *  e ) {
			interpPattern = cmbCurPattern->SelectedIndex;
			if ( interpPattern < 0 )
				return;
			interpSelection = 0;
			lblRem->Text = "Select first row";
		}

		// Processes mouse clicks on text boxes
		void tb_MouseDown ( Object* sender, MouseEventArgs* e ) {
			if ( interpSelection < 0 )
				return;
			TextBox* t = dynamic_cast<TextBox*>(sender);
			int k = Convert::ToInt32 ( t->Tag );
			interpSelectedBoxes[interpSelection++] = k;
			if ( interpSelection == 1 )
				lblRem->Text = "Select second row";
			if ( interpSelection == 2 ) {
				// Interpolate selected rows
				lblRem->Text = String::Empty;
				interpSelection = -1;
				int k0 = min ( interpSelectedBoxes[0], interpSelectedBoxes[1] );
				int k1 = max ( interpSelectedBoxes[0], interpSelectedBoxes[1] );
				if ( k0 == k1 )
					return;
				int v0 = g_bytePatterns[interpPattern][k0];
				int v1 = g_bytePatterns[interpPattern][k1];
				for ( int i = k0 + 1; i < k1; i++ )
					tb[i]->Text = Convert::ToString ( v0 + (v1-v0)*(i-k0)/(k1-k0) ); 
			}
		}

private:

		// Changes pattern text
		System::Void pbRename_Click ( System::Object *  sender, System::EventArgs *  e ) {
			 if ( cmbCurPattern->SelectedIndex < 0 )
				return;
			GetValueForm* f = new GetValueForm ( );
			f->Text = S"Enter pattern name";
			f->dfValue->Text = cmbCurPattern->Text;
			if ( DialogResult::Cancel == f->ShowDialog ( NULL ) )
				return;
			bytePatternNames[cmbCurPattern->SelectedIndex] = f->dfValue->Text;
			RefreshPatterns ( -1 );
		}

private: System::Void menuItemCopyPattern_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 copiedPattern = cmbCurPattern->SelectedIndex;
		 }

private: System::Void menuItemPastePattern_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if ( copiedPattern >= 0 && copiedPattern < g_bytePatternsCount && cmbCurPattern->SelectedIndex >= 0 ) {
				 for ( int i = 0; i < tb->Length; i++ )
					 tb[i]->Text = Convert::ToString ( g_bytePatterns[copiedPattern][i] );
			 }
		 }

		 System::Void tb_DoubleClick(System::Object *  sender, System::EventArgs *  e)
		 {
			TextBox* t = dynamic_cast<TextBox*>(sender);
			int k = Convert::ToInt32 ( t->Tag );
			if ( Control::ModifierKeys & Keys::Control )
				RemoveLine ( k );
			else
				AddLine ( k );
		 }

};

}