#pragma once
#include "Instruments.h"
#include "GetValueForm.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;


namespace Buzzic
{
	/// <summary> 
	/// Summary for InstrumentEditor
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class InstrumentEditor : public System::Windows::Forms::Form
	{
		int insNo;
		Instrument* ins;
		int focusedOper;
		int focusedLine;
		int lineFromObj;
		int lineFromPort;
		String* byteSequenceNames[];
		POINT lineFrom;
		HFONT hFont;
		static System::Drawing::Point lastWinPos;
		static System::Drawing::Size  lastWinSize;
	private: System::Windows::Forms::ContextMenu *  contextMenu1;
	private: System::Windows::Forms::MenuItem *  menuItemDelete;
	private: System::Windows::Forms::Label *  label1;
	private: System::Windows::Forms::Label *  label2;
	private: System::Windows::Forms::ComboBox *  cmbNote;
	private: System::Windows::Forms::ComboBox *  cmbNoteLen;
	private: System::Windows::Forms::Label *  label3;
	private: System::Windows::Forms::TextBox *  dfStackSize;
	private: System::Windows::Forms::Label *  label4;

	private: System::Windows::Forms::Label *  label5;
	private: System::Windows::Forms::TextBox *  dfAmplitude;
	private: System::Windows::Forms::ComboBox *  cmbVolume;
	private: System::Windows::Forms::HScrollBar *  hScrollBar1;
	private: System::Windows::Forms::VScrollBar *  vScrollBar1;


			 POINT lastMovePos;
	public: 
		__value struct OperationEditData {
		public:
			Operation* op;
			int param;
			int type;
		};

		// Constructors
		InstrumentEditor ( ) {
			InitializeComponent ( );
		}
		InstrumentEditor ( int insNo, String* byteSequenceNames[] ) {
			InitializeComponent ( );
			String* s = g_instruments[insNo].name;
			Text = String::Format ( "{0} '{1}'", Text, s );
			this->insNo = insNo;
			this->byteSequenceNames = byteSequenceNames;
			ins = g_instruments + insNo;
			focusedOper = -1;
			lineFromObj = -1;
			focusedLine = -1;
			tvOperators->ExpandAll ( );
			hFont = NULL;
			// Colorize nodes
			for ( int i = 0; i < tvOperators->Nodes->Count; i++ ) {
				Color c = Color::FromArgb ( 255, 240, 255 );
				TreeNode* nd = tvOperators->Nodes->get_Item ( i );
				if ( nd->Text == S"Push" )
					c = Color::FromArgb ( 230, 255, 240 );
				if ( nd->Text == S"Oscillator" )
					c = Color::FromArgb ( 230, 240, 255 );
				if ( nd->Text == S"Arithmetics" )
					c = Color::FromArgb ( 255, 255, 240 );
				nd->BackColor = c;
				for ( int k = 0; k < nd->Nodes->Count; k++ ) {
					TreeNode* ndc = nd->Nodes->get_Item ( k );
					ndc->BackColor = c;
				}
			}
			for ( int i = 0; i < g_byteSequencesCount; i++ ) {
				cmbNote->Items->Add ( byteSequenceNames[i] );
				cmbNoteLen->Items->Add ( byteSequenceNames[i] );
				cmbVolume->Items->Add ( byteSequenceNames[i] );
			}
			SetComboStreamValue ( cmbNote, ins->note );
			SetComboStreamValue ( cmbNoteLen, ins->noteLen );
			SetComboStreamValue ( cmbVolume, ins->volume );
		}

		// Sets combo box stream value
		void SetComboStreamValue ( ComboBox* cb, char val ) {
			if ( val >= 0 )
				cb->Text = Convert::ToString ( val );
			else if ( byteSequenceNames[-val - 1] )
				cb->Text = byteSequenceNames[-val - 1];
			else
				cb->Text = String::Empty;
		}

		// Gets combo box stream value (throws exceptions)
		char GetComboStreamValue ( ComboBox* cb ) {
			char k1 = 0;
			bool found = false;
			for ( int i = 0; i < g_byteSequencesCount; i++ ) {
				if ( byteSequenceNames[i]->Equals ( cb->Text ) ) {
					found = true;
					k1 = -(i + 1);
				}
			}
			if ( !found ) {
				int k = Convert::ToInt32 ( cb->Text );
				if ( k < 0 ) k = 0;
				if ( k > 127 ) k = 127;
				k1 = k;
			}
			return k1;
		}
        
	protected: 
		void Dispose ( Boolean disposing ) {
			if ( disposing && components )
				components->Dispose ( );
			if ( disposing && hFont ) {
				DeleteObject ( hFont );
				hFont = NULL;
			}
			__super::Dispose ( disposing );
		}
	private: System::Windows::Forms::Button *  btnPlay;
	private: System::Windows::Forms::Button *  btnClose;
	private: System::Windows::Forms::TreeView *  tvOperators;
	private: System::Windows::Forms::Panel *  panelLeft;
	private: System::Windows::Forms::Panel *  pic;


	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container* components;

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->btnPlay = new System::Windows::Forms::Button();
			this->btnClose = new System::Windows::Forms::Button();
			this->tvOperators = new System::Windows::Forms::TreeView();
			this->panelLeft = new System::Windows::Forms::Panel();
			this->pic = new MyPanel();
			this->contextMenu1 = new System::Windows::Forms::ContextMenu();
			this->menuItemDelete = new System::Windows::Forms::MenuItem();
			this->vScrollBar1 = new System::Windows::Forms::VScrollBar();
			this->hScrollBar1 = new System::Windows::Forms::HScrollBar();
			this->label1 = new System::Windows::Forms::Label();
			this->label2 = new System::Windows::Forms::Label();
			this->cmbNote = new System::Windows::Forms::ComboBox();
			this->cmbNoteLen = new System::Windows::Forms::ComboBox();
			this->label3 = new System::Windows::Forms::Label();
			this->dfStackSize = new System::Windows::Forms::TextBox();
			this->label4 = new System::Windows::Forms::Label();
			this->label5 = new System::Windows::Forms::Label();
			this->dfAmplitude = new System::Windows::Forms::TextBox();
			this->cmbVolume = new System::Windows::Forms::ComboBox();
			this->panelLeft->SuspendLayout();
			this->pic->SuspendLayout();
			this->SuspendLayout();
			// 
			// btnPlay
			// 
			this->btnPlay->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right);
			this->btnPlay->Location = System::Drawing::Point(584, 424);
			this->btnPlay->Name = S"btnPlay";
			this->btnPlay->Size = System::Drawing::Size(64, 40);
			this->btnPlay->TabIndex = 0;
			this->btnPlay->Text = S"Play";
			this->btnPlay->Click += new System::EventHandler(this, btnPlay_Click);
			// 
			// btnClose
			// 
			this->btnClose->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Right);
			this->btnClose->DialogResult = System::Windows::Forms::DialogResult::Cancel;
			this->btnClose->Location = System::Drawing::Point(656, 424);
			this->btnClose->Name = S"btnClose";
			this->btnClose->Size = System::Drawing::Size(64, 40);
			this->btnClose->TabIndex = 1;
			this->btnClose->Text = S"Close";
			this->btnClose->Click += new System::EventHandler(this, btnClose_Click);
			// 
			// tvOperators
			// 
			this->tvOperators->Dock = System::Windows::Forms::DockStyle::Fill;
			this->tvOperators->ImageIndex = -1;
			this->tvOperators->Location = System::Drawing::Point(0, 0);
			this->tvOperators->Name = S"tvOperators";
			System::Windows::Forms::TreeNode* __mcTemp__1[] = new System::Windows::Forms::TreeNode*[5];
			System::Windows::Forms::TreeNode* __mcTemp__2[] = new System::Windows::Forms::TreeNode*[5];
			__mcTemp__2[0] = new System::Windows::Forms::TreeNode(S"Sequence");
			__mcTemp__2[1] = new System::Windows::Forms::TreeNode(S"Const");
			__mcTemp__2[2] = new System::Windows::Forms::TreeNode(S"Note");
			__mcTemp__2[3] = new System::Windows::Forms::TreeNode(S"Time");
			__mcTemp__2[4] = new System::Windows::Forms::TreeNode(S"Current");
			__mcTemp__1[0] = new System::Windows::Forms::TreeNode(S"Push", __mcTemp__2);
			System::Windows::Forms::TreeNode* __mcTemp__3[] = new System::Windows::Forms::TreeNode*[6];
			__mcTemp__3[0] = new System::Windows::Forms::TreeNode(S"Sin");
			__mcTemp__3[1] = new System::Windows::Forms::TreeNode(S"Saw");
			__mcTemp__3[2] = new System::Windows::Forms::TreeNode(S"Noise");
			__mcTemp__3[3] = new System::Windows::Forms::TreeNode(S"Exp");
			__mcTemp__3[4] = new System::Windows::Forms::TreeNode(S"SinG");
			__mcTemp__3[5] = new System::Windows::Forms::TreeNode(S"SawG");
			__mcTemp__1[1] = new System::Windows::Forms::TreeNode(S"Oscillator", __mcTemp__3);
			System::Windows::Forms::TreeNode* __mcTemp__4[] = new System::Windows::Forms::TreeNode*[2];
			__mcTemp__4[0] = new System::Windows::Forms::TreeNode(S"Add");
			__mcTemp__4[1] = new System::Windows::Forms::TreeNode(S"Mul");
			__mcTemp__1[2] = new System::Windows::Forms::TreeNode(S"Arithmetics", __mcTemp__4);
			System::Windows::Forms::TreeNode* __mcTemp__5[] = new System::Windows::Forms::TreeNode*[2];
			__mcTemp__5[0] = new System::Windows::Forms::TreeNode(S"Lowpass");
			__mcTemp__5[1] = new System::Windows::Forms::TreeNode(S"Highpass");
			__mcTemp__1[3] = new System::Windows::Forms::TreeNode(S"Filter", __mcTemp__5);
			System::Windows::Forms::TreeNode* __mcTemp__6[] = new System::Windows::Forms::TreeNode*[4];
			__mcTemp__6[0] = new System::Windows::Forms::TreeNode(S"ADSR");
			__mcTemp__6[1] = new System::Windows::Forms::TreeNode(S"Pan");
			__mcTemp__6[2] = new System::Windows::Forms::TreeNode(S"Echo");
			__mcTemp__6[3] = new System::Windows::Forms::TreeNode(S"Compress");
			__mcTemp__1[4] = new System::Windows::Forms::TreeNode(S"Others", __mcTemp__6);
			this->tvOperators->Nodes->AddRange(__mcTemp__1);
			this->tvOperators->SelectedImageIndex = -1;
			this->tvOperators->Size = System::Drawing::Size(152, 468);
			this->tvOperators->TabIndex = 2;
			this->tvOperators->ItemDrag += new System::Windows::Forms::ItemDragEventHandler(this, tvOperators_ItemDrag);
			// 
			// panelLeft
			// 
			this->panelLeft->Controls->Add(this->tvOperators);
			this->panelLeft->Dock = System::Windows::Forms::DockStyle::Left;
			this->panelLeft->Location = System::Drawing::Point(0, 0);
			this->panelLeft->Name = S"panelLeft";
			this->panelLeft->Size = System::Drawing::Size(152, 468);
			this->panelLeft->TabIndex = 3;
			// 
			// pic
			// 
			this->pic->AllowDrop = true;
			this->pic->Anchor = (System::Windows::Forms::AnchorStyles)(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Left) 
				| System::Windows::Forms::AnchorStyles::Right);
			this->pic->BackColor = System::Drawing::Color::White;
			this->pic->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->pic->ContextMenu = this->contextMenu1;
			this->pic->Controls->Add(this->vScrollBar1);
			this->pic->Controls->Add(this->hScrollBar1);
			this->pic->Location = System::Drawing::Point(160, 8);
			this->pic->Name = S"pic";
			this->pic->Size = System::Drawing::Size(576, 392);
			this->pic->TabIndex = 4;
			this->pic->MouseUp += new System::Windows::Forms::MouseEventHandler(this, pic_MouseUp);
			this->pic->Paint += new System::Windows::Forms::PaintEventHandler(this, pic_Paint);
			this->pic->DragDrop += new System::Windows::Forms::DragEventHandler(this, pic_DragDrop);
			this->pic->DragOver += new System::Windows::Forms::DragEventHandler(this, pic_DragOver);
			this->pic->MouseMove += new System::Windows::Forms::MouseEventHandler(this, pic_MouseMove);
			this->pic->MouseDown += new System::Windows::Forms::MouseEventHandler(this, pic_MouseDown);
			// 
			// contextMenu1
			// 
			System::Windows::Forms::MenuItem* __mcTemp__7[] = new System::Windows::Forms::MenuItem*[1];
			__mcTemp__7[0] = this->menuItemDelete;
			this->contextMenu1->MenuItems->AddRange(__mcTemp__7);
			this->contextMenu1->Popup += new System::EventHandler(this, contextMenu1_Popup);
			// 
			// menuItemDelete
			// 
			this->menuItemDelete->Index = 0;
			this->menuItemDelete->Text = S"Delete";
			this->menuItemDelete->Click += new System::EventHandler(this, menuItemDelete_Click);
			// 
			// vScrollBar1
			// 
			this->vScrollBar1->Dock = System::Windows::Forms::DockStyle::Right;
			this->vScrollBar1->Location = System::Drawing::Point(558, 0);
			this->vScrollBar1->Maximum = 500;
			this->vScrollBar1->Name = S"vScrollBar1";
			this->vScrollBar1->Size = System::Drawing::Size(16, 374);
			this->vScrollBar1->TabIndex = 1;
			this->vScrollBar1->Scroll += new System::Windows::Forms::ScrollEventHandler(this, panelScroll);
			// 
			// hScrollBar1
			// 
			this->hScrollBar1->Dock = System::Windows::Forms::DockStyle::Bottom;
			this->hScrollBar1->Location = System::Drawing::Point(0, 374);
			this->hScrollBar1->Maximum = 500;
			this->hScrollBar1->Name = S"hScrollBar1";
			this->hScrollBar1->Size = System::Drawing::Size(574, 16);
			this->hScrollBar1->TabIndex = 0;
			this->hScrollBar1->Scroll += new System::Windows::Forms::ScrollEventHandler(this, panelScroll);
			// 
			// label1
			// 
			this->label1->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label1->Location = System::Drawing::Point(168, 432);
			this->label1->Name = S"label1";
			this->label1->Size = System::Drawing::Size(48, 16);
			this->label1->TabIndex = 5;
			this->label1->Text = S"Note:";
			// 
			// label2
			// 
			this->label2->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label2->Location = System::Drawing::Point(312, 432);
			this->label2->Name = S"label2";
			this->label2->Size = System::Drawing::Size(72, 16);
			this->label2->TabIndex = 6;
			this->label2->Text = S"Note length:";
			// 
			// cmbNote
			// 
			this->cmbNote->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->cmbNote->Location = System::Drawing::Point(216, 432);
			this->cmbNote->Name = S"cmbNote";
			this->cmbNote->Size = System::Drawing::Size(80, 21);
			this->cmbNote->TabIndex = 7;
			this->cmbNote->TextChanged += new System::EventHandler(this, cmbNote_TextChanged);
			// 
			// cmbNoteLen
			// 
			this->cmbNoteLen->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->cmbNoteLen->Location = System::Drawing::Point(384, 432);
			this->cmbNoteLen->Name = S"cmbNoteLen";
			this->cmbNoteLen->Size = System::Drawing::Size(80, 21);
			this->cmbNoteLen->TabIndex = 8;
			this->cmbNoteLen->TextChanged += new System::EventHandler(this, cmbNote_TextChanged);
			// 
			// label3
			// 
			this->label3->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label3->Location = System::Drawing::Point(472, 408);
			this->label3->Name = S"label3";
			this->label3->Size = System::Drawing::Size(64, 16);
			this->label3->TabIndex = 9;
			this->label3->Text = S"Stack size:";
			// 
			// dfStackSize
			// 
			this->dfStackSize->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->dfStackSize->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->dfStackSize->Location = System::Drawing::Point(536, 408);
			this->dfStackSize->Name = S"dfStackSize";
			this->dfStackSize->ReadOnly = true;
			this->dfStackSize->Size = System::Drawing::Size(40, 20);
			this->dfStackSize->TabIndex = 10;
			this->dfStackSize->Text = S"";
			// 
			// label4
			// 
			this->label4->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label4->Location = System::Drawing::Point(168, 408);
			this->label4->Name = S"label4";
			this->label4->Size = System::Drawing::Size(48, 16);
			this->label4->TabIndex = 11;
			this->label4->Text = S"Volume:";
			// 
			// label5
			// 
			this->label5->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->label5->Location = System::Drawing::Point(312, 408);
			this->label5->Name = S"label5";
			this->label5->Size = System::Drawing::Size(64, 16);
			this->label5->TabIndex = 13;
			this->label5->Text = S"Amplitude:";
			// 
			// dfAmplitude
			// 
			this->dfAmplitude->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->dfAmplitude->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->dfAmplitude->Location = System::Drawing::Point(384, 408);
			this->dfAmplitude->Name = S"dfAmplitude";
			this->dfAmplitude->ReadOnly = true;
			this->dfAmplitude->Size = System::Drawing::Size(40, 20);
			this->dfAmplitude->TabIndex = 14;
			this->dfAmplitude->Text = S"";
			// 
			// cmbVolume
			// 
			this->cmbVolume->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Bottom | System::Windows::Forms::AnchorStyles::Left);
			this->cmbVolume->Location = System::Drawing::Point(216, 404);
			this->cmbVolume->Name = S"cmbVolume";
			this->cmbVolume->Size = System::Drawing::Size(80, 21);
			this->cmbVolume->TabIndex = 15;
			this->cmbVolume->TextChanged += new System::EventHandler(this, cmbNote_TextChanged);
			// 
			// InstrumentEditor
			// 
			this->AcceptButton = this->btnPlay;
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->CancelButton = this->btnClose;
			this->ClientSize = System::Drawing::Size(744, 468);
			this->Controls->Add(this->cmbVolume);
			this->Controls->Add(this->dfAmplitude);
			this->Controls->Add(this->dfStackSize);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->cmbNoteLen);
			this->Controls->Add(this->cmbNote);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->label1);
			this->Controls->Add(this->pic);
			this->Controls->Add(this->panelLeft);
			this->Controls->Add(this->btnClose);
			this->Controls->Add(this->btnPlay);
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::SizableToolWindow;
			this->Name = S"InstrumentEditor";
			this->ShowInTaskbar = false;
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterParent;
			this->Text = S"Edit Instrument";
			this->Load += new System::EventHandler(this, InstrumentEditor_Load);
			this->Closed += new System::EventHandler(this, InstrumentEditor_Closed);
			this->panelLeft->ResumeLayout(false);
			this->pic->ResumeLayout(false);
			this->ResumeLayout(false);

		}		

	private: System::Void btnClose_Click(System::Object *  sender, System::EventArgs *  e)
			 {
				 Close ( );
			 }

	private:// Starts dragging from treeview 
			System::Void tvOperators_ItemDrag(System::Object *  sender, System::Windows::Forms::ItemDragEventArgs *  e)
			 {
				 if ( e->Button != MouseButtons::Left  || (dynamic_cast<TreeNode*>(e->Item))->Parent == NULL )
					 return;
				 this->DoDragDrop ( e->Item, DragDropEffects::Move );
			 }



private: System::Void pic_DragOver(System::Object *  sender, System::Windows::Forms::DragEventArgs *  e)
		 {
			 e->Effect = DragDropEffects::Move;
			 if ( e->Data->GetData ( __typeof(TreeNode) ) == NULL )
				 e->Effect = DragDropEffects::None;
		 }

		 // Redraws screen
		 void RedrawWorkingArea ( ) {
			 pic->Invalidate ( );
			 pic->Update ( );
		 }

private: System::Void pic_DragDrop(System::Object *  sender, System::Windows::Forms::DragEventArgs *  e)
		 {
			TreeNode* node = dynamic_cast<TreeNode*>(e->Data->GetData (__typeof(TreeNode)));
			if ( node == NULL )
				return;
			// Create new operation of given type
			Operation* op = NULL;
			if ( node->Text == S"Const" )	op = new PushConstOperation ( );
			if ( node->Text == S"Sequence" )op = new PushStreamOperation ( );
			if ( node->Text == S"Note" )	op = new PushNoteOperation ( );
			if ( node->Text == S"Time" )	op = new PushTimeOperation ( );
			if ( node->Text == S"Current" )	op = new PushCurrentOperation ( );
			if ( node->Text == S"Sin" )		op = new OscSinOperation ( );
			if ( node->Text == S"SinG" )	op = new OscSinGOperation ( );
			if ( node->Text == S"Saw" )		op = new OscSawOperation ( );
			if ( node->Text == S"SawG" )	op = new OscSawGOperation ( );
			if ( node->Text == S"Noise" )	op = new OscNoiseOperation ( );
			if ( node->Text == S"Exp" )		op = new OscExpOperation ( );
			if ( node->Text == S"Add" )		op = new AddOperation ( );
			if ( node->Text == S"Mul" )		op = new MulOperation ( );
			if ( node->Text == S"Lowpass" )	op = new FilterOperation ( OP_LP_FILTER );
			if ( node->Text == S"Highpass" )op = new FilterOperation ( OP_HP_FILTER );
			//if ( node->Text == S"Bandpass" )op = new FilterOperation ( OP_BP_FILTER );
			if ( node->Text == S"ADSR" )	op = new AdsrOperation ( );
			if ( node->Text == S"Pan" )		op = new PanOperation ( );
			if ( node->Text == S"Echo" )	op = new EchoOperation ( );
			if ( node->Text == S"Compress" )op = new CompressOperation ( );
			// Add to collection and redraw
			if ( op != NULL ) {
				POINT pt = {e->X+hScrollBar1->Value,e->Y+vScrollBar1->Value}; 
				ScreenToClient ( (HWND)pic->Handle.ToInt32 ( ), &pt );
				op->pos = pt;
				ins->oper[ins->operCount++] = op;
				RedrawWorkingArea ( );
			}
		 }

private:

		// Returns connection line coordinates
		void GetConnLineCoord ( int l, POINT* pt1, POINT* pt2 ) {
			OperConnection* oc = ins->operConn + l;
			Operation* op = ins->oper[oc->operFrom];
			pt1->x = op->pos.x;
			pt1->y = op->pos.y + op->size.cy;
			op = ins->oper[oc->operTo];
			pt2->x = op->GetInputPos ( oc->inputNo ).x;
			pt2->y = op->pos.y - op->size.cy;
		}

		// Operations rendering 
		System::Void pic_Paint ( System::Object *  sender, System::Windows::Forms::PaintEventArgs *  e ) {
			HDC hdc = (HDC)e->Graphics->GetHdc ( ).ToInt32 ( );
			// Render links
			HPEN hBoldPen = CreatePen ( PS_SOLID, 3, 0 );
			for ( int i = 0; i < ins->operConnCount; i++ ) {
				POINT pt1, pt2;
				GetConnLineCoord ( i, &pt1, &pt2 );
				MoveToEx ( hdc, pt1.x - hScrollBar1->Value, pt1.y - vScrollBar1->Value, NULL );
				HPEN hOldPen;
				if ( i == focusedLine )
					hOldPen = (HPEN)SelectObject ( hdc, hBoldPen );
				LineTo ( hdc, pt2.x - hScrollBar1->Value, pt2.y - vScrollBar1->Value );
				if ( i == focusedLine )
					 SelectObject ( hdc, hOldPen );
			}
			DeleteObject ( hBoldPen );
			// Render operations
			if ( hFont == NULL )
				hFont = CreateFont ( 14, 0, 0, 0, FW_THIN, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "Arial" );
			HFONT hOldFonr = (HFONT)SelectObject ( hdc, hFont );
			POINT offs;
			offs.x = -hScrollBar1->Value;
			offs.y = -vScrollBar1->Value;
			for ( int i = 0; i < ins->operCount; i++ )
				ins->oper[i]->Draw ( hdc, i == focusedOper, byteSequenceNames, offs );
			e->Graphics->ReleaseHdc ( hdc );
			SelectObject ( hdc, hOldFonr );
		}

private:

		// Returns distance between two points
		double GetPointDistance ( POINT pt1, POINT pt2 ) {
			return max(abs(pt1.x-pt2.x),abs(pt2.y-pt1.y));
		}

		// Performs mouse hit test on operation ports
		void PortsHitTest ( POINT pt, POINT* from, int* obj, int* conn ) {
			*obj = -1;
			*conn = 0;
			for ( int i = 0; i < ins->operCount; i++ ) {
				RECT r = ins->oper[i]->GetRect ( );
				// Test output
				POINT pt1 = { ins->oper[i]->pos.x, r.bottom };
				if ( GetPointDistance ( pt, pt1 ) < 10 ) {
					*from = pt1;
					*obj = i;
					*conn = -1;
					return;
				}
				// Test inputs					
				for ( int k = 0; k < ins->oper[i]->inputCount; k++ ) {
					pt1 = ins->oper[i]->GetInputPos ( k );
					if ( GetPointDistance ( pt, pt1 ) < 10 ) {
						*from = pt1;
						*obj = i;
						*conn = k + 1;
						return;
					}
				}
			}
		}

		// Performs parameter edition
		void EditOperationParameter ( Operation* op, RECT r, int p ) {
			if ( op->paramTypes[p] == PT_FLOAT || op->paramTypes[p] == PT_BYTE ) {
				TextBox* tb = new TextBox ( );
				tb->Location = Point ( r.left, r.top );
				tb->Size = System::Drawing::Size ( r.right - r.left, r.bottom - r.top );
				tb->Parent = pic;
				char buf[128];
				sprintf ( buf, "%f", op->params[p] );
				if ( op->paramTypes[p] == PT_BYTE )
					sprintf ( buf, "%d", (int)op->params[p] );
				tb->Text = buf;
				OperationEditData ed;
				ed.op = op;
				ed.param = p;
				ed.type = op->paramTypes[p];
				tb->Tag = __box(ed);
				tb->SelectionStart = 0;
				tb->SelectionLength = 1000;
				tb->Focus ( );
				tb->LostFocus += new EventHandler ( this, FloatEditBox_LostFocus );
			}
			if ( op->paramTypes[p] == PT_STREAM ) {
				ComboBox* cb = new ComboBox ( );
				cb->Location = Point ( r.left, r.top );
				cb->Size = System::Drawing::Size ( r.right - r.left, r.bottom - r.top );
				cb->Parent = pic;
				cb->Sorted = false;
				for ( int i = 0; i < g_byteSequencesCount; i++ )
					cb->Items->Add ( byteSequenceNames[i] );
				OperationEditData ed;
				ed.op = op;
				ed.param = p;
				ed.type = op->paramTypes[p];
				cb->Tag = __box(ed);
				SetComboStreamValue ( cb, op->params[p] );
				cb->SelectionStart = 0;
				cb->SelectionLength = 1000;
				cb->Focus ( );
				cb->LostFocus += new EventHandler ( this, FloatEditBox_LostFocus );
			}
			if ( op->paramTypes[p] == PT_FLT_TYPE ) {
				ComboBox* cb = new ComboBox ( );
				cb->Location = Point ( r.left, r.top );
				cb->Size = System::Drawing::Size ( r.right - r.left, r.bottom - r.top );
				cb->Parent = pic;
				cb->Sorted = false;
				cb->DropDownStyle = ComboBoxStyle::DropDownList;
				cb->Items->Add ( S"Low pass" );
				cb->Items->Add ( S"High pass" );
				//cb->Items->Add ( S"Band pass" );
				if ( op->type == OP_LP_FILTER )
					cb->SelectedIndex = 0;
				if ( op->type == OP_HP_FILTER )
					cb->SelectedIndex = 1;
				/*if ( op->type == OP_BP_FILTER )
					cb->SelectedIndex = 2;*/
				OperationEditData ed;
				ed.op = op;
				cb->Tag = __box(ed);
				cb->Focus ( );
				cb->LostFocus += new EventHandler ( this, FilterEditBox_LostFocus );
			}
		}

		// Processes filter type selection
		void FilterEditBox_LostFocus ( System::Object*  sender, EventArgs *  e ) {
			ComboBox* cb = dynamic_cast<ComboBox*> ( sender );
			OperationEditData ed = *dynamic_cast<__box OperationEditData*>(cb->Tag);
			if ( cb->SelectedIndex == 0 )
				ed.op->type = OP_LP_FILTER;
			if ( cb->SelectedIndex == 1 )
				ed.op->type = OP_HP_FILTER;
			if ( cb->SelectedIndex == 2 )
				ed.op->type = OP_BP_FILTER;
			pic->Controls->Remove ( cb );
		}

		// Processes parameter value edit lost focus
		void FloatEditBox_LostFocus ( System::Object*  sender, EventArgs *  e ) {
			Control* c =  dynamic_cast<Control*> ( sender );
			Object* tag; 
			String* text;
			TextBox* tb = dynamic_cast<TextBox*> ( sender );
			ComboBox* cb = dynamic_cast<ComboBox*> ( sender );
			if ( tb != NULL ) {
				tag = tb->Tag;
				text = tb->Text;
			} else {
				tag = cb->Tag;
				text = cb->Text;
			}
			OperationEditData ed = *dynamic_cast<__box OperationEditData*>(tag);
			try {
				if ( ed.type == PT_BYTE ) {
					int k = Convert::ToInt32 ( tb->Text );
					if ( k < -127 ) k = -127;
					if ( k > 127 ) k = 127;
					ed.op->params[ed.param] = k;
				} 
				if ( ed.type == PT_FLOAT )
					ed.op->params[ed.param] = Convert::ToSingle ( tb->Text );
				if ( ed.type == PT_STREAM )
					ed.op->params[ed.param] = GetComboStreamValue ( cb );
			}
			catch ( Exception* ) {
			}
			pic->Controls->Remove ( c );
		}

		// Selecting object 
		System::Void pic_MouseDown ( System::Object *  sender, System::Windows::Forms::MouseEventArgs *  e ) {
			pic->Focus ( );
			int prevFocus = focusedOper;
			int prevFocusedLine = focusedLine;
			focusedOper = -1;
			focusedLine = -1;
			POINT pt = {e->X+hScrollBar1->Value,e->Y+vScrollBar1->Value};
			// Test object selection
			for ( int i = 0; i < ins->operCount; i++ ) {
				RECT r = ins->oper[i]->GetRect ( );
				if ( PtInRect ( &r, pt ) ) {
					lastMovePos.x = pt.x; lastMovePos.y = pt.y;
					focusedOper = i;
					RedrawWorkingArea ( );
					// Test if we should start edit operation
					for ( int k = 0; k < ins->oper[i]->paramCount; k++ ) {
						RECT r1 = ins->oper[i]->GetParamRect ( k );
						if ( PtInRect ( &r1, pt ) ) {
							focusedOper = -1;
							OffsetRect ( &r1, -hScrollBar1->Value, -vScrollBar1->Value );
							EditOperationParameter ( ins->oper[i], r1, k );
							return;
						}
					}
					return;
				}
			}
			// Test line selection
			int minLine = -1;
			float minDist = 100000.0;
			for ( int i = 0; i < ins->operConnCount; i++ ) {
				POINT pt1, pt2;
				GetConnLineCoord ( i, &pt1, &pt2 );
				PointF lv (pt2.x - pt1.x,pt2.y - pt1.y);
				float lvl = sqrtf(lv.X*lv.X + lv.Y*lv.Y);
				if ( lvl ) {
					lv.X /= lvl;
					lv.Y /= lvl;
					PointF pv ( pt.x - pt1.x, pt.y - pt1.y );
					float dotProd = pv.X*lv.X + pv.Y*lv.Y;
					if ( dotProd >= 0.0 && dotProd <= lvl ) {
						lv.X *= dotProd;
						lv.Y *= dotProd;
						pv.X -= lv.X;
						pv.Y -= lv.Y;
						float d = sqrtf(pv.X*pv.X + pv.Y*pv.Y);
						if ( d < minDist && d < 10.0 ) {
							minDist = d;
							minLine = i;
						}
					}
				}
			}
			if ( minLine >= 0 ) {
				focusedLine = minLine;
				RedrawWorkingArea ( );
				return;
			}
			if ( prevFocus != focusedOper || focusedLine != prevFocusedLine )
				RedrawWorkingArea ( );
			// Test object ports selection
			POINT ptt;
			int obj, conn;
			PortsHitTest ( pt, &ptt, &obj, &conn );
			lineFrom.x = ptt.x; lineFrom.y = ptt.y; 
			lineFromObj = obj;
			lineFromPort = conn;
		}

private:
		// Moving objects and lines
		System::Void pic_MouseMove ( System::Object *  sender, System::Windows::Forms::MouseEventArgs *  e ) {
			// Move objects
			if ( focusedOper >= 0 && e->Button == MouseButtons::Left ) {
				POINT pt = {e->X + hScrollBar1->Value,e->Y + vScrollBar1->Value};
				if ( pt.x >= 0 && pt.y >= 0 && pt.x < pic->Width + hScrollBar1->Maximum && pt.y < pic->Height + vScrollBar1->Maximum ) {
					ins->oper[focusedOper]->pos.x += pt.x - lastMovePos.x;
					ins->oper[focusedOper]->pos.y += pt.y - lastMovePos.y;
					lastMovePos.x = pt.x; lastMovePos.y = pt.y;
				}
				RedrawWorkingArea ( );
			}
			// Move lines
			if ( lineFromObj >= 0 && e->Button == MouseButtons::Left ) {
				RedrawWorkingArea ( );
				HDC hdc = GetDC ( (HWND)pic->Handle.ToInt32 ( ) );
				MoveToEx ( hdc, lineFrom.x - hScrollBar1->Value, lineFrom.y - vScrollBar1->Value, NULL );
				LineTo ( hdc, e->X, e->Y );
				ReleaseDC ( (HWND)pic->Handle.ToInt32 ( ), hdc );				
			}
		}

private: 
		// Delete selected operation
		System::Void menuItemDelete_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( focusedOper >= 0 ) {
				// Remove operation itself
				delete ins->oper[focusedOper];
				for ( int i = focusedOper; i < ins->operCount - 1; i++ )
					ins->oper[i] = ins->oper[i+1];
				ins->operCount--;
				// Remove all links from/to operation
				for ( int i = 0; i < ins->operConnCount; i++ ) {
					if ( ins->operConn[i].operFrom == focusedOper || ins->operConn[i].operTo == focusedOper ) {
						for ( int k = i; k < ins->operConnCount-1; k++ )
							ins->operConn[k] = ins->operConn[k+1];
						ins->operConnCount--;
						i = -1;
						continue;
					}
				}
				// Renumber all links
				for ( int i = 0; i < ins->operConnCount; i++ ) {
					if ( ins->operConn[i].operFrom > focusedOper )
						ins->operConn[i].operFrom--;
					if ( ins->operConn[i].operTo > focusedOper )
						ins->operConn[i].operTo--;
				}
				focusedOper = -1;
				RedrawWorkingArea ( );
				return;
			}
			if ( focusedLine >= 0 ) {
				for ( int k = focusedLine; k < ins->operConnCount - 1; k++ )
					ins->operConn[k] = ins->operConn[k+1];
				ins->operConnCount--;
				focusedLine = -1;
				RedrawWorkingArea ( );
				return;
			}
		}

private: 
		// Menu popup processing
		System::Void contextMenu1_Popup ( System::Object *  sender, System::EventArgs *  e ) {
			menuItemDelete->Enabled = ( focusedOper >= 0 || focusedLine >= 0 );
		}

private: 
    	// Process mouse up
		System::Void pic_MouseUp ( System::Object *  sender, System::Windows::Forms::MouseEventArgs *  e ) {
			if ( lineFromObj >= 0 ) {
				POINT pt = { e->X + hScrollBar1->Value, e->Y + vScrollBar1->Value}, from;
				int obj, conn;
				PortsHitTest ( pt, &from, &obj, &conn );
				if ( obj >= 0 && obj != lineFromObj && lineFromPort*conn < 0 ) {
					int operFrom, operTo, inputNo;
					if ( conn > 0 ) {
						operFrom = lineFromObj;
						operTo = obj;
						inputNo = conn - 1;
					} else {
						operFrom = obj;
						operTo = lineFromObj;
						inputNo = lineFromPort - 1;
					}
					OperConnection oc = { operFrom, operTo, inputNo };
					// Test that no similar connection exist
					bool exists = false;
					for ( int i = 0; i < ins->operConnCount; i++ ) 
						if ( ins->operConn[i].operFrom == oc.operFrom || 
							ins->operConn[i].operTo == oc.operTo && ins->operConn[i].inputNo == oc.inputNo )
							exists = true;
					if ( !exists )
						ins->operConn[ins->operConnCount++] = oc;
				}
				lineFromObj = -1;
				RedrawWorkingArea ( );
			}
		}

private: 
		// Processes form display
		System::Void InstrumentEditor_Closed ( System::Object *  sender, System::EventArgs *  e ) {
			lastWinPos = this->Location;
			lastWinSize = this->Size;
		}

private:
		// Processes form close
		System::Void InstrumentEditor_Load ( System::Object *  sender, System::EventArgs *  e ) {
			if ( lastWinSize.Width && lastWinSize.Height ) {
				this->Location = lastWinPos;
				this->Size = lastWinSize;
			}
		}
public:

		// Pushes current operation and all above it
		static void PushOperationRecursive ( HWND hWnd, Instrument* ins, int operNum, int maxStackSize, char* stack, int* sp ) {
			// Enumerate all inputs
			char tmpBuf[1024] = {0};
			for ( int i = ins->oper[operNum]->inputCount - 1; i >= 0 ; i-- ) {
				// Find operation, connected to this input
				int connOper = -1;
				for ( int k = 0; k < ins->operConnCount; k++ )
					if ( ins->operConn[k].inputNo == i && ins->operConn[k].operTo == operNum ) {
						connOper = ins->operConn[k].operFrom;
						break;
					}
				if ( connOper < 0 ) {
					sprintf ( tmpBuf, "Opened input found. Operation: %s, Instrument: %s", ins->oper[operNum]->name, ins->name );
					MessageBoxA ( hWnd, tmpBuf, "Instrument stack generation", MB_OK | MB_ICONEXCLAMATION );
					*sp = -1;
					return;
				}
				// Push this operation
				PushOperationRecursive ( hWnd, ins, connOper, maxStackSize, stack, sp );
				if ( *sp < 0 )
					return;
			}
			// Push our own stack bytes
			int cnt = 0;
			ins->oper[operNum]->GetStackBytes ( stack + *sp, &cnt );
			if ( cnt < 0 ) {
				sprintf ( tmpBuf, "Bad parameters passed. Operation: %s, Instrument: %s", ins->oper[operNum]->name, ins->name );
				MessageBoxA ( hWnd, tmpBuf, "Instrument stack generation", MB_OK | MB_ICONEXCLAMATION );
				*sp = -1;
				return;
			}
			if ( *sp > maxStackSize ) {
				*sp = -1;
				MessageBoxA ( hWnd, "Operation stack overflow!", "Instrument stack generation", MB_OK | MB_ICONEXCLAMATION );
				return;
			}
			*sp += cnt;
		}

		// Builds operator stack for given instrument, Count < 0 if error occured
		static void BuildOperatorStack ( HWND hWnd, Instrument* ins, char* stack, int* count ) {
			// Fool proof
			if ( ins->operCount == 0 ) {
				*count = 0;
				return;
			}
			char tmpBuf[1024] = {0};
			// Find root operation - the one who has nothing at his output
			int rootOper = -1;
			for ( int i = 0; i < ins->operCount; i++ ) {
				bool found = false;
				for ( int k = 0; k < ins->operConnCount; k++ ) {
					if ( ins->operConn[k].operFrom == i ) {
						found = true;
						break;
					}
				}
				if ( !found ) {
					if ( rootOper >= 0 ) {
						*count = -1;
						sprintf ( tmpBuf, "More than one operator with free output found. Instrument: %s", ins->name );
						MessageBoxA ( hWnd, tmpBuf, "Instrument stack generation", MB_OK | MB_ICONEXCLAMATION );
						return;
					}
					rootOper = i;
				}
			}
			if ( rootOper < 0 ) {
				*count = -1;
				sprintf ( tmpBuf, "No operators with free output found. Instrument: %s", ins->name );
				MessageBoxA ( hWnd, tmpBuf, "Instrument stack generation", MB_OK | MB_ICONEXCLAMATION );
				return;
			}
			// Unwind stack from last operator
			int maxStackSize = *count;
			*count = 0;
			PushOperationRecursive ( hWnd, ins, rootOper, maxStackSize, stack, count );
		}

private: 


		// Builds operator stack for instrument and plays it
		System::Void btnPlay_Click ( System::Object *  sender, System::EventArgs *  e ) {
			char stack[MAX_OPER_STACK_SIZE+128] = {0};
			int count = MAX_OPER_STACK_SIZE;
			BuildOperatorStack ( (HWND)this->Handle.ToInt32 ( ), ins, stack, &count );
			dfStackSize->Text = Convert::ToString ( count );
			// Fill instrument stack and play it
			if ( count >= 0 ) {
				EnterCriticalSection ( &g_stackCs );
				CopyMemory ( ins->stack, stack, count );
				ins->programLen = count;
				LeaveCriticalSection ( &g_stackCs );
				float amp = 0;
				PlayOneNote ( ins, &amp );
				dfAmplitude->Text = Convert::ToString ( amp );
			}
        }

private: 

		// Processes note and note length changing
		System::Void cmbNote_TextChanged ( System::Object *  sender, System::EventArgs *  e ) {
			ComboBox* cb = dynamic_cast<ComboBox*>(sender);
			try {
				char v = GetComboStreamValue ( cb );
				if ( cb == cmbNote )
					ins->note = v;
				if ( cb == cmbNoteLen )
					ins->noteLen = v;
				if ( cb == cmbVolume )
					ins->volume = v;
			}
			catch ( Exception* e ) {
			}
		}

private:
		// Scroll panel
		System::Void panelScroll ( System::Object *  sender, System::Windows::Forms::ScrollEventArgs *  e ) {
			 RedrawWorkingArea ( );
		}		 

};
}