#include "StdAfx.h"
#include "Instruments.h"

char g_buf[1024] = {0};
Instrument g_instruments[128] = { 0 };
int g_instrumentCount = 0;
char g_bytePatterns[MAX_PATTERNS][16] = {0};
short g_bitPatterns[MAX_PATTERNS] = {0};
char g_byteSequences[MAX_SEQUENCES][MAX_TEMPLATE_MELODY_LEN] = {0};
char g_bitSequences[MAX_SEQUENCES][MAX_TEMPLATE_MELODY_LEN] = {0};
int g_bytePatternsCount = 0;
int g_bitPatternsCount = 0;
int g_byteSequencesCount = 0;
int g_bitSequencesCount = 0;
float g_masterVolume = 1.0f;
int ROW_SIZE_SAMPLES = 1;

const float PI				= 3.1415926f;
const float PI_2			= 2*PI;

int			g_patternNo;
int			g_patternRowNo;

float				g_freqAnSamples[FREQ_ANALYZE_SAMPLES];
CRITICAL_SECTION	g_anCs;
CRITICAL_SECTION	g_stackCs;

// ==================================================================
// Converts .NET string to char*
char* StringToChar ( System::String* s ) {
	char* p = (char*)System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(s).ToPointer(); 
   	strcpy ( g_buf, p );
	System::Runtime::InteropServices::Marshal::FreeHGlobal(p);
	return g_buf;
} // StringToChar


// ==================================================================
// Cuts signal level
float CutLevel ( float x, float lvl ) {
	if ( x > lvl )
		return lvl;
	if ( x < -lvl )
		return -lvl;
	return x;
}
float my_fabs ( float v ) {
	__asm {
		fld v
		fabs
		fstp v
	}
	return v;
}
float my_sin ( float v ) {
	__asm {
		fld v
		fsin
		fstp v
	}
	return v;
}
int __cdecl _ftol ( float fvar ) {
	int lvar;
	__asm {
		fld dword ptr fvar
		fistp dword ptr lvar
	}
	return lvar;
}
float __cdecl pow2 ( float x ) {
	float y;
	__asm {
		fld dword ptr x
		fld st(0)
		frndint
		fxch st(1)
		fsub st(0),st(1)
		f2xm1
		fld1
		faddp st(1),st(0)
		fscale
		fstp st(1)
		fstp dword ptr y
	}
	return y;
}
float Noise1 ( int x ) {
    x = (x<<13) ^ x;
    return (float)( 1.0f - ( (x * (x * x * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0f);    
}
float my_sqrt ( float v ) {
	__asm {
		fld v
		fsqrt
		fstp v
	}
	return v;
}
float Sawtooth ( float x ) {
	x /= PI_2;
	return x - _ftol ( x );
}
float LowPassResonantFilter ( float x, float f, float q, float* coeff ) {
	float fb = q + q / ( 1.0f - f );
	coeff[0] = coeff[0] + f * ( x - coeff[0] + fb * ( coeff[0] - coeff[1] ) );
	coeff[1] = coeff[1] + f * ( coeff[0] - coeff[1] );
	return coeff[1];
}

// ==================================================================
// Playback notify function
void CALLBACK waveOutProc ( HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2 ) {
  if ( uMsg == WOM_DONE )
	  SetEvent ( (HANDLE)dwInstance );
} // waveOutProc


// ==================================================================
// Converts note number to frequency (includes multiplication by 2*pi)
float NoteToFrequency ( char note  ) {
	return PI_2 * 440.0f * powf ( 2.0f, (note-45)/12.0f );
}

// ==================================================================
// Sound play thread
int g_bufLenSamples;
DWORD WINAPI SoundPlayThreadProc ( LPVOID lpParameter ) {
	// Prepare headers
	HANDLE hEvent = CreateEvent ( 0, FALSE, FALSE, NULL );
	HWAVEOUT g_wo;
	WAVEFORMATEX wfx = { WAVE_FORMAT_PCM, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16, 0 };
	waveOutOpen ( &g_wo, WAVE_MAPPER, &wfx, (DWORD_PTR)waveOutProc, (DWORD_PTR)hEvent, CALLBACK_FUNCTION );
	// Play melody
	WAVEHDR hdr = {0};
	hdr.lpData = (LPSTR) lpParameter;
	hdr.dwBufferLength  = (int) ( g_bufLenSamples*2*sizeof(short) );
	hdr.dwFlags = WHDR_BEGINLOOP | WHDR_ENDLOOP;
	waveOutPrepareHeader ( g_wo, &hdr, sizeof(hdr) );
	waveOutWrite ( g_wo, &hdr, sizeof(hdr) );
	// Wait until sound stop playing...
	WaitForSingleObject ( hEvent, INFINITE );
	CloseHandle ( hEvent );
	waveOutReset ( g_wo );
	waveOutClose ( g_wo );
	delete[] lpParameter;
	return 0;
} // SoundPlayThreadProc


// ==================================================================
// Returns given value or reads value from byte stream at current position
char GetFixedOrStreamValue ( char val ) {
	if ( val >= 0 )
		return val;
	// Ignore streamed values if not streaming
	if ( g_patternNo < 0 )
		return 0;
	val = -val;
	if ( val-1 >= g_byteSequencesCount )
		return 0;
	int k = g_byteSequences[val-1][g_patternNo];
	if ( k )
		return g_bytePatterns[k-1][g_patternRowNo];
	return 0;
}


// ==================================================================
// Fills buffer for one note
int FillNoteBuffer ( float* data, int maxLenSamples, Instrument* ins, int rowPos ) {
	EnterCriticalSection ( &g_stackCs );
	if ( !ins->programLen ) {
		LeaveCriticalSection ( &g_stackCs );
		return 0;
	}
	g_patternNo = g_patternRowNo = -1;
	if ( rowPos >= 0 ) {
		g_patternNo = ( rowPos >> 4 );
		g_patternRowNo = ( rowPos & 0xF );
	}
	int noteLenSamples = (int)GetFixedOrStreamValue ( ins->noteLen ) * ROW_SIZE_SAMPLES / 8;
	int soundLen = noteLenSamples;
	float insVolume = GetFixedOrStreamValue ( ins->volume ) * 0.01f;
	// Channels
	for ( int ch = 0; ch < 2; ch++ ) {
		char* ip = ins->stack;
		// Process stack
		char note = GetFixedOrStreamValue ( ins->note );
		if ( !note ) {
			LeaveCriticalSection ( &g_stackCs );
			return 0;
		}
		float *b = data + ch;

		// Zero filter memory
		float stack[128], tmp1, tmp2;
		float filterData[256];
		for ( int i1 = 0; i1 < sizeof(filterData)/sizeof(float); i1++ ) filterData[i1] = 0;
		float tStart = (float)(rowPos*ROW_SIZE_SAMPLES) / SAMPLE_FREQUENCY;
		// Generate sample
		for ( int s = 0; s < noteLenSamples; s++, b += 2 ) {
			float tRel = (float) s / noteLenSamples;
			float tGlobal = (float)s / SAMPLE_FREQUENCY;
			float tGlobalSt = tGlobal + tStart;
			float* sp = stack;
			int pp = 0;
			float *curFilt = filterData;
			while ( pp < ins->programLen ) {
				char op = ip[pp];
				if ( OP_PUSH_STREAM == op ) { *(sp++) = GetFixedOrStreamValue ( ip[pp+1] ) * 0.01f; pp += 2; }
				if ( OP_PUSH_CONST == op ) { *(sp++) = *((float*)(ip + pp + 1)); pp += 5; }
				if ( OP_PUSH_NOTE == op ) { *(sp++) = NoteToFrequency ( note + ip[pp+1] ); pp += 2; }
				if ( OP_PUSH_TIME == op ) { *(sp++) = tRel; pp++; }
				if ( OP_EXP == op ) { tmp1 = *(--sp); *(sp++) = pow2 ( tmp1 ); pp++; }
				if ( OP_SIN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobal + tmp2 ); pp++; }
				if ( OP_SIN_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobalSt + tmp2 ); pp++; }
				if ( OP_SAW == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobal + tmp2 ); pp++; }
				if ( OP_SAW_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobalSt + tmp2 ); pp++; }
				if ( OP_NOISE == op ) { *(sp++) = Noise1 ( s ); pp++; }
				if ( OP_MUL == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 * tmp2; pp++; }
				if ( OP_ADD == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 + tmp2; pp++; }
				if ( OP_PAN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp2 * (ch ? tmp1 : my_sqrt(1.0f-tmp1*tmp1)); pp++; }
				if ( OP_PUSH_CURRENT == op ) { *(sp++) = *b; pp++; }
				if ( OP_COMPRESS == op ) { 
					float l1 = ip[pp+1]*0.01f, l2 = ip[pp+2]*0.01f;
					tmp1 = *(--sp); 
					float v = my_fabs(tmp1) - l1;
					if ( v > 0.0 ) {
						v = l2 - (l2-l1) / ( 1.0f + v / (l2-l1) );
						if ( tmp1 > 0.0 )
							tmp1 = v;
						else
							tmp1 = -v;
					}
					*(sp++) = tmp1; 
					pp += 3; 
				}
				if ( OP_ADSR == op ) {
					float t1 = ip[pp+1] * 0.01f;
					float t2 = ip[pp+2] * 0.01f;
					float t3 = ip[pp+3] * 0.01f;
					float l = ip[pp+4] * 0.01f;
					float adsr;
					if ( tRel < t1 )
						adsr = tRel / t1;
					else if ( tRel < t2 )
						adsr = 1.0f - ( 1.0f - l ) * ( tRel - t1 ) / ( t2 - t1 );
					else if ( tRel < t3 )
						adsr = l;
					else
						adsr = l * ( 1.0f - tRel  ) / ( 1.0f - t3 );
					*(sp++) = *(--sp) * adsr;
					pp += 5;
				}
				if ( OP_LP_FILTER == op || OP_HP_FILTER == op || OP_BP_FILTER == op ) {
					tmp1 = *(--sp) / (0.35f*PI*SAMPLE_FREQUENCY);	// Frequency (*0.35 for simple filter only)
					tmp2 = *(--sp);									// Quality
					float in = *(--sp);
					// Moog filter coefficients
					/*float f, p, q;
					float t1, t2;
					q = 1.0f - tmp1;
					p = tmp1 + 0.8f * tmp1 * q;
					f = p + p - 1.0f;
					q = tmp2 * (1.0f + 0.5f * q * (1.0f - q + 5.6f * q * q));
					// Filter
					in -= q * curFilt[4];                        // feedback
					t1 = curFilt[1];	curFilt[1] = (in + curFilt[0]) * p - curFilt[1] * f;
					t2 = curFilt[2];	curFilt[2] = (curFilt[1] + t1) * p - curFilt[2] * f;
					t1 = curFilt[3];	curFilt[3] = (curFilt[2] + t2) * p - curFilt[3] * f;
										curFilt[4] = (curFilt[3] + t1) * p - curFilt[4] * f;
					curFilt[4] = curFilt[4] - curFilt[4] * curFilt[4] * curFilt[4] * 0.166667f;    // clipping
					curFilt[0] = in;
					float y = curFilt[4];
					if ( OP_HP_FILTER == op )
						y = in - y;
					if ( OP_BP_FILTER == op )
						y = 3.0f * (curFilt[3] - y);*/
					// Simple LP/HP filter
					float y = LowPassResonantFilter ( in, tmp1, tmp2, curFilt );
					if ( OP_HP_FILTER == op )
						y = in - y;
					/*if ( OP_BP_FILTER == op )
						y = y - LowPassResonantFilter ( y, tmp1, tmp2, curFilt + 2 );*/
					*(sp++) = y;
					pp++;
					//curFilt += 6;
					curFilt += 2;
				}
				if ( OP_ECHO == op ) {
					float t1 = ip[pp+1] * 0.01f;
					float y = (*(--sp))*insVolume;
					float yold = y;
					float *bb1 = b;
					int delay = (ROW_SIZE_SAMPLES/8) * 2 * ip[pp+2];
					bool pan = false;
					if ( delay < 0 ) {
						pan = true;
						delay *= -1;
					}
					for ( int k = 0; k < ip[pp+3]; k++ ) {
						bb1 += delay;
						y *= t1;
						*bb1 += ( pan ? y*((k+0)%2 == ch) : y );
						if ( (bb1 - data)/2 > soundLen )
							soundLen = (bb1 - data)/2;
					}
					*(sp++) = yold;
					pp += 4;
				}
			}
			// Write sample out
			*b += (*(--sp))*insVolume;
			if ( sp != stack ) { 
				LeaveCriticalSection ( &g_stackCs );
				MessageBoxA ( NULL, "STACK CORRUPTED!!", "Filling sound buffer", MB_OK | MB_ICONERROR ); 
				return 0;
			}
		}
	}
	LeaveCriticalSection ( &g_stackCs );
	return soundLen;
} // FillNoteBuffer


// ==================================================================
// Plays one note with specified instrument. Streamed values are ignored.
void PlayOneNote ( Instrument* ins, float* amplitude ) {
	// Prepare buffers
	int bufSizeSamples = SAMPLE_FREQUENCY * 60;
	short* finalBuf = new short[bufSizeSamples*2];
	float* data = new float[bufSizeSamples*2];
	ZeroMemory ( data, bufSizeSamples*sizeof(float)*2 );
	ZeroMemory ( finalBuf, bufSizeSamples*sizeof(short)*2 );

	// Play note
	g_bufLenSamples = FillNoteBuffer ( data, bufSizeSamples, ins, -1 );

	// Copy float array to output
	short *s = finalBuf;
	float *d = data;
	*amplitude = 0.0;
	for ( int i = 0; i < g_bufLenSamples*2; i++ ) {
		*amplitude = max(*d,*amplitude);
		*(s++) = (short) ( 32760 * CutLevel ( (*(d++))*g_masterVolume, 1 ) );
	}
	// Call play thread and pass data to it (called thread will free array)
	DWORD id;
	HANDLE hThread = CreateThread ( 0, 0, SoundPlayThreadProc, finalBuf, 0, &id );
	CloseHandle ( hThread );
	delete[] data;

} // PlayOneNote