; 2B or not 2B check macro
; (c) 2020 / ShakeSpirt / RMDA

; fasm 1

; submacro for 'display' macro
macro __digit num
{
 if num < 10
   display '0'+num
 else
   display 'A'+num-10
 end if
}

; submacro for 'display' macro
macro __display arg1,arg2
{
 if arg2 eq
   display arg1
 else
   local tmp
   tmp = arg1
   virtual at 0
     repeat 32
       if tmp > 0
         db tmp mod arg2
         tmp = tmp / arg2
       end if
     end repeat
     repeat $
       load tmp byte from $-%
       __digit tmp
     end repeat
     if $ = 0
       display '0'
     end if
   end virtual
 end if
}

; macro to display numbers
; example: display 'Value = ',<count,10>
; where 10 is radix
macro display [arg] { __display arg }

; check the code
macro @2b.check
{
  local x, ofs, warn
  warn = 0

  if start <> $82
    display "2b.check: offset of 'start' label is not $82 !!!",13,10
    warn = warn + 1
  end if

  if $-start = 0
    display '2b.check: no code !!!',13,10
    warn = warn + 1
  end if

  repeat $-start
    ofs = start+%-1
    load x byte from ofs
    if x < 32 | x = '<' | x = '>' | x = '|' | x = '&' | x = '%' | x = '^'
      display "2b.check: forbidden char $",<x,16>
      if x >= 32
        display " ('",x,"')"
      end if
      display " at offset $",<ofs,16>," ($",<ofs-@cmd,16>," in file) !!!",13,10
      warn = warn + 1
    end if
  end repeat

  if $-start > 125
    display "2b.check: code is too long (allowed 125 bytes max) !!!",13,10
    warn = warn + 1
  end if
  if warn = 0
    display "2b.check: code is OK, main code size = ",<$-start,10>," bytes.",13,10
  else
    display "2b.check: ",<warn,10>," warning(s), main code size = ",<$-start,10>," bytes.",13,10
  end if
}

@2b.check
