; 2B or not 2B draft for 44-byte intro :)
; generates chars in range $21...$7E (except forbidden) that can be entered manually
; copy this draft to your intro name and then write the code
; (c) 2020 / ShakeSpirt / RMDA

; fasm 1

format binary as 'bat'

org $82-@cmdlen
@cmd:
;db '@' ; uncomment this to cancel command line echo
db '2b ' ; execution command
@cmdlen = $-@cmd

org $82
start:

;-------------------------------------------------------------------------------

	; assume: ax = bx = 0

; decoder (only opcodes in range $21...$7E)
;	pusha			; uncomment this (and 'popa' below) to save all register values (your max code size will be 43 bytes max)
	xor al,$41		; ax = $41
	push ax
	pop bp			; bp = $41
	sub [bp+(@dcjnz+1-$41)],al ; correct relative jump address at @dcjnz
	xor ax,$302D		; ax = $10D5
	sub [bp+(@dcaad-$41)],ax ; store 'aad $10' instruction to @dcaad ($4141 - $306C = $10D5)
	push bp			; bp = $41 (source address)
	pop di			; di = $41 (destination address)
@decode:
	push bx
	pop ax			; ax = 0
	xor ax,[bp+(main-$41)]	; ax = [bp]
	sub ax,'AK'
@dcaad:	dw $4141		; it will be 'aad $10' here
	and [di+(main-$41)],bx	; bx is used because bl generates opcode $20 (space)
	xor [di+(main-$41)],ax	; [di] = al (decoded ax)
	inc bp
	inc bp			; bp += 2
	inc di			; di += 1
	dec cx
@dcjnz:	jnz @decode+$41		; will be corrected to 'jnz @decode'
;	popa

; instead of the above code you can just use this string:
; db '4AP](Fe5-0)FXU_SX3Ff-AKAA!]f1EfEEGIu+'

; use this string if you need to save all register values (your max code size will be 43 bytes max):
; db '`4AP](Ff5-0)FYU_SX3Fh-AKAA!]h1EhEEGIu+a'

main:	; unchanged: bx=0, dx=cs=ds=es=ss, si=$100
	; changed: ah=0 (al depends of the last code byte), cx=0, edi=$140=320, ebp=$23F

;===============================================================================

; put your code here, 44 bytes max
; this code will be encoded to uppercase latin letters (2 letters per 1 byte)
; there's no forbidden chars, you can feel free :)
; don't forget to watch warning messages after compilation!

; example:
;	mov ah,9
;	mov dx,text
;	int $21
;	ret
;text db 'Hello World!',13,10,'$'

;===============================================================================

mainend:
mainsize = mainend-main
rb mainsize

repeat mainsize
  load x byte from mainend-%
  x = (x and $F + 'A') + (x shr 4 + 'K') shl 8
  store word x at $-%*2
end repeat

;-------------------------------------------------------------------------------

include '2b.check.inc' ; code check (highly desirable)
include '2b.debug.inc' ; create .com and .bin files for debugging (can be commented)
