; 2B or not 2B demo - life game
; (c) 2020 / ShakeSpirt / RMDA

; fasm 1

format binary as 'bat'

org $82-@cmdlen
@cmd:
;db '@' ; uncomment this to cancel command line echo
db '2b ' ; execution command
@cmdlen = $-@cmd

org $82
start:

;===============================================================================

key = $AC ; xor cryption key (0 - don't crypt)
initpop = $20 ; initial population (high byte)
color = 2 ; 85 is max, 64 can't be used

; code decryptor
if key	; bx = 0
	mov bl,main
@@:	sub byte [bx],key
	inc bx
	loop @B
end if

; main code
main:	; ax = 0, dx = cs, bh = 1 (if key <> 0)
	mov al,$13
	int $10			; 320x200, 256 colors

	add dh,al
	mov ds,dx		; ds = buffer
	mov ax,$A000		; push $A000 contains forbidden char for 2b
	mov es,ax		; es = video
;	push $A000		; use this in non-crypted code instead of above
;	pop es

	mov ch,initpop
	mov ax,color + $3F shl 8
gen:
	imul di,cx		; random screen position
;	imul di,77		; this is better but contains forbidden char for 2b
	stosb
	loop gen		; generate initial population

	mov dx,$330		; midi port
	out dx,ax		; enter uart mode ($3F -> $331)

	mov bl,319 and $FF	; bx = 319
;	mov bx,319		; for non-crypted code
again:
	xor si,si		; this can be commented if 'mov ch,320*200/256' will be commented below
copy:
	es lodsb
	mov [si+bx],al		; copy screen to buffer with shift
	loop copy

	mov ch,320*200/256	; FreeDOS will crash if this will be commented
next:
	lodsw
	add al,[si]		; top right
	dec si
	add al,[si+bx]		; left
	add al,[si+bx+2]	; right
	add ax,[si+639]		; 2 bottom left
	add al,[si+641]		; bottom right
	add al,ah		; sum of 8 neighbors
	sub al,color*2
	jz continue		; 2 neighbors (keep alive)
	cmp al,color
	je set			; 3 neighbors (give new life)
if color > 32
	xor al,al		; al = 0 (kill if alive) if neighbors < 2 or > 3
else
	salc			; al = 0
end if
set:	mov [es:si],al		; write to screen with shift
continue:
	loop next

	mov al,$91
	out dx,al
	dec bp
	mov ax,bp
	and al,$3F
	add al,42
	out dx,al
	out dx,al

	hlt			; delay

	mov ah,1
	int $16			; check for any keypress
	jz again

	xor ah,ah
	int $16			; clear keypress
	
	mov ax,3
	int $10			; text mode (ax = 3)

	ret			; quit
len = $-main

; code cryptor
if key
  repeat len
    load x byte from main+%-1
    store byte (x + key) and $FF at main+%-1
  end repeat
end if

;===============================================================================

include '2b.check.inc' ; code check (highly desirable)
include '2b.debug.inc' ; create .com and .bin files for debugging (can be commented)
