#ifndef _CUBE
#define _CUBE

#include <sys/types.h>
#include "o3d.h"

#define CUBE_NBTEX 6

extern u_long emad;
extern u_long tex01;
extern u_long tex02;
extern u_long tex03;
extern u_long tex04;
extern u_long tex05;

u_long *cube_tex[CUBE_NBTEX] =
	{&emad,&tex01,&tex02,&tex03,&tex04,&tex05};

u_short	cube_texID[CUBE_NBTEX];

#define CUBE_NBVERTS 8

SVECTOR	cube_vert[CUBE_NBVERTS] =
	{{-64, 64, 64},
	 { 64, 64, 64},
	 { 64, 64,-64},
	 {-64, 64,-64},
	 {-64,-64, 64},
	 { 64,-64, 64},
	 { 64,-64,-64},
	 {-64,-64,-64}};

#define	CUBE_NBPOLYS 6

u_short	cube_poly0[4] = {3,2,0,1};
u_short	cube_poly1[4] = {1,5,0,4};
u_short	cube_poly2[4] = {2,6,1,5};
u_short	cube_poly3[4] = {3,7,2,6};
u_short	cube_poly4[4] = {0,4,3,7};
u_short	cube_poly5[4] = {4,5,7,6};

u_short	*cube_polys[CUBE_NBPOLYS] =
	{cube_poly0,
	 cube_poly1,
	 cube_poly2,
	 cube_poly3,
	 cube_poly4,
	 cube_poly5};

u_char	cube_pdim[CUBE_NBPOLYS] =
	{4,
	 4,
	 4,
	 4,
	 4,
	 4};

u_char	cube_ptype[CUBE_NBPOLYS] =
	{TYPE_GT+FLAG_L,
	 TYPE_GT+FLAG_L,
	 TYPE_GT+FLAG_L,
	 TYPE_GT+FLAG_L,
	 TYPE_GT+FLAG_L,
	 TYPE_GT+FLAG_L};

u_char	cube_data0_u[4] = {0,0,127,127};
u_char	cube_data0_v[4] = {0,127,0,127};
Color	cube_data0_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data0 = {0,cube_data0_u,cube_data0_v,cube_data0_color};
u_char	cube_data1_u[4] = {0,0,127,127};
u_char	cube_data1_v[4] = {0,127,0,127};
Color	cube_data1_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data1 = {0,cube_data1_u,cube_data1_v,cube_data1_color};
u_char	cube_data2_u[4] = {0,0,127,127};
u_char	cube_data2_v[4] = {0,127,0,127};
Color	cube_data2_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data2 = {0,cube_data2_u,cube_data2_v,cube_data2_color};
u_char	cube_data3_u[4] = {0,0,127,127};
u_char	cube_data3_v[4] = {0,127,0,127};
Color	cube_data3_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data3 = {0,cube_data3_u,cube_data3_v,cube_data3_color};
u_char	cube_data4_u[4] = {0,0,127,127};
u_char	cube_data4_v[4] = {0,127,0,127};
Color	cube_data4_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data4 = {0,cube_data4_u,cube_data4_v,cube_data4_color};
u_char	cube_data5_u[4] = {0,0,127,127};
u_char	cube_data5_v[4] = {0,127,0,127};
Color	cube_data5_color[4] = {{80,0,80},{80,0,80},{80,0,80},{80,0,80}};
TPolyData cube_data5 = {0,cube_data5_u,cube_data5_v,cube_data5_color};

void	*cube_data[CUBE_NBPOLYS] =
	{&cube_data0,
	 &cube_data1,
	 &cube_data2,
	 &cube_data3,
	 &cube_data4,
	 &cube_data5};

SObject		cube_sobj;
Object3D	cube_o3d = {0,&cube_sobj,0};

SVECTOR cube_f_normals[CUBE_NBPOLYS];
SVECTOR cube_v_normals[CUBE_NBVERTS];

Object3D* cube_object() {
	cube_sobj.nbv	= CUBE_NBVERTS;
	cube_sobj.vert	= cube_vert;
	cube_sobj.nbp	= CUBE_NBPOLYS;
	cube_sobj.polys	= cube_polys;
	cube_sobj.pdim	= cube_pdim;
	cube_sobj.ptype	= cube_ptype;
	cube_sobj.data	= cube_data;
	cube_sobj.nbt	= CUBE_NBTEX;
	cube_sobj.tex	= cube_tex;
	cube_sobj.texID	= cube_texID;
	cube_sobj.f_normals = cube_f_normals;
	cube_sobj.v_normals = cube_v_normals;
	InitSObject(&cube_o3d);
	return &cube_o3d;
}

#endif
