#ifndef _O3D_H
#define _O3D_H

#include "constants.h"
#include "regtex.h"

#include <sys/types.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>

#define OTSIZE 256
#define OTZ    6	// n+2 where 2^n = 4096/OTSIZE

// Precalculated light
#define TYPE_LINE_F	0
#define TYPE_LINE_G	1
#define TYPE_F		2
#define TYPE_G		3
#define TYPE_FT		4
#define TYPE_GT		5

#define FLAG_L		8	// Real time light
#define FLAG_S		16	// Semi Transparency
#define FLAG_V		32	// Always visible
#define FLAG_MB		64	// Motion blur

// RGB color

typedef struct {
	u_char r,g,b;
} Color;

// Textured polygone parameters

typedef struct {
	u_short	texID;	// Texture number
	u_char	*u;	// U coordinates of vertices on the texture
	u_char	*v;	// V coordinates of vertices on the texture
	Color	*color;	// 1 color for flat, color[] for gouraud
} TPolyData;

// Simple object

typedef struct {
	u_short	nbv;		// Number of vertices
	SVECTOR	*vert;		// Vertices
	u_short	nbp;		// Number of polys
	u_short	**polys;	// polys[face][0] : vert 0 ... polys[face][n] : vert n with 1<n<5 : 2 = line; 3 triangle; 4 quadrangle
	u_char	nbt;		// Number of textures
	u_long	**tex;		// Textures
	u_short	*texID;		// Registered texture ID
	u_char	*pdim;		// Dim of each poly : 2, 3 or 4
	u_char	*ptype;		// Type of each poly : TYPE_LINE, TYPE_F, TYPE_G, TYPE_FT, TYPE_GT...
	void	**data;		// Data for each polygones:
				//	TYPE_LINE :	Color
				//	TYPE_F :	Color
				//	TYPE_G :	Color[]
				//	TYPE_FT :	TPolyData
				//	TYPE_GT :	TPolyData
	SVECTOR	*f_normals;	// Faces normals
	SVECTOR	*v_normals;	// Vertices normals
} SObject;

// Composition of an object with a position and a rotation
typedef struct {
	void	*obj;	// Pointer to an object or scene
	VECTOR	pos;	// Position in 3D space
	SVECTOR	ang;	// Angles of rotation
	VECTOR	scale;	// Scaling
} ObjPos;

// General 3D Object

typedef struct {
	u_char	type;			// 0 : simple, > 0 : number of objects
	union {
		SObject	*single;	// Single object if type = 0
		ObjPos	*scene;		// Composition of objects in space if type > 0
	} o;
	u_char	flags;			// Semitrans, motion blur
} Object3D;


// Object initialisation

#ifndef _O3D_C
extern void	ChangeTex	(SObject *sobj,int f,int tex);
extern void	InitObjPos	(ObjPos *pos,Object3D *obj,long x,long y,long z,short ax,short ay,short az,long sc);
extern void	InitSObject	(Object3D *obj);
extern void	Init3DPrims	();
extern void	Draw3D		(ObjPos *scene, SVECTOR* light, u_long *ot);
extern void	setZTex		(int z);
#endif

#endif
