{                                                                         }
{ This routine is dedicated to Lord Crom, because he asked me for a fast  }
{ keyboard routine for LISSA. Then I made this little example for all     }
{ coders. Feel free to use it. I only want you to give me credit.         }
{                                                                         }
{               Creada por Spanish Lords Enero 1994.                      }
{                    Lords   Crom  &  Mitra.                              }
{                       Alcala de Henares                                 }
{                         M a d r i d                                     }
{                           (Spain)                                       }

Program PixelScroll;

uses dos;

var
  XPos,YPos : Integer;   { X,Y positions of the screen. }
  IncCnt    : Byte;      { Pixels to move each time. }
  ContExec  : Boolean;   { True if executing. False when ESC is pressed. }
  ScrDirec  : Byte;      {  Where is the screen going ? }
  OldProc   : Procedure; { Here goes the normal interrupt 9. }


Procedure ClearBuffer; assembler;

ASM
   push  es
   push  ax

   cli                   { Deactivate interrupts. }

   xor  ax,ax            { AX := 0 }
   mov  es,ax            { ES := 0 }
   mov  al,es:[$41A]     { AL := Keyboard buffer begin. }
   mov  es:[$41C],al     { Keyboard buffer tail := Keyboard buffer begin. }

   sti                   { Enable interrupts. }

   pop  ax
   pop  es
END;


{$S-,W-,F+}
procedure Teclado; interrupt;
begin
  If Port[$60]= 1 then ContExec:=False; { ESCAPE      }
  If Port[$60]=72 then ScrDirec:=1;     { UP ARROW    }
  If Port[$60]=75 then ScrDirec:=2;     { LEFT ARROW  }
  If Port[$60]=77 then ScrDirec:=3;     { RIGHT ARROW }
  If Port[$60]=80 then ScrDirec:=4;     { DOWN ARROW  }
  If (Port[$60]=27) or (Port[$60]=78)   { + KEY       }
     then If IncCnt<20 then Inc(IncCnt);
  If (Port[$60]=53) or (Port[$60]=74)   { - KEY       }
     then If IncCnt>1  then Dec(IncCnt);
  If Port[$60]=$E1 then Port[$60]:=0;
  inline ($9C); { PUSHF }
  OldProc; { Execute old interrupt. }
  ClearBuffer; { Clean keyboard buffer. }
end;
{$F-,S+}

{ BPR is the number of bytes that each row occupies in video memory. }

Procedure SetBegin(X,Y,BPR:Word); assembler;

asm
   push  ds
   push  si
   push  es
   push  di
   pusha

   mov   ax,40h     { Segment 40h }
   mov   es,ax
   mov   cl,es:49h  { Port 49h = Video BIOS data area }

   mov   ax,X       { AX := X coordinate. }
   mov   bx,Y       { BX := Y coordinate. }

   cmp   cl,7       { Jump if graphics mode. }
   ja    @l01

   je    @l02       { Jump if monocrome text. }

   test  byte ptr es:89h,1 { If there's 1 in port 89h , we have a VGA }
   jnz   @l02       { Jump if VGA present }

   jmp   @l03

@L01:
   mov   cx,8       { CL := 8 pixels by byte. }
                    { CH := 0(Line sweep preselection. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := Byte displacement in pixels row. }
   mov   cl,ah      { CL := Horizontal pixel panoramic. }
   xor   ah,ah
   xchg  ax,bx      { AX := Y }
                    { BX := Byte displacement in pixels row. }
   mov   dx,BPR     { DX := Chars row shown }
   mul   dx         { AX := Byte displacement in row begin. }
   jmp   @L05

@L02:
   mov   cx,9       { CL := 9 pixels by byte. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := byte displacement in pixels row. }
   dec   ah         { AH := -1, 0-7 }
   jns   @l04       { Jump if AL = 0-7 }
   mov   ah,8       { AH := 8 }
   jmp   @L04

@L03:
   mov   cx,8       { CL := 8 pixels by byte. }
   div   cl         { AH := bit displacement in byte. }
                    { AL := byte displacement in pixels row. }


@L04:
   mov   cl,ah      { Horizontal pixel panoramic value. }
   xor   ah,ah
   xchg  ax,bx      { AX := Y }
                    { BX := byte displacement in row. }
   div   byte ptr es:85h  { AL := Char`s row }
                    { AH := Sweep line in characters matrix. }
   xchg  ah,ch      { AX := Char`s row. }
                    { CH := Sweep line. }
   mov   dx,BPR     { DX := chars row shown }
   mul   dx         { AX := Byte displacement in char`s row. }
   shr   ax,1       { AX := Word displacement in char`s row. }

{ Here the operations end. Now, this is the routine that really do all. }
{ Assembler registers must have these valours :                         }
{  AX : Char`s row displacement.                                        }
{  BX : Byte displacement in the row.                                   }
{  CH : Line sweep preselection                                         }
{  CL : Horizontal pixel panoramic                                      }

@L05:
   add   bx,ax
   mov   dx,es:63h { Puerto 63h = E/S del CRTC }
   add   dl,6      { Puerto del estado de video }

@L20:              { Wait for vertical retrace. }
   in    al,dx

   test  al,8
   jz    @L20

@L21:              { Wait until vertical retrace ends. }
   in    al,dx
   test  al,8
   jnz   @L21

   cli             { Stop interrupts. }
   sub   dl,6      { DX := 3B4H or 3D4H. }

   mov   ah,bh     { AH := High value for begin direction. }
   mov   al,0ch    { AL := Register to modify. }
   out   dx,ax
   mov   ah,bl     { AH := Low  value for begin direction. }
   inc   al        { AL := Register to modify. }
   out   dx,ax
   sti             { Enable interrupts. }

   add   dl,6      { DX := Video status port. }

@L22:              { Wait for vertical retrace. }
   in    al,dx
   test  al,8
   jz    @l22

   cli             { Stop interrupts. }

   sub   dl,6      { DX := 3B4h or 3D4H }
   mov   ah,ch     { AH := Value for line sweep preselection register. }
   mov   al,8      { AL := Register to change. }
   out   dx,ax
   mov   dl,0C0h   { Atributes controller port. }
   mov   al,13h OR 20h { Horizontal pixel panoramic register. }
   out   dx,al
   mov   al,cl     { Horizontal pixel panoramic value. }
   out   dx,al

   sti             { Enable interrupts. }

   popa
   pop   di
   pop   es
   pop   si
   pop   ds

end;

Begin
 { Save the old keyboard interrupt and put mine. }
  GetIntVec($9,@OldProc);
  SetIntVec($9,@Teclado);
 { Put in variables their initial values. }
  IncCnt:=1;
  ContExec:=True;
  ScrDirec:=0;
  XPos:=0;
  YPos:=0;
 { Execute until ESC pressed. }
  Repeat
      if ScrDirec<>0 then SetBegin(XPos,YPos,160);
      Case ScrDirec of
           1: If YPos+IncCnt<401 then Inc (YPos,IncCnt)
                                 else begin
                                         ScrDirec:=4;{Y:=0;}
                                         YPos:=400;
                                      end;
           2: If XPos+IncCnt<721 then Inc (XPos,IncCnt)
                                 else begin
                                         ScrDirec:=3;{X:=0;}
                                         XPos:=721;
                                      end;
           3: If XPos-IncCnt>0   then Dec (XPos,IncCnt)
                                 else begin
                                         ScrDirec:=2;{X:=720;}
                                         XPos:=0;
                                      end;
           4: If YPos-IncCnt>0   then Dec (YPos,IncCnt)
                                 else begin
                                         ScrDirec:=1;{Y:=400;}
                                         YPos:=0;
                                      end;
      end;
  Until not ContExec;
 { Put the sreen in the correct position. }
  SetBegin(0,0,640);
 { Put the old keyboard interrupt }
  SetIntVec($9,@OldProc);
End.