#ifndef OBJECT_H
#define OBJECT_H

#include "shadow.h"

class object
{
public:
	bool resized;
	long *Childs;
//		3D COM buffers
	float *shape3D;		// original x,y,z points
	USHORT *rel;		// max points per objects = 65536 as in lightwave
	float *pNormals;	// normals par points with maxsmoothing angle (face buffer)
	float *fNormals;	// normals par faces
	float *mc;			// mapping coord

//		3D non-COM buffers
	USHORT *IDF;

	USHORT	*oss;	// list of surfaces offsets in surface scene list(allocated during load)
	USHORT  nosurf;	// number of surfaces in that object

	// inverse of the rel buffer
	// ppt : number of adj face/point
	// pptf: list of adj faces/point (face offset)
	long **pptf, *ppt;

	long nbp,nbf, allocPF;	// nb of points, face counting
	char *objectFileName;
	USHORT  COMValue;		// say if the buffer is to be deleted or not
	object *dataLocation;	// where data is located(local class or not)
	scen   *whichScene;

	// methods:
	object();
	void init();
	void initClone();

//		managing memory
	void allocFaces(long dataSize, long nbF);
	void allocPoints(long nbP);

	class ShadowVolume shad;
//		-------------------------------------
	~object();
};


//		------------- methods of objects ----------------

object::object()
{
	resized = false;
	objectFileName = NULL;
	rel = NULL;
	shape3D = NULL;
	IDF = NULL;
	COMValue = 1;
	dataLocation = this;
	Childs = NULL;
	pNormals = NULL;
	fNormals = NULL;
	mc = NULL;
}

void object::initClone()
{
	long i;
	IDF = new USHORT[nbf];
	if ( nosurf <= 0 ) quitMessage("scen::object::initClone","Error managing memory");
	oss = new USHORT[nosurf];
	for(i=0;i<nosurf;i++) oss[i] = dataLocation->oss[i];
	for(i=0;i<nbf;i++) IDF[i] = dataLocation->IDF[i];
}

void object::init()
{
	Childs = NULL;
}

//		managing faces memory
void object::allocFaces(long dataSize, long nbF)
{
		// allocate or define the buffers
	if( dataLocation == this)
	{
		IDF = new USHORT[nbF];
		rel = new USHORT[dataSize];
	}
	else quitMessage("scen::object::allocFaces()","this cas should not appear!!\nexiting...Check memory management!");
}


void object::allocPoints(long nbP)
{
// allocate or define the buffers
	if( dataLocation == this)
	{
		shape3D = new float[nbP * 3];
	}
	else quitMessage("scen::object::allocPoints()","this cas should not appear!!\nexiting...Check memory management!");
}

object::~object()
{
	dataLocation->COMValue--;
	if( !dataLocation->COMValue  )  
	{
		if (objectFileName != NULL)
		{
			delete objectFileName;
			objectFileName = NULL;
		}

		if (shape3D != NULL) 
		{
			delete shape3D;
			shape3D = NULL;
		}

		if (rel != NULL) 
		{
			delete rel;
			rel = NULL;
		}

		if( pNormals != NULL)
		{
			delete pNormals;
			pNormals = NULL;
		}

		if( fNormals != NULL)
		{
			delete fNormals;
			fNormals = NULL;
		}

		if( mc != NULL)
		{
			delete mc;
			mc = NULL;
		}
	}

// dynamique buffers, they are not COM type!!! so delete all them !

	if(Childs != NULL)
	{
		delete Childs;
		Childs = NULL;
	}

	if (IDF != NULL) 
	{
		delete IDF;
		IDF = NULL;
	}
}

#endif