#version 330

in vec2 uv;
in vec2 uvasp;
out vec4 FragColor;

uniform sampler2D tex2012;
uniform sampler2D texcloud1;
uniform sampler2D texcloud2;
uniform sampler2D texfbo;
uniform float tick;
uniform float screensize;
uniform float cloudiness;
uniform float black;

void viginette(inout vec4 col)
{
	vec2 pure = uvasp;
	float dist = min(pure.y*pure.x*240, 1);
	dist = min((1-pure.y)*(1-pure.x)*240, dist);
	dist = min((pure.y)*(1-pure.x)*240, dist);
	dist = min((1-pure.y)*(pure.x)*240, dist);
	col *= dist;
}

void lcd(inout vec4 col)
{
	vec4 masks[4];
	vec2 screenpos = screensize * uv;
	int p = int(screenpos.x) % 4 + 
	        (int(screenpos.y) / 4) * 2;
	p = p % 4;
	
	col = min(col, vec4(1));
	
	masks[0] = vec4(1,1,0,1);
	masks[1] = vec4(0,1,1,1);
	masks[2] = vec4(1,0,1,1);
	masks[3] = vec4(1,1,1,1);
	
	col = mix(col, masks[p], 0.15);
}

vec4 horizblur(sampler2D tex, vec2 uv)
{
	return
		(texture(tex, vec2(fract(uv.x-0.003), uv.y)) +
		 texture(tex, vec2(fract(uv.x), uv.y)) +
		 texture(tex, vec2(fract(uv.x+0.003), uv.y))) / 3;
}

void cloud(inout vec4 col)
{
	vec4 cloud1 = horizblur(texcloud1, vec2(fract(uv.x+tick*0.0001), uv.y));
	vec4 cloud2 = horizblur(texcloud2, vec2(fract(uv.x+tick*0.00013), uv.y));
	
	float cloudy = cloud1.x+cloud2.x - cloudiness;
	
	if (cloudy < 1.0)
		col = mix(col, vec4(1), clamp(1-(cloudy-0.5)*2,0,1));
}

void cloud2(inout vec4 col)
{
	vec4 cloud1 = horizblur(texcloud1, vec2(fract((uv.x+tick*0.00005)), fract(uv.y+0.7)));
	vec4 cloud2 = horizblur(texcloud2, vec2(fract((uv.x+tick*0.00007)), fract(uv.y+0.7)));
	
	float cloudy = cloud1.x+cloud2.x - cloudiness;
	
	if (cloudy < 1.0)
		col = mix(col, vec4(1), clamp(1-(cloudy-0.5)*2,0,1));
}

void cloud3(inout vec4 col)
{
	vec4 cloud1 = horizblur(texcloud1, vec2(fract((uv.x+tick*0.000025)), fract(uv.y+0.3)));
	vec4 cloud2 = horizblur(texcloud2, vec2(fract((uv.x+tick*0.000037)), fract(uv.y+0.3)));
	
	float cloudy = cloud1.x+cloud2.x - cloudiness;

	if (cloudy < 1.0)
		col = mix(col, vec4(1), clamp(1-(cloudy-0.5)*2,0,1));
}

void main()
{
	vec4 leafy = texture(texfbo, uv);
	FragColor = texture(tex2012, uv);
	FragColor *= 0.95;
	cloud(FragColor);
	FragColor *= 0.95;
	cloud2(FragColor);
	FragColor *= 0.95;
	FragColor *= leafy;
	cloud3(FragColor);
	lcd(FragColor);
	viginette(FragColor);
	FragColor *= black;
}