#version 330
#extension GL_ARB_explicit_uniform_location : enable

uniform float time;
in vec4 pos;
in vec4 col;
out vec4 fragcolor;

float rand(float n){return fract(sin(n) * 43758.5453123);}
float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}
float noise(float p){
	float fl = floor(p);
  float fc = fract(p);
	return mix(rand(fl), rand(fl + 1.0), fc);
}
	
float noise(vec3 n) {
    return noise(n.x) * noise(n.y) * noise(n.z);
}

float turbulence (vec3 P, int numFreq)
   {
      float val = 0.0;
      float freq = 1.0;
      for (int i=0; i<numFreq; i++) {
         val += abs (noise(P*freq) / freq);
         freq *= 2.07;
      }
      return val;
   }  

void main()
{    
    float x = (0.5 + turbulence(pos.xyz + vec3(0,-(time * (0.3 + 0.2 * (sin(pos.x*0.1) + cos(abs(sin(pos.x)) + pos.z*0.1)))),0),6));
	fragcolor = col * col * col * col * col * (x * x * x + 0.5);
}