#version 330
#extension GL_ARB_explicit_uniform_location : enable

uniform float colmul;
in vec4 pos;
in vec2 uv;
in float s;
out vec4 fragcolor;

vec4 colorize(float f)
{    
    return vec4(
    f,
    f*f*1.5,
    f*f*sqrt(f),
    1);
}

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main()
{    
    float v = rand(pos.x+10*pos.y);//clamp(abs(sin(4 * cos(5 * sin(4 * cos(3 * uv.x + uv.y) + pos.x) + pos.y) + pos.z)), 0, 1);    
    float cdist = 1 - sqrt((uv.x - 0.5) * (uv.x - 0.5) + (uv.y - 0.5) * (uv.y - 0.5)) / sqrt(0.25);    
    cdist = cdist * cdist * cdist * cdist * cdist;
    fragcolor = clamp(colorize(v * cdist) * s, 0, 1) * colmul;
}