#version 330
#extension GL_ARB_explicit_uniform_location : enable

layout(location = 1) in vec4 vertexposition;
layout(location = 2) in vec4 normal;
layout(location = 3) in vec2 texcoord;
layout(location = 4) in float vox;

uniform mat4 mvp;
uniform mat4 model;
out vec2 uv;
out vec4 norm;
out vec4 pos;

void main()
{
	if (vox < 1) 
	{
		gl_Position = vec4(0);
		pos = vec4(0);
		norm = vec4(0);
		uv = vec2(0);
	}
	else
	{
		int x = gl_InstanceID % 64;
		int y = (gl_InstanceID / 64) % 64;
		int z = (gl_InstanceID / (64*64)) % 64;
		vec4 v = vertexposition + 2 * vec4(x - 32, y - 32, z - 32, 0);
		gl_Position = mvp * v;
		pos = model * v;

		int color = int(vox) - 1;

		uv = (texcoord + vec2(color % 4, color / 4)) * 0.25;
		norm = normal;
	}
}
