unit bolas;

INTERFACE

procedure init;
procedure done;
procedure go1;
procedure go2;

IMPLEMENTATION

uses Mode13,math,Engine3D,colors,MyDOS,main;

const
	MAX=25-1;
	XX=5000;
	SPEED=5;

	R=40;
	YI:word=1*SPEED;

	YY=-1500;
	ZMIN=-100;ZMAX=50000;
	ZINC=500;

type
	TObj=record
		pos,add:integer;
	end;

var
	l:PMapLight;
	scene:TScene;
	handle,EnvMap:PTexture;
	b:P3D;
	o:array[0..MAX] of P3D;
	d:array[0..MAX] of TObj;
	m:integer;

procedure NewBall(n:integer);
begin
 with o[n]^ do
	 begin
		 world.x:=aleatorio(-XX,XX);world.z:=ZMIN;
		 angle.balanza:=random(DEG);angle.deriva:=random(DEG);angle.caida:=random(DEG);
	 end;

 with d[n] do
	 begin
		 pos:=aleatorio(-R,R);
		 if random(2)+1=1 then
			 add:=YI
		 else
			 add:=-YI;
	 end;
end;

procedure init;
var
	pal:TPal;
	n:integer;

begin
	if not Load3D(o[0],'BOLA') then FError('BOLA.3DN');
	if not LoadMapLight(l,'GLOBAL') then FError('GLOBAL.LGT');
	if not LoadTexture('ORO',EnvMap,pal) then FError('ORO.TEX');
	if not LoadTexture('PARANOIA',handle,pal) then FError('PARANOIA.TEX');
	if not Load3D(b,'BOLA') then FError('BOLA.3DN');

	SetEnvMap(o[0],ALL_CHILDS,EnvMap);
	SetTexture(o[0],ALL_CHILDS,handle);
	SetEnvMap(b,ALL_CHILDS,handle);
	SetTexture(b,ALL_CHILDS,handle);
	SetRenderType(b,ALL_CHILDS,_TEXTURE_ENVMAP_);
	SetMapLight(b,ALL_CHILDS,l);
	ScaleCoordinates(b,ALL_CHILDS,15);
	b^.world.z:=10000;

	for n:=0 to MAX do
		begin
			if n>0 then MakeClone3D(o[0],o[n]);
			SetRenderType(o[n],ALL_CHILDS,_TEXTURE_ENVMAP_);
			SetMapLight(o[n],ALL_CHILDS,l);
			NewBall(n);
		end;

	NewScene(scene,MAX_FACES_IN_SCENE);
	m:=0;
end;

procedure done;
var
	n:integer;

begin
	FreeTexture(handle);
	FreeTexture(EnvMap);
	Free3D(b);
	for n:=1 to MAX do FreeClone3D(o[n]);
	Free3D(o[0]);
	FreeMapLight(l);
	FreeScene(scene);
end;

procedure go1;
begin
	if MyFrames and 127=0 then
		if random(2)=1 then
			SetEnvMap(b,ALL_CHILDS,handle)
		else
			SetEnvMap(b,ALL_CHILDS,EnvMap);
	with b^.angle do
		begin
			caida:=caida+1;
			if caida>DEG then caida:=caida-DEG;

			balanza:=balanza+2;
			if balanza>DEG then balanza:=balanza-DEG;

			deriva:=deriva-1;
			if deriva<0 then deriva:=deriva+DEG;
		end;
	PutAll3D(scene,b);
	RenderScene(scene);
end;

procedure go2;
var
	n:integer;

begin
	for n:=0 to m do with o[n]^ do
		begin
			inc(d[n].pos,d[n].add);
			if (d[n].pos<-R) or (d[n].pos>R) then d[n].add:=-d[n].add;
			world.y:=YY+sqr(d[n].pos);

			if world.z>ZMAX then NewBall(n);
			world.z:=world.z+ZINC;

			with angle do
				begin
					caida:=caida+2;
					if caida>DEG then caida:=caida-DEG;

					balanza:=balanza-1;
					if balanza<0 then balanza:=balanza+DEG;

					deriva:=deriva+2.5;
					if deriva>DEG then deriva:=deriva-DEG;
				end;
			PutAll3D(scene,o[n]);
		end;
	RenderScene(scene);
	if (MyFrames and 7=0) and (n<MAX) then inc(m);
end;

end.