unit plasma;

INTERFACE

procedure init;
procedure go;
procedure done;

IMPLEMENTATION

uses main,Mode13,math,Engine3D,OP386,colors,mem;

type
	TRaiz=array[0..65534] of byte;

var
	t:Ptexture;
	raiz:^TRaiz;
	seno:array[0..DEG+COSINE] of integer;
	xc,yc,
	h,x,yy,xx,
	d,i,a1,a2,y:integer;

procedure init;
var
	c:TPal;
	n:word;

begin
	if not LoadTexture('PASTL602',t,c) then FError('PASTL602.TEX');

	GetMem(raiz,65535);
	for n:=0 to high(TRaiz) do raiz^[n]:=round(sqrt(n));
	for n:=0 to high(seno) do	seno[n]:=round(n*sin(n*RAD));

	d:=random(DEG);i:=1;
	a1:=random(DEG);a2:=random(DEG);
end;

procedure done;
begin
	FreeTexture(t);
	dispose(raiz);
end;

procedure go;
begin
	xc:=CENTERX+round(128*sin(a1*RAD));
	inc(a1,2);
	if a1>DEG then dec(a1,DEG);

	yc:=CENTERY+round(64*cos(a2*RAD));
	dec(a2,1);
	if a2<0 then inc(a2,DEG);

	inc(d,i);
	if word(d)>DEG then i:=-i;
	ASM
		PUSH	BP

		LES		DI,PvRAM
		MOV		y,YMAX+1

		MOV		AX,WORD(raiz+2)
		DW		MOV_GS_AX

		MOV		AX,WORD(t+2)
		DW		MOV_FS_AX

		MOV		BP,d

@V:
		MOV		AX,yc
		SUB		AX,y
		IMUL	AX
		MOV		yy,AX

		MOV		CX,320

@H:
		MOV		AX,xc
		SUB		AX,CX
		IMUL	AX
		ADD		AX,yy
		MOV		BX,AX
		DB		GS;MOV	 BL,BYTE(TRaiz[BX])

		MOV		SI,CX
		ADD		SI,SI
		MOV   DX,WORD(seno[SI])

		MOV		AX,y
		IMUL	DX
		SAR		AX,8
		ADD		AX,CX
		SUB		AX,BP
		MOV		BH,AL

		DB		FS;MOV	 AL,[BX]
		MOV		ES:[DI],AL
		INC		DI
		DEC		CX
		JNZ		@H

		DEC		y
		JNZ		@V

		POP		BP
	END;
end;

end.