unit rotar;

INTERFACE

procedure init;
procedure done;
procedure go;

IMPLEMENTATION

uses main,Mode13,colors,Engine3D,math,Op386;

const
	ANCHO=$100;ALTO=$100;

var
	sprite:PTexture;
	seno,CosX,SinX,CosY,SinY:array[0..DEG+COSINE] of integer;
	d,i,top,distancia,rotacion:integer;

procedure init;
var
	n:integer;
	c:TPal;

begin
	for n:=0 to high(seno) do	seno[n]:=round(256*sin(n*RAD));
	for n:=0 to DEG do
		begin
			CosX[n]:=seno[COSINE+n]*ANCHO;
			SinY[n]:=seno[n]*ALTO;
			SinX[n]:=seno[n]*ANCHO;
			CosY[n]:=seno[COSINE+n]*ALTO;
		end;

	if not LoadTexture('PARANOIA',sprite,c) then FError('PARANOIA.TEX');
	rotacion:=0;distancia:=50;
	i:=1;d:=1;
	top:=180;
end;

procedure done;
begin
	FreeTexture(sprite);
end;

procedure rota;ASSEMBLER;
ASM
	PUSH		DS
	PUSH		BP

	MOV			CX,distancia
	MOV			DI,rotacion
	ADD			DI,DI

	MOV			AX,WORD(seno[DI+(COSINE*2)])
	IMUL		CX
	MOV			BL,AH
	MOV			BH,DL               {cosine:=(seno[rotacion+90]*distancia)/256}

	MOV			AX,WORD(seno[DI])
	IMUL		CX
	MOV			CL,AH
	MOV			CH,DL               {sine:=(seno[rotacion]*distancia)/256}

	DB $66,$F,$AC,$CE,$10				{SHRD ESI,ECX,16}
	MOV			SI,BX								{ESI=sine:cosine}


	MOV			AX,WORD(CosX[DI])
	SUB			AX,WORD(SinY[DI]) 	{ddy=CosX-SinY}

	MOV			DX,WORD(CosY[DI])
	ADD			DX,WORD(SinX[DI]) 	{ddx=CosY+SinX}

	DB			_386;SHL	DX,16
	MOV			DX,AX								{EDX=ddx:ddy}

	LES			DI,PvRAM
	MOV			DS,WORD(sprite+2)

	MOV			BP,YMAX+1							{for y:=YMAX DownTo 0 do}

@Y:
		DB			_386;PUSH	DX      {Guardo ddx y ddy}
		MOV			CH,320/2					{for x:=XMAX/2 DownTo 0 do}

@X:
			DB $66,$0F,$A4,$D3,$10	{SHLD EBX,EDX,16 BH=ddx/256}
			MOV 		BL,DH						{BL=ddy/256}
			DB			_386;SUB	DX,SI {dec(ddx,seno);dec(ddy,coseno)}
			MOV			AL,[BX]

			DB $66,$0F,$A4,$D3,$10	{SHLD EBX,EDX,16}
			MOV 		BL,DH
			DB			_386;SUB	DX,SI
			MOV			AH,[BX]

			MOV			ES:[DI],AX
			ADD			DI,2						{plot(x,y,SpriteR[ddx/256,ddy/256]);}

			DEC			CH          		{Bucle X}
			JNZ			@X

		DB			_386;POP	DX      {Recupero ddx y ddy}

		DB 			_386;ROL 	DX,16
		MOV			AX,DX
		DB 			_386;ADD	DX,SI  	{inc(ddy,sine);}

		MOV			DX,AX
		SUB 		DX,SI             {dec(ddx,cosine);}
		DB 			_386;ROL	DX,16

		DEC			BP
		JNZ			@Y       					{Bucle Y}

	POP			BP
	POP			DS
END;

procedure go;
begin
	if MyFrames and 63=0 then
		begin
			top:=random(DEG)-5;
			i:=random(5);
		end;
	if (rotacion<0) or (rotacion>DEG-top) then i:=-i;
	inc(rotacion,i);
	if (distancia<50) or (distancia>500) then d:=-d;
	inc(distancia,d);
	rota;
end;

end.