unit flame;

INTERFACE

procedure go;

IMPLEMENTATION

uses Mode13,Old3D,Engine3D,colors,keys,MyDOS,OP386,main,MyMidas;

const
	L_TOTAL=100;
	L_ZMAX=5000;

type
	Tlines=record
		x1,y1,x2,
		y2,x3,y3,
		z:integer;
	end;
	AL=array[0..L_TOTAL] of Tlines;

const
	P_TOTAL=5000;

type
	Txyz=record
		x,y,z:LongInt;
	end;
	Axyz=array[0..P_TOTAL] of Txyz;

var
	p:^Axyz;
	TresPal:Tpal;
	m:integer;

	l:^AL;
	x1,y1,x2,
	y2,x3,y3:integer;
	v,vv:PObject;
	a,b,d,ang:integer;
	DosPal:Tpal;

	o:P3D;
	UnoPal:Tpal;
	n,
	h0,h1,
	l1,l2,l3:integer;
	light:TLight;

	s:TScene;
	cam:TCamera;

procedure UnoInit;
begin
	if not Load3D(o,'DONUT') then Ferror('DONUT.3DN');
	SetRenderType(o,ALL_CHILDS,_FLAT_);
	o^.world.z:=5000;
	o^.angle.caida:=90;

	if not LoadPal(UnoPal,'COLORES') then Ferror('COLORES.RGB');

	NewScene(s,MAX_FACES_IN_SCENE);
	ResetCamera(cam);
	h0:=NewLight(s,_FOCUS_);
	h1:=NewLight(s,_FOCUS_);
	light.from.x:=-150;light.from.y:=100;light.from.z:=100;

	l1:=random(DEG);l2:=random(DEG);l3:=random(DEG);
end;

procedure uno;
var
	n:integer;

begin
	SetCamera(s,cam);
	for n:=1 to SkipFrames do
		begin
			light.where.x:=16*sine[l1] div ESCALE;
			inc(l1);
			if l1>DEG then dec(l1,DEG);

			light.where.y:=32*sine[l2+COSINE] div ESCALE;
			dec(l2,2);
			if l2<0 then inc(l2,DEG);

			light.where.z:=64*sine[l3] div ESCALE;
			inc(l3,3);
			if l3>DEG then dec(l3,DEG);

			SetLight(s,h0,light);
			light.where.z:=-light.where.z*256;
			SetLight(s,h1,light);

			with o^.angle do
				begin
					deriva:=deriva+1;
					if deriva>DEG then deriva:=deriva-DEG;

					caida:=caida-2;
					if caida<0 then caida:=caida+DEG;

					balanza:=balanza+3;
					if balanza>DEG then balanza:=balanza-DEG;
				end;
		end;

	PutAll3D(s,o);
	RenderScene(s);
end;

procedure nuevo(n:integer);
begin
	with l^[n] do
		begin
			x1:=aleatorio(-400,400);
			y1:=aleatorio(-400,400);

			x2:=x1+aleatorio(-400,400);
			y2:=y1+aleatorio(-400,400);

			x3:=x2+aleatorio(-400,400);
			y3:=y2+aleatorio(-400,400);

			z:=L_ZMAX;
		end;
end;

procedure _lineas(x1,y1,x2,y2,x3,y3:integer);
begin
	if Mode13.Clip2D(x1,y1,x2,y2) then Mode13.draw(c_x1,c_y1,c_x2,c_y2,n);
	if Mode13.Clip2D(x1,y1,x2,y2) then Mode13.draw(c_x1,c_y1,c_x2,c_y2,n);
end;

procedure DosInit;
begin
	GetMem(l,SizeOf(AL));
	for n:=0 to L_TOTAL do nuevo(n);
	for n:=0 to L_TOTAL do l^[n].z:=random(L_ZMAX);

	if not LoadPal(DosPal,'MORE') then error('MORE.RGB');

	GetMem(v,SizeOf(Tobject));
	ResetObject(v);
	v^.wz:=500;

	a:=0;b:=0;d:=0;
	ang:=0;
end;

procedure dos;
var
	f:integer;

begin
	Precalc12Mult(v);

	v^.wx:=512*sine[ang] div ESCALE;
	v^.wy:=256*sine[COSINE+ang] div ESCALE;

	for f:=1 to SkipFrames do
		begin
			inc(ang,3);
			if ang>DEG then dec(ang,DEG);
		end;

	for n:=0 to d do
		begin
			v^.x:=l^[n].x1;v^.y:=l^[n].y1;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x1:=v^.sx;y1:=v^.sy;

			v^.x:=l^[n].x2;v^.y:=l^[n].y2;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x2:=v^.sx;y2:=v^.sy;

			v^.x:=l^[n].x3;v^.y:=l^[n].y3;
			v^.z:=l^[n].z;
			RotateVertex12Mult(v);
			x3:=v^.sx;y3:=v^.sy;

			for f:=1 to SkipFrames do
				begin
					dec(l^[n].z,100);
					if l^[n].z<1 then nuevo(n);
				end;

			_lineas(x1,y1,x2,y2,x3,y3);
		end;

	for f:=1 to SkipFrames do
		begin
			inc(v^.balanza,a);
			if v^.balanza>DEG then v^.balanza:=0;
			if v^.balanza<0 then v^.balanza:=DEG;

			inc(b);
			if b and 127=0 then
				begin
					a:=-a*2;
					if a=0 then a:=1;
				end;
			if (b and 3=0) and (d<L_TOTAL) then inc(d,2);
		end;
end;

procedure TresInit;
begin
	if not LoadPal(TresPal,'PRUEBA') then error('PRUEBA.RGB');

	GetMem(p,SizeOf(Axyz));
	for n:=0 to P_TOTAL do with p^[n] do
		begin
			x:=round(n*sin(n*RAD));
			y:=round(n*cos(n*RAD));
			z:=round(n*(sin(n)/cos(n)));
		end;

	GetMem(vv,SizeOf(Tobject));
	ResetObject(vv);
	vv^.caida:=90;
	vv^.wz:=5000;

	n:=0;
end;

procedure tres;
begin
	Precalc12Mult(vv);
	ASM
		PUSH		BP

		MOV			AX,WORD(vv+2)
		DW			MOV_GS_AX

		MOV			AX,WORD(p+2)
		DW			MOV_FS_AX
		MOV			SI,WORD(p)

		MOV		 	m,P_TOTAL

@BUCLE:
			MOV		BX,WORD(vv)
			DW		FS_386;MOV		AX,WORD(Txyz[SI].x)
			DW		GS_386;MOV		WORD(Tobject[BX].x),AX
			DW		FS_386;MOV		AX,WORD(Txyz[SI].y)
			DW		GS_386;MOV		WORD(Tobject[BX].y),AX
			DW		FS_386;MOV		AX,WORD(Txyz[SI].z)
			DW		GS_386;MOV		WORD(Tobject[BX].z),AX

			PUSH		SI

			DW			PUSH_GS
			PUSH		BX
			CALL		RotateVertex12Mult

			POP			SI

			TEST		AL,AL
			JZ			@MAYOR

			DB			GS;MOV			BP,Tobject[BX].sy
			CMP			BP,YMAX
			JA			@MAYOR

			DB			GS;MOV			AX,Tobject[BX].sx
			CMP			AX,XMAX
			JA			@MAYOR

				MOV			ES,vRAM

				ADD			BP,BP
				MOV			DI,AX
				ADD			DI,WORD(DS:MultByWidth[BP])
				MOV			ES:[DI],AL

@MAYOR:
		ADD			SI,TYPE(Txyz)
		DEC			m
		JNZ			@BUCLE

		POP			BP
	END;

	for n:=1 to SkipFrames do with vv^ do
		begin
			if n>500 then dec(wz,50);

			inc(caida);
			if caida>DEG then dec(caida,DEG);

			dec(balanza);
			if balanza<0 then inc(balanza,DEG);

			inc(deriva,2);
			if deriva>DEG then dec(deriva,DEG);
		end;
end;

procedure go;
var
	delay,n,m:integer;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(DESINTEGRATE);

	UnoInit;
	DosInit;
	TresInit;

{	n:=random(3)+1;}
	n:=2;
	InkAllRGB(0,255,DosPal);
	delay:=512;

	SkipFrames:=StartFrame;
	inc(MyFrames);
	repeat
		case n of
			1:uno;
			2:dos;
			3:tres;
		end;

		m:=MyFrames mod delay;
		if m=delay-1 then WhitePal;
		if m=0 then
			begin
				delay:=aleatorio(3,64);
{				if delay>4 then delay:=delay div 2;}

				m:=n;
				repeat
					n:=random(3)+1;
				until n<>m;
				case n of
					1:
						begin
							InkAllRGB(0,255,UnoPal);
							SetDesintegrate(5);
						end;
					2:
						begin
							InkAllRGB(0,255,DosPal);
							SetDesintegrate(13);
						end;
					3:
						begin
							InkAllRGB(0,255,TresPal);
							SetDesintegrate(1);
						end;
				end;
			end;

		if inkey[K_ESC] then halt;

		DrawH(0,0,XMAX,0);
		DrawH(0,YMAX,XMAX,0);
		SkipFrames:=anima;
	until finish;
	DifumineToColor(0,255,white);

	FreeLight(s,h0);
	FreeLight(s,h1);

	Free3D(o);
	FreeScene(s);

	FreeMem(v,SizeOf(Tobject));
	FreeMem(vv,SizeOf(Tobject));

	FreeMem(p,SizeOf(Axyz));
	FreeMem(l,SizeOf(AL));
end;

end.