Program LZCreate;
{ Proyecto:     Programa para crear un fichero .LZW                       }
{ Autor:        Antonio Tejada Lacaci a.k.a. EtCtera                      }
{ Fecha:        Junio '96                                                 }
{ Descripcin:  Permite leer ficheros incrustados comprimidos o sin       }
{               comprimir (subficheros) en un gran fichero (fichero LZ)   }
{               Funciona como programa desde lnea de comandos. Escribir  }
{               LZW para ver la sintaxis.                                 }
{               Para comprimir, necesita el programa LZCOMP.EXE           }
{$M 8096 0 128000 }
{{$D-,Y-,R-,S-}
Uses
  LZFiles,Files,DOS;

Var
  LZFile:TLZFile;
  aFile:Files.TFile absolute LZFile;

  Function Mays(Cad:String):String;Assembler;
  { Convierte Cad en maysculas }
  Asm
    push ds                   { Guardo el segmento de datos               }
    lds si,Cad                { Cargo el puntero a Cad en ds:si           }
    les di,@Result            { Cargo el puntero al resultado en es:di    }
    mov al,byte ptr [si]      { meto en al la longitud de la cadena       }

    xor cx,cx                 { Borro cx                                  }
    mov cl,al                 { Meto en cl la longitud de la cadena       }
    mov es:[di],cl            { Meto en el resultado la longitud de la    }
                              { cadena resultante                         }
    cmp cl,0                  { Si la cadena es nula, finalizamos         }
    je @Fin
    @Bucle1:                  { Bucle de tratamiento de Cad               }
      inc si                  { Incremento el puntero a Cad               }
      inc di                  { Incremento el puntero al resultado        }
      mov al, byte ptr [si]   { Meto en al el caracter a tratar           }
      cmp al,'a'              { Comparo con "a", si es menor no convierto }
      jb @NoConv
      cmp al,'z'              { Comparo con "z", si es mayor salto al tra-}
      ja @EspChar             { tamiento de caracteres especiales.        }
      sub al,32               { Convierto (resto 32)                      }
      jmp @Noconv

      @EspChar:               { Trato        (solo castellano)     }
        cmp al,''            { Es una ""?                              }
        jnz @No00
          mov al,'A'          { Pongo "A"                                 }
        jmp @NoConv
        @No00:
				cmp al,''            { Es una ""?                              }
        jnz @No01
          mov al,'E'          { Pongo una "E"                             }
        jmp @NoConv
        @No01:
        cmp al,''            { Es una ""?                              }
        jnz @No02
          mov al,'I'          { Pongo una "I"                             }
          jmp @NoConv
        @No02:
        cmp al,''            { Es una ""                               }
        jnz @No03
          mov al,'O'          { Pongo una "O"                             }
          jmp @NoConv
        @No03:
        cmp al,''            { Es una ""?                              }
        jnz @No04
          mov al,'U'          { Pongo una "U"                             }
          jmp @NoConv
        @No04:
        cmp al,''            { Es una ?                                }
        jnz @No05
          mov al,''
          jmp @NoConv
        @No05:
        cmp al,''            { Es una ""                               }
        jnz @NoConv
          mov al,''
          jmp @NoConv
      @NoConv:
       mov byte ptr es:[di],al { Muevo la letra, convertida o no a result }
    loop @Bucle1
    @Fin:
    pop ds
  End;

  Procedure LZNew(LZFileName:TFileName);
  { Si el fichero no existe, lo crea. Si existe, lo abre para su uso }
  Var
    Count:Word;
  Begin
    With LZFile do begin
      lzHandle     := 0;         { Handle al fichero DOS    }
      With lzHeader do begin
         lzIdent:='';
				 szChar:=0;
         szAlpha:=0;
         ptDirectory:=SizeOf(LZFile.lzHeader);
         nmFiles:=0;
      end;
      lzDirectory:=nil;
      lzEXEOffset:=0;
    end;

    If Files.Open(aFile,LZFileName,Files.RW)<>0 then begin
       { El fichero no existe, lo creamos }
       Files.ReWrite(aFile,LZFileName);
       LZFile.lzHeader.lzIdent:=lzMagic;
       New(LZFile.lzDirectory);
    end else begin
       { Nos posicionamos en el ltimo LONGINT, que es un puntero "inverso" }
       { al principio del .LZW                                              }
       Files.Seek(aFile,Files.filesize(aFile)-4);
       Files.Read(aFile,LZFile.lzEXEOffset,4,count);
       LZFile.lzEXEOffset := Files.fileSize(aFile)-LZFile.lzEXEOffset-1;

       { Leemos la cabecera del .LZW }
       Files.Seek(aFile,LZFile.lzEXEOffset);
       { El fichero existe, leemos la cabecera }
       Files.Read(aFile,LZFile.lzHeader,SizeOf(LZFile.lzHeader),Count);
       { Comprobamos que es un .LZW }
       If (LZFile.lzHeader.lzIdent <> lzMagic) then begin
          Writeln('ERROR: El fichero ',LZFileName,' no es de tipo .LZW');
          halt;
       end;
       { Leemos el directorio de subficheros }
       New(LZFile.lzDirectory);
       Files.Seek(aFile, LZFile.lzHeader.ptDirectory+LZFile.lzEXEOffset);
       Files.Read(aFile, LZFile.LZDirectory^,LZFile.lzHeader.nmFiles*
       SizeOf(TSubDescriptor),count);
    end;
  End;

  Procedure LZAdd(aFileName:TFileName;Compressed:Boolean);
  { Aade el subfichero FileName al fichero .LZW LZFile }
  Var
    bFile:Files.TFile;
    bFilename:String;
    c:Char;
    count:Word;
    FileSize:Longint;
    CompSize:Longint;
    Name,ext,dummy:String;
    P:^Byte;
  Begin
    { Abrimos el fichero a aadir }
    If open(bFile,aFileName,RO) <> 0 then begin
       Writeln('ERROR: Imposible abrir el fichero ',aFileName);
       exit;
    end;
    FileSize:=Files.FileSize(bFile);
    If compressed then begin
       { Comprimimos el fichero }
       Files.Close(bFile);
       Exec('lzcomp.exe',aFileName+' tempfile.lzw');
       If (Files.Open(bFile,'tempfile.lzw',RO)<>0) or (DosError<>0) then begin
          Writeln('ERROR: Imposible comprimir el fichero ',aFileName);
          exit;
	  end;
       CompSize:=Files.FileSize(bFile);
    end else Compsize := -1;

    { Pedimos memoria para el buffer intermedio }
    GetMem(P,60000);
    { Buscamos la posicin del .LZW donde aadir el fichero }
    Files.Seek(aFile,LZFile.lzHeader.ptDirectory+LZFile.lzEXEOffset);
    While not eof(bFile) do begin
      Files.Read(bFile,P^,60000,count);
      Files.Write(aFile,P^,count,count);
    end;

    { Borramos el fichero temporal }
    If compressed then erase(bFile);
    { Cerramos el subfichero }
    Files.Close(bFile);
    { Liberamos el buffer intermedio }
    Freemem(P,60000);

    { Actualizamos el descriptor del subfichero }
    With LZFile.lzDirectory^[LZFile.lzHeader.nmFiles] do begin
      FSplit(aFileName,dummy,Name,Ext);
      FileName := Mays(aFileName);
      szFile := FileSize;
      szComp := CompSize;
      ptFile:=LZFile.lzHeader.ptDirectory;
    end;

    { Actualizamos el directorio del .LZW }
    If compressed then
       Inc(LZFile.lzHeader.ptDirectory,CompSize)
    else
       Inc(LZFile.lzHeader.ptDirectory,FileSize);
       Inc(LZFile.lzHeader.nmFiles);
    End;

    Function LZFind(FileName:TFileName):Integer;
    { Devuelve un ndice a la entrada del fichero FileName en el directorio }
    Var
      MFileName:String;
      i:Integer;
    Begin
      MFileName:=Mays(FileName);
      i:=0;
      While (LZFile.lzHeader.nmFiles> i) and
        (LZFile.lzDirectory^[i].FileName<>MFileName) do inc(i);
	If not(LZFile.lzHeader.nmFiles> i) then i:= -1;
	LZFind:=i;
    End;

  Procedure LZDel(FileName:TFileName);
  { Borra el subfichero FileName del fichero .LZW LZFile }
  Var
    P:^Byte;
    k,i:Longint;
    index,FileSize:Longint;
    count:Word;
  Begin
		i:=LZFind(FileName);
    If i=-1 then begin
       Writeln('ERROR: El fichero ',Filename,' a borrar no exite en el .LZW');
       exit;
    end;

    { Tomamos el no. de bytes a desplazar }
    If LZFile.lzDirectory^[i].szComp>-1 then
       FileSize:=LZFile.lzDirectory^[i].szComp
    else
       FileSize:=LZFile.lzDirectory^[i].szFile;

    { Pedimos memoria para el buffer intermedio }
    GetMem(P,60000);
    index:=LZFile.lzDirectory^[i].ptFile+FileSize;
    While index+FileSize<LZFile.lzHeader.ptDirectory do begin
        Files.Seek(aFile,index+LZFile.lzEXEOffset);
        Files.Read(aFile,P^,60000,count);
        Files.Seek(aFile,LZFile.lzEXEOffset+index-FileSize);
        Files.Write(aFile,P^,count,count);
        Inc(Index,count);
    end;
    { Truncamos }
    Files.Seek(aFile,LZFile.lzHeader.ptDirectory-FileSize+LZFile.lzEXEOffset);
    Files.Write(aFile,P^,0,count);
    { Liberamos la memoria del buffer intermedio }
    FreeMem(P,60000);

    { Actualizamos los descriptores }
    For k:=i+1 to LZFile.lzHeader.nmFiles-1 do
        Dec(LZFile.lzDirectory^[k].ptFile,FileSize);

    { Trasladamos todos los descriptores una posicin }
    { Bastara con copiar el ltimo descriptor en la posicin que queda }
    { libre, pero para mantener el orden de introduccin de los descrip-}
    { tores, lo hacemos as (adems son rpidas transferencias a Mem. P.}
    If i<>LZFile.lzHeader.nmFiles-1 then
       Move(LZFile.lzDirectory^[i+1],LZFile.lzDirectory^[i],
          SizeOf(TSubDescriptor)*(LZFile.lzHeader.nmFiles-1-i));
    Dec(LZFile.lzHeader.nmFiles);
    Dec(LZFile.lzHeader.ptDirectory,FileSize);
  End;


  Function LZGetDirectory:PLZDirectory;
	Var
		i:integer;
    realtotal,total:Real;
  Begin
    total:=0;
    realtotal:=0;
    For i:=0 to LZFile.lzHeader.nmFiles-1 do With LZFile.lzDirectory^[i] do begin
        if i mod 25=0 then Writeln('FILE                  COMPSIZE    REALSIZE     POSITION  RATIO');
        Writeln(FileName:14,'  ',szComp:12,szFile:12,'  ',ptFile:12,'   ',
          (szComp*100 div (szFile+1)):3,'%');
        realtotal:=Realtotal+szFile;
        If szComp>-1 then total:=total+szComp else total:=total+szfile;
    end;
    Writeln('------------------------------------------------------------------');
    Writeln('Total: ',LZFile.lzHeader.nmFiles:4,' files ',total:12:0,
      realtotal:12:0,'     *******   ',(total*100/realtotal):3:0,'%');
  End;

  Procedure LZDone;
  { Guarda el directorio de un fichero .LZW y actualiza su cabecera }
  Var
    Count:Word;
    Offset:Longint;
  Begin
		{ Guardamos la cabecera }
		Files.Seek(aFile, LZFile.lzEXEOffset);
		Files.Write(aFile,LZFile.lzHeader,SizeOf(LZFile.lzHeader),count);
		{ Guardamos el directorio }
		Files.Seek(aFile,LZFile.lzHeader.ptDirectory+LZFile.lzEXEOffset);
		Files.Write(aFile,LZFile.lzDirectory^,SizeOf(TSubDescriptor)*LZFile.lzHeader.nmFiles,count);
    { Guardamos el puntero a la cabecera }
    Offset:=files.FilePos(aFile)+3-LZFile.lzEXEOffset;
    Files.Write(aFile,offset,SizeOf(Offset),count);
		Files.Close(aFile);
    { Devolvemos la memoria asignada al directorio }
		Dispose(LZFile.lzDirectory);
	End;

Var
	m:Longint;
	i:Integer;
	command:String;
Begin
	m:=MemAvail;
	{ LZW: <nom_LZWFich> -command [NomFichs] }
	{    Donde command es:                   }
	{     v -> Mostrar directorio            }
	{     a -> Aadir ficheros               }
	{     d -> Borrar ficheros               }
	If ParamCount<2 then begin
		 { Formato incorrecto de llamada }
		 Writeln('LZW. Gestor de ficheros incrustados en un .LZW. (c) EtCtera ''96');
		 Writeln('Formato: LZW <nom_LZWFich> -command [NomSubFich1[ NomSubFich2]]');
		 Writeln('  Los posibles valores de command son: ');
		 Writeln('   v -> Muestra el directorio del fichero .LZW');
		 Writeln('   ac -> Aade subficheros comprimidos al fichero .LZW');
		 Writeln('   ax -> Aade subficheros sin comprimir al fichero .LZW');
		 Writeln('   d -> Borra subficheros del fichero .LZW');
     Writeln;
     Writeln('Ejemplos: ');
     Writeln(' Aadir comprimiendo los ficheros fichero1.dat, fichero2.dat y fichero3.dat');
     Writeln('a fichero.lzw');
     Writeln('  LZW fichero.lzw -ac fichero1.dat fichero2.dat fichero3.dat');
     Writeln(' Listar los ficheros incrustados en fichero.lzw');
     Writeln('  LZW fichero.lzw -v');
		 Halt;
	end;

	LZNew(ParamSTr(1));
	Command:=ParamStr(2);
	Writeln('Abriendo fichero de datos ',ParamStr(1));
	case Command[2] of
    'v':LZGetDirectory;
		'a':Case Command[3] of
				 'c':For i:=3 to ParamCount do begin
						 Writeln('Aadiendo fichero comprimido ',ParamStr(i));
						 LZAdd(ParamStr(i),True);
				 end;
				 'x':For i:=3 to ParamCount do begin
						 Writeln('Aadiendo fichero sin comprimir ',ParamStr(i));
						 LZAdd(ParamStr(i),False);
				 end;
		end;
		'd':For i:=3 to ParamCount do begin
						 Writeln('Borrando fichero ',ParamStr(i));
						 LZDel(ParamStr(i));
			 end;
		else Writeln('ERROR: Comando desconocido ',ParamStr(2));
	end;
	LZDone;
	Writeln(memavail-m);
End.