unit cadenas;

INTERFACE

const
	VentanasAbiertas:word=0;
	TipoMarco:array[1..3] of string[8]=('ķԳ','Ŀ','ͻȺ');

	NEGRO=0;
	AZUL=1;
	VERDE=2;
	AZUL_CLARO=3;
	ROJO=4;
	ROSA=5;
	MARRON=6;
	GRIS_CLARO=7;
	GRIS_OSCURO=8;
	AZUL_MAR=9;
	VERDE_CLARO=10;
	AZUL_CIELO=11;
	ROJO_CLARO=12;
	ROSA_CLARO=13;
	AMARILLO=14;
	BLANCO=15;

	BEEP=#7;

	ESCAPE=#27;
	ESPACIO=#32;
	RETURN=#13;

	ARRIBA=#72;
	IZQUIERDA=#75;
	DERECHA=#77;
	ABAJO=#80;

	F1=#59;
	F2=#60;
	F3=#61;
	F4=#62;
	F5=#63;
	F6=#64;
	F7=#65;
	F8=#66;
	F9=#67;
	F10=#68;

	CTRL_DEL=#127;
	ALT_DEL=#14;

	CTRL_F1=#94;
	CTRL_F2=#95;
	CTRL_F3=#96;
	CTRL_F4=#96;
	CTRL_F5=#98;
	CTRL_F6=#99;
	CTRL_F7=#100;
	CTRL_F8=#101;
	CTRL_F9=#102;
	CTRL_F10=#103;

	ALT_F1=#104;
	ALT_F2=#105;
	ALT_F3=#106;
	ALT_F4=#107;
	ALT_F5=#108;
	ALT_F6=#109;
	ALT_F7=#110;
	ALT_F8=#111;
	ALT_F9=#112;
	ALT_F10=#113;

	ALT_Q=#16;
	ALT_W=#17;
	ALT_E=#18;
	ALT_R=#19;
	ALT_T=#20;
	ALT_Y=#21;
	ALT_U=#22;
	ALT_I=#23;
	ALT_O=#24;
	ALT_P=#25;
	ALT_A=#30;
	ALT_S=#31;
	ALT_D=#32;
	ALT_F=#33;
	ALT_G=#34;
	ALT_H=#35;
	ALT_J=#36;
	ALT_K=#37;
	ALT_L=#38;
	ALT_Z=#44;
	ALT_X=#45;
	ALT_C=#46;
	ALT_V=#47;
	ALT_B=#48;
	ALT_N=#49;
	ALT_M=#50;

	AVANCE=#81;
	RETROCESO=#73;
	INICIO=#71;
	FIN=#79;
	OTRO_CODIGO=#0;
	VACIO=#255;
	MAS=#43;
	DEL=#8;
	INS=#82;
	SUPR=#83;
	TAB=#9;
	REVERSE_TAB=#15;
	CARRO=#10;

	TOTAL_OPCIONES=20;

type
	TDir=(HORIZONTAL,VERTICAL);

	TcentroX=(SIN_CENTRAR,A_IZQUIERDA,AL_CENTRO,A_DERECHA);
	TcentroY=(A_ARRIBA,A_ABAJO);
	Tcursor=(SIN_CURSOR,CURSOR_NORMAL,CURSOR_GRANDE);
	Tentrada=(NUMERICA,ALFABETICA,ALFANUMERICA);
	Tbox=(NOMBRE,FECHA,LONGITUD,EXTENSION);

	RangoColor=0..15;
	RangoFondo=0..7;
	RangoX=1..80;
	RangoY=1..25;

	TVentana=record
		x1,x2:RangoX;
		y1,y2:RangoY;
		ColorMarco:RangoColor;
		ColorVentana:RangoFondo;
		Usar3D:boolean;
		marco:string[8];
		titulo:string;
		CentrarTitulo:TcentroX;
		posicion:TcentroY;
	end;

	Tfont16=array[0..15] of byte;

	Tr=record
		elemento,fichero:string[50];
		marcado:boolean;
	end;

	Tbrowse=array[0..500] of Tr;

	car=set of char;

const
	ColorEspecial:RangoColor=ROJO;
	ColorAtributo:word=1792;

	mayusculas:car=['A'..'Z'];
	minusculas:car=['a'..'z'];
	numeros:car=['0'..'9'];
	alfabeto:car=['A'..'z'];
	operadores:car=['+','-','*','/'];

	SpecialKey:boolean=FALSE;

var
	opciones:array[1..TOTAL_OPCIONES] of string[80];
	browse:^Tbrowse;

procedure AlinearNumero(var cadena:string;ancho,decimales:byte);
{alinea a la derecha una cadena numrica de ANCHO y DECIMALES}

procedure AlinearCadena(var cadena:string;ancho:byte);
{alinea a la derecha una cadena alfanumrica de ANCHO}

procedure puntos(var cadena:string);
{separa con puntos una cadena numrica}

function AcceptDate(xx:RangoX;yy:RangoY;var cadena:string;anterior:boolean;
										ancho:RangoX;color:RangoColor;fondo:RangoFondo):char;
{edita una fecha (puede estar inicializada si ANTERIOR=TRUE) con NUM
de longitud}

function accept(xx:RangoX;yy:RangoY;var cadena:string;anterior,
								mayusculas:boolean;tipo:Tentrada;ancho:RangoX;
								color:RangoColor;fondo:RangoFondo):char;
{edita una cadena (puede estar inicializada si ANTERIOR=TRUE) con ancho
de longitud, si MAYUSCULAS=TRUE..., TIPO de entrada NUMERICA,ALFANUMERICA,
COLOR=...}

function upper(c:string):string;
{convierte una cadena a maysculas}

function lower(c:string):string;
{convierte una cadena a minsculas}

function strings(num:byte;caracter:char):string;
{devuelve una cadena de NUM longitud con el CARACTER}

procedure locate(x:RangoX;y:RangoY);
{pone el cursor en las coordenadas x y (estas coordenadas son diferentes a
las de la unidad CRT}

procedure pen(tinta:RangoColor;fondo:RangoFondo);
{cambia el color y el fondo para el procedimiento print()}

procedure print(frase:string);
{escribe una cadena en las coordenadas de LOCATE con con los colores de PEN}

procedure CopyChr(var caracter:char;var at:byte);
{devuelve en CARACTER el caracter que hay en la posicin actual del cursor
OJO de GOTOXY! y en AT el atributo que hay}

function hex(variable:word):string;
{devuelve una cadena en hexadecimal de VARIABLE}

function LongHex(variable:LongInt):string;

function BinB(num:byte):string;
{devuelve una cadena en binario de VARIABLE byte}

function BinW(num:word):string;
{devuelve una cadena en binario de VARIABLE word}

function BinL(num:LongInt):string;
{devuelve una cadena en binario de VARIABLE word}

procedure mode(modo:byte);
{cambia al modo de pantalla especificado}

procedure cls(caracter:char);
{rellena la actual ventana de texto con CARACTER}

function AbrirVentana(ventana:TVentana):boolean;
{abre una ventana del tipo TVentana}

function CerrarVentana:boolean;
{cierra la ventana abierta con AbrirVentana, va como LIFO}

procedure cursor(modo:Tcursor);
{tipo de cursor, NORMAL, SIN , GRANDE}

procedure symbol(caracter:char;var s:TFont16);
{Cambio la letra CARACTER, por el patrn S del tipo FONT16}

function left(c1,c2:string):string;

function box(xx:RangoX;yy:RangoY;ventana:TVentana;actual:string;
						 var fichero:string;alto:RangoY;tb,sort:Tbox;var line:integer):integer;
{Devuelve en FICHERO el fichero especificado en ACTUAL, pudiendo recorrer}
{el rbol de directorios}

function IsNumeric(cadena:string):boolean;
{Devuelve TRUE si la cadena es numrica}

function IsAlfabetic(cadena:string):boolean;
{Devuelve TRUE si la cadena es alfabtica}

procedure barra(x:RangoX;y:RangoY;actual,total:LongInt;ancho:RangoX);
{ Hace una barra de estado con:
	x,y=coordenadas
 current=operacin actual
 total=total de operaciones
 width=ancho de la barra}

function EligeOpcion(xx,yy:integer;var v:TVentana;NumeroOpciones:integer;
										 d:TDir;color:RangoColor;fondo:RangoFondo):ShortInt;
{ xx,yy=coordenadas
	v=tipo de ventana definido por TVentana
	NumeroOpciones
	d=direccin, HORIZONTAL o VERTICAL
	color
	fondo

			Se puede cambiar el color marcado por la letra directa, como
			ColorEspecial}

function control:boolean;
{Devuelve TRUE si hay algn control apretado}

function alt:boolean;
{Devuelve TRUE si hay algn alt apretado}

procedure str(n:byte;width:integer;var s:string);
{Convierte un nmero en una cadena}

function MakeBrowse(xx,yy,ancho,alto,total:integer;v:Tventana;
										asterisco:boolean;var line:integer):integer;

function SearchString(var fuente;LongitudFuente:word;
											var destino;LongitudDestino:word;var puntero:word):boolean;
{TRUE si la cadena fuente se encuentra en la cadena destino, en puntero
la posicin en la que se encontr}

procedure centrado(c:string;t:integer);

function ReadKey:char;

procedure ScrollUp(x1,y1,x2,y2,at:byte);

procedure ScrollDown(x1,y1,x2,y2,at:byte);

IMPLEMENTATION

uses
	MyDOS,DOS,CRT,speed;

type
	p=^estructura;
	estructura=record
		anterior:p;
		attr,vx,vy:word;
		x1,x2,CurX:1..80;
		y1,y2,CurY:1..25;
		dir:^byte;
	end;

const
	actual:p=NIL;

	w:word=0;

	DigitHex:array[0..15] of char='0123456789ABCDEF';

var
	anterior:p;

procedure AlinearNumero(var cadena:string;ancho,decimales:byte);
var
	error,n,n1,m:integer;
	numero:double;

begin
	val(cadena,numero,error);
	system.str(numero:ancho:decimales,cadena);
end;

procedure AlinearCadena(var cadena:string;ancho:byte);
begin
	insert(strings(ancho-length(cadena),' '),cadena,1);
end;

procedure puntos(var cadena:string);
var
	a,n,m:integer;
	apoyo:string;

begin
	a:=length(cadena);
	n:=0;m:=a;
	while m>-1 do
		begin
			inc(n);
			if n=4 then
				begin
					n:=0;
					inc(a);
				end;
			dec(m);
		end;

	apoyo[0]:=chr(a);
	m:=1;
	for n:=byte(cadena[0]) downto 1 do
		if (cadena[n] in ['-','0'..'9']) then
			begin
				if m=4 then
					begin
						if cadena[n]<>'-' then
							begin
								apoyo[a]:=',';
								dec(a);
							end;
						m:=1;
					end;
				apoyo[a]:=cadena[n];
				dec(a);
				inc(m);
			end;
	cadena:=apoyo;
end;

function AcceptDate(xx:RangoX;yy:RangoY;var cadena:string;anterior:boolean;
										ancho:RangoX;color:RangoColor;fondo:RangoFondo):char;
var
	 x,y,p,n:byte;

procedure eol;
begin
	GotoXY(x,y);
	write(strings(ancho,' '));
end;

var
	tecla:char;
	guarda:string;
	attr:word;

begin
	guarda:=cadena;
	attr:=TextAttr;
	x:=xx;y:=yy;
	TextColor(color);
	TextBackGround(fondo);
	eol;

	GotoXY(x,y);
	if anterior then
		begin
			write(cadena);
			GotoXY(x,y);
		end
	else
		cadena:=strings(ancho,' ');

	cadena[0]:=chr(ancho);
	GotoXY(x+2,y);
	cadena[3]:='-';
	write('-');
	GotoXY(x+5,y);
	cadena[6]:='-';
	write('-');
	GotoXY(x,y);
	n:=1;

	repeat
		repeat
			tecla:=ReadKey;
		until tecla in [DEL,TAB,RETURN,ESCAPE,'0'..'9'];

		if SpecialKey then
			case tecla of
				ARRIBA,ABAJO,AVANCE,RETROCESO:break;

				IZQUIERDA:if n>1 then
					begin
						dec(n);
						if (n=3) or (n=6) then dec(n);
						GotoXY((x+n)-1,y);
					end;

				DERECHA:if n<ancho then
						begin
							inc(n);
							if (n=3) or (n=6) then inc(n);
							GotoXY((x+n)-1,WhereY);
						end;
			end
		else
			case tecla of
				RETURN,TAB,ESCAPE:break;
				DEL:if n>1 then
						begin
							dec(n);
							if (n=3) or (n=6) then
								begin
									dec(n);
									GotoXY((x+n),y);
								end;
							cadena[n]:=OTRO_CODIGO;
							GotoXY(WhereX-1,y);
							write(' ');
							GotoXY(WhereX-1,y);
						end;
				else if n<=ancho then
					begin
						cadena[n]:=tecla;
						write(tecla);
						inc(n);
						if (n=3) or (n=6) then
							begin
								inc(n);
								GotoXY((x+n)-1,y);
							end;
					end;
			end;
	 until FALSE;

	 TextAttr:=attr;
	 GotoXY(x,y);
	 for n:=1 to ANCHO do write(' ');
	 GotoXY(x,y);
	 write(cadena);
	 AcceptDate:=tecla;
end;

function accept(xx:RangoX;yy:RangoY;var cadena:string;anterior,
								mayusculas:boolean;tipo:Tentrada;ancho:RangoX;
								color:RangoColor;fondo:RangoFondo):char;
var
	guarda:string;
	insertar:boolean;
	n,p,x,y:byte;
	tecla:char;
	attr:word;

procedure EOL;
begin
	GotoXY(x,y);
	write(strings(ancho,' '));
end;

begin
	guarda:=cadena;
	insertar:=FALSE;
	cursor(CURSOR_NORMAL);
	x:=xx;y:=yy;
	attr:=TextAttr;
	TextColor(color);
	TextBackGround(fondo);
	EOL;
	GotoXY(x,y);

	p:=1;
	if (anterior) and (cadena>'') then
		begin
			write(cadena);
			GotoXY(x,y);
		end
	else
		cadena:='';

	repeat
		GotoXY(x,y);
		write(cadena);
		GotoXY(x+(p-1),y);
		repeat
			tecla:=ReadKey;
			if ((tipo=NUMERICA) and (tecla in [' '..'*',':'..''])) or
				 ((tipo=ALFABETICA) and (tecla in numeros)) then continue;
		until tecla in [' '..VACIO,DEL,TAB,ESCAPE,RETURN];

		if mayusculas then tecla:=UpCase(tecla);

		if SpecialKey then
			case tecla of
				ARRIBA,ABAJO,AVANCE,RETROCESO:break;

				IZQUIERDA:if p>1 then dec(p);

				DERECHA:if (p<length(cadena)+1) and (p<ancho) then inc(p);

				INICIO:p:=1;

				FIN:
					begin
						p:=length(cadena)+1;
						if p>ancho then p:=ancho;
					end;

				INS:
					begin
						insertar:=not insertar;
						if insertar then
							cursor(CURSOR_GRANDE)
						else
							cursor(CURSOR_NORMAL);
					end;

				SUPR:
					begin
						delete(cadena,p,1);
						EOL;
					end;
			end
		else
			case tecla of
				DEL:if p>1 then
					begin
						dec(p);
						delete(cadena,p,1);
						EOL;
					end;
				RETURN,TAB,ESCAPE:break
			else
				if tecla in [ESPACIO..VACIO] then
					if insertar then
						begin
							if length(cadena)<ancho then
								begin
									insert(tecla,cadena,p);
									inc(p);
								end;
						end
					else if p<=ancho then
						begin
							insert(tecla,cadena,p);
							delete(cadena,p+1,1);
							inc(p);
						end;
			end;
	until FALSE;

	accept:=tecla;
	TextAttr:=attr;
	GotoXY(x,y);
	EOL;
	GotoXY(x,y);
	if tecla=ESCAPE then cadena:=guarda;
end;

function upper(c:string):string;
var
	n:byte;

begin
	upper[0]:=c[0];
	for n:=1 to length(c) do upper[n]:=UpCase(c[n]);
end;

function lower(c:string):string;
var
	n:byte;

begin
	lower[0]:=c[0];
	for n:=1 to length(c) do
		if c[n] in mayusculas then
			lower[n]:=chr(ord(c[n])+32)
		else
			lower[n]:=c[n];
end;

function strings(num:byte;caracter:char):string;
var
	conta:byte;

begin
	strings[0]:=chr(num);
	for conta:=1 to num do strings[conta]:=caracter;
end;

procedure locate(x:RangoX;y:RangoY);ASSEMBLER;
ASM
	XOR			AH,AH
	MOV			AL,y
	DEC			AX
	MOV			BX,80
	MUL			BX         {w:=(y-1)*80+(x-1)*2;}

	XOR			BH,BH
	MOV			BL,x
	DEC			BX
	ADD			AX,BX
	ADD			AX,AX

	MOV			w,AX
END;

procedure pen(tinta:RangoColor;fondo:RangoFondo);ASSEMBLER;
ASM
	XOR			AX,AX
	MOV			AL,fondo
	SHL			AX,4
	ADD			AL,tinta      {Color:=((fondo shl 4)+tinta) shl 8;}
	SHL			AX,8
	MOV			ColorAtributo,AX
END;

procedure print(frase:string);ASSEMBLER;
ASM
	PUSH			DS
	MOV				ES,SegB800

	MOV				BX,ColorAtributo    {El color se cambia con PEN(color,fondo)}
	MOV				DI,w        				{La direccin se cambia con LOCATE(x,y)}
	LDS       SI,frase

	MOV				CL,[SI]     {En Pascal la longitud se guarda en el primer char}
	JCXZ			@FIN        {Si longitud=0 goto fin}
	INC				SI					{for i:=0 to length(frase)-1 do}

@BUCLE:
	XOR				AH,AH
	LODSB
	ADD				AX,BX
	STOSW                {memw[DirPant:w+(i*2)]:=color+ord(frase[i]);}
	DEC				CL
	JNZ				@BUCLE

@FIN:
	POP				DS
	MOV				w,DI
END;

procedure CopyChr(var caracter:char;var at:byte);ASSEMBLER;
ASM
	MOV			AH,8
	XOR			BH,BH
	INT			$10

	LES			DI,caracter
	MOV			ES:[DI],AL
	LES			DI,at
	MOV			ES:[DI],AH
END;

function hex(variable:word):string;
begin
	hex:=DigitHex[hi(variable) shr 4]+DigitHex[hi(variable) and $f]+
			 DigitHex[lo(variable) shr 4]+DigitHex[lo(variable) and $f];
end;

function LongHex(variable:LongInt):string;
var
	v:array[1..4] of byte absolute variable;
	c:string;

begin
	c:=
		DigitHex[v[4] shr 4]+DigitHex[v[4] and $f]+
		DigitHex[v[3] shr 4]+DigitHex[v[3] and $f]+
		DigitHex[v[2] shr 4]+DigitHex[v[2] and $f]+
		DigitHex[v[1] shr 4]+DigitHex[v[1] and $f];

	LongHex:=c;
end;

function BinB(num:byte):string;
var
	bt,i:integer;
	c:string[8];

begin
	bt:=1;
	c:='';
	for i:=1 to 8 do
		begin
			if num and bt>0 then
				c:='1'+c
			else
				c:='0'+c;

			bt:=bt*2;
		end;

	BinB:=c;
end;

function BinW(num:word):string;
var
	bt,i:integer;
	c:string[16];

begin
	bt:=1;
	c:='';
	for i:=1 to 16 do
		begin
			if num and bt>0 then
				c:='1'+c
			else
				c:='0'+c;

			bt:=bt*2;
		end;

	BinW:=c;
end;

function BinL(num:LongInt):string;
var
	bt,i:integer;
	c:string[32];

begin
	bt:=1;
	c:='';
	for i:=1 to 32 do
		begin
			if num and bt>0 then
				c:='1'+c
			else
				c:='0'+c;

			bt:=bt*2;
		end;

	BinL:=c;
end;

procedure mode(modo:byte);
begin
	randomize;
	TextBackGround(NEGRO);
	TextColor(GRIS_CLARO);
	ClrScr;
	w:=0;
	ASM
		XOR		AH,AH
		MOV		AL,modo
		INT		$10
	END;
end;

procedure cls(caracter:char);
var
	guarda:byte;
	x,y:word;
	c:string[80];

begin
	guarda:=lo(WindMin);
	c:=strings(lo(WindMax)-guarda+1,caracter);
	for y:=hi(WindMin) to hi(WindMax) do
		begin
			locate(guarda+1,y+1);
			print(c);
		end;
end;

function AbrirVentana(ventana:TVentana):boolean;

procedure Borde3D(x,y,x1,y1:integer);
var
	cx,cy,cx1,cy1,c,n,m:byte;
	a:char;

begin
	m:=TextAttr;

	cx:=lo(WindMin);cy:=hi(WindMin);
	cx1:=lo(WindMax);cy1:=hi(WindMax);
	window(1,1,80,25);

	TextColor(GRIS_OSCURO);
	TextBackGround(NEGRO);
	GotoXY(x+1,y1+1);
	for n:=x+1 to x1+1 do
		begin
			CopyChr(a,c);
			write(a);
		end;
	for n:=y+1 to y1+1 do
		begin
			GotoXY(x1+1,n);
			CopyChr(a,c);
			write(a);
			CopyChr(a,c);
			write(a);
		end;
	TextAttr:=m;
	window(cx,cy,cx1,cy1);
end;

procedure FormaMarco(x,y,x1,y1:integer);
var
	cx,cy,cx1,cy1,m,n,p:byte;

begin
	m:=TextAttr;

	cx:=lo(WindMin);cy:=hi(WindMin);
	cx1:=lo(WindMax);cy1:=hi(WindMax);
	window(1,1,80,25);

	TextColor(ventana.ColorMarco);
	GotoXY(x,y);
	write(strings(x1-x,ventana.marco[2]));

	GotoXY(x,y1);
	write(strings(x1-x,ventana.marco[6]));

	for n:=y to y1 do
		begin
			GotoXY(x,n);
			write(ventana.marco[8]);
		end;
	for n:=y to y1 do
		begin
			GotoXY(x1,n);
			write(ventana.marco[4]);
		end;

	GotoXY(x,y);
	write(ventana.marco[1]);

	GotoXY(x1,y);
	write(ventana.marco[3]);

	GotoXY(x,y1);
	write(ventana.marco[7]);

	GotoXY(x1,y1);
	write(ventana.marco[5]);

	if (ord(ventana.CentrarTitulo)>0) and (length(ventana.titulo)<x1-x) then
		begin
			if ventana.posicion=A_ARRIBA then
				p:=y
			else
				p:=y1;

			case ventana.CentrarTitulo of
				A_IZQUIERDA:GotoXY(x+2,p);
				AL_CENTRO:GotoXY((x+((x1-x) div 2))-(length(ventana.titulo) div 2),p);
				A_DERECHA:GotoXY((x1-length(ventana.titulo))-1,p);
			end;
			write(ventana.titulo);
		end;

	TextAttr:=m;
	window(cx,cy,cx1,cy1);
end;

var
	LenX,l:word;
	guarda:pointer;

begin
	AbrirVentana:=FALSE;

	with ventana do
		begin
			inc(x2,2);inc(y2);
			l:=(x2-x1+1)*(y2-y1+1)*2;
		end;

	if MaxAvail<SizeOf(estructura)+l then exit;
	inc(VentanasAbiertas);
	if actual=NIL then
		begin
			new(actual);
			GetMem(actual^.dir,l);
			actual^.anterior:=NIL;
		end
	else
		begin
			anterior:=actual;
			new(actual);
			GetMem(actual^.dir,l);
			actual^.anterior:=anterior;
		end;

	with actual^ do
		begin
			vx:=WindMin;vy:=WindMax;
			CurX:=WhereX;CurY:=WhereY;
			x1:=ventana.x1;x2:=ventana.x2;
			y1:=ventana.y1;y2:=ventana.y2;
			attr:=TextAttr;

			guarda:=dir;
		end;

	with ventana do
		begin
			LenX:=(x2-x1+1)*2;
			locate(x1,y1);
			for l:=y1 to y2 do with actual^ do
				begin
					move(mem[SegB800:w],dir^,LenX);
					inc(dir,LenX);
					inc(w,80*2);
				end;
		end;

	actual^.dir:=guarda;
	with ventana do
		begin
			dec(x2,2);dec(y2);

			if Usar3D then Borde3D(x1,y1,x2,y2);
			window(x1,y1,x2,y2);
			TextBackGround(ColorVentana);
			ClrScr;

			if marco>'' then
				begin
					FormaMarco(x1,y1,x2,y2);
					window(x1+1,y1+1,x2-1,y2-1);
					ClrScr;
				end;
		end;

	AbrirVentana:=TRUE;
end;

function CerrarVentana:boolean;
var
	apoyo,guarda:pointer;
	LenX:word;
	n,xx1,yy1,xx2,yy2:byte;

begin
	CerrarVentana:=FALSE;
	if actual=NIL then exit;

	dec(VentanasAbiertas);

	with actual^ do
		begin
			apoyo:=anterior;
			guarda:=dir;

			xx1:=x1;xx2:=x2;
			yy1:=y1;yy2:=y2;

			LenX:=(xx2-xx1+1)*2;
			locate(xx1,yy1);
			for n:=yy1 to yy2 do
				begin
					move(dir^,mem[SegB800:w],LenX);
					inc(dir,LenX);
					inc(w,80*2);
				end;
			dir:=guarda;

			window(lo(vx)+1,hi(vx)+1,lo(vy)+1,hi(vy)+1);
			GotoXY(CurX,CurY);
			TextAttr:=attr;
			FreeMem(dir,((xx2-xx1+1)*(yy2-yy1+1))*2);
		end;

	dispose(actual);
	actual:=apoyo;
	CerrarVentana:=TRUE;
end;

procedure cursor(modo:Tcursor);ASSEMBLER;
ASM
	MOV			AH,1
	CMP			modo,SIN_CURSOR
	JNZ			@NO1
	MOV			CX,$2020
	JMP			@RUT

@NO1:
	CMP			modo,CURSOR_NORMAL
	JNZ			@NO2
	MOV			CX,$0607
	JMP			@RUT

@NO2:
	CMP			modo,CURSOR_GRANDE
	JNZ			@RUT
	MOV			CX,7

@RUT:
	INT			$10
END;

procedure symbol(caracter:char;var s:Tfont16);ASSEMBLER;
ASM
	PUSH 		BP

	MOV  		AX,$1100
	MOV  		BH,16       {16 Bytes por caracter}
	MOV			BL,8				{Bloque de caracteres 0}
	MOV  		CX,1        {Definir solo un caracter}
	MOV  		DL,caracter
	XOR			DH,DH
	LES  		BP,s
	INT  		$10

	POP  		BP
END;

function left(c1,c2:string):string;
var
	n:integer;

begin
	n:=length(c2);
	left:=c1+strings(n-length(c1),c2[1]);
end;

var
	Anterior24:pointer;

function MyInt24(AX,BX,CX,DX,SI,DI,DS,ES,BP:WORD):word;INTERRUPT;
var
	v:Tventana;


	function error(c:string):integer;
var
	tmp:integer;

begin
	tmp:=IOresult;

	v.ColorVentana:=ROJO;
	v.ColorMarco:=BLANCO;
	v.marco:=TipoMarco[1];
	v.Usar3D:=TRUE;
	v.CentrarTitulo:=AL_CENTRO;
	v.posicion:=A_ARRIBA;
	v.titulo:=c;

	opciones[1]:='^Ignorar';
	opciones[2]:='^Reintentar';
	opciones[3]:='^Cancelar';
	opciones[4]:='^Terminar';

	ColorEspecial:=AMARILLO;
	error:=EligeOpcion(15,10,v,4,HORIZONTAL,BLANCO,AZUL)-1;
end;

const
	mensaje:array[0..15] of string[20]=(
		' Disco protegido ',
		' Unidad invlida ',
		' Unidad no preparada ',
		' Comando desconocido ',
		' Error de CRC ',
		' Longitud errnea ',
		' Error de bsqueda ',
		' Tipo desconocido ',
		' Sector no hallado ',
		' Sin papel ',
		' Error de escritura ',
		' Error de lectura ',
		' Fallo general',
		'',
		'',
		'');

var
	code:byte;

begin
	CLI;

	code:=error(mensaje[1]);

	ASM
{$IFDEF __BPPROT__}
		MOV		AX,CS
		ADD		AX,SelectorInc
		MOV		ES,AX
		MOV		AL,code
		MOV		BYTE(ES:@CAMBIA+1),AL
{$ELSE}
		MOV		AL,code
		MOV		BYTE(CS:@CAMBIA+1),AL
{$ENDIF}

		MOV		SP,BP
		POP		BP
		POP		ES
		POP		DS
		POP		DI
		POP		SI
		POP		DX
		POP		CX
		POP		BX
		POP		AX

@CAMBIA:
		MOV		AL,0
		IRET
	END;
end;

{$I-}
function box(xx:RangoX;yy:RangoY;ventana:TVentana;actual:string;
							var fichero:string;alto:RangoY;tb,sort:Tbox;var line:integer):integer;
const
	ANCHO=40;
	HIDDEN=7;

var
	tipo,guarda:string;
	barra,t,num:integer;
	UnidadCD:char;

function otro:boolean;
var
	guarda:Tr;
	DirInfo:SearchRec;
	bottom,n,m:integer;
	da,cad,cad1:string;
	dt:DateTime;

begin
	otro:=FALSE;
	if actual[length(actual)]='\' then
		actual:=actual+'*.*'
	else
		actual:=actual+'\*.*';

	FindFirst(actual,AnyFile,DirInfo);
	if IOResult>0 then exit;

	browse^[1].marcado:=FALSE;
	browse^[1].elemento:='A:';

	browse^[2].marcado:=FALSE;
	browse^[2].elemento:='B:';

	browse^[3].marcado:=FALSE;
	browse^[3].elemento:='C:';

	num:=3;

	if GetCDROM(UnidadCD) then
		begin
			inc(num);
			browse^[num].marcado:=FALSE;
			browse^[num].elemento:=UnidadCD+':';
		end;

	GetDir(0,da);
	if length(da)>3 then
		begin
			inc(num);
			browse^[num].marcado:=TRUE;
			browse^[num].elemento:='\'+strings((xx+ANCHO) div 2-1,' ')+'[DIR]';
		end;

	bottom:=num;

	while (DosError=0) or (num>800) do
	 begin
		 browse^[num+1].marcado:=FALSE;
		 if (DirInfo.attr=directory) and (DirInfo.name<>'.') then browse^[num+1].marcado:=TRUE;

		 if (pos(tipo,DirInfo.name)>0) or (browse^[num+1].marcado) or
				((tipo='.*') and (DirInfo.name>'.') and (DirInfo.attr<>VolumeID) and
				(DirInfo.attr<>HIDDEN)) then
			 begin
				 inc(num);
				 browse^[num].elemento:=DirInfo.name+strings((xx+ANCHO) div 2-length(DirInfo.name),' ');
				 if not browse^[num].marcado then
						begin
							case tb of
								LONGITUD:
									begin
										system.str(DirInfo.size:5,cad);
										browse^[num].elemento:=browse^[num].elemento+cad;
									end;
								FECHA:
									begin
										UnpackTime(DirInfo.time,dt);

										system.str(dt.day,cad1);
										if length(cad1)=1 then cad1:='0'+cad1;
										cad:=cad1+'/';

										system.str(dt.month,cad1);
										if length(cad1)=1 then cad1:='0'+cad1;
										cad:=cad+cad1+'/';

										system.str(dt.year,cad1);
										if length(cad1)=1 then cad1:='0'+cad1;
										cad:=cad+cad1;

										browse^[num].elemento:=browse^[num].elemento+cad;
									end;
							end;
						end else browse^[num].elemento:=browse^[num].elemento+'[DIR]';
			 end;

		 FindNext(DirInfo);
	 end;

	if (sort=NOMBRE) or (sort=EXTENSION) then
		begin
			for n:=bottom+1 to num-1 do for m:=n+1 to num do  {}
				begin
					if browse^[n].elemento>browse^[m].elemento then
						begin
							guarda:=browse^[n];
							browse^[n]:=browse^[m];
							browse^[m]:=guarda;
						end;
				end;
		end;

	if sort=EXTENSION then
		begin
			for n:=bottom+1 to num-1 do for m:=n+1 to num do  {}
				begin
					if copy(browse^[n].elemento,pos('.',browse^[n].elemento),3)>
						 copy(browse^[m].elemento,pos('.',browse^[m].elemento),3) then
						begin
							guarda:=browse^[n];
							browse^[n]:=browse^[m];
							browse^[m]:=guarda;
						end;
				end;
		end;

{  if sort=FECHA then
		begin
			UnpackTime(DirInfo.time,dt);
		end;}

	otro:=TRUE;
end;

label _error;

var
	n,m:byte;
	error:boolean;
	at:integer;
	gt,ultimo:string;

begin
	GetIntVec($24,Anterior24);
	SetIntVec($24,@MyInt24);

	gt:=ventana.titulo;

	at:=TextAttr;
	cursor(SIN_CURSOR);

	GetDir(0,guarda);
	ultimo:=guarda;
	n:=length(actual);
	actual:=upper(actual);

	if (pos('\',actual)>0) or (pos(':',actual)>0) then
		begin
			repeat
				dec(n)
			until (actual[n]=':') or (actual[n]='\');
			inc(n);
			tipo:=upper(copy(actual,n+1,length(actual)-n+1));
			actual:=copy(actual,1,n-1);
		end
	else
		begin
			tipo:=copy(actual,pos('.',actual),length(actual)-pos('.',actual)+1);
			actual:=guarda;
		end;

	if (actual[length(actual)]='\') and (actual[length(actual)-1]<>':') then
		dec(actual[0]);
{	if pos('.',tipo)=0 then tipo:='.*';
	ventana.titulo:=' '+tipo+' ';}
	if (pos(':',actual)=2) and (length(actual)=2) then actual:=actual+'\';

	box:=-1;
	ChDir(actual);
	if IOResult>0 then goto _error;
	ultimo:=actual;

	if MemAvail>=SizeOf(Tbrowse) then
		new(browse)
	else
		exit;

	t:=TextAttr;
	error:=not otro;

	repeat
		if error then break;

		case GetDrive of
			0:ventana.titulo:='A:\ '+gt;
			1:ventana.titulo:='B:\ '+gt;
			2:ventana.titulo:='C:\ '+gt;
		end;

		barra:=MakeBrowse(xx,yy,xx+ANCHO,yy+ALTO,num,ventana,FALSE,line);
		if barra=-1 then break;
		if browse^[barra].marcado then
			begin
				actual:=browse^[barra].elemento;
				if length(actual)>1 then dec(actual[0]);
				if pos(' ',actual)>0 then delete(actual,pos(' ',actual),length(actual)-pos(' ',actual)+1);
				ChDir(actual);
				GetDir(0,actual);
				ultimo:=actual;
				error:=not otro;
				line:=1;
			end
		else
			begin
				if pos(':',browse^[barra].elemento)>0 then
					begin
						case browse^[barra].elemento[1] of
							'A':drive(_A);
							'B':drive(_B);
							'C':drive(_C);
						end;

						if browse^[barra].elemento[1]=UnidadCD then
							begin
								n:=ord(UnidadCD)-ord('A');
								drive(Tunidad(n));
							end;

						GetDir(0,actual);
						if IOResult>0 then break;
						ChDir(actual);
						if IOResult>0 then break;
						ultimo:=actual;
						error:=not otro;
						continue;
					end;

				if length(ultimo)>3 then
					fichero:=upper(ultimo)+'\'+browse^[barra].elemento
				else
					fichero:=upper(ultimo)+browse^[barra].elemento;

				delete(fichero,pos(' ',fichero),length(fichero)-pos(' ',fichero)+1);
				box:=1;
				break;
			end;
	until FALSE;

_ERROR:
	dispose(browse);

	ChDir(guarda);
	cursor(CURSOR_NORMAL);
	TextAttr:=at;

	SetIntVec($24,Anterior24);
end;
{$I+}

function IsNumeric(cadena:string):boolean;
var
	n:integer;

begin
	IsNumeric:=TRUE;
	for n:=1 to length(cadena) do
		if cadena[n] in alfabeto then
			begin
				IsNumeric:=FALSE;
				break;
			end;
end;

function IsAlfabetic(cadena:string):boolean;
var
	n:integer;

begin
	IsAlfabetic:=TRUE;
	for n:=1 to length(cadena) do
		if cadena[n] in numeros then
			begin
				IsAlfabetic:=FALSE;
				break;
			end;
end;

procedure barra(x:RangoX;y:RangoY;actual,total:LongInt;ancho:Rangox);
var
	len,i,xx,yy:integer;

begin
	xx:=WhereX;yy:=WhereY;
	len:=(actual*ancho) div total;

	GotoXY(x,y);
	write('0%');

	GotoXY(x+ancho div 2-1,y);
	write('50%');

	GotoXY(x+ancho-4,y);
	write('100%');

	GotoXY(x,y+1);
	for i:=1 to ancho do write('');

	GotoXY(x,y+1);
	for i:=1 to len do write('');

	GotoXY(xx,yy);
end;

function EligeOpcion(xx,yy:integer;var v:Tventana;NumeroOpciones:integer;
										 d:TDir;color:RangoColor;fondo:RangoFondo):ShortInt;
var
	tecla:char;
	mayor:integer;
	x,x1,y,y1:integer;
	cx,cy:array[1..TOTAL_OPCIONES] of integer;

procedure negrita;
var
	a,b:integer;

begin
	GotoXY(cx[x1],cy[y1]);
	TextBackGround(v.ColorVentana);

	if d=HORIZONTAL then
		begin
			a:=pos('^',opciones[x1]);
			for b:=1 to length(opciones[x1]) do
				begin
					if b-1=a then
						TextColor(ColorEspecial)
					else
						TextColor(color);

					if opciones[x1,b]<>'^' then write(opciones[x1,b])
				end;
		end
	else
		begin
			a:=pos('^',opciones[y1]);
			for b:=1 to length(opciones[y1]) do
				begin
					if b-1=a then
						TextColor(ColorEspecial)
					else
						TextColor(color);

					if opciones[y1,b]<>'^' then write(opciones[y1,b]);
				end;
		end;

	GotoXY(cx[x],cy[y]);
	TextBackGround(fondo);
	if d=HORIZONTAL then
		begin
			a:=pos('^',opciones[x]);
			for b:=1 to length(opciones[x]) do
				begin
					if b-1=a then
						TextColor(ColorEspecial)
					else
						TextColor(color);

					if opciones[x,b]<>'^' then write(opciones[x,b])
				end;
		end
	else
		begin
			a:=pos('^',opciones[y]);
			for b:=1 to length(opciones[y]) do
				begin
					if b-1=a then
						TextColor(ColorEspecial)
							else
						TextColor(color);

					if opciones[y,b]<>'^' then write(opciones[y,b]);
				end;
		end;
end;

function SacaMayor:integer;
var
	a,b,n:integer;

begin
	b:=0;
	for n:=1 to NumeroOpciones do
		if length(opciones[n])>b then b:=length(opciones[n]);

	SacaMayor:=b;
end;

procedure dimensiones;
var
	n,m:integer;

begin
	for n:=1 to NumeroOpciones do
		begin
			opciones[n]:=strings((mayor-length(opciones[n])) div 2,' ')+opciones[n];
			insert(strings((mayor-length(opciones[n])),' '),opciones[n],length(opciones[n])+1);
		end;

	m:=mayor;
{	dec(mayor,2);}
	v.x1:=xx;v.y1:=yy;
	if d=HORIZONTAL then
		begin
			v.x2:=v.x1+(mayor*NumeroOpciones)+NumeroOpciones+2;
			v.y2:=v.y1+4;
		end
	else
		begin
			v.x2:=v.x1+mayor+2;
			if NumeroOpciones<13 then
				v.y2:=v.y1+NumeroOpciones*2
			else
				v.y2:=v.y1+NumeroOpciones+1;
			if v.y2>25 then v.y2:=25;
		end;
	mayor:=m;

	AbrirVentana(v);
end;

procedure prepara;
var
	a,b,n:integer;

begin
	if d=HORIZONTAL then
		GotoXY(1,2)
	else
		GotoXY(1,1);

	for n:=1 to NumeroOpciones do
		begin
			write(' ');
			cx[n]:=WhereX;cy[n]:=WhereY;

			a:=pos('^',opciones[n]);
			for b:=1 to length(opciones[n]) do
				begin
					if b-1=a then
						TextColor(ColorEspecial)
					else
						TextColor(color);

					if opciones[n,b]<>'^' then write(opciones[n,b])
				end;
			if (d=VERTICAL) and (n<NumeroOpciones) then
				begin
					WriteLN;
					if NumeroOpciones<13 then WriteLn;
				end;
		end;
end;

function procesa:boolean;
var
	a:integer;

begin
	procesa:=FALSE;
	if (tecla in numeros) or (tecla in alfabeto) then
		for a:=1 to NumeroOpciones do
			if tecla=upper(copy(opciones[a],pos('^',opciones[a])+1,1)) then
				begin
					if d=HORIZONTAL then
						x:=a
					else
						y:=a;

					procesa:=TRUE;
				end;
end;

var
	at,n,ax,ay:integer;

begin
	at:=TextAttr;
	ax:=WhereX;ay:=WhereY;

	GotoXY(xx,yy);
	cursor(SIN_CURSOR);

	mayor:=SacaMayor;
	dimensiones;
	prepara;

	x:=1;x1:=1;
	y:=1;y1:=1;

	repeat
		negrita;

		tecla:=UpCase(ReadKey);
		x1:=x;y1:=y;

		if (SpecialKey) and (tecla=INICIO) then
			if d=HORIZONTAL
				then x:=1
			else
				y:=1;

		if (SpecialKey) and (tecla=FIN) then
			if d=HORIZONTAL then
					x:=NumeroOpciones
				else
					y:=NumeroOpciones;

		if (SpecialKey) and ((tecla=ARRIBA) or (tecla=IZQUIERDA)) then
			if d=HORIZONTAL then
				begin
					dec(x);
					if x<1 then x:=NumeroOpciones;
				end
			else
				begin
					dec(y);
					if y<1 then y:=NumeroOpciones;
				end;

		if (SpecialKey) and ((tecla=ABAJO) or (tecla=DERECHA)) then
			if d=HORIZONTAL then
				begin
					inc(x);
					if x>NumeroOpciones then x:=1;
				end
			else
				begin
					inc(y);
					if y>NumeroOpciones then y:=1;
				end
		else
			if procesa then break;

	until tecla in [RETURN,ESCAPE];

	if d=HORIZONTAL then
		EligeOpcion:=x
	else
		EligeOpcion:=y;

	if tecla=ESCAPE then EligeOpcion:=-1;

	cursor(CURSOR_NORMAL);
	CerrarVentana;

	GotoXY(ax,ay);
	TextAttr:=at;
end;

function control:boolean;
var
	r:registers;

begin
	r.AH:=2;
	intr($16,r);
	control:=TestBit(r.AL,2);
end;

function alt:boolean;
var
	r:registers;

begin
	r.AH:=2;
	intr($16,r);
	alt:=TestBit(r.AL,3);
end;

procedure str(n:byte;width:integer;var s:string);ASSEMBLER;
ASM
	STD
	MOV			AL,n
	MOV			CX,width
	JCXZ		@EXIT

	LES			DI,s
	MOV			ES:[DI],CL
	ADD			DI,CX

@START:
	AAM
	ADD			AL,$30
	STOSB
	XCHG		AL,AH
	DEC			CX
	JNZ			@START

@EXIT:
END;

function ReadKey:char;
var
	c:char;

begin
	c:=CRT.ReadKey;
	SpecialKey:=c=OTRO_CODIGO;
	if SpecialKey then c:=CRT.ReadKey;
	ReadKey:=c;
end;

function MakeBrowse(xx,yy,ancho,alto,total:integer;v:Tventana;asterisco:boolean;var line:integer):integer;
var
	y,y1,barra,barra1,numero:integer;
	desde,hasta:integer;
	ventana:Tventana;
	vez:boolean;
	elemento,ElementoM:string[80];

	procedure calcula;
begin
	desde:=line;
	hasta:=(desde+ALTO)-2;
	barra:=desde;barra1:=barra;
	y:=1;y1:=y;
end;

	procedure listar;
var
	n,m,a:integer;

begin
	TextBackGround(v.ColorVentana);
	ClrScr;

	m:=hasta;
	if m>total then m:=total;
	a:=desde;
	if a<1 then
		begin
			a:=1;
			m:=ALTO;
			barra:=1;barra1:=barra;
			y:=1;y1:=y;
			desde:=a;hasta:=m;
		end;

	for n:=a to m do
		begin
			TextColor(BLANCO);
			if (browse^[n].marcado) and (asterisco) then
				begin
					system.write(n:3);
					TextColor(AMARILLO);
					write('*');
					TextColor(BLANCO);
				end
			else
				system.write(n:3,' ');

			system.write(browse^[n].elemento);
			if n<m then WriteLN;
		end;
end;

	procedure reverse;
var
	n:integer;
	s:string;

begin
	GotoXY(1,y1);
	TextBackGround(v.ColorVentana);
	TextColor(BLANCO);
	if (browse^[barra1].marcado) and (asterisco) then
		begin
			system.write(barra1:3);
			TextColor(AMARILLO);
			write('*');
			TextColor(BLANCO);
		end
	else
		system.write(barra1:3,' ');

	s:=browse^[barra1].elemento;
	system.write(s);
	n:=length(s);
	system.write(strings(ANCHO-n-6,VACIO));

	GotoXY(1,y);
	TextBackGround(VERDE_CLARO);
	TextColor(BLANCO);
	if (browse^[barra].marcado) and (asterisco) then
		begin
			system.write(barra:3);
			TextColor(AMARILLO);
			write('*');
			TextColor(BLANCO);
		end
	else
		system.write(barra:3,' ');

	s:=browse^[barra].elemento;
	system.write(s);
	n:=length(s);
	system.write(strings(ANCHO-n-6,VACIO));

	barra1:=barra;
	y1:=y;
end;

	procedure buscar;
var
	cadena:string;
	n:integer;
	encontrado:boolean;

begin
	ventana.titulo:=' BUSQUEDA ';
	ventana.CentrarTitulo:=AL_CENTRO;
	ventana.ColorVentana:=GRIS_CLARO;
	ventana.ColorMarco:=NEGRO;
	ventana.marco:=TipoMarco[3];
	ventana.posicion:=A_ARRIBA;
	ventana.x1:=8;ventana.x2:=72;
	ventana.y1:=11;ventana.y2:=14;
	AbrirVentana(ventana);

	cadena:='';
	TextColor(BLANCO);
	WriteLN('Cadena a buscar:');
	accept(1,WhereY,cadena,TRUE,FALSE,ALFANUMERICA,(ventana.x2-ventana.x1)-2,BLANCO,NEGRO);
	cursor(SIN_CURSOR);
	CerrarVentana;

	ElementoM:=cadena;
	elemento:=upper(cadena);
	if cadena>'' then
		begin
			vez:=FALSE;
			encontrado:=FALSE;
			for n:=1 to total do
				if pos(elemento,upper(browse^[n].elemento))>0 then
					begin
						vez:=TRUE;
						desde:=n;
						hasta:=(desde+ALTO)-1;
						barra:=desde;barra1:=barra;
						numero:=barra+1;
						y:=1;y1:=y;
						listar;
						reverse;
						GotoXY(4+pos(elemento,upper(browse^[n].elemento)),1);
						system.write(ElementoM);
						encontrado:=TRUE;
						break;
					end;
		end;
	if not encontrado then system.write(BEEP);
end;

	procedure otra;
var
	n:byte;
	encontrado:boolean;

begin
	numero:=barra+1;
	if vez then
		begin
			encontrado:=FALSE;
			for n:=numero to total do
				if pos(elemento,upper(browse^[n].elemento))>0 then
					begin
						desde:=n;
						hasta:=(desde+ALTO)-1;
						barra:=desde;barra1:=barra;
						numero:=barra+1;
						y:=1;y1:=1;
						listar;
						reverse;
						GotoXY(4+pos(elemento,upper(browse^[n].elemento)),1);
						system.write(ElementoM);
						encontrado:=TRUE;
						break;
					end;
		end;

	if not encontrado then system.write(BEEP);
end;

	procedure BuscaNumero;
var
	num,error,guarda:integer;
	cadena:string;
	r:char;
	sigue:boolean;

begin
	ventana.titulo:=' BUSQUEDA ';
	ventana.CentrarTitulo:=AL_CENTRO;
	ventana.ColorVentana:=GRIS_CLARO;
	ventana.marco:=TipoMarco[3];
	ventana.ColorMarco:=NEGRO;
	ventana.x1:=28;ventana.x2:=52;
	ventana.y1:=12;ventana.y2:=15;
	AbrirVentana(ventana);
	guarda:=desde;

	TextColor(BLANCO);
	repeat
		sigue:=FALSE;
		GotoXY(1,1);
		system.write(' Nmero de lnea: ');
		r:=accept(WhereX,WhereY,cadena,FALSE,FALSE,NUMERICA,3,BLANCO,NEGRO);
		val(cadena,num,error);
		if ((num<1) or (num>total) or (cadena='')) and (r<>ESCAPE) then
			system.write(BEEP)
		else
			sigue:=TRUE;
	until sigue;

	if (not sigue) or (r=ESCAPE) then num:=guarda;
	cursor(SIN_CURSOR);
	CerrarVentana;
	if error>0 then exit;

	desde:=num;
	hasta:=(desde+ALTO)-1;
	barra:=desde;barra1:=barra;
	numero:=barra+1;
	y:=1;y1:=1;
	listar;
	reverse;
end;

var
	tecla:char;

begin
	if total<1 then exit;

	cursor(SIN_CURSOR);
	calcula;

	ventana:=v;
	ventana.x1:=2;ventana.y1:=21;
	ventana.x2:=79;ventana.y2:=23;
	ventana.titulo:=' Opciones ';
	ventana.posicion:=A_ABAJO;
	ventana.CentrarTitulo:=AL_CENTRO;
	AbrirVentana(ventana);

	TextColor(AMARILLO);
	system.write('   ESC ');
	TextColor(BLANCO);
	system.write('Salir  ');

	TextColor(AMARILLO);
	system.write('SPACE ');
	TextColor(BLANCO);
	system.write('Buscar elemento  ');

	TextColor(AMARILLO);
	system.write('+ ');
	TextColor(BLANCO);
	system.write('Otra vez  ');

	TextColor(AMARILLO);
	system.write('TAB ');
	TextColor(BLANCO);
	system.write('Ir lnea ');

	if asterisco then
		begin
			TextColor(AMARILLO);
			system.write('INS ');
			TextColor(BLANCO);
			system.write('Marcar');
		end;
	ClrEOL;

	v.CentrarTitulo:=AL_CENTRO;
	if v.titulo='' then v.titulo:=' Browse ';
	v.posicion:=A_ARRIBA;
	v.x1:=xx;v.y1:=yy;
	v.x2:=xx+ancho;v.y2:=yy+alto;
	AbrirVentana(v);

	dec(alto);

	listar;
	reverse;

	repeat
		tecla:=ReadKey;

		if (SpecialKey) and (tecla=INS) then
			begin
				browse^[barra].marcado:=not browse^[barra].marcado;
				reverse;
				tecla:=ABAJO;
			end;

		if SpecialKey then
			case tecla of
				ARRIBA:if barra>1 then
					begin
						dec(y);
						if y<1 then
							begin
								y:=1;
								dec(desde);
								dec(hasta);
								listar;
							end;
						dec(barra);
						reverse;
					end;

				ABAJO:if barra<total then
					begin
						inc(y);
						if y>ALTO then
							begin
								y:=ALTO;
								inc(desde);
								inc(hasta);
								listar;
							end;
						inc(barra);
						reverse;
					end;

				AVANCE:if barra<total-ALTO then
					begin
						inc(barra,ALTO);
						barra1:=barra;
						inc(desde,ALTO);
						inc(hasta,ALTO);
						listar;
						reverse;
					end
				else if barra<>total then
					begin
						barra:=total;barra1:=barra;
						hasta:=total;
						desde:=(hasta-ALTO)+1;
						if desde<1 then desde:=1;
						y:=ALTO;
						if y>total then y:=total;
						y1:=y;

						listar;
						reverse;
					end;

				RETROCESO:if barra>ALTO then
					begin
						dec(barra,ALTO);
						barra1:=barra;
						dec(desde,ALTO);
						dec(hasta,ALTO);
						listar;
						reverse;
					end
				else if barra>1 then
					begin
						barra:=1;barra1:=barra;
						desde:=1;hasta:=ALTO;
						y:=1;y1:=y;
						listar;
						reverse;
					end;

				INICIO:if barra>1 then
					begin
						y:=1;
						hasta:=ALTO;
						if hasta>total then hasta:=total;
						desde:=1;
						listar;
						barra:=1;barra1:=barra;
						y1:=y;
						reverse;
					end;

				FIN:if barra<total then
					begin
						y:=ALTO;
						if y>total then y:=total;
						hasta:=total;
						desde:=(hasta-ALTO)+1;
						if desde<1 then desde:=1;
						listar;
						barra:=hasta;barra1:=barra;
						y1:=y;
						reverse;
					end;
			end
		else
			case tecla of
				TAB:BuscaNumero;
				MAS:otra;
				ESPACIO:buscar;
			end;
	until (tecla=ESCAPE) or (tecla=RETURN);

	CerrarVentana;
	CerrarVentana;
	cursor(CURSOR_NORMAL);

	line:=barra;
	if tecla=ESCAPE then
		MakeBrowse:=-1
	else
		MakeBrowse:=barra;
end;

function SearchString(var fuente;LongitudFuente:word;
											var destino;LongitudDestino:word;var puntero:word):boolean;ASSEMBLER;
ASM
	PUSH		DS
	LES			DI,destino
	LDS			SI,fuente

	MOV			DX,LongitudDestino

@COM:
		MOV			CX,LongitudFuente

		PUSH		SI

			REP		CMPSB

			TEST	CX,CX
			JNZ		@SIGUE

		POP			SI
		SUB			DI,LongitudFuente

		MOV			AL,TRUE
		JMP			@FIN

@SIGUE:
	POP			SI

	DEC			DX
	JNZ			@COM

	MOV			AL,FALSE

@FIN:
	POP			DS

	LES			SI,puntero
	SUB			DI,WORD(destino)
	INC			DI
	MOV			ES:[SI],DI
END;

procedure centrado(c:string;t:integer);
begin
	write(strings((t div 2)-(length(c) div 2),' '),c);
end;

procedure ScrollUp(x1,y1,x2,y2,at:byte);ASSEMBLER;
ASM
	MOV		AX,$601

	MOV		BH,at

	MOV		CL,x1
	MOV		CH,y1

	MOV		DL,x2
	MOV   DH,y2

	INT		$10
END;

procedure ScrollDown(x1,y1,x2,y2,at:byte);ASSEMBLER;
ASM
	MOV		AX,$701

	MOV		BH,at

	MOV		CL,x1
	MOV		CH,y1

	MOV		DL,x2
	MOV   DH,y2

	INT		$10
END;

end.