unit colors;

INTERFACE

type
	TRGB=record
		red,green,blue:0..63;
	end;
	TPal=array[0..255] of TRGB;
	PPal=^TPal;

const
	white:TRGB=(red:63;green:63;blue:63);
	black:TRGB=(red:0;green:0;blue:0);
	yellow:TRGB=(red:63;green:63;blue:0);
	pink:TRGB=(red:63;green:0;blue:63);
	red:TRGB=(red:63;green:0;blue:0);
	blue:TRGB=(red:0;green:0;blue:63);
	green:TRGB=(red:0;green:63;blue:0);
	cyan:TRGB=(red:0;green:63;blue:63);
	brown:TRGB=(red:48;green:31;blue:19);

	PColors:boolean=FALSE;PFrom:integer=0;PTo:integer=0;PTPal:^TPal=NIL;

	steps:integer=64;

procedure border(color:byte);
{cambia el color del borde en cualquier modo}

procedure ink(numero,color:byte);
{cambia el color de una pluma NUMERO por otra COLOR}

procedure InkRGB(numero:byte;var colores:TRGB);
{cambia la intensidad TRGB de del color}

procedure GetRGB(numero:byte;var colores:TRGB);
{devuelve la intensidad TRGB del color}

procedure DifumineToColor(desde,hasta:byte;var color:TRGB);
{difumina los colores hasta color}

procedure DifumineToPalette(desde,hasta:integer;var nueva:TPal);
{difumina los colores actuales hasta cambiarlos a nueva}

procedure InkAllBlue(desde,hasta:byte;var colores,c:TPal);
{difumina los colores actuales hasta cambiarlos a blues}

procedure InkAllGreen(desde,hasta:byte;var colores,c:TPal);
{difumina los colores actuales hasta cambiarlos a greens}

procedure InkAllRed(desde,hasta:byte;var colores,c:TPal);
{difumina los colores actuales hasta cambiarlos a reds}

procedure InkAllOrange(desde,hasta:byte;var colores,c:TPal);
{difumina los colores actuales hasta cambiarlos a naranjas}

procedure InkAllYellow(desde,hasta:byte;var colores,c:TPal);

procedure InkAllGray(desde,hasta:byte;var colores,c:TPal);
{difumina los colores actuales hasta cambiarlos a grises}

procedure InkAllRGB(desde,hasta:integer;var nueva:TPal);
{cambia la intensidad TRGB de TPal desde PRIMERO A ULTIMO en
VALORES es un puntero a una tabla de 3 bytes de cada color en TRGB}

procedure SetColors;

procedure GetAllRGB(desde,hasta:integer;var nueva:TPal);
{Devuelve la intensidad TRGB de TPal desde PRIMERO A ULTIMO en
VALORES es un puntero a una tabla de 3 bytes de cada color en TRGB}

procedure MakeGrayScale(desde,hasta:byte);
{Hace una escala de grises}

procedure MakeInverseGrayScale(desde,hasta:byte);

function LoadPal(var p:TPal;n:string):boolean;

function GetNearColor(var color:TRGB;var paleta:TPal):byte;

procedure WhitePal;
procedure BlackPal;
procedure GetPal(var p:TPal;desde,hasta:integer;color:tRGB);
procedure ramp(s:integer;var c1:TRGB;e:integer;var c2:TRGB;var pal:TPal);
procedure HSI2RGB(H,S,I:double;var c:TRGB);
{Convert (Hue, Saturation, Intensity) -> (RGB)}

IMPLEMENTATION

uses
	Mode13,MyDOS,speed,
{$IFDEF _LZ_}
	LzFiles
{$ELSE}
	{$IFDEF _RLE_}
	RLEFiles
	{$ELSE}
	files
{$ENDIF}
{$ENDIF}

{$IFDEF _SYNCRO_}
	,MyMidas
{$ENDIF}
;

procedure border(color:byte);ASSEMBLER;
ASM
{	MOV		AX,$1001
	MOV		BH,color
	INT		$10}
	MOV		DX,$3C0
	MOV		AL,$31
	OUT		DX,AL
	MOV		AL,color
	OUT		DX,AL
END;

procedure ink(numero,color:byte);
var
	valor:TRGB;

begin
	GetRGB(color,valor);
	InkRGB(numero,valor);
end;

procedure InkRGB(numero:byte;var colores:TRGB);ASSEMBLER;
ASM
	LES			SI,colores

	MOV			DX,$3C8
	MOV			AL,numero
	OUT			DX,AL
	INC			DX

	MOV			AL,ES:TRGB[SI].red
	OUT			DX,AL
	MOV			AL,ES:TRGB[SI].green
	OUT			DX,AL
	MOV			AL,ES:TRGB[SI].blue
	OUT			DX,AL
END;

procedure GetRGB(numero:byte;var colores:TRGB);ASSEMBLER;
ASM
	LES			DI,colores

	MOV			DX,$3C7
	MOV			AL,numero
	OUT			DX,AL
	ADD			DX,2

	IN			AL,DX
	MOV			ES:TRGB[DI].red,AL
	IN			AL,DX
	MOV			ES:TRGB[DI].green,AL
	IN			AL,DX
	MOV			ES:TRGB[DI].blue,AL
END;

procedure DifumineToColor(desde,hasta:byte;var color:TRGB);
var
	nueva:TPal;
	n:byte;

begin
	for n:=desde to hasta do nueva[n]:=color;
	DifumineToPalette(desde,hasta,nueva);
end;

procedure DifumineToPalette(desde,hasta:integer;var nueva:TPal);
var
	vieja,WorkPalette:TPal;
	CrossFade,counter:word;

begin
	GetAllRGB(desde,hasta,vieja);

	for CrossFade:=0 to steps do
		begin
			for counter:=desde to hasta do with WorkPalette[counter] do
				begin
					red:=((vieja[counter].red*(steps-CrossFade))+
								(nueva[counter].red*CrossFade)) div steps;

					green:=((vieja[counter].green*(steps-CrossFade))+
									(nueva[counter].green*CrossFade)) div steps;

					blue:=((vieja[counter].blue*(steps-CrossFade))+
								 (nueva[counter].blue*CrossFade)) div steps;
				end;

			InkAllRGB(desde,hasta,WorkPalette);
			frame;
		end;
end;

procedure InkAllBlue(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			c[n].red:=PorCiento(red,30);
			c[n].green:=PorCiento(green,11);
			c[n].blue:=PorCiento(blue,59);
		end;
end;

procedure InkAllGreen(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			c[n].red:=PorCiento(red,30);
			c[n].green:=PorCiento(green,59);
			c[n].blue:=PorCiento(blue,11);
		end;
end;

procedure InkAllRed(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			c[n].red:=PorCiento(red,59);
			c[n].green:=PorCiento(green,11);
			c[n].blue:=PorCiento(blue,30);
		end;
end;

procedure InkAllOrange(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			c[n].red:=PorCiento(red,59);
			c[n].green:=PorCiento(green,30);
			c[n].blue:=PorCiento(blue,11);
		end;
end;

procedure InkAllYellow(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			c[n].red:=PorCiento(red,100);
			c[n].green:=PorCiento(green,100);
			c[n].blue:=PorCiento(blue,0);
		end;
end;

procedure InkAllGray(desde,hasta:byte;var colores,c:TPal);
var
	n:integer;
	mezcla:byte;

begin
	for n:=desde to hasta do with colores[n] do
		begin
			mezcla:=PorCiento(red,30)+PorCiento(green,11)+PorCiento(blue,59);
			c[n].red:=mezcla;
			c[n].green:=mezcla;
			c[n].blue:=mezcla;
		end;
end;

procedure InkAllRGB(desde,hasta:integer;var nueva:TPal);
begin
	Pcolors:=TRUE;
	Pfrom:=desde;Pto:=hasta;
	PTPal:=@nueva;
end;

procedure SetColors;ASSEMBLER;
ASM
	PUSH		DS

	MOV			AX,Pfrom
	MOV			CX,Pto

	LDS			SI,PTPal
	MOV			DX,$3C8

	OUT			DX,AL
	INC			DX

	SUB			CX,AX
	INC			CX

	MOV			BX,AX		{*3}
	ADD			AX,AX
	ADD			AX,BX
	ADD			SI,AX   {SI=nueva[desde]}

	MOV			BX,CX
	ADD			CX,CX
	ADD			CX,BX		{CX=(hasta-desde)*3}

	{$IFNDEF DAC}
	CLD
	REP			OUTSB
	{$ELSE}
@BUCLE:
	MOV 		AL,[SI]
	INC			SI
	OUT			DX,AL
	DEC			CX
	JNZ			@BUCLE
	{$ENDIF}

	POP			DS
END;

procedure GetAllRGB(desde,hasta:integer;var nueva:TPal);ASSEMBLER;
ASM
	LES			DI,nueva

	MOV			DX,$3C7

	MOV			AX,desde
	OUT			DX,AL
	INC			DX
	INC			DX

	MOV			CX,hasta
	SUB			CX,AX
	INC			CX

	MOV			BX,AX     {*3}
	ADD			AX,AX
	ADD			AX,BX
	ADD			DI,AX     {DI=nueva[desde]}

	MOV			BX,CX
	ADD			CX,CX
	ADD			CX,BX			{CX=(hasta-desde)*3}

	{$IFNDEF DAC}
	CLD
	REP			INSB
	{$ELSE}
@BUCLE:
	IN			AL,DX
	MOV 		ES:[DI],AL
	INC			DI
	DEC			CX
	JNZ			@BUCLE
	{$ENDIF}
END;

procedure MakeGrayScale(desde,hasta:byte);
var
	colores:TPal;
	a,n,pasos:integer;
	m,mi:double;
	nueva:TRGB;

begin
	mi:=63/(hasta-desde);
	m:=0;

	for n:=desde to hasta do
		begin
			with nueva do
				begin
					a:=round(m);
					red:=a;green:=a;blue:=a;
				end;
			colores[n]:=nueva;

			m:=m+mi;
		end;

	InkAllRGB(desde,hasta,colores);
	frame;
end;

procedure MakeInverseGrayScale(desde,hasta:byte);
var
	colores:TPal;
	a,n,pasos:integer;
	m,mi:double;
	nueva:TRGB;

begin
	mi:=63/(hasta-desde);
	m:=63;

	for n:=desde to hasta do
		begin
			with nueva do
				begin
					a:=round(m);
					red:=a;green:=a;blue:=a;
				end;
			colores[n]:=nueva;

			m:=m-mi;
		end;

	InkAllRGB(desde,hasta,colores);
	frame;
end;

function LoadPal(var p:TPal;n:string):boolean;
var
	f:Tfile;
	l:word;
	magic:array[0..2] of char;

begin
	LoadPal:=FALSE;

	if pos('.',n)=0 then n:=n+'.RGB';
	if open(f,n,RO)>0 then exit;

	read(f,magic,SizeOf(magic),l);
	if magic<>'PAL' then
		begin
			close(f);
			exit;
		end;

	read(f,p,SIzeOf(p),l);
	close(f);
	LoadPal:=TRUE;
end;

function GetNearColor(var color:tRGB;var paleta:TPal):byte;
var
	c,SelCol,
	r,g,b:byte;
	inter,suma:LongInt;

begin
	inter:=MaxLongInt;
	for c:=0 to 255 do with paleta[c] do
		begin
			r:=abs(color.red-red);
			g:=abs(color.green-green);
			b:=abs(color.blue-blue);
			suma:=sqr(r)+sqr(g)+sqr(b);

			if suma<inter then
				begin
					inter:=suma;
					SelCol:=c;
				end;
		end;
	GetNearColor:=SelCol;
end;

procedure WhitePal;
var
	wp:TPal;

begin
	FillChar(wp,SizeOf(wp),63);
	InkAllRGB(0,255,wp);
	frame;
end;

procedure BlackPal;
var
	bp:TPal;

begin
	FillChar(bp,SizeOf(bp),0);
	InkAllRGB(0,255,bp);
	frame;
end;

procedure GetPal(var p:TPal;desde,hasta:integer;color:tRGB);
var
	n:integer;

begin
	for n:=desde to hasta do p[n]:=color;
end;

procedure ramp(s:integer;var c1:TRGB;e:integer;var c2:TRGB;var pal:TPal);
var
	i:integer;
	r,g,b:double;

begin
	r:=(c2.red-c1.red)/(e-s);
	g:=(c2.green-c1.green)/(e-s);
	b:=(c2.blue-c1.blue)/(e-s);
	for i:=s to e do
		begin
			pal[i].red:=c1.red+round(r*(i-s));
			pal[i].green:=c1.green+round(g*(i-s));
			pal[i].blue:=c1.blue+round(b*(i-s));
		end;
end;

procedure HSI2RGB(H,S,I:double;var c:TRGB);
var
	Rv,Gv,Bv,
	T:double;

begin
	T:=H;
	Rv:=1+S*Sin(T-2*Pi/3);
	Gv:=1+S*Sin(T);
	Bv:=1+S*Sin(T+2*Pi/3);
	T:=63.999*I/2;
	with c do
		begin
			red:=trunc(Rv*T);	{round?{}
			green:=trunc(Gv*T);
			blue:=trunc(Bv*T);
		end;
end;

end.