{To do: 3d clipping, fast triangles, 32-bit engine, shadows, camera.where.XYZ...}

unit Engine3D;

INTERFACE

uses matrix,vector,colors;

const
	DADDY=0;
	ALL_CHILDS=-1;

	MAX_VERTEX=2500;
	MAX_FACES=4000;
	MAX_FACES_IN_SCENE=2950;

	MAX_LIGHTS=3;

type
	TSegment=array[0..254,0..256] of byte;{}
	PTexture=^TSegment;
	PMapLight=^TSegment;
	PTransparency=^TSegment;
	PBump=^TSegment;

	TRender=(_POINT_,_WIRE_,_FLAT_,_GOURAUD_,
					 _ENVMAP_,_TEXTURE_,_TEXTURE_FLAT_,_TEXTURE_GOURAUD_,_TEXTURE_ENVMAP_,
					 _PERSPECTIVE_ENVMAP_,_PERSPECTIVE_TEXTURE_,
					 _FLAT_TRANSPARENT_,_GOURAUD_TRANSPARENT_,
					 _TEXTURE_TRANSPARENT_,_ENVMAP_TRANSPARENT_,
					 _DOUBLE_ENVMAP_,
					 _PERSPECTIVE_TRANSPARENT_ENVMAP_,_PERSPECTIVE_TRANSPARENT_TEXTURE_
					);

	TFocus=(_FOCUS_,_DIRECT_);

	TSort=(_NO_SORT_,_QSORT_,_RADIX_,_ZBUFFER_);

	TTriangle=record
		x1,y1,z1,
		x2,y2,z2,
		x3,y3,z3:integer;
		u1,v1,
		u2,v2,
		u3,v3:double;
		texture,EnvMap:PTexture;
		MapLight:PMapLight;
		transparency:PTransparency;
	end;

	TAngles=record
		balanza,caida,deriva:double;
	end;

	PCamera=^TCamera;
	TCamera=record
		ZClipMin,ZClipMax:double;
		from:TVector;
		where:TAngles;
	end;

	PLight=^TLight;
	TLight=record
		from,where:TVector;
	end;

	PVertex=^TVertex;
	TVertex=record
		x,y,z,
		nx,ny,nz:LongInt;
		u,v:byte;
	end;
	TAVertex=array[0..MAX_VERTEX] of TVertex;
	PAVertex=^TAVertex;

	PFaces=^TFaces;
	TFaces=record
		texture:pointer;
		v1,v2,v3:word;
		nada:array[1..6] of byte;{}
	end;
	TAFaces=array[0..MAX_FACES] of TFaces;
	PAFaces=^TAFaces;

	PScreen=^TScreen;
	TScreen=record
		u,v,
		light:byte;
		xs,ys,
		tx,ty:integer;
		z:LongInt;
	end;
	TAScreen=array[0..MAX_FACES] of TScreen;
	PAScreen=^TAScreen;

	P3D=^T3D;
	T3D=record
		TotalObjects,           {Numbers of objects}
		TotalVertex,TotalFaces,	{Vertex and faces in ALL_CHILDS objects}
		vertex,faces:word;    	{Vertex and faces of the current object}

		MINX,MINY,MINZ,         {For clipping...}
		MAXX,MAXY,MAXZ:double;

		angle:TAngles;          {Angles of the current object}
		world,									{World coordinates of the current object}
		axis:TVector;   				{Return values of rotations}
		sx,sy:integer;    			{Return 2D coordinates after rotating and projecting}

		MapLight:PMapLight;   	{Map for _TEXTURE_FLAT_, _TEXTURE_GOURAUD_, TEXTURE_ENVMAP_,_DOUBLE_ENVMAP_ _FLAT_TRANSPARENCY_}
		EnvMap:PTexture;        {Texture for _TEXTURE_ENVMAP_}
		TransMap:PTransparency; {Map for _FLAT_TRANSPARENCY_}

		UnColor:integer;        {-1 normal, 0..255 unique color for the current object}
		ForceVisible,           {Force a face to be visible (no normal test)}
		contour:boolean;				{For trace a contour around every triangle}
		RenderType:TRender;     {Type of render}

		PVertex:PAVertex;       {Vertex array}
		PFaces:PAFaces;         {Faces array}
		PScreen:PAScreen;     	{Final screen array}

		child:P3D;         			{Pointer to the next child, NIL=no more childs}
	end;

	PLights=^TLights;
	TLights=record
		active:boolean;
		light:TVector;
		LType:TFocus;
	end;

	PBuffer=^TBuffer;
	TBuffer=record
		zCenter,
		z1,z2,z3:LongInt;       {Z's of the triangle}
		vertex:integer;         {Num vertex of the object}
		obj:P3D;                {Pointer to the object}
	end;
	TABuffer=array[0..MAX_FACES_IN_SCENE] of TBuffer;

	PScene=^TScene;
	TScene=record
		buffer:^TABuffer;
		TotalFaces,faces:integer;
		DistanceFromEye,
		AmbientLight:double;
		sort:TSort;
		camera:TCamera;
		lights:array[0..MAX_LIGHTS] of TLights;
	end;

	PWorld=^TWorld;
	TWorld=record
		total:integer;
		camera:TCamera;
		obj:P3D;
		next:PWorld;
	end;

{$IFDEF _DEBUG_}
var
	f:text;
{$ENDIF}

function NewScene(var s:TScene;f:integer):boolean;
{Inicializa una escena con N caras de mximo}
procedure FreeScene(var s:Tscene);
{acaba una escena}
procedure SetSceneSort(var s:TScene;t:TSort);
{Devuelve el tipo de ordenacin de la escena}
function GetSceneSort(var s:TScene):TSort;
{POne el tipo de ordenacin de la escena}
function RenderScene(var s:TScene):integer;
{Renderiza la scena}
procedure ResetScene(var s:TScene);

function Put3D(var s:TScene;o:P3D;n:integer):boolean;
{Pone el objeto N en la escena S}
function PutAll3D(var s:TScene;o:P3D):boolean;
{Pone todos los objetos en la escena S}
procedure Rotate3D(o:P3D;a:integer;caida,balanza,deriva:double);
{Rota un objeto}
procedure Move3D(o:P3D;a:integer;ix,iy,iz:double);
{Mueve un objeto en incrementos}
procedure Set3DPos(o:P3D;a:integer;x,y,z:double);
{Posiciona un objeto}
procedure Set3DAngle(o:P3D;a:integer;balanza,deriva,caida:double);
{Pone los ngulos a un objeto}
function FaceVisible(var t:TTriangle):boolean;
{Devuelve true si una cara es visible}
function TriangleOutside(var t:TTriangle):boolean;
{Devuelve true si un tringulo est fuera de la pantalla}
function collision(o1,o2:P3D):boolean;
{Devuelve si 2 objetos an colisionado}

procedure SetCamera(var s:TScene;var c:TCamera);
{Posiciona la camara}
procedure ResetCamera(var camera:TCamera);
{Posiciona la camara en su posicin original}
procedure RotateCamera(var camera:TCamera;caida,balanza,deriva:double);
procedure MoveCamera(var camera:TCamera;x,y,z:double);
procedure SetCameraPos(var camera:TCamera;x,y,z:double);
procedure SetCameraClip(var camera:TCamera;zMin,zMax:double);

procedure PrecalculateVertex(var s:TScene;o:P3D);
{Precalcula los valores de seno, coseno y caida del objeto o en la escena s}
procedure RotateVertex(var s:TScene;o:P3D;v:PVertex);
{Devuelve en SX y SY las coordenadas rotadas del objeto o en la escena s}
procedure RotateNormals(v:PVertex;var normals:TVector);
{Rota las normales del objeto o}

procedure SetRenderType(o:P3D;n:integer;r:TRender);
{Cambia el mtodo de render para el objeto n, ALL_CHILDS para todos}
function GetRenderType(o:P3D;n:integer):TRender;
{Devuelve el mtodo de render de Put3DObject}
procedure SetUnColor(o:P3D;a,n:integer);
{Pone todo el objeto a un slo color si <>-1}
procedure SetVisible(o:P3D;a:integer;b:boolean);
{Fuerza a que todas las caras sean visibles}
procedure SetContour(o:P3D;a:integer;b:boolean);
{Activa el modo wire con cualquier otro}

function Load3D(var o:P3D;nombre:string):boolean;
{Lee el fichero nombre y lo mete en el objeto o, si FALSE, error de fichero}
procedure Free3D(var o:P3D);
{Libera la memoria ocupada por el objeto}
procedure Reset3D(o:P3D;n:integer);
{Pone por defecto las coordenadas y los ngulos del objeto}
function MakeClone3D(f:P3D;var d:P3D):boolean;
{Hace que los datos de f estn en la misma zona de memoria de d}
procedure FreeClone3D(var o:P3D);
{Libera el clone o}
procedure ScaleCoordinates(o:P3D;n:integer;scale:double);
procedure UnScaleCoordinates(o:P3D;n:integer;scale:double);
{Escala un objeto}
procedure ScaleMapping(o:P3D;n:integer;scale:double);
procedure UnScaleMapping(o:P3D;n:integer;scale:double);
{Escala el mapeado de texturas}

function LoadTexture(n:string;var t:PTexture;var p:Tpal):boolean;
{Carga una textura y devuelve un puntero a ella}
function SaveTexture(n:string;t:PTexture;var p:Tpal):boolean;
{Salva una texture}
procedure FreeTexture(var t:PTexture);
{Libera el puntero}
procedure SetTexture(o:P3D;n:integer;t:PTexture);
{Le asigna al objeto N la texture t}
procedure SetEnvMap(o:P3D;n:integer;t:PTexture);
{Asigna el envmap t, para _TEXTURE_ENVMAP_}
procedure SetEnvmapCenter(x,y:integer);

function LoadMapLight(var l:PMapLight;n:string):boolean;
{Carga e inicializa un mapa de luces para texturas}
procedure FreeMapLight(var l:PMapLight);
{Libera el mapa de luz}
procedure SetMapLight(o:P3D;a:integer;l:PMapLight);
{Carga en el objeto o el fichero n de luz}

procedure SetTransparency(o:P3D;a:integer;t:Ptransparency);
{Asigna la transparency t}

function NewLight(var s:TScene;l:TFocus):integer;
{Inicializa un nuevo foco}
procedure SetLight(var s:TScene;h:integer;var l:TLight);
{Pone un foco de luz para polgonos gouraud y texture gouraud}
procedure SetLightWhere(var l:TLight;x,y,z:double);
procedure SetLightFrom(var l:TLight;x,y,z:double);
procedure FreeLight(var s:TScene;h:integer);
{libera el foco h}
procedure ResetLights(var s:TScene);
{Borra todas las luces}

function LoadWorld(var w:PWorld;n:string):boolean;
procedure MakeWorld(var s:TScene;w:PWorld);
function Get3DOfWorld(w:PWorld;n:integer):P3D;

IMPLEMENTATION

uses math,OP386,mem,speed,Mode13,triangles,
{$IFDEF _LZ_}
	LZFiles;
{$ELSE}
	{$IFDEF _RLE_}
	RLEFiles;
	{$ELSE}
	files;
{$ENDIF}
{$ENDIF}

const
	TEXTURE_CENTER=127;       {Center of 256x256 textures}
	VERTEX_OUTSIDE=-32767;   	{Vertex outside of screen}

var
	TCenterX,TCenterY:integer;
	PB:PBuffer;
	RotationMatrix,CameraMatrix:TMatrix;

function FindChild(o:P3D;n:integer):P3D;
var
	m:integer;

begin
	for m:=0 to n-1 do o:=o^.child;
	FindChild:=o;
end;

function NextChild(o:P3D):P3D;
begin
	if o^.child<>NIL then
		NextChild:=o^.child
	else
		NextChild:=NIL;
end;

var
	tmp:TScene;

procedure QSort(l,r:integer);{}
var
	_DI:word;
	i,j:integer;
	m,zi,zj:LongInt;

begin
	i:=l;j:=r;
	m:=tmp.buffer^[(i+j) div 2].zCenter;

	repeat
		ASM
			LEA		SI,tmp
			LES		DI,TScene[SI].buffer
			MOV		_DI,DI

			MOV		BX,i
			MOV		AX,BX
			IMUL	BX,BX,TYPE(TBuffer)
			ADD		DI,BX
			DB		_386;MOV		DX,WORD(m)

@WI:
			INC		AX
			DB		_386;MOV 		CX,WORD(ES:TBuffer[DI].zCenter)
			ADD		DI,TYPE(TBuffer)
			DB		_386;CMP		CX,DX
			JG		@WI
			DEC		AX
			MOV		i,AX
			DB		_386;MOV		WORD(zi),CX
{		zi:=tmp.data^[i].zm;
		while zi>xx do
			begin
				inc(i);
				zi:=tmp.data^[i].zm;
			end;}

			MOV		DI,_DI
			MOV		BX,j
			MOV		AX,BX
			IMUL	BX,BX,TYPE(TBuffer)
			ADD		DI,BX
			DB		_386;MOV		DX,WORD(m)

@WJ:
			DEC		AX
			DB		_386;MOV 		CX,WORD(ES:TBuffer[DI].zCenter)
			SUB		DI,TYPE(TBuffer)
			DB		_386;CMP		DX,CX
			JG		@WJ
			INC		AX
			MOV		j,AX
			DB		_386;MOV		WORD(zj),CX
		END;
{		zj:=tmp.data^[j].zm;
		while xx>zj do
			begin
				dec(j);
				zj:=tmp.data^[j].zm;
			end;}

		if i<=j then
			begin
				if zi<>zj then with tmp do
{					begin
						move(buffer^[i],xchg,SizeOf(TBuffer));
						move(buffer^[j],buffer^[i],SizeOf(TBuffer));
						move(xchg,buffer^[j],SizeOf(TBuffer));
					end;}
					ASM
						LEA		SI,tmp

						MOV		BX,i
						LES		DI,TScene[SI].buffer
						MOV		SI,DI
						IMUL	BX,BX,TYPE(TBuffer)
						ADD		DI,BX

						MOV		BX,j
						IMUL	BX,BX,TYPE(TBuffer)
						ADD		SI,BX

						MOV		CX,TYPE(TBuffer)
@BUCLE:
						MOV		AL,ES:[DI]
						MOV		AH,ES:[SI]
						MOV		ES:[SI],AL
						MOV		ES:[DI],AH

						INC		DI
						INC		SI
						DEC		CX
						JNZ		@BUCLE
					END;

				inc(i);
				dec(j);
			end;
	until i>j;

	if l<j then QSort(l,j);
	if i<r then QSort(i,r);
end;

procedure SceneQSort(var scene:TScene);
begin
	tmp.buffer:=scene.buffer;
	QSort(0,scene.faces-1);
end;

function NewScene(var s:TScene;f:integer):boolean;
begin
	NewScene:=FALSE;
	if not GetMem(s.buffer,f*SizeOf(TBuffer)) then exit;
	s.TotalFaces:=f;
	ResetScene(s);
	ResetLights(s);
	NewScene:=TRUE;
end;

procedure FreeScene(var s:TScene);
begin
	FreeMem(s.buffer,s.TotalFaces*SizeOf(TBuffer));
end;

procedure SetSceneSort(var s:TScene;t:TSort);
begin
	s.sort:=t;
end;

function GetSceneSort(var s:TScene):TSort;
begin
	GetSceneSort:=s.sort;
end;

procedure ResetScene(var s:TScene);
begin
	FillChar(s.buffer^,s.TotalFaces*SizeOf(TBuffer),0);
	s.faces:=0;
	s.sort:=_QSORT_;
	s.AmbientLight:=80;
	s.DistanceFromEye:=512;
end;

function FaceVisible(var t:TTriangle):boolean;ASSEMBLER;
ASM
	LES			SI,t
	MOV			AX,ES:TTriangle[SI].x2             {ESI=LongInt(x2-x1)*LongInt(y3-y1)-}
	SUB			AX,ES:TTriangle[SI].x1
	DW			CWDE
	MOV			DX,ES:TTriangle[SI].y3
	SUB			DX,ES:TTriangle[SI].y1
	DD			MOVSX_EDX_DX
	DB			_386;IMUL		DX
	DB			_386;MOV		DI,AX

	MOV			AX,ES:TTriangle[SI].y2             {EAX=LongInt(y2-y1)*LongInt(x3-x1)}
	SUB			AX,ES:TTriangle[SI].y1
	DW			CWDE
	MOV			DX,ES:TTriangle[SI].x3
	SUB			DX,ES:TTriangle[SI].x1
	DD			MOVSX_EDX_DX
	DB			_386;IMUL		DX
	DB			_386;SUB		DI,AX									 {IsFaceVisible:=ESI-EAX<0;}

	DB			$0F,$9C,$C0												 {SETL AL}
END;

function TriangleOutside(var t:TTriangle):boolean;ASSEMBLER;
var
	result:boolean;

ASM
	MOV		result,FALSE
	LES		DI,t

	MOV		AX,ES:TTriangle[DI].x1
	MOV		BX,ES:TTriangle[DI].x2
	MOV		CX,ES:TTriangle[DI].x3

	MOV		DX,ES:TTriangle[DI].y1
	MOV		SI,ES:TTriangle[DI].y2
	MOV		DI,ES:TTriangle[DI].y3

	CMP		AX,XMAX
	JLE		@NEXTX
	CMP		BX,XMAX
	JLE		@NEXTX
	CMP		CX,XMAX
	JLE		@NEXTX
	MOV		result,TRUE		{if (t.x1>XMAX) and (t.x2>XMAX) and (t.x3>XMAX) then}
	JMP		@FIN

@NEXTX:
	TEST	AX,AX
	JGE		@Y
	TEST	BX,BX
	JGE		@Y
	TEST	CX,CX
	JGE		@Y
	MOV		result,TRUE   {if (t.x1<0) and (t.x2<0) and (t.x3<0) then}
	JMP		@FIN

@Y:
	CMP		DX,YMAX
	JLE		@NEXTY
	CMP		SI,YMAX
	JLE		@NEXTY
	CMP		DI,YMAX
	JLE		@NEXTY
	MOV		result,TRUE		{if (t.y1>YMAX) and (t.y2>YMAX) and (t.y3>YMAX) then}
	JMP		@FIN

@NEXTY:
	TEST	DX,DX
	JGE		@EQUAL
	TEST	SI,SI
	JGE		@EQUAL
	TEST	DI,DI
	JGE		@EQUAL
	MOV		result,TRUE		{if (t.y1<0) and (t.y2<0) and (t.y3<0) then}
	JMP		@FIN

@EQUAL:
	CMP   DX,SI
	JNZ		@FIN
	CMP		SI,DI
	JNZ		@FIN
	MOV		result,TRUE   {if (t.y1=t.y2) and (t.y2=t.y3) then}

@FIN:
	MOV		AL,result
END;

function AddObjectToScene(var scene:TScene;o:P3D):boolean;
label cont;

var
	n,NumFaces,ActualFaces:integer;
	PB:PBuffer;
	PF:PFaces;
	PS:PaScreen;
	t:TTriangle;
	visible:boolean;

begin
	AddObjectToScene:=FALSE;

	with o^ do
		begin
			ActualFaces:=scene.faces;
			NumFaces:=faces-1;
			if word(ActualFaces+NumFaces)>MAX_FACES_IN_SCENE then exit;

			PB:=@scene.buffer^[ActualFaces];
			PF:=@PFaces^;
			PS:=@PScreen^;

			visible:=ForceVisible;
		end;
	for n:=0 to NumFaces do
		begin
			 with PS^[PF^.v1] do
				 begin
					 t.x1:=xs;
					 if t.x1=VERTEX_OUTSIDE then goto cont;
					 t.y1:=ys;
					 PB^.z1:=z;
				 end;
			 with PS^[PF^.v2] do
				 begin
					 t.x2:=xs;
					 if t.x2=VERTEX_OUTSIDE then goto cont;
					 t.y2:=ys;
					 PB^.z2:=z;
				 end;
			 with PS^[PF^.v3] do
				 begin
					 t.x3:=xs;
					 if t.x3=VERTEX_OUTSIDE then goto cont;
					 t.y3:=ys;
					 PB^.z3:=z;
				 end;

			if (TriangleOutside(t)) or ((not visible) and (not FaceVisible(t))) then goto cont;

			with PB^ do
				begin
					obj:=o;
					vertex:=n;
					zCenter:=sqr(z1)+sqr(z2)+sqr(z3);
				end;
			inc(PB);
			inc(ActualFaces);

cont:
			inc(PF);
		end;

	inc(scene.faces,ActualFaces-scene.faces);
	AddObjectToScene:=TRUE;
end;

function RenderPoint(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	RenderPoint:=TRUE;
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			if UnColor<>-1 then
				begin
					plot(x1,y1,UnColor);
					plot(x2,y2,UnColor);
					plot(x3,y3,UnColor);
				end
			else
				begin
					plot(x1,y1,l1);
					plot(x2,y2,l2);
					plot(x3,y3,l3);
				end;
		end;
end;

function RenderWire(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	RenderWire:=TRUE;
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			if UnColor<>-1 then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end
			else
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,l1);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,l2);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,l3);
				end;
		end;
end;

function RenderFlat(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	c,l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			if UnColor<>-1 then
				c:=UnColor
			else
				c:=(l1+l2+l3) div 3;

			RenderFlat:=triangle(	x1,y1,
														x2,y2,
														x3,y3,
														c);
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;

end;

function RenderGouraud(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			RenderGouraud:=TriangleGouraud(	x1,y1,l1,
																			x2,y2,l2,
																			x3,y3,l3);
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderTexture(o:P3D;v:integer):boolean;FAR;
var
	tx1,ty1,
	tx2,ty2,
	tx3,ty3,
	x1,y1,
	x2,y2,
	x3,y3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					tx1:=tx;ty1:=ty;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					tx2:=tx;ty2:=ty;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					tx3:=tx;ty3:=ty;
				end;

			RenderTexture:=TextureTriangle(	y1,x1,ty1,tx1,
																			y2,x2,ty2,tx2,
																			y3,x3,ty3,tx3,
																			seg(texture^));
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderTextureCorrected(o:P3D;v:integer):boolean;FAR;
var
	t:TTriangle;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					t.x1:=xs;t.y1:=ys;
					t.u1:=tx;t.v1:=ty;
					t.z1:=PB^.z1;
				end;
			with PScreen^[v2] do
				begin
					t.x2:=xs;t.y2:=ys;
					t.u2:=tx;t.v2:=ty;
					t.z2:=PB^.z2;
				end;
			with PScreen^[v3] do
				begin
					t.x3:=xs;t.y3:=ys;
					t.u3:=tx;t.v3:=ty;
					t.z3:=PB^.z3;
				end;
			t.texture:=texture;

			RenderTextureCorrected:=TexturePerspectiveTriangle(t);
			if contour then
				begin
					if Clip2D(t.x1,t.y1,t.x2,t.y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(t.x2,t.y2,t.x3,t.y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(t.x3,t.y3,t.x1,t.y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderTextureCorrectedTransparent(o:P3D;v:integer):boolean;FAR;
var
	t:TTriangle;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					t.x1:=xs;t.y1:=ys;
					t.u1:=tx;t.v1:=ty;
					t.z1:=PB^.z1;
				end;
			with PScreen^[v2] do
				begin
					t.x2:=xs;t.y2:=ys;
					t.u2:=tx;t.v2:=ty;
					t.z2:=PB^.z2;
				end;
			with PScreen^[v3] do
				begin
					t.x3:=xs;t.y3:=ys;
					t.u3:=tx;t.v3:=ty;
					t.z3:=PB^.z3;
				end;
			t.texture:=texture;
			t.transparency:=TransMap;

			RenderTextureCorrectedTransparent:=TexturePerspectiveTransparentTriangle(t);
			if contour then
				begin
					if Clip2D(t.x1,t.y1,t.x2,t.y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(t.x2,t.y2,t.x3,t.y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(t.x3,t.y3,t.x1,t.y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderTextureFlat(o:P3D;v:integer):boolean;FAR;
var
	tx1,ty1,
	tx2,ty2,
	tx3,ty3,
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					tx1:=tx;ty1:=ty;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					tx2:=tx;ty2:=ty;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					tx3:=tx;ty3:=ty;
					l3:=light;
				end;

			RenderTextureFlat:=TextureTriangleFlat(	x1,y1,tx1,ty1,
																							x2,y2,tx2,ty2,
																							x3,y3,tx3,ty3,
																							(l1+l2+l3) div 3,seg(texture^),seg(MapLight^));
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderTextureGouraud(o:P3D;v:integer):boolean;FAR;
var
	tx1,ty1,
	tx2,ty2,
	tx3,ty3,
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					tx1:=tx;ty1:=ty;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					tx2:=tx;ty2:=ty;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					tx3:=tx;ty3:=ty;
					l3:=light;
				end;

			RenderTextureGouraud:=TextureTriangleGouraud(	x1,y1,tx1,ty1,l1,
																										x2,y2,tx2,ty2,l2,
																										x3,y3,tx3,ty3,l3,
																										seg(texture^),seg(MapLight^));
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderDoubleTexture(o:P3D;v:integer):boolean;FAR;
var
	tx1,ty1,
	tx2,ty2,
	tx3,ty3,
	tu1,tv1,
	tu2,tv2,
	tu3,tv3,
	x1,y1,
	x2,y2,
	x3,y3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					tx1:=tx;ty1:=ty;
					tu1:=u;tv1:=v;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					tx2:=tx;ty2:=ty;
					tu2:=u;tv2:=v;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					tx3:=tx;ty3:=ty;
					tu3:=u;tv3:=v;
				end;

			RenderDoubleTexture:=TextureTriangleEnvMap(	x1,y1,tx1,ty1,tu1,tv1,
																									x2,y2,tx2,ty2,tu2,tv2,
																									x3,y3,tx3,ty3,tu3,tv3,
																									seg(texture^),seg(EnvMap^),seg(MapLight^));
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderFlatTransparent(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			RenderFlatTransparent:=FlatTransparentTriangle(	x1,y1,
																											x2,y2,
																											x3,y3,
																											(l1+l2+l3) div 3,seg(TransMap^),seg(MapLight^));
		end;
end;

function RenderGouraudTransparent(o:P3D;v:integer):boolean;FAR;
var
	x1,y1,
	x2,y2,
	x3,y3,
	l1,l2,l3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					l1:=light;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					l2:=light;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					l3:=light;
				end;

			RenderGouraudTransparent:=GouraudTransparentTriangle(	x1,y1,l1,
																														x2,y2,l2,
																														x3,y3,l3,
																														seg(TransMap^),seg(MapLight^));
		end;
end;

function RenderTextureTransparent(o:P3D;v:integer):boolean;FAR;
var
	tx1,ty1,
	tx2,ty2,
	tx3,ty3,
	x1,y1,
	x2,y2,
	x3,y3:integer;

begin
	with o^,PFaces^[v] do
		begin
			with PScreen^[v1] do
				begin
					x1:=xs;y1:=ys;
					tx1:=tx;ty1:=ty;
				end;
			with PScreen^[v2] do
				begin
					x2:=xs;y2:=ys;
					tx2:=tx;ty2:=ty;
				end;
			with PScreen^[v3] do
				begin
					x3:=xs;y3:=ys;
					tx3:=tx;ty3:=ty;
				end;

			RenderTextureTransparent:=TextureTransparentTriangle(	y1,x1,ty1,tx1,
																														y2,x2,ty2,tx2,
																														y3,x3,ty3,tx3,
																														seg(texture^),seg(TransMap^));
			if contour then
				begin
					if Clip2D(x1,y1,x2,y2) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x2,y2,x3,y3) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
					if Clip2D(x3,y3,x1,y1) then	draw(c_x1,c_y1,c_x2,c_y2,UnColor);
				end;
		end;
end;

function RenderScene(var s:TScene):integer;
const
	call:array[TRender] of function(o:P3D;v:integer):boolean=
		(
			RenderPoint,
			RenderWire,
			RenderFlat,
			RenderGouraud,
			RenderTexture,
			RenderTexture,
			RenderTextureFlat,
			RenderTextureGouraud,
			RenderDoubleTexture,
			RenderTextureCorrected,
			RenderTextureCorrected,
			RenderFlatTransparent,
			RenderGouraudTransparent,
			RenderTextureTransparent,
			RenderTextureTransparent,
			RenderDoubleTexture,
			RenderTextureCorrectedTransparent,
			RenderTextureCorrectedTransparent
		);

var
	i,n,nf:integer;

begin
	RenderScene:=-1;

	i:=0;
	nf:=s.faces-1;
	if nf>=0 then
		begin
			case s.sort of
				_QSORT_:SceneQSort(s);
			end;

			PB:=@s.buffer^;
			for n:=0 to nf do
				begin
					with PB^ do inc(i,ord(call[obj^.RenderType](obj,vertex)));
					inc(PB);
				end;
		end;

	s.faces:=0;
	RenderScene:=i;
end;

procedure SetCamera(var s:TScene;var c:TCamera);
var
	ax,ay,az,
	xSin,xCos,
	ySin,yCos,
	zSin,zCos,
	sxsz,sxcz,szcx,cxcz:double;

begin
	move(c,s.camera,SizeOf(TCamera));

	ax:=-s.camera.where.caida;
	ay:=-s.camera.where.deriva;
	az:=-s.camera.where.balanza;

	xSin:=sin(ax*RAD);
	xCos:=cos(ax*RAD);

	ySin:=sin(ay*RAD);
	yCos:=cos(ay*RAD);

	zSin:=sin(az*RAD);
	zCos:=cos(az*RAD);

	sxsz:=xSin*zSin;
	sxcz:=xSin*zCos;
	szcx:=zSin*xCos;
	cxcz:=xCos*zCos;

	CameraMatrix[0,0]:=yCos*zCos;
	CameraMatrix[1,0]:=yCos*zSin;
	CameraMatrix[2,0]:=-ySin;

	CameraMatrix[0,1]:=ySin*sxcz-szcx;
	CameraMatrix[1,1]:=ySin*sxsz+cxcz;
	CameraMatrix[2,1]:=xSin*yCos;

	CameraMatrix[0,2]:=ySin*cxcz+sxsz;
	CameraMatrix[1,2]:=ySin*szcx-sxcz;
	CameraMatrix[2,2]:=xCos*yCos;
end;

procedure ResetCamera(var camera:TCamera);
begin
	FillChar(camera,SizeOf(TCamera),0);
	camera.ZClipMin:=50;
	camera.ZClipMax:=100000;
end;

procedure	SetMaximusCoordinates(o:P3D;var t:TVector);{}
begin
	with o^ do
		begin
			if t.x<MINX then
				MINX:=t.x
			else
				if t.x>MAXX then MAXX:=t.x;
			if t.y<MINY then
				MINY:=t.y
			else
				if t.y>MAXY then MAXY:=t.y;
			if t.z<MINZ then
				MINZ:=t.z
			else
				if t.z>MAXZ then MAXZ:=t.z;
		end;
end;

procedure ResetCollisionValues(o:P3D);{}
begin
	with o^ do
		begin
			MINX:=1.7e308;MAXX:=5.0e-324;
			MINY:=MINX;MAXY:=MAXX;
			MINZ:=MINX;MAXZ:=MAXX;
		end;
end;

function collision(o1,o2:P3D):boolean;{}
begin
	with o1^ do
		collision:=	(MAXX>o2^.MINX) and (o2^.MAXX>MINX) and
								(MAXY>o2^.MINY) and (o2^.MAXY>MINY) and
								(MAXZ>o2^.MINZ) and (o2^.MAXZ>MINZ);
end;

procedure PrecalculateVertex(var s:TScene;o:P3D);
var
	xSin,xCos,
	ySin,yCos,
	zSin,zCos,
	sxsz,sxcz,szcx,cxcz:double;

begin
	with o^ do
		begin
			xSin:=sin(angle.caida*RAD);
			xCos:=cos(angle.caida*RAD);

			ySin:=sin(angle.deriva*RAD);
			yCos:=cos(angle.deriva*RAD);

			zSin:=sin(angle.balanza*RAD);
			zCos:=cos(angle.balanza*RAD);
		end;

	sxsz:=xSin*zSin;
	sxcz:=xSin*zCos;
	szcx:=zSin*xCos;
	cxcz:=xCos*zCos;

	RotationMatrix[0,0]:=yCos*zCos;
	RotationMatrix[1,0]:=yCos*zSin;
	RotationMatrix[2,0]:=-ySin;

	RotationMatrix[0,1]:=ySin*sxcz-szcx;
	RotationMatrix[1,1]:=ySin*sxsz+cxcz;
	RotationMatrix[2,1]:=xSin*yCos;

	RotationMatrix[0,2]:=ySin*cxcz+sxsz;
	RotationMatrix[1,2]:=ySin*szcx-sxcz;
	RotationMatrix[2,2]:=xCos*yCos;
end;

procedure RotateCamera(var camera:TCamera;caida,balanza,deriva:double);
begin
	camera.where.deriva:=camera.where.deriva+deriva;
	if camera.where.deriva>DEG then camera.where.deriva:=camera.where.deriva-DEG;

	camera.where.balanza:=camera.where.balanza+balanza;
	if camera.where.balanza>DEG then camera.where.balanza:=camera.where.balanza-DEG;

	camera.where.caida:=camera.where.caida+caida;
	if camera.where.caida>DEG then camera.where.caida:=camera.where.caida-DEG;
end;

procedure MoveCamera(var camera:TCamera;x,y,z:double);
begin
	camera.from.x:=camera.from.x+x;
	camera.from.y:=camera.from.y+y;
	camera.from.z:=camera.from.z+z;
end;

procedure SetCameraPos(var camera:TCamera;x,y,z:double);
begin
	camera.from.x:=x;
	camera.from.y:=y;
	camera.from.z:=z;
end;

procedure SetCameraClip(var camera:TCamera;zMin,zMax:double);
begin
	camera.ZClipMin:=zMin;
	camera.ZClipMax:=zMax;
end;

procedure RotateVertex(var s:TScene;o:P3D;v:PVertex);
var
	t:TVector;
	vx,vy,vz:double;

begin
	with o^ do
		begin
			with v^ do
				begin
					vx:=x;
					vy:=y;
					vz:=z;
				end;
			t.x:=	(vx*RotationMatrix[0,0])+
						(vy*RotationMatrix[0,1])+
						(vz*RotationMatrix[0,2])+world.x-s.camera.from.x;

			t.y:=	(vx*RotationMatrix[1,0])+
						(vy*RotationMatrix[1,1])+
						(vz*RotationMatrix[1,2])+world.y-s.camera.from.y;

			t.z:=	(vx*RotationMatrix[2,0])+
						(vy*RotationMatrix[2,1])+
						(vz*RotationMatrix[2,2])+world.z-s.camera.from.z;

			axis.z:=(t.x*CameraMatrix[2,0])+
							(t.y*CameraMatrix[2,1])+
							(t.z*CameraMatrix[2,2]);
			if (axis.z>s.camera.ZClipMin) and (axis.z<s.camera.ZClipMax) and (axis.z<>0) then{}
				begin
					sx:=CENTERX+round(((t.x*CameraMatrix[0,0])+
														 (t.y*CameraMatrix[0,1])+
														 (t.z*CameraMatrix[0,2]))*s.DistanceFromEye/axis.z);

					sy:=CENTERY+round(((t.x*CameraMatrix[1,0])+
														 (t.y*CameraMatrix[1,1])+
														 (t.z*CameraMatrix[1,2]))*s.DistanceFromEye/axis.z);
				end
			else
				sx:=VERTEX_OUTSIDE;
		end;

	SetMaximusCoordinates(o,t);
end;

procedure RotateNormals(v:PVertex;var normals:TVector);{}
var
	t:TVector;

begin
	with v^ do
		begin
			t.x:=nx/65536;
			t.y:=ny/65536;
			t.z:=nz/65536;
		end;
	normals.x:=(t.x*RotationMatrix[0,0])+(t.y*RotationMatrix[0,1])+(t.z*RotationMatrix[0,2]);
	normals.y:=(t.x*RotationMatrix[1,0])+(t.y*RotationMatrix[1,1])+(t.z*RotationMatrix[1,2]);
	normals.z:=(t.x*RotationMatrix[2,0])+(t.y*RotationMatrix[2,1])+(t.z*RotationMatrix[2,2]);
end;

function GetNormalLights(var s:TScene;var normals:TVector):integer;
const
	MIN_INTENSITY=2;
	MAX_INTENSITY=253;
	BASE_COLOR=128;

var
	h:integer;
	l:double;
	i:integer;

begin
	with s do
		begin
			l:=AmbientLight;
			for h:=0 to MAX_LIGHTS do with lights[h] do
				if active then l:=l+BASE_COLOR*((light.x*normals.x)+(light.y*normals.y)+(light.z*normals.z));
		end;

	i:=round(l);
	if i<MIN_INTENSITY then
		i:=MIN_INTENSITY
	else
		if i>MAX_INTENSITY then i:=MAX_INTENSITY;
	GetNormalLights:=i;
end;

procedure PutLight(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;
	normals:TVector;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					RotateNormals(PV,normals);
					inc(PV);

					with PS^ do
						begin
							light:=GetNormalLights(s,normals);
							xs:=sx;ys:=sy;
							z:=round(axis.z);
						end;
					inc(PS);
				end;
		end;
end;

procedure PutTexture(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					with PS^ do
						begin
							with PV^ do
								begin
									tx:=u;
									ty:=v;
								end;
							xs:=sx;
							ys:=sy;
							z:=round(axis.z);
						end;
					inc(PV);
					inc(PS);
				end;
		end;
end;

procedure PutEnvMap(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;
	normals:TVector;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					RotateNormals(PV,normals);
					inc(PV);

					with PS^ do
						begin
							tx:=TCenterX+round(normals.x*TEXTURE_CENTER);
							ty:=TCenterX+round(normals.y*TEXTURE_CENTER);
							xs:=sx;ys:=sy;
							z:=round(axis.z);
						end;
					inc(PS);
				end;
		end;
end;

procedure PutTextureLight(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;
	normals:TVector;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					RotateNormals(PV,normals);

					with PS^ do
						begin
							with PV^ do
								begin
									tx:=u;
									ty:=v;
								end;
							light:=GetNormalLights(s,normals);
							xs:=sx;
							ys:=sy;
							z:=round(axis.z);
						end;
					inc(PV);
					inc(PS);
				end;
		end;
end;

procedure PutTextureEnvMap(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;
	normals:TVector;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					RotateNormals(PV,normals);

					with PS^ do
						begin
							u:=TCenterX+round(normals.x*TEXTURE_CENTER);
							v:=TCenterX+round(normals.y*TEXTURE_CENTER);
							with PV^ do
								begin
									tx:=u;
									ty:=v;
								end;
							xs:=sx;
							ys:=sy;
							z:=round(axis.z);
						end;
					inc(PV);
					inc(PS);
			end;
		end;
end;

procedure PutDoubleEnvMap(var s:TScene;o:P3D);FAR;
var
	n:integer;
	PV:PVertex;
	PS:PScreen;
	normals:TVector;

begin
	with o^ do
		begin
			PV:=@PVertex^;
			PS:=@PScreen^;
			for n:=0 to vertex-1 do
				begin
					RotateVertex(s,o,PV);
					RotateNormals(PV,normals);
					inc(PV);

					with PS^ do
						begin
							u:=TCenterX+round(normals.x*TEXTURE_CENTER);
							v:=TCenterX+round(normals.y*TEXTURE_CENTER);
							tx:=u;
							ty:=v;
							xs:=sx;
							ys:=sy;
							z:=round(axis.z);
						end;
					inc(PS);
				end;
		end;
end;

function Put3D(var s:TScene;o:P3D;n:integer):boolean;
const
	call:array[TRender] of procedure(var s:TScene;o:P3D)=
		(
			PutLight,
			PutLight,
			PutLight,
			PutLight,
			PutEnvMap,
			PutTexture,
			PutTextureLight,
			PutTextureLight,
			PutTextureEnvMap,
			PutEnvMap,
			PutTexture,
			PutLight,
			PutLight,
			PutTexture,
			PutEnvMap,
			PutDoubleEnvMap,
			PutEnvMap,
			PutTexture
		);

begin
	o:=FindChild(o,n);
	if o=NIL then exit;
	ResetCollisionValues(o);
	PrecalculateVertex(s,o);
	call[o^.RenderType](s,o);
	Put3D:=AddObjectToScene(s,o);
end;

function PutAll3D(var s:TScene;o:P3D):boolean;
var
	n:integer;
	new,tmp:P3D;
	ok:boolean;

begin
	new:=o;
	for n:=0 to o^.TotalObjects do
		begin
			ok:=Put3D(s,o,n);
			if not ok then break;
			tmp:=new;
			new:=new^.child;
			if new=NIL then break;
			with new^ do
				begin
					angle.balanza:=tmp^.angle.balanza;
					angle.deriva:=tmp^.angle.deriva;
					angle.caida:=tmp^.angle.caida;
					world.x:=tmp^.world.x;world.y:=tmp^.world.y;world.z:=tmp^.world.z;
				end;
		end;
	PutAll3D:=ok;
end;

procedure Rotate3D(o:P3D;a:integer;caida,balanza,deriva:double);
begin
	if a=ALL_CHILDS then
		repeat
			with o^ do
				begin
					angle.balanza:=angle.balanza+angle.balanza;
					if angle.balanza>DEG then angle.balanza:=angle.balanza-DEG;

					angle.deriva:=angle.deriva+deriva;
					if angle.deriva>DEG then angle.deriva:=angle.deriva-DEG;

					angle.caida:=angle.caida+caida;
					if angle.caida>DEG then angle.caida:=angle.caida-DEG;
				end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			with o^ do
				begin
					angle.balanza:=angle.balanza+balanza;
					if angle.balanza>DEG then angle.balanza:=balanza-DEG;

					angle.deriva:=angle.deriva+deriva;
					if angle.deriva>DEG then angle.deriva:=angle.deriva-DEG;

					angle.caida:=angle.caida+caida;
					if angle.caida>DEG then angle.caida:=angle.caida-DEG;
				end;
		end;
end;

procedure Move3D(o:P3D;a:integer;ix,iy,iz:double);
begin
	if a=ALL_CHILDS then
		repeat
			with o^.world do
				begin
					x:=x+ix;
					y:=y+iy;
					z:=z+iz;
				end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			with o^.world do
				begin
					x:=x+ix;
					y:=y+iy;
					z:=z+iz;
				end;
		end;
end;

procedure Set3DPos(o:P3D;a:integer;x,y,z:double);
begin
	if a=ALL_CHILDS then
		repeat
			o^.world.x:=x;
			o^.world.y:=y;
			o^.world.z:=z;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.world.x:=x;
			o^.world.y:=y;
			o^.world.z:=z;
		end;
end;

procedure Set3DAngle(o:P3D;a:integer;balanza,deriva,caida:double);
begin
	if a=ALL_CHILDS then
		repeat
			o^.angle.caida:=caida;
			o^.angle.balanza:=balanza;
			o^.angle.deriva:=deriva;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.angle.caida:=caida;
			o^.angle.balanza:=balanza;
			o^.angle.deriva:=deriva;
		end;
end;

procedure SetRenderType(o:P3D;n:integer;r:TRender);
begin
	if n=ALL_CHILDS then
		repeat
			o^.RenderType:=r;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			o^.RenderType:=r;
		end;
end;

function GetRenderType(o:P3D;n:integer):TRender;
begin
	GetRenderType:=FindChild(o,n)^.RenderType;
end;

function Load3D(var o:P3D;nombre:string):boolean;
type
	TR3D=record
		magic:array[0..2] of char; {3DN}
		total:word;
	end;

var
	f:Tfile;
	obj,caras,vertices,
	l,n:word;
	C3D:TR3D;
	last,new:P3D;

begin
	Load3D:=FALSE;

	if pos('.',nombre)=0 then nombre:=nombre+'.3DN';
	if open(f,nombre,RO)>0 then exit;

	read(f,C3D,SizeOf(C3D),l);
	if C3D.magic<>'3DN' then
		begin
			close(f);
			exit;
		end;

	caras:=0;vertices:=0;
	new:=o;
	for n:=1 to C3D.total do
		begin
			if not GetMem(new,SizeOf(T3D)) then
				begin
					close(f);
					exit;
				end;

			if n>1 then
				last^.child:=new
			else
				o:=new;
			with new^ do
				begin
					read(f,vertex,SizeOf(integer),l);
					read(f,faces,SizeOf(integer),l);
					if (not GetMem(PScreen,SizeOf(TScreen)*vertex)) or
						 (not GetMem(PVertex,SizeOf(TVertex)*vertex)) or
						 (not GetMem(PFaces,SizeOf(TFaces)*faces)) then
						begin
							close(f);
							exit;
						end;
					inc(caras,faces);
					inc(vertices,vertex);

					read(f,PVertex^,SizeOf(TVertex)*vertex,l);
					read(f,PFaces^,SizeOf(TFaces)*faces,l);

					child:=NIL;
					Reset3D(new,DADDY);
					last:=new;
				end;
		end;
	close(f);

	o^.TotalObjects:=C3D.total;
	o^.TotalFaces:=caras;o^.TotalVertex:=vertices;

	Load3D:=TRUE;
end;

procedure Free3D(var o:P3D);{}
const
	MAX_OBJ_IN_SCENE=1024;

var
	tmp:P3D;
	save:array[0..MAX_OBJ_IN_SCENE] of P3D;
	n,m:integer;

begin
	tmp:=o;
	n:=0;
	repeat
		with tmp^ do
			begin
				FreeMem(PScreen,SizeOf(TScreen)*(vertex+1));
				FreeMem(PFaces,SizeOf(TFaces)*(faces+1));
				FreeMem(PVertex,SizeOf(TVertex)*(vertex+1));
			end;
			save[n]:=tmp;
			inc(n);
			tmp:=tmp^.child;
	until tmp=NIL;

	for m:=n-1 DownTo 0 do FreeMem(save[m],SizeOf(T3D));
end;

procedure Reset3D(o:P3D;n:integer);
begin
	if n=ALL_CHILDS then
		repeat
			with o^ do
				begin
					world.x:=0;
					world.y:=0;
					world.z:=3000;

					angle.caida:=0;
					angle.balanza:=0;
					angle.deriva:=0;

					EnvMap:=NIL;
					MapLight:=NIL;
					TransMap:=NIL;

					RenderType:=_FLAT_;
					UnColor:=-1;
					contour:=FALSE;
					ForceVisible:=FALSE;
				end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			with o^ do
				begin
					world.x:=0;
					world.y:=0;
					world.z:=3000;

					angle.caida:=0;
					angle.balanza:=0;
					angle.deriva:=0;

					EnvMap:=NIL;
					MapLight:=NIL;
					TransMap:=NIL;

					RenderType:=_FLAT_;
					UnColor:=-1;
					contour:=FALSE;
					ForceVisible:=FALSE;
				end;
		end;
end;

procedure SetTexture(o:P3D;n:integer;t:PTexture);
begin
	if n=ALL_CHILDS then
		repeat
			ASM
				PUSH		DS
				DB			_386;MOV		AX,WORD(t)
				LES			DI,o
				MOV			CX,ES:T3D[DI].faces
				LDS			DI,ES:T3D[DI].PFaces

@BUCLE:
				DB			_386;MOV		WORD(TFaces[DI].texture),AX
				ADD			DI,TYPE(TFaces)
				DEC			CX
				JNZ			@BUCLE	{for n:=0 to faces-1 do PFaces^[n].texture:=h;}

				POP			DS
			END;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			ASM
				PUSH		DS
				DB			_386;MOV		AX,WORD(t)
				LES			DI,o
				MOV			CX,ES:T3D[DI].faces
				LDS			DI,ES:T3D[DI].PFaces

@BUCLE:
				DB			_386;MOV		WORD(TFaces[DI].texture),AX
				ADD			DI,TYPE(TFaces)
				DEC			CX
				JNZ			@BUCLE

				POP			DS
			END;
		end;
end;

function MakeClone3D(f:P3D;var d:P3D):boolean;
var
	n:integer;
	DADDY,tmp:P3D;

begin
	MakeClone3D:=FALSE;

	n:=0;
	tmp:=d;
	repeat
		if not GetMem(tmp,SizeOf(T3D)) then exit;
		if n=0 then DADDY:=tmp;
		inc(n);
		tmp^:=f^;
		GetMem(tmp^.PScreen,SizeOf(TScreen)*f^.faces);
		f:=f^.child;
		tmp:=tmp^.child;
	until f=NIL;
	d:=DADDY;

	MakeClone3D:=TRUE;
end;

procedure FreeClone3D(var o:P3D);{}
begin
	FreeMem(o^.PScreen,SizeOf(TScreen)*o^.faces);
	FreeMem(o,SizeOf(T3D));
end;

procedure SetEnvMap(o:P3D;n:integer;t:PTexture);
begin
	if n=ALL_CHILDS then
		repeat
			o^.EnvMap:=t;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			o^.EnvMap:=t;
		end;
end;

procedure ScaleCoordinates(o:P3D;n:integer;scale:double);
var
	a:integer;

begin
	if n=ALL_CHILDS then
		repeat
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						x:=round(x*scale);
						y:=round(y*scale);
						z:=round(z*scale);
					end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						x:=round(x*scale);
						y:=round(y*scale);
						z:=round(z*scale);
					end;
		end;
end;

procedure UnScaleCoordinates(o:P3D;n:integer;scale:double);
var
	a:integer;

begin
	if n=ALL_CHILDS then
		repeat
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						x:=round(x/scale);
						y:=round(y/scale);
						z:=round(z/scale);
					end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						x:=round(x/scale);
						y:=round(y/scale);
						z:=round(z/scale);
					end;
		end;
end;

procedure ScaleMapping(o:P3D;n:integer;scale:double);
var
	a:integer;

begin
	if n=ALL_CHILDS then
		repeat
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						u:=round(u*scale);
						v:=round(v*scale);
					end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						u:=round(u*scale);
						v:=round(v*scale);
					end;
		end;
end;

procedure UnScaleMapping(o:P3D;n:integer;scale:double);
var
	a:integer;

begin
	if n=ALL_CHILDS then
		repeat
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						u:=round(u/scale);
						v:=round(v/scale);
					end;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,n);
			with o^ do
				for a:=0 to vertex-1 do with PVertex^[a] do
					begin
						u:=round(u/scale);
						v:=round(v/scale);
					end;
		end;
end;

function NewLight(var s:TScene;l:TFocus):integer;
var
	n:integer;

begin
	NewLight:=-1;
	for n:=0 to MAX_LIGHTS do with s.lights[n] do
		if not active then
			begin
				active:=TRUE;
				LType:=l;
				NewLight:=n;
				exit;
			end;
end;

procedure SetLight(var s:TScene;h:integer;var l:TLight);
var
	length:double;
	r:TVector;

begin
	with s.lights[h] do
		begin
			if not active then exit;
			VectorSub(r,l.where,l.from);
			VectorNormalize(r,light);
		end;
end;

procedure SetLightWhere(var l:TLight;x,y,z:double);
begin
	l.where.x:=x;
	l.where.y:=y;
	l.where.z:=z;
end;

procedure SetLightFrom(var l:TLight;x,y,z:double);
begin
	l.from.x:=x;
	l.from.y:=y;
	l.from.z:=z;
end;

procedure FreeLight(var s:TScene;h:integer);
begin
	s.lights[h].active:=FALSE;
end;

procedure ResetLights(var s:TScene);
begin
	FillChar(s.lights,SizeOf(s.lights),0);
end;

procedure SetEnvmapCenter(x,y:integer);{}
begin
	TCenterX:=x;TCenterY:=y;
end;

procedure SetTransparency(o:P3D;a:integer;t:Ptransparency);
begin
	if a=ALL_CHILDS then
		repeat
			o^.TransMap:=t;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.TransMap:=t;
		end;
end;

function LoadTexture(n:string;var t:PTexture;var p:Tpal):boolean;
var
	f:Tfile;
	ll:word;
	magic:array[0..2] of char;
	tmp:byte;

begin
	LoadTexture:=FALSE;

	if pos('.',n)=0 then n:=n+'.TEX';
	if open(f,n,RO)>0 then exit;

	read(f,magic,SizeOf(magic),ll);
	if magic<>'TEX' then
		begin
			close(f);
			exit;
		end;

	if not GetMem(t,SizeOf(TSegment)) then
		begin
			close(f);
			exit;
		end;

	read(f,t^,SizeOf(TSegment),ll);
	read(f,tmp,1,ll);
{	seek(f,65535+SizeOf(magic)+1);}
	read(f,p,SizeOf(p),ll);
	close(f);

	LoadTexture:=TRUE;
end;

function SaveTexture(n:string;t:PTexture;var p:Tpal):boolean;
const
	magic:array[0..2] of char='TEX';

var
	f:Tfile;
	l:word;

begin
	SaveTexture:=FALSE;

	if pos('.',n)=0 then n:=n+'.TEX';
	if ReWrite(f,n)>0 then exit;
	write(f,magic,SizeOf(magic),l);
	write(f,t^,SizeOf(TSegment),l);
	{$IFNDEF _BPREAL_}
	write(f,l,1,l);
	{$ENDIF}
	write(f,p,SizeOf(TPal),l);
	close(f);

	SaveTexture:=TRUE;
end;

procedure FreeTexture(var t:PTexture);
begin
	FreeMem(t,SizeOf(TSegment));
end;

function LoadMapLight(var l:PMapLight;n:string):boolean;
var
	f:Tfile;
	ll:word;
	magic:array[0..4] of char;

begin
	LoadMapLight:=FALSE;

	if not GetMem(l,SizeOf(TSegment)) then exit;

	if pos('.',n)=0 then n:=n+'.LGT';
	if open(f,n,RO)>0 then exit;

	read(f,magic,SizeOf(magic),ll);
	if magic<>'LIGHT' then
		begin
			close(f);
			exit;
		end;

	read(f,l^,SizeOf(TSegment),ll);
	close(f);

	LoadMapLight:=TRUE;
end;

procedure FreeMapLight(var l:PMapLight);
begin
	FreeMem(l,SizeOf(TSegment));
end;

procedure SetMapLight(o:P3D;a:integer;l:PMapLight);
begin
	if a=ALL_CHILDS then
		repeat
			o^.MapLight:=l;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.MapLight:=l;
		end;
end;

procedure SetUnColor(o:P3D;a,n:integer);
begin
	if a=ALL_CHILDS then
		repeat
			o^.UnColor:=n;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.UnColor:=n;
		end;
end;

procedure SetVisible(o:P3D;a:integer;b:boolean);
begin
	if a=ALL_CHILDS then
		repeat
			o^.ForceVisible:=b;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.ForceVisible:=b;
		end;
end;

procedure SetContour(o:P3D;a:integer;b:boolean);
begin
	if a=ALL_CHILDS then
		repeat
			o^.contour:=b;
			o:=NextChild(o);
		until o=NIL
	else
		begin
			o:=FindChild(o,a);
			o^.contour:=b;
		end;
end;

function LoadWorld(var w:PWorld;n:string):boolean;
type
	TCab=record
		magic:array[0..4] of char;	{WORLD}
		total:integer;
		camera:TCamera;
	end;

var
	f:TFile;
	a:integer;
	cab:TCab;
	l:word;
	last,new:PWorld;

begin
	LoadWorld:=FALSE;
	if open(f,n,RO)>0 then exit;
	read(f,cab,SizeOf(cab),l);
	if cab.magic<>'WORLD' then
		begin
			close(f);
			exit;
		end;
	for a:=1 to cab.total do
		begin
			if GetMem(new,SizeOf(TWorld)) then
				begin
					close(f);
					exit;
				end;
			if a>1 then
				last^.next:=new
			else
				begin
					w:=new;
					w^.total:=cab.total;
					w^.camera:=cab.camera;
				end;

			with new^ do
				begin
					read(f,n,8,l);
					if not Load3D(obj,n) then
						begin
							close(f);
							exit;
						end;
					read(f,obj^.world,SizeOf(TVector),l);
					read(f,obj^.angle,SizeOf(TAngles),l);
					next:=NIL;
					last:=new;
				end;
		end;
	close(f);
end;

procedure FreeWorld(var w:PWorld);{}
begin
end;

procedure Delete3DOfWorld(w:PWorld;o:P3D;n:integer);{}
var
	a:integer;
	p:PWorld;

begin
	dec(w^.total);
	for a:=0 to n-1 do
		begin
			if a<n-1 then p:=w;
			w:=w^.next;
		end;
	p^.next:=w^.next;
	Free3D(w^.obj);
end;

function Insert3DInWorld(w:PWorld;o:P3D):integer;{}
var
	n:integer;
	l:PWorld;

begin
	l:=w;
	for n:=1 to w^.total do w:=w^.next;
	inc(l^.total);

	l:=w;
	GetMem(w,SizeOf(TWorld));
	l^.obj:=o;
	l^.next:=w;
end;

procedure MakeWorld(var s:TScene;w:PWorld);
var
	n:integer;

begin
	for n:=1 to w^.total do
		begin
			PutAll3D(s,w^.obj);
			w:=w^.next;
		end;
end;

function Get3DOfWorld(w:PWorld;n:integer):P3D;
var
	a:integer;

begin
	for a:=0 to n-1 do w:=w^.next;
	Get3DOfWorld:=w^.obj;
end;

begin
	SetEnvmapCenter(TEXTURE_CENTER,TEXTURE_CENTER);
{$IFDEF _DEBUG_}
	assign(f,'ENGINE3D.ERR');
	system.ReWrite(f);
{$ENDIF}
end.