unit files;

INTERFACE

type
	ModoLectura=(RO,WO,RW);
	ModoComparticion=(COMPATIBILIDAD_TOTAL,TODO_DENEGADO,ESCRITURA_DENEGADA,
										LECTURA_DENEGADA,NADA_DENEGADO);

	TFile=record
		nombre:array[0..255] of char;
		handle:word;
	end;

	TError=(NO_ERROR,_1_,NO_FILE,PATH_ERROR,TOO_FILES_OPEN);

function open(var f:TFile;nombre:string;ml:ModoLectura):integer;
function ReWrite(var f:TFile;nombre:string):integer;
function close(var f:TFile):integer;
function read(var f:TFile;var buffer;bytes:word;var leidos:word):integer;
function write(var f:TFile;var buffer;bytes:word;var escritos:word):integer;
function seek(var f:TFile;desplazamiento:LongInt):integer;
function FilePos(var f:TFile):LongInt;
function erase(var f:TFile):integer;
function rename(var f:TFile;nuevo:string):integer;
function FileSize(var f:TFile):LongInt;
function EOF(var f:TFile):boolean;
function search(var f:TFile;s:string;longitud:byte):string;

IMPLEMENTATION

uses strings,MyDOS;

{$IFDEF _DEBUG_}
var
	fich:text;
{$ENDIF}

function open(var f:TFile;nombre:string;ml:ModoLectura):integer;
var
	at:byte;
	handle:word;
	error:integer;

begin
{$IFDEF _DEBUG_}
	WriteLn(fich,nombre);
{$ENDIF}

	StrPCopy(f.nombre,nombre);
	at:=$80+ord(ml);		{BIT 7 a 1 = handle no se hereda :-? }

	ASM
		MOV			error,0

		PUSH		DS
		MOV			AH,$3d
		MOV			AL,at
		LDS			SI,f
		LEA			DX,TFile[SI].nombre
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		POP			DS
		MOV			handle,AX
	END;

	f.handle:=handle;
	open:=error;
end;

function ReWrite(var f:TFile;nombre:string):integer;
var
	handle:word;
	error:integer;

begin
	StrPCopy(f.nombre,nombre);

	ASM
		MOV			error,0

		PUSH		DS
		MOV			AH,$3c
		MOV			CX,0
		LDS			SI,f
		LEA			DX,TFile[SI].nombre
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		POP			DS
		MOV			handle,AX
	END;

	f.handle:=handle;
	ReWrite:=error;
end;

function close(var f:TFile):integer;
var
	handle:word;
	error:integer;

begin
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AH,$3e
		MOV			BX,handle
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	close:=error;
end;

function read(var f:TFile;var buffer;bytes:word;var leidos:word):integer;
var
	handle,n:word;
	error:integer;

begin
	NumLockOn;
	handle:=f.handle;

	ASM
		PUSH		DS
		MOV			error,0

		MOV			AH,$3F
		MOV			BX,handle
		MOV			CX,bytes
		LDS			DX,buffer
		INT			$21

		POP			DS
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			n,AX
	END;

	leidos:=n;
	read:=error;

	NumLockOff;
end;

function write(var f:TFile;var buffer;bytes:word;var escritos:word):integer;
var
	n,handle:word;
	error:integer;

begin
	handle:=f.handle;

	ASM
		PUSH		DS
		MOV			error,0

		MOV			AH,$40
		MOV			BX,handle
		MOV			CX,bytes
		LDS			DX,buffer
		INT			$21

		POP			DS
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			n,AX
	END;

	escritos:=n;
	write:=error;
end;

function seek(var f:TFile;desplazamiento:LongInt):integer;
var
	handle:word;
	error:integer;

begin
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AX,$4200
		MOV			BX,handle
		MOV			CX,WORD(desplazamiento+2)
		MOV			DX,WORD(desplazamiento)
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
	END;

	seek:=error;
end;

function FilePos(var f:TFile):LongInt;
var
	d:LongInt;
	handle:word;
	error:integer;

begin
	handle:=f.handle;

	ASM
		MOV			error,0

		MOV			AX,$4201
		MOV			BX,handle
		XOR			CX,CX
		MOV			DX,CX
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			WORD(d),AX
		MOV			WORD(d+2),DX
	END;

	FilePos:=d;
end;

function erase(var f:TFile):integer;
var
	error:integer;

begin
	ASM
		MOV			error,0

		PUSH		DS
		MOV			AH,$41
		LDS			SI,f
		LEA			DX,TFile[SI].nombre
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		POP			DS
	END;

	erase:=error;
end;

function rename(var f:TFile;nuevo:string):integer;
var
	n:array[0..255] of char;
	error:integer;

begin
	StrPCopy(n,nuevo);

	ASM
		MOV			error,0

		PUSH		DS
		MOV			AH,$56
		MOV			BX,SS
		MOV			ES,BX
		LEA			DI,n
		LDS			SI,f
		LEA			DX,TFile[SI].nombre
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		POP			DS
	END;

	ReName:=error;
end;

function FileSize(var f:TFile):LongInt;
var
	d,e:LongInt;
	handle:word;
	error:integer;

begin
	handle:=f.handle;
	e:=FilePos(f);

	ASM
		MOV			error,0

		MOV			AX,$4202
		MOV			BX,handle
		MOV			CX,0
		MOV			DX,CX
		INT			$21
		JNC			@FIN
		MOV			error,AX

@FIN:
		MOV			WORD(d),AX
		MOV			WORD(d+2),DX
	END;

	seek(f,e);
	FileSize:=d;
end;

function EOF(var f:TFile):boolean;
begin
	EOF:=FilePos(f)>=FileSize(f);
end;

function search(var f:TFile;s:string;longitud:byte):string;
var
	line:string;
	l:word;

begin
	repeat
		read(f,line,longitud,l);
	until (pos(s,line)>0) or (EOF(f));

	if EOF(f) then line:='';
	search:=line;
end;

{$IFDEF _DEBUG_}
var
	last:pointer;

procedure salir;FAR;
begin
	system.close(fich);
	Exitproc:=last;
end;

begin
	assign(fich,'FILES.TXT');
	system.ReWrite(fich);

	last:=ExitProc;
	ExitProc:=@salir;
{$ENDIF}
end.