Unit LZFiles;
{ Proyecto:     Unidad para mantener un fichero .LZ                       }
{ Autor:        Antonio Tejada Lacaci a.k.a. EtCtera                      }
{ Fecha:        Junio '96                                                 }
{ Descripcin:  Permite leer ficheros incrustados comprimidos o sin       }
{               comprimir (subficheros) en un gran fichero (fichero LZ)   }

{ Notas:				Preparado para compilar en modo Protegido del BP.					}
{							  En caso de emplear modo Real, recordar que el TlzDataFrame}
{								debe estar alineado en offset 0                           }

{ Defines:      _DEBUGLZ_ : Crea el archivo LZFILES.DBG y escribe en l   }
{               todas las operaciones realizadas sobre el .LZW            }

Interface
Const
	MaxSubFiles = 1; { Nmero mximo de subarchivos abiertos a la vez }
	MaxLZFiles = 1;  { Nmero mximo de archivos LZ abiertos a la vez }
	BufferSize = 1024; { Tamao del buffer a leer de disco }
	lzMagic    = #8'LZW DataFile. (c) The Banner ''96'#26#0;
	SeekBufSize= 50*1024;

Type
	PByte = ^Byte;
	TFileName = String[80]; { $$$$$$$$.$$$ cadena de nombre de un subfichero }
	TOpenMode = (RO,WO,RW); { Modo de lectura: ReadOnly, WriteOnly, ReadWrite }

	{ Identificacin de un fichero .LZ }
	TLZMagic = String[Length(lzMagic)];

	{ Conjunto de datos a guardar por cada fichero comprimido }
	PLZDataFrame = ^TLZDataFrame;
	TLZDataFrame = Record
		input_handle : Word;   { Handle del archivo a comprimir }
		hash         : Array [0..12287] of byte;  { Tabla de hash para el      }
																							{ diccionario (3*4096 bytes) }
		cur_code     : Word;   { Cdigo actual   }
		old_code     : Word;   { Cdigo anterior }
		in_code      : Word;   { Cdigo ledo    }
		free_code    : Word;   { Entrada libre del diccionario (258) }
		stack_count  : Word;   { Nmero de caracteres en la pila (0) }
		nbits        : Word;   { Longitud actual del cdigo      (9) }
		max_code     : Word;   { Cdigo mximo para la longitud actual (512) }
		fin_char     : Byte;
		k            : Byte;
		output_offset: Word;   { Offset a la posicin donde escribir sobre el }
													 { buffer de salida                             }
		output_base  : Word;   { Offset donde comienzan los datos descomprimi-}
													 { dos del buffer de salida                     }
		output_buffer: Array [0..4095] of byte; { Buffer de salida }
		masks        : Array [0..3] of Word;    { Mscaras para las distintas }
																						{ longitudes de cdigo        }
																						{ (1ffh,3ffh,7ffh,0fffh)      }
		input_buffer : Array [0..1023] of byte; { Buffer de entrada }
		bit_offset   : Word;   { Offset en bits que indica la posicin sobre  }
													 { el buffer de entrada del siguiente cdigo    }
													 { (1024*8, para indicar lectura del fichero)   }
		eof          : Boolean;{ True si se lleg al final del fichero        }
		count        : Word;   { Nmero final de caracteres ledos            }
		output_pointer: Pointer; { Puntero al buffer donde depositar la descom}
														 { presin                                    }
	end;

	{ Cabecera de un fichero .LZ }
  TLZHeader = Record
		lzIdent     : TLZMagic; { Identificador de fichero de datos LZW }
    szChar      : Byte;   { Nmero de bits por caracter. Normalmente 8 }
    szAlpha     : Word;   { Tamao de la tabla del alfabeto. Normalmente 4096 }
		ptDirectory : Longint;{ Offset desde el principio del LZW al TLZDirectory }
                          { de este fichero                                   }
		nmFiles     : Integer;{ Nmero de ficheros includos en el .LZ  }
	end;

	{ Descriptor de un subfichero incrustado en el .LZ }
	PSubDescriptor = ^TSubDescriptor;
	TSubDescriptor = Record
		FileName : TFileName; { Nombre del fichero incrustado    }
		szFile   : Longint;   { Tamao del archivo sin comprimir }
		szComp   : Longint;   { Tamao del archivo comprimido,   }
													{ -1 si no est comprimido         }
		ptFile   : Longint;   { Puntero al principio del sub fichero en el }
													{ archivo .LZ                                }
	end;

	{ Un TLZDirectory es un array de TSubDescriptor situado al final del .LZ }
	PLZDirectory = ^TLZDirectory;
	TLZDirectory = Array [0..($FFFF div SizeOf(TSubDescriptor))-1] of
								 TSubDescriptor;

	{ Subfichero incrustado en el .LZ }
	PFile = ^TFile;
	TFile = Record
    ptDesc  : PSubDescriptor; { Puntero al descriptor de este subfichero    }
		bOffset : Longint;        { Offset sobre el buffer en memoria           }
		lzOffset : Longint;       { Offset actual sobre el fichero LZW          }
		lzDataFrame:PLZDataFrame;
	end;

	{ Fichero .LZ }

	PLZFile = ^TLZFile;
	TLZFile = Record
		lzName       : Array [0..80] of Char;  { Nombre del fichero .LZ   }
		lzHandle     : Word;         { Handle al fichero DOS    }
		LZHeader     : TLZHeader;    { Cabecera del fichero .LZ }
		lzDirectory  : PLZDirectory; { Puntero a una copia del TLZDirectory en }
																 { memoria principal                       }
		lzEXEOffset  : Longint;      { En caso de que el .LZW est incrustado  }
																 { un .EXE, p. ej., indica el principio    }
		SubOpened    : Word;         { Nmero de subficheros abiertos          }
		SeekBuf      : PByte;        { Buffer temporal para el seek     }
	end;


	Function LZInit(LZFileName:String):integer;
	{ Prepara el fichero LZFileName para ser el fichero actual de lectura }
	{ Devuelve el mismo tipo de error que un "Open"                       }
	Function Open(var f:TFile;SubName:string;a:TOpenMode):integer;
	{ Abre el subfichero SubName en el Fichero actual de lectura }
  function ReWrite(var f:Tfile;nombre:string):integer;
  { Funcin no soportada }
	Function Close(var f:TFile):integer;
	{ Cierra el subfichero dado por TFile }
	Function Read(var f:TFile;var buffer;ToRead:word;var ReadCount:word):integer;
	{ Lee ToRead bytes del fichero y los pone en buffer. Devuelve en }
	{ ReadCount el nmero de bytes ledos                            }
	Function Seek(var f:TFile;anOffset:LongInt):integer;
	{ Posiciona el ndice al fichero en la posicin anOffset a partir del }
	{ principio del subfichero.                                           }
	Function FilePos(Var f:TFile):LongInt;
	{ Da la posicin actual del ndice dentro del subfichero              }
	Function FileSize(Var f:TFile):LongInt;
	{ Devuelve el tamao del subfichero sin comprimir }
	Function EOF(Var f:TFile):boolean;
	{ Devuelve True si el ndice est al final del fichero }
	function write(f:Tfile;var buffer;bytes:word;var escritos:word):integer;
	{ Funcin no soportada }
	Procedure LZDeInit;
	{ Desinicializa el fichero .LZW abierto }
Var
	LZFile : TLZFile;

Implementation
Uses Files;
Var
	aFile:Files.TFile absolute LZFile;  { LZFile en formato Files.TFile    }
	{$IFDEF _DEBUG_}
	fich:Text;
	{$ENDIF}
	LZOpened:Word;                      { Nmero de ficheros .LZW abiertos }

	Procedure decompress(dataFrame:word);External;
	{$L lzfiles.obj}

  {$IFNDEF DPMI }
  { Rutinas para pedir memoria alineada a prrafos cuando no hay DPMI }
  function malloc(num:LongInt):PLZDataFrame;Assembler;
  { Devuelve Nil si hubo error }
	asm
	  mov ax,word ptr [num]
    mov dx,word ptr [num+2]
    { Ajustamos num a un mltiplo de 16 bytes (prrafo) }
    test ax,$000F
    jz @Multiple
       add ax,$0010
    @Multiple:
    { Calculamos el nmero de prrafos }
    shr ax,4
    shl dx,16-4
		or ax,dx
    mov bx,ax

    { Llamada a la interrupcin 21h/48h, Allocate memory }
		mov ah,$48
    int $21
    jc @Error
       mov dx,ax
			 jmp @Fin
    @Error:
       xor dx,dx
		@Fin:
    xor ax,ax
  end;

  function dalloc(pt:PLZDataFrame):boolean;assembler;
  { Devuelve False si hubo error }
  asm
    mov ax, word ptr [pt+2]   { Tomamos el segmento de pt }
    or ax,ax                  { Miramos si pt es NIL      }
    jnz @DeAlloc
        mov ax,False          { Error }
        jmp @DoEnd
    @DeAlloc:
        mov es, ax            { Ponemos el segmento de pt en es }
        mov ah,$49            { Int $21/$49                     }
        int $21
        mov al, False
        jc @DoEnd
        mov al,True
    @DoEnd:
  end;
  {$ENDIF}

	Procedure Initialize;
	{ Inicializa la variable LZFile }
	Begin
	With LZFile do begin
			lzHandle     := 0;         { Handle al fichero DOS    }
			With LZHeader do begin
				 lzIdent:='';
				 szChar:=0;
				 szAlpha:=0;
				 ptDirectory:=0;
				 nmFiles:=0;
			end;
			lzDirectory:=Nil;
			SubOpened:=0;
		end;
    lzopened:=0;
	End;

	Function Mays(Cad:String):String;Assembler;
	{ Convierte Cad en maysculas }
	Asm
		push ds                   { Guardo el segmento de datos               }
		lds si,Cad                { Cargo el puntero a Cad en ds:si           }
		les di,@Result            { Cargo el puntero al resultado en es:di    }
		mov al,byte ptr [si]      { meto en al la longitud de la cadena       }

		xor cx,cx                 { Borro cx                                  }
		mov cl,al                 { Meto en cl la longitud de la cadena       }
		mov es:[di],cl            { Meto en el resultado la longitud de la    }
															{ cadena resultante                         }
		test cl,cl                { Si la cadena es nula, finalizamos         }
		jz @Fin
		@Bucle1:                  { Bucle de tratamiento de Cad               }
			inc si                  { Incremento el puntero a Cad               }
			inc di                  { Incremento el puntero al resultado        }
			mov al, byte ptr [si]   { Meto en al el caracter a tratar           }
			cmp al,'a'              { Comparo con "a", si es menor no convierto }
			jb @NoConv
			cmp al,'z'              { Comparo con "z", si es mayor salto al tra-}
			ja @EspChar             { tamiento de caracteres especiales.        }
			sub al,32               { Convierto (resto 32)                      }
			jmp @Noconv

			@EspChar:               { Trato        (solo castellano)     }
				cmp al,''            { Es una ""?                              }
				jnz @No00
					mov al,'A'          { Pongo "A"                                 }
				jmp @NoConv
				@No00:
				cmp al,''            { Es una ""?                              }
        jnz @No01
          mov al,'E'          { Pongo una "E"                             }
        jmp @NoConv
        @No01:
				cmp al,''            { Es una ""?                              }
				jnz @No02
					mov al,'I'          { Pongo una "I"                             }
          jmp @NoConv
        @No02:
        cmp al,''            { Es una ""                               }
        jnz @No03
          mov al,'O'          { Pongo una "O"                             }
          jmp @NoConv
        @No03:
				cmp al,''            { Es una ""?                              }
        jnz @No04
          mov al,'U'          { Pongo una "U"                             }
					jmp @NoConv
				@No04:
				cmp al,''            { Es una ?                                }
				jnz @No05
          mov al,''
          jmp @NoConv
        @No05:
        cmp al,''            { Es una ""                               }
        jnz @NoConv
          mov al,''
          jmp @NoConv
      @NoConv:
       mov byte ptr es:[di],al { Muevo la letra, convertida o no a result }
		  dec cl
    jnz @Bucle1
		@Fin:
    pop ds
	End;


	Function LZInit(LZFileName:String):integer;
	var
		ErrorCode:integer;
		count:word;

	Begin
		{ Comprobamos que no se exceda el lmite mximo de LZW abiertos }
		If LZOpened>MaxLZFiles-1 then begin
			 LZInit:=4;
			 exit;
		end;

		{ Abrimos el fichero .LZW }
		ErrorCode := Files.Open(aFile,LZFileName,Files.RO);
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'OPEN ',aFile.handle);
		{$ENDIF }

		{ Miramos si hubo error de apertura de fichero }
		If ErrorCode<>0 then begin
			 { Hubo error de apertura de fichero }
			 LZInit:=ErrorCode;
			 exit;
		end;

		{ Nos posicionamos en el ltimo LONGINT, que es un puntero "inverso" }
		{ al principio del .LZW                                              }
		Files.Seek(aFile,Files.FileSize(aFile)-4);
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'SEEK ',aFile.handle);
		{$ENDIF }
		Files.Read(aFile,LZFile.lzEXEOffset,4,count);
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'READ ',aFile.handle);
		{$ENDIF }
		LZFile.lzEXEOffset := Files.fileSize(aFile)-LZFile.lzEXEOffset-1;

		{ Leemos la cabecera del .LZW }
		Files.Seek(aFile,LZFile.lzEXEOffset);
		Files.Read(aFile,LZFile.LZHeader,SizeOf(LZFile.LZHeader),Count);

		{ Comprobamos que sea un archivo de tipo .LZW }
		If (LZFile.LZHeader.lzIdent <> lzMagic) then begin
			 Files.Close(aFile);  { Cerramos el archivo }
			 LZInit:=11;          { Error de Invalid Format}
			 exit;
		end;

		{ Pedimos memoria para el directorio de subficheros }
		GetMem(LZFile.LZDirectory,LZFile.LZHeader.nmFiles*SizeOf(TSubDescriptor));

		{ Leemos el directorio de subficheros }
		Files.Seek(aFile, LZFile.LZHeader.ptDirectory+lzFIle.lzEXEOffset);
		Files.Read(aFile, LZFile.LZDirectory^,
											LZFile.LZHeader.nmFiles*SizeOf(TSubDescriptor),Count);

		GetMem(Pointer(LZFile.SeekBuf),SeekBufSize);

		{ Incrementamos el nmero de .LZW abiertos }
		Inc(LZOpened);
		LZInit:=ErrorCode;
	End;

	Function Open(Var f:TFile;SubName:String;a:TOpenMode):Integer;
	Var
		MSubName:String;
		i:Longint;
	Begin
		{ Comprobamos que no se exceda el nmero mximo posible de SubFicheros }
		{ abiertos.                                                            }
		If LZFile.SubOpened>=MaxSubFiles then begin
			 { Demasiados ficheros abiertos }
			 Open:=4;  { Too many open files }
			 exit;
		end;
		{ Tomamos el nombre del subfichero en maysculas }
		MSubName:=Mays(SubName);
		i:=0;
		{ Buscamos el subfichero en los descriptores }
		While (LZFile.LZHeader.nmFiles> i) and
			(LZFile.lzDirectory^[i].FileName<>MSubName) do inc(i);
		If (LZFile.LZHeader.nmFiles= i) then begin
			 { No se encontr el subfichero }
			 Open:=2;  { File Not Found }
			 exit;
		end;

		{ Asignamos el descriptor del subfichero }
		F.ptDesc:=@(LZFile.lzDirectory^[i]);
		{ Posicionamos el ndice del LZW al principio del subfichero }
		i:=LZFile.lzDirectory^[i].ptFile;
		F.lzOffset:=i;
		Files.Seek(aFile,i+LZFile.lzEXEOffset);
		{ Incrementamos el nmero de subficheros abiertos }
		Inc(LZFile.SubOpened);

		If (F.ptDesc^.szComp<>-1) then begin
			 { Inicializamos el data frame }
			 {$IFDEF DPMI}
			 New(F.lzDataFrame);
			 {$ELSE }
			 F.lzDataFrame :=malloc(SizeOf(F.lzDataFrame^));
			 {$ENDIF}
			 With F.lzDataFrame^ do begin
				 input_handle:=LZFile.lzHandle;
				 Free_code:=258;
				 nbits := 9;
				 max_code:=512;
				 output_offset:=0;
				 output_base:=0;
				 masks[0]:=$1ff;
				 masks[1]:=$3ff;
				 masks[2]:=$7ff;
				 masks[3]:=$FFF;
				 bit_offset:=1024*8;
				 Eof:=False;
				 stack_count:=0;
			 end;
		end;
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'Abriendo archivo ',SubName,' ',seg(F.lzDataFrame^));
		{$ENDIF}
		Open:=0;
	End;

	function ReWrite(var f:Tfile;nombre:string):integer;
	Begin
		ReWrite:=-1;
	End;

	Function Close(var f:TFile):integer;
	{ Cierra el subfichero dado por TFile }
	Begin
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'Cerrando archivo ',F.ptDesc^.FileName);
		{$ENDIF }
		If LZFile.SubOpened>0 then
			Dec(LZFile.SubOpened)
		else begin
			close:=103; { File not open }
			exit;
		end;
		F.lzOffset:=0;
		{ Desalojamos el DataFrame }
		If (F.ptDesc^.szComp<>-1) then
			 {$IFDEF DPMI }
			 Dispose(F.lzDataFrame);
			 {$ELSE }
			 Dalloc(F.lzDataFrame);
			 {$ENDIF}
		F.ptDesc:=nil;
		Close:=0;
	End;

	function write(f:Tfile;var buffer;bytes:word;var escritos:word):integer;
	Begin
		write:=-1;
	End;

	Function Read(var f:TFile;var buffer;ToRead:word;var ReadCount:word):integer;
	Var
		ErrorCode:Integer;
	Begin
		ErrorCode:=0;
		{$IFDEF _DEBUG_}
		System.Writeln(fich,'Leyendo a ',Seg(Buffer),':',Ofs(buffer),' ',ToRead,'bytes');
		{$ENDIF}
		If not(eof(f)) and (ToRead>0) then begin
			If F.ptDesc^.szComp=-1 then begin
				 { El fichero no est comprimido }
				 ErrorCode:=Files.Read(aFile,buffer,ToRead,ReadCount);
				 Inc(F.lzOffset,ReadCount);
			end else begin
				 { El fichero est comprimido }
				 {$IFDEF _DEBUG_}
				 WriteLn(fich,seg(F.lzDataFrame^));
				 {$ENDIF}
				 F.lzDAtaFrame^.count:=toread;
				 F.lzDataFrame^.output_Pointer:=@Buffer;
				 end;
				 {$IFDEF _DEBUG_}
				 System.Writeln(fich,'BEFORE READ COMPRESS ',aFile.handle);
				 {$ENDIF }
				 Decompress(Seg(F.lzDataFrame^));
				 {$IFDEF _DEBUG_}
				 WriteLn(fich,'OK');
				 {$ENDIF}
				 ReadCount:=ToRead-F.lzDataFrame^.Count;
				 Inc(f.lzOffset,ReadCount);
			end;
		Read:=ErrorCode;
	End;

	Function Seek(var f:TFile;anOffset:LongInt):integer;
	Var
		ErrorCode:Integer;
		i:Longint;
		count:Word;
	Begin
		ErrorCode:=0;
		If F.ptDesc^.szComp=-1 then begin
			 { El fichero no est comprimido }
			 F.lzOffset:=F.ptDesc^.ptFile+anOffset;
			 ErrorCode:=Files.Seek(aFile,F.lzOffset+LZFile.lzEXEOffset);
		end else begin
				{ El fichero est comprimido }
				With F.lzDataFrame^ do begin
					 { Inicializamos el DataFrame }
					 input_handle:=LZFile.lzHandle;
					 Free_code:=258;
					 nbits := 9;
					 max_code:=512;
					 output_offset:=0;
					 output_base:=0;
					 bit_offset:=1024*8;
					 Eof:=False;
					 stack_count:=0;
				end;
				{ Buscamos el principio del subfichero }
				Files.seek(afile,F.ptDesc^.ptFile+LZFile.lzEXEOffset);
				F.lzOffset:=F.ptDesc^.ptFile;
				If anOffset>0 then begin
					 { Si el Offset es 0, no hacemos nada }
					 While anOffset-SeekBufSize>0 do begin
						read(f,LZFile.SeekBuf^,SeekBufSize,count);
						dec(anOffset,SeekBufSize);
					 end;
					 If anOffset>0 then read(f,LZFile.SeekBuf^,anOffset,count);
				end;
		end;
		Seek:=ErrorCode;
	End;

	Function FilePos(Var f:TFile):LongInt;
	Begin
		FilePos:=F.lzOffset-F.ptDesc^.ptFile;
	End;

	Function FileSize(Var f:TFile):LongInt;
	Begin
		FileSize:=F.ptDesc^.szFile;
	End;

	Function EOF(Var f:TFile):boolean;
	Begin
		If F.ptDesc^.szComp = -1 then
				 EOF:=(F.ptDesc^.szFile=F.lzOffset-F.ptDesc^.ptFile)
		else
				 EOF:=(F.lzDataFrame^.EOF);
	End;

	Procedure LZDeInit;
	Begin
		{ Liberamos la memoria tomada para el directorio de subficheros }
		Dispose(LZFile.LZDirectory);
    FreeMem(LZFile.SeekBuf,SeekBufSize);
		{ Cerramos el fichero LZW }
		Files.Close(aFile);
		{ Inicializamos la variable LZFile }
		Initialize;
		{ Decrementamos el nmero de LZW abiertos }
		Dec(LZOpened);
		{$IFDEF _DEBUG_}
		System.close(fich);
		{$ENDIF}
	End;

begin
	{ Inicializamos la variable LZFile }
	Initialize;
	{$IFDEF _DEBUG_}
	system.Assign(fich,'LZFiles.DBG');
	system.Rewrite(fich);
	{$ENDIF}
end.