unit menus;

INTERFACE

type
	Tmenu=record
		NombreMenu:string[15];
		PosicionCursor,NumeroOpciones:byte;
		NombreSubMenu:array[1..10] of string[30];
		rutina:array[1..10] of procedure;
		ayuda:array[1..10] of string[80];
		CodigoTecla:array[1..10] of char;
		tecla:array[1..10] of string[8];
	end;

	TmenuH=record
		menus:array[1..10] of Tmenu;
		TotalMenus:byte;
	end;

	TMenuBottom=record
		nombre:array[1..10] of string[25];
		tecla:array[1..10] of string[8];
		total:byte;
	end;

var
	menu:TmenuH;
	status:TMenuBottom;

procedure init;
procedure go;
procedure done;

IMPLEMENTATION

uses
	CRT,DOS,MyDOS,cadenas,speed;

const
	CodigoAlt:array[ALT_Q..ALT_M] of char=
		('q','w','e','r','t','y','u','i','o','p',' ',' ',' ',' ',
		 'a','s','d','f','g','h','j','k','l',' ',' ',' ',' ',' ',
		 'z','x','c','v','b','n','m');

var
	n,m,x,y,x1,y1:integer;
	tecla:char;
	mayor,cx:array[0..10] of byte;
	ventana:Tventana;
	va:boolean;

procedure MarcoStandard;
begin
	ventana.Usar3D:=TRUE;
	ventana.marco:='Ŀ';
	ventana.ColorMarco:=NEGRO;
	ventana.CentrarTitulo:=SIN_CENTRAR;
	ventana.ColorVentana:=GRIS_CLARO;
end;

procedure VerAyuda(x,y:integer);
var
	cx,cy:integer;

begin
	cx:=WindMin;cy:=WindMax;

	window(1,25,80,25);
	TextColor(NEGRO);
	TextBackGround(GRIS_CLARO);

	GotoXY(1,1);
	ClrEOL;
	Gotoxy(2,1);
	write(menu.menus[x].ayuda[y]);

	window(lo(cx)+1,hi(cx)+1,lo(cy)+1,hi(cy)+1);
end;

procedure NegritaSubMenu;
var
	n,m:byte;

begin
	GotoXY(1,y1);
	TextBackGround(GRIS_CLARO);

	n:=pos('^',menu.menus[x].NombreSubMenu[y1]);
	if n>0 then
		for m:=1 to mayor[x] do
			begin
				if m-1=n then
					TextColor(ROJO)
				else
					TextColor(NEGRO);

				if menu.menus[x].NombreSubMenu[y1,m]<>'^' then
					write(menu.menus[x].NombreSubMenu[y1,m])
			end
	else
		write(menu.menus[x].NombreSubMenu[y1]);

	GotoXY(mayor[x]-length(menu.menus[x].tecla[y1])-1,y1);
	write(menu.menus[x].tecla[y1]);

	GotoXY(1,y);
	TextBackGround(VERDE_CLARO);
	n:=pos('^',menu.menus[x].NombreSubMenu[y]);
	if n>0 then
		for m:=1 to mayor[x] do
			begin
				if m-1=n then
					TextColor(ROJO)
				else
					TextColor(NEGRO);

				if menu.menus[x].NombreSubMenu[y,m]<>'^' then
					write(menu.menus[x].NombreSubMenu[y,m])
			end
	else
		write(menu.menus[x].NombreSubMenu[y]);

	GotoXY(mayor[x]-length(menu.menus[x].tecla[y])-1,y);
	write(menu.menus[x].tecla[y]);
	if y<menu.menus[x].NumeroOpciones then WriteLN;
	y1:=y;

	VerAyuda(x,y);
end;

procedure NegritaMenu;
var
	cero:byte;

begin
	window(1,1,80,25);
	if va then
		 begin
			 CerrarVentana;
			 va:=FALSE;
		 end;

	GotoXY(cx[x1],1);
	TextBackGround(GRIS_CLARO);
	n:=pos('^',menu.menus[x1].NombreMenu);
	if n>0 then
		for m:=1 to length(menu.menus[x1].NombreMenu) do
			begin
				if m-1=n then
					TextColor(ROJO)
				else
					TextColor(NEGRO);

				if menu.menus[x1].NombreMenu[m]<>'^' then
					write(menu.menus[x1].NombreMenu[m]);
			end
	else
		write(menu.menus[x1].NombreMenu);

	GotoXY(cx[x],1);
	TextBackGround(VERDE_CLARO);
	n:=pos('^',menu.menus[x].NombreMenu);
	if n>0 then
		for m:=1 to length(menu.menus[x].NombreMenu) do
			begin
				if m-1=n then
					TextColor(ROJO)
				else
					TextColor(NEGRO);

				if menu.menus[x].NombreMenu[m]<>'^' then
					write(menu.menus[x].NombreMenu[m]);
		end
	else write(menu.menus[x].NombreMenu);

	ventana.x1:=cx[x];ventana.y1:=2;
	ventana.x2:=cx[x]+mayor[x]+1;ventana.y2:=3+menu.menus[x].NumeroOpciones;
	AbrirVentana(ventana);
	for cero:=1 to menu.menus[x].NumeroOpciones do
		begin
			n:=pos('^',menu.menus[x].NombreSubMenu[cero]);
			if n>0 then
				for m:=1 to length(menu.menus[x].NombreSubMenu[cero]) do
					begin
						if m-1=n then
							TextColor(ROJO)
						else
							TextColor(NEGRO);

						if menu.menus[x].NombreSubMenu[cero,m]<>'^' then
							write(menu.menus[x].NombreSubMenu[cero,m]);
			end
				else write(menu.menus[x].NombreSubMenu[cero]);

			GotoXY(mayor[x]-length(menu.menus[x].tecla[cero])-1,cero);
			write(menu.menus[x].tecla[cero]);
			if cero<menu.menus[x].NumeroOpciones then WriteLN;
		end;

	y:=menu.menus[x].PosicionCursor;
	y1:=y;
	NegritaSubMenu;
	x1:=x;

	va:=TRUE;
end;

procedure VerStatus;
var
	a,cx,cy:integer;

begin
	cx:=WindMin;cy:=WindMax;
	window(1,25,80,25);
	Gotoxy(2,1);
	TextbackGround(GRIS_CLARO);
	for a:=1 to status.total do
		begin
			TextColor(ROJO);
			write(status.tecla[a],' ');
			TextColor(NEGRO);
			write(status.nombre[a],'  ');
		end;
	ClrEOL;
	window(lo(cx)+1,hi(cx)+1,lo(cy)+1,hi(cy)+1);
end;

procedure pantalla;

	procedure PonBarras;
begin
	GotoXY(1,25);
	TextBackGround(GRIS_CLARO);
	ClrEOL;
	Gotoxy(1,1);
	ClrEOL;
	GotoXY(2,25);
end;

var
	a,a1,b:integer;

begin
	mode(3);
	pen(GRIS_CLARO,AZUL);
	cls('');
	cursor(SIN_CURSOR);

	PonBarras;
	VerStatus;

	TextColor(NEGRO);
	GotoXY(2,1);
	for a:=1 to menu.TotalMenus do
		begin
			a1:=pos('^',menu.menus[a].NombreMenu);
			if a1>0 then
				begin
					cx[a]:=WhereX;
					for b:=1 to length(menu.menus[a].NombreMenu) do
						begin
							if b-1=a1 then TextColor(ROJO) else TextColor(NEGRO);
							if menu.menus[a].NombreMenu[b]<>'^' then
								write(menu.menus[a].NombreMenu[b]);
						end;
				end
			else
				write(menu.menus[a].NombreMenu);

			write('  ');
		end;
end;

procedure maximos;
var
	a,n,m:byte;

begin
	FillChar(mayor,SizeOf(mayor),0);

	for n:=1 to menu.TotalMenus do
		for m:=1 to menu.menus[n].NumeroOpciones do
			if mayor[n]<length(menu.menus[n].NombreSubMenu[m])+
									length(menu.menus[n].tecla[m]) then
				begin
					mayor[n]:=length(menu.menus[n].NombreSubMenu[m]);
					a:=length(menu.menus[n].tecla[m]);
					if a>1 then mayor[n]:=mayor[n]+a+5;
				end;
end;

procedure init;
begin
	maximos;
	pantalla;
	va:=FALSE;
end;

procedure go;
label sigue,final;

var
	r:registers;
	repite:boolean;
	caracter,codigo,cx,cy,xx,yy,at:integer;

begin
	if not(alt or control) then exit;

	r.AH:=1;
	intr($16,r);
	if TestBit(r.FLAGS,Fzero) then exit;
	codigo:=r.AH;
	caracter:=r.AL;

	if not KeyPressed then exit;
	tecla:=ReadKey;
	if not SpecialKey then
		begin
			r.AH:=5;
			r.CL:=caracter;
			r.CH:=codigo;
			intr($16,r);

			exit;
		end;

	if (SpecialKey) and  not((tecla in [F1..F10]) or
		(tecla in [CTRL_F1..CTRL_F10]) or (tecla in [ALT_F1..ALT_F10]) or
		(tecla in [ALT_Q..ALT_M])) then
		 begin
			r.AH:=5;
			r.CL:=caracter;
			r.CH:=codigo;
			intr($16,r);

			exit;
		 end;

	cx:=WhereX;cy:=WhereY;
	at:=TextAttr;
	xx:=WindMin;yy:=WindMax;
	cursor(SIN_CURSOR);

	repite:=FALSE;
	repeat
		if tecla=RETURN then
			begin
				va:=FALSE;
				CerrarVentana;		{Cierro la ventana del men}

				cursor(CURSOR_NORMAL);
				menu.menus[x].rutina[y];  {Ejecuto el procedimiento}
				break;
			end;

	 if (not SpecialKey) and (tecla in ['A'..'Z']) then
		 for n:=1 to menu.menus[x].NumeroOpciones do
			 if tecla=upper(copy(menu.menus[x].NombreSubMenu[n],
											pos('^',menu.menus[x].NombreSubMenu[n])+1,1)) then
				 begin
					 va:=FALSE;
					 CerrarVentana;
					 cursor(CURSOR_NORMAL);

					 VerAyuda(x,n);
					 menu.menus[x].rutina[n];
					 MarcoStandard;

					 y:=n;
					 goto final;
				 end;

		if (SpecialKey) and (tecla in [ALT_Q..ALT_M]) then
			begin
				for n:=1 to menu.TotalMenus do
					if char(UpCase(CodigoAlt[tecla]))=
									upper(copy(menu.menus[n].NombreMenu,
									pos('^',menu.menus[n].NombreMenu)+1,1)) then
						begin
							if va then CerrarVentana;
							va:=FALSE;
							x:=n;
							MarcoStandard;
							NegritaMenu;
							repite:=TRUE;
							goto sigue;
						end;
			end;

		if SpecialKey then
			for m:=1 to menu.TotalMenus do
				for n:=1 to menu.menus[m].NumeroOpciones do
					if menu.menus[m].CodigoTecla[n]=tecla then
						begin
							va:=FALSE;
							if repite then CerrarVentana;
							cursor(CURSOR_NORMAL);

							menu.menus[m].rutina[n];
							goto final;
						end;

		if SpecialKey then
			case tecla of
				IZQUIERDA:
					begin
						dec(x);
						if x<1 then x:=menu.TotalMenus;
						NegritaMenu;
					end;
				DERECHA:
					begin
						inc(x);
						if x>menu.TotalMenus then x:=1;
						NegritaMenu;
					end;
				ABAJO:
					begin
						inc(y);
						if y>menu.menus[x].NumeroOpciones then y:=1;
						menu.menus[x].PosicionCursor:=y;
						NegritaSubMenu;
					end;
				ARRIBA:
					begin
						dec(y);
						if y<1 then y:=menu.menus[x].NumeroOpciones;
						menu.menus[x].PosicionCursor:=y;
						NegritaSubMenu;
					end;
				INICIO:
					begin
						y:=1;
						NegritaSubMenu;
					end;
				FIN:
					begin
						y:=menu.menus[x].NumeroOpciones;
						NegritaSubMenu;
					end;
			end;

sigue:
		if not repite then break;

		tecla:=UpCase(ReadKey);
	until tecla=ESCAPE;

final:
	if va then CerrarVentana;
	va:=FALSE;

	VerStatus;

	TextAttr:=at;
	window(lo(xx)+1,hi(xx)+1,lo(yy)+1,hi(yy)+1);
	GotoXY(cx,cy);
	cursor(CURSOR_NORMAL);
end;

procedure done;
var
	n:integer;

begin
	for n:=1 to VentanasAbiertas do CerrarVentana;

	cursor(CURSOR_NORMAL);
	mode(3);
end;

begin
	FillChar(menu,SizeOf(menu),0);
	FillChar(status,SizeOf(status),0);

	CheckBreak:=FALSE;

	x:=1;y:=1;
	x1:=x;y1:=y;
end.