unit mikmod;

interface

type


ENVPT = record
        pos : word ;
        val : word ;
end;


SAMPLE = record
       c2spd     : word ;
       transpose : shortint ;
       volume    : byte ;
       panning   : byte ;
       length    : longint ;
       loopstart : longint ;
       loopend   : longint ;
       flags     : word ;
       seekpos   : longint ;
       samplename: PChar ;
       handle    : integer;
end;


INSTRUMENT = record
       numsmp      : byte ;
       samplenumber: array[0..95] of byte;

       volflg      : byte;
       volpts      : byte;
       volsus      : byte;
       volbeg      : byte;
       volend      : byte;
       volenv      : array[0..11] of ENVPT;

       panflg      : byte;
       panpts      : byte;
       pansus      : byte;
       panbeg      : byte;
       panend      : byte;
       panenv      : array[0..11] of ENVPT;


       vibtype     : byte;
       vibsweep    : byte;
       vibdepth    : byte;
       vibrate     : byte;

       volfade     : word;

       insname     : PChar;
       samples     : ^SAMPLE;
end;


UNIMOD = record
       numchn   : byte ;
       numpos   : word ;
       numpat   : word ;
       numtrk   : word ;
       numins   : word ;
       initspeed: byte ;
       inittempo: byte ;
       positions: array[0..255] of byte ;
       panning  : array [0..31] of byte ;
       flags    : byte ;
       songname : PChar;
       modtype  : PChar;
       comment  : PChar;
       instruments : ^instrument;
       patterns : ^word;
       pattrows : ^word;
       tracks   : ^PChar;
end;

PUNIMOD = ^UNIMOD ;


LOADER = record
       next    : pointer;
       modtype : PChar;
       version : PChar;
       Init    : pointer;
       Test    : pointer;
       Load    : pointer;
       Cleanup : pointer;
end;

PLOADER = ^LOADER;


GHOLD = record
     kick   : byte ;
     active : byte ;
     flags  : word ;
     handle : integer;
     start  : longint;
     size   : longint;
     reppos : longint;
     repend : longint;
     frq    : longint;

     vol    : byte;
     pan    : byte;

     iter   : word;
     current: longint;
     increment: longint;
     lvoltab: pointer;
     rvoltab: pointer;
end;


DRIVER = record
     next          : pointer;
     Name          : PChar;
     Version       : PChar;
     IsPresent     : pointer;
     SampleLoad    : pointer;
     SampleUnLoad  : pointer;
     Init          : pointer;
     Exit          : pointer;
     PlayStart     : pointer;
     PlayStop      : pointer;
     Update        : pointer;
end;

PDRIVER = ^DRIVER;

const finetune : array[0..15] of integer = (
	8363,	8413,	8463,	8529,	8581,	8651,	8723,	8757,
	7895,	7941,	7985,	8046,	8107,	8169,	8232,	8280
);

var modfd        : integer;
    oof          : UNIMOD;
    myerr        : PChar;
    md_device    : word ;
    md_mixfreq   : word ;
    md_mode      : word ;
    md_dmabufsize: word ;
    md_numchn    : byte ;
    ghld         : array[0..31] of GHOLD;
    mp_bpm       : byte;
    mp_patpos    : word;
    mp_sngpos    : integer;
    mp_sngspd    : word;
    mp_numchn    : byte;
    mp_loop      : wordbool;
    mp_panning   : wordbool;
    mp_extspd    : wordbool;
    mp_volume    : byte;


{ LOADER Definitions: }
function  ML_LoadFN(name : PChar) : PUNIMOD ; far ;
function  ML_LoadFD(fd : integer) : PUNIMOD ; far ;
procedure ML_RegisterLoader(ldr : PLOADER) ; far ;
procedure ML_Free(w : PUNIMOD) ; far ;


{ DRIVER Definitions: }
procedure MD_RegisterDriver(p : PDRIVER) ; far ;
function  MD_Init : wordbool ; far ;
procedure MD_Exit ; far ;
procedure MD_PlayStart ; far ;
procedure MD_PlayStop ; far ;
procedure MD_Update ; far ;


{ PLAYER Definitions: }
procedure MP_Init(w : PUNIMOD) ; far ;
procedure MP_HandleTick ; far ;
procedure MP_NextPosition ; far ;
procedure MP_PrevPosition ; far ;
function  MP_Ready : wordbool ; far ;

{ The gus driver: }
function pgusdriver : PDRIVER ; far ;

{ The nosound driver: }
function pnosnddriver : PDRIVER ; far ;

{ .UNI loader }
function puniload : PLOADER ; far ;


implementation

{ LOADER Definitions: }

function  ML_LoadFN(name : PChar) : PUNIMOD ; external;
function  ML_LoadFD(fd : integer) : PUNIMOD ; external;
procedure ML_RegisterLoader(ldr : PLOADER) ; external;
procedure ML_Free(w : PUNIMOD) ; external;

{ DRIVER Definitions: }
procedure MD_RegisterDriver(p : PDRIVER) ; external ;
function  MD_Init : wordbool ; external ;
procedure MD_Exit ; external ;
procedure MD_PlayStart ; external ;
procedure MD_PlayStop ; external ;
procedure MD_Update ; external ;

{ PLAYER Definitions: }
procedure MP_Init(w : PUNIMOD) ; external ;
procedure MP_HandleTick ; external ;
procedure MP_NextPosition ; external ;
procedure MP_PrevPosition ; external ;
function  MP_Ready : wordbool ; external ;

{ The gus driver: }
function pgusdriver : PDRIVER ; external;

{ The nosound driver: }
function pnosnddriver : PDRIVER ; external;

{ .UNI loader }
function puniload : PLOADER ; external;

{$L UNILOAD.OBJ}
{$L MLOADER.OBJ}
{$L MUNITRK.OBJ}
{$L MDRIVER.OBJ}
{$L MPLAYER.OBJ}
{$L MMIO.OBJ}
{$L GUSDEV.OBJ}
{$L NOSNDDEV.OBJ}

begin
    md_device:=0;
    md_mixfreq:=44100;
    md_mode:=0;
    md_dmabufsize:=8192;
    md_numchn:=0;
    mp_extspd:=TRUE;
    mp_panning:=TRUE;
    mp_loop:=FALSE;
    mp_volume:=100;
    mp_numchn:=0;
end.
