unit mode13;

INTERFACE

uses
	colors,Engine3D
{$IFDEF _SYNCRO_}
	,MyMidas
{$ENDIF}
	;

const
	XMAX=319;
	YMAX=199;
	CENTERX:word=160;
	CENTERY:word=100;
	BPP=8;
	LINE_WIDTH=320;

	CIRCLE_ADJUST=0.707106781;
	FIX_ASPECT_RATIO=1.2;

	TEXT_HEIGHT=8;
	TEXT_WIDTH=8;

type
	TMode=(	NOP,
					COPY,HALF_COPY,
					COPY_BACKGROUND,HALF_COPY_BACKGROUND,
					COPY_SCROLL,COPY_CLEAR_SCROLL,
					COPY_CLEAR,HALF_COPY_CLEAR,
					SHADE,HALF_SHADE,
					SHADE_BACKGROUND,
					COPY_ZOOM,
					COPY_CLEAR_ZOOM,
					FLAME,HALF_FLAME,
					COPY_MESH,COPY_CLEAR_MESH,COPY_BACKGROUND_MESH,
					COPY_BLUR,COPY_CLEAR_BLUR,COPY_BACKGROUND_BLUR,
					COPY_GRANULATE,COPY_CLEAR_GRANULATE,COPY_BACKGROUND_GRANULATE,
					DESINTEGRATE,
					SHADE_BLUR,
					SUPER_BLUR,
					COPY_BIG,COPY_CLEAR_BIG);

	TClip=record
		xul,yul,
		xlr,ylr:word
	end;

const
	region:TClip=(xul:0;yul:0;xlr:XMAX;ylr:YMAX);
	MyFrames:LongInt=0;

var
	MultByWidth:array[0..YMAX] of word;

	VGA,PvRAM,PBackPage:^byte;
	vRAM,BackPage:word;

	c_x1,c_y1,
	c_x2,c_y2:integer;		 	{coordinates after clip}

	ShadeTable:array[0..255] of byte;	{shaded table of colors for DIFUMINE modes...}
	vRAMSize:word;

function init(m:TMode):boolean;
{Cambia el modo de video}

procedure done;
{Devuelve el anterior modo de video}

procedure OutTextXY(x:integer;y:integer;color:byte;cadena:string);
{Escribe la cadena CADENA en las coordenadas XY con color y fondo}

procedure OutNumXY(x,y:integer;color:byte;num:LongInt);
{Escribe el nmero num en las coordenadas XY con el color y fondo}

procedure print(x,y:integer;color1,color2:byte;cadena:string;num:LongInt);

function test(x,y:integer):byte;
{devuelve el color de las coordenadas XY}

function TestBack(x,y:integer):byte;
{devuelve el color de las coordenadas XY de la pgina de fondo}

procedure plot(x,y:integer;col:byte);
{Pone el color COL en las coordenadas XY}

procedure PlotBack(x,y:integer;col:byte);
{Pone el color COL en las coordenadas XY en la pgina de fondo}

procedure draw(x1,y1,x2,y2:integer;color:byte);
{dibuja una lnea desde X1Y1 hasta X2Y2 con el color COLOR}

procedure DrawH(x1,y,x2:integer;color:byte);
{dibuja una lnea horizontal desde X1Y1 hasta X2 con el color COLOR}

procedure DrawV(x,y1,y2:integer;color:byte);
{dibuja una lnea vertical desde X1Y1 hasta Y2 con el color COLOR}

procedure circle(x,y,radio:integer;color:byte);
{Dibuja un crculo en las coordenadas X e Y con RADIO y COLOR}

procedure ellipse(xx,yy,a0,b0:integer;color:byte);
{Dibuja un elipse en las coordenadas XX e YY con el radio A0 y B0 y COLOR}

procedure rectangle(x1,y1,x2,y2:integer;color:byte);
{Borra el rectngulo dado con el color COLOR en x1y1x2y2}

procedure box(x1,y1,x2,y2:integer;color:byte);
{Pone un caja en X1Y1, X2Y2 con COLOR}

function Clip2D(x1,y1,x2,y2:integer):boolean;
{Hace un clipping de x1 y1 , x2 y2}

function StartFrame:integer;
{inicializa la rutina de frames, se pone antes de empezar la rutina}

function anima:integer;
{Espera al barrido, actua segn el modo de transferencia
y devuelve los frames a saltarse cuando se define _SYNCRO_}

procedure SetTransferMode(t:TMode);
{Activa el modo t}
function GetTransferMode:TMode;
{Devuelve el modo actual de transferencia}

function LoadPCX(n:string;s:pointer;var p:Tpal):boolean;
{Carga un PCX en s y devuelve la paleta p}
function LoadLBM(n:string;d:pointer;var c:Tpal):boolean;
{Carga un LBM en s y devuelve la paleta c}

procedure FillEllipse(x,y,rx,ry,color:integer);
{hace una elipse en x (128) e y(50) con radios rx,xy y color}

procedure SetNormalShade;
{Pone por defecto los valores para los modo difumine}

procedure SetSyncro(w:boolean);
function GetSyncro:boolean;
procedure frame;
{$IFDEF _SYNCRO_}
INLINE(
	$66/$A1/frames/     {			MOV	EAX,frames}
	$66/$3B/$06/frames/ {@1:	CMP	frames,EAX}
	$74/$F9);						{			JZ	@1}
{$ENDIF}

{Espera un barrido de pantalla}

procedure WaitDE;
{Espera a que el barrido empieze}

procedure WaitVR;
{Espera a que el barrido acabe}

procedure VGAon;
{Enciende la VGA}

procedure VGAoff;
{Apaga la VGA}

function VGAExist:boolean;
{TRUE si hay VGA}

function LoadIMG(n:string;segment:pointer;var p:Tpal):boolean;

function LoadTransparency(var t:PTransparency;n:string):boolean;
procedure FreeTransparency(var t:PTransparency);

procedure SetBackgroundColor(n:byte);
{Define el color del fondo}
function GetBackgroundColor:byte;
{Define el color del fondo}

procedure SetShade(factor:double;var palette:Tpal);
procedure SetDesintegrate(f:integer);

procedure delay(m:double);

procedure SetZoom(x:integer);

procedure SortPal(var p:Tpal);
{Ordena una paleta por distancia de RGB}

procedure InitSuperBlur(t:PTransparency);

procedure SetDirect(b:boolean);
{Pone la escritura directa a la pantalla}

procedure Fflame;

procedure SetTimerInterrupt;
procedure RestoreTimerInterrupt;

procedure ScanLines(n:word);

IMPLEMENTATION

uses dos,MyDOS,OP386,memory,Anima13,mem,RLE,speed,math,
{$IFDEF _LZ_}
	LZFiles;
{$ELSE}
	{$IFDEF _RLE_}
	RLEFiles;
	{$ELSE}
	files;
{$ENDIF}
{$ENDIF}

const
	BackgroundColor:LongInt=0;

var
	TransferMode:TMode;

function init(m:TMode):boolean;
var
	n:word;

begin
	init:=FALSE;
	if not VGAexist then exit;
	for n:=0 to YMAX do MultByWidth[n]:=n*LINE_WIDTH;
	SetBackgroundColor(0);

	{$IFDEF _SYNCRO_}
	StopScreenSyncro;
	{$ENDIF}

	ASM
		MOV		AX,$13
		INT		$10
	END;

	{$IFDEF _SYNCRO_}
	SetScreenSyncro(GetScreenSyncro);
	{$ENDIF}

	vRAMSize:=320*(YMAX+5);
	case m of
		COPY,HALF_COPY,
		COPY_CLEAR,HALF_COPY_CLEAR,
		SHADE,HALF_SHADE,
		COPY_ZOOM,COPY_CLEAR_ZOOM,
		FLAME,HALF_FLAME,
		COPY_MESH,COPY_CLEAR_MESH,
		COPY_BLUR,COPY_CLEAR_BLUR,
		COPY_GRANULATE,COPY_CLEAR_GRANULATE,
		SHADE_BLUR,
		COPY_SCROLL,COPY_CLEAR_SCROLL,
		COPY_BIG,COPY_CLEAR_BIG:
			begin
				if MemAvail<vRAMSize then exit;

				PvRAM:=MemAllocSeg(vRAMSize);
				FillChar(PvRAM^,vRAMSize ,BackgroundColor);
				vRAM:=seg(PvRAM^);
			end;

		COPY_BACKGROUND,HALF_COPY_BACKGROUND,
		COPY_BACKGROUND_MESH,
		COPY_BACKGROUND_BLUR,
		COPY_BACKGROUND_GRANULATE,
		SHADE_BACKGROUND,
		DESINTEGRATE,
		SUPER_BLUR:
			begin
				if MemAvail<vRAMSize*2 then exit;

				PvRAM:=MemAllocSeg(vRAMSize);
				FillChar(PvRAM^,vRAMSize,BackgroundColor);
				vRAM:=seg(PvRAM^);

				PBackPage:=MemAllocSeg(vRAMSize);
				FillChar(PBackPage^,vRAMSize,BackgroundColor);
				BackPage:=seg(PBackPage^);
			end;
	end;

	SetTransferMode(m);

	init:=TRUE;
end;

procedure done;
begin
	ASM
		MOV		AX,3
		INT		$10
	END;

	case TransferMode of
		COPY_BACKGROUND,HALF_COPY_BACKGROUND,
		COPY_BACKGROUND_MESH,
		COPY_BACKGROUND_BLUR,
		COPY_BACKGROUND_GRANULATE,
		SHADE_BACKGROUND,
		DESINTEGRATE,
		SUPER_BLUR,
		COPY_BLUR:
			begin
				FreeMem(PvRAM,vRAMSize);
				FreeMem(PBackPage,vRAMSize);
			end;

		COPY_SCROLL,COPY_CLEAR_SCROLL,
		COPY,HALF_COPY,
		COPY_CLEAR,HALF_COPY_CLEAR,
		SHADE,HALF_SHADE,
		COPY_ZOOM,COPY_CLEAR_ZOOM,
		FLAME,HALF_FLAME,
		COPY_MESH,COPY_CLEAR_MESH,
		COPY_BLUR,COPY_CLEAR_BLUR,
		COPY_GRANULATE,COPY_CLEAR_GRANULATE,
		SHADE_BLUR,
		COPY_BIG,COPY_CLEAR_BIG:FreeMem(PvRAM,vRAMSize);
	end;
end;

procedure OutTextXY(x:integer;y:integer;color:byte;cadena:string);

	procedure text(xx,yy:integer;caracter:char;c:byte);ASSEMBLER;
ASM
	PUSH		DS

	MOV			BX,yy
	ADD			BX,BX
	MOV			DI,xx
	ADD			DI,WORD(MultByWidth[BX])

	MOV			ES,Seg0040
	MOV			CX,ES:[$85]
	MOV			ES,Seg0000
	MOV			SI,ES:[$43*4]
	MOV			ES,vRAM
	MOV			DS,SegC000

	MOV			AL,caracter
	MUL			CL
	ADD			SI,AX
	MOV			BL,c

@Y:
	MOV			CH,TEXT_WIDTH
	MOV			AH,[SI]
	INC			SI

@X:
	ADD			AH,AH
	JNC			@SIGUE
	MOV			ES:[DI],BL

@SIGUE:
	INC			DI
	DEC			CH
	JNZ			@X

	ADD			DI,LINE_WIDTH-TEXT_HEIGHT
	DEC			CL
	JNZ			@Y

	POP			DS
END;

var
	a,m:byte;
	cx:integer;

begin
	if (word(y+8)>YMAX) or (x+8>XMAX) or (y<0) then exit;

	cx:=x;
	a:=1;
	if x<0 then
		begin
			inc(a,abs(cx div TEXT_WIDTH)+1);
			cx:=0;
		end;

	if x+(length(cadena)*TEXT_WIDTH)>XMAX then dec(cadena[0],(x+(length(cadena)*TEXT_WIDTH)-XMAX) div TEXT_WIDTH+1);
	for m:=a to length(cadena) do
		begin
			text(cx,y,cadena[m],color);
			inc(cx,TEXT_WIDTH);
		end;
end;

procedure OutNumXY(x,y:integer;color:byte;num:LongInt);
var
	s:string;

begin
	if num<0 then
		begin
			OutTextXY(x,y,color,'-');
			inc(x,TEXT_WIDTH);
			num:=abs(num);
		end;
	str(num,s);
	OutTextXY(x,y,color,s);
end;

procedure print(x,y:integer;color1,color2:byte;cadena:string;num:LongInt);
var
	s:string;

begin
	OutTextXY(x,y,color1,cadena);
	inc(x,(length(cadena)+1)*TEXT_WIDTH);

	str(num,s);
	OutTextXY(x,y,color2,s);
end;

function test(x,y:integer):byte;ASSEMBLER;
ASM
	MOV			BX,y
	CMP			BX,region.ylr
	JA			@SIGUE
	ADD			BX,BX

	MOV			DI,x
	CMP			DI,region.xlr
	JA			@SIGUE
	ADD			DI,WORD(MultByWidth[BX])

	MOV			ES,vRAM
	MOV			AL,ES:[DI]

@SIGUE:
END;

function TestBack(x,y:integer):byte;ASSEMBLER;
ASM
	MOV			BX,y
	CMP			BX,region.ylr
	JA			@SIGUE

	MOV			DI,x
	CMP			DI,region.xlr
	JA			@SIGUE
	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			ES,BackPage
	MOV			AL,ES:[DI]

@SIGUE:
END;

procedure plot(x,y:integer;col:byte);ASSEMBLER;
ASM
	MOV			BX,y
	CMP			BX,region.ylr
	JA			@SIGUE
	ADD			BX,BX

	MOV			DI,x
	CMP			DI,region.xlr
	JA			@SIGUE
	ADD			DI,WORD(MultByWidth[BX])

	MOV			ES,vRAM
	MOV			AL,col
	MOV			ES:[DI],AL

@SIGUE:
END;

procedure PlotBack(x,y:integer;col:byte);ASSEMBLER;
ASM
	MOV			BX,y
	CMP			BX,region.ylr
	JA			@SIGUE
	ADD			BX,BX

	MOV			DI,x
	CMP			DI,region.xlr
	JA			@SIGUE
	ADD			DI,WORD(MultByWidth[BX])

	MOV			ES,BackPage
	MOV			AL,col
	MOV			ES:[DI],AL

@SIGUE:
END;

var
	d,dInc1,dInc2,NumPixels,cx1,cy1,cx2,cy2:integer;

procedure draw(x1,y1,x2,y2:integer;color:byte);ASSEMBLER;
ASM
	PUSH	BP

	MOV		BX,x1
	MOV		CX,y1
	MOV		DX,x2
	MOV		AX,y2

	CMP		BX,DX         {if x1>x2 then swap(x1,x2);swap(y1,y2);}
	JLE		@YM
	XCHG	BX,DX
	XCHG	CX,AX

@YM:
	MOV		cx1,BX
	MOV		cy1,CX
	MOV		cx2,DX
	MOV		cy2,AX

	SUB		DX,BX
	JZ		@LINE_V       {if DeltaX=0 then DrawV(x1,y1,y2,color);}
	JGE		@XS
	NEG		DX       			{DeltaX:=abs(DeltaX);}

@XS:
	SUB		AX,CX
	JZ		@LINE_H       {if DeltaY=0 then DrawH(x1,y1,x2,color);}
	JGE		@YS
	NEG		AX       			{DeltaY:=abs(DeltaY);}

@YS:
	PUSH	DS
	{$IFDEF __BPPROT__}
	MOV		CX,CS
	ADD		CX,SelectorInc
	MOV		DS,CX
	MOV		CL,color
	MOV		BYTE(DS:@PRINCIPAL+3),CL
	{$ELSE}
	MOV		CL,color
	MOV		BYTE(CS:@PRINCIPAL+3),CL
	{$ENDIF}
	POP		DS

	CMP		DX,AX
	JL		@DELTA_MENOR	{if DeltaX >= DeltaY then...}

	MOV		CX,AX
	ADD		CX,CX
	MOV		dInc1,CX      {dInc1 := DeltaY Shl 1;}

	SUB		AX,DX
	ADD		AX,AX
	MOV		dInc2,AX			{dinc2 := (DeltaY - DeltaX) shl 1;}

	SUB		CX,DX
	MOV		d,CX          {d := (2 * DeltaY) - DeltaX;}

	MOV		CX,DX
	INC		CX
	MOV		NumPixels,CX	{NumPixels := DeltaX + 1;}

	MOV		AX,1       		{xInc1=1}
	MOV		SI,0       		{yInc1=0}

	MOV		DX,AX       	{xInc2=1}
	MOV		BP,LINE_WIDTH       	{yInc2=1}

	JMP		@CONTINUE

@DELTA_MENOR:
	MOV		CX,DX
	ADD		CX,CX
	MOV		dInc1,CX      {dInc1 := DeltaX Shl 1;}

	SUB		DX,AX
	ADD		DX,DX
	MOV		dInc2,DX			{dinc2 := (DeltaX - DeltaY) shl 1;}

	SUB		CX,AX
	MOV		d,CX          {d := (2 * DeltaX) - DeltaY;}

	MOV		CX,AX
	INC		CX
	MOV		NumPixels,CX	{NumPixels := DeltaY + 1;}

	MOV		AX,0      		{xInc1=0}
	MOV		SI,LINE_WIDTH       	{yInc1=1}

	MOV		DX,1       		{xInc2=1}
	MOV		BP,SI       	{yInc2=1}

@CONTINUE:
	MOV		DI,cy1
	CMP		DI,cy2
	JLE		@Y_MENOR
	NEG		SI						{yInc1 := - yInc1;}
	NEG		BP						{yInc2 := - yInc2;}

@Y_MENOR:
	MOV		CX,cx1
	CMP		CX,cx2
	JLE		@X_MENOR
	NEG		AX            {xInc1 := - xInc1;}
	NEG		DX            {xInc2 := - xInc2;}

@X_MENOR:
	ADD   SI,AX					{ScreenInc1 := yInc1 * LINE_WIDTH + xInc1;}
	ADD		BP,DX					{ScreenInc2 := yInc2 * LINE_WIDTH + xInc2;}

	ADD		DI,DI
	MOV		DI,WORD(MultByWidth[DI])
	ADD		DI,CX

	MOV		CX,NumPixels
	MOV		DX,d

	MOV		BX,dInc1
	MOV		AX,dInc2

	MOV		ES,vRAM

@PRINCIPAL:      			{ALIGN 16}
	MOV		BYTE(ES:[DI]),$ff

	TEST	DX,DX
	JGE		@MAYOR
											{d<0}
	ADD		DI,SI
	ADD		DX,BX         {inc(d,dInc1);}
	JMP		@SIGUE

@MAYOR:  							{d>=0}
	ADD		DI,BP
	ADD		DX,AX         {inc(d,dInc2);}

@SIGUE:
	DEC		CX
	JNZ		@PRINCIPAL
	JMP		@FIN

@LINE_H:
	MOV		DI,CX		{CX=y1}
	ADD		DI,DI
	MOV		DI,WORD(MultByWidth[DI])
	ADD		DI,BX   {BX=x1}

	MOV		CX,cx2  {DX=x2}
	INC		CX
	SUB		CX,BX
	JL		@FIN    {if x2-x1=0 then goto fin}

	MOV		AL,color
	MOV		AH,AL
	MOV		BX,AX
	DB		_386;SHL AX,16
	MOV		AX,BX

	MOV		ES,vRAM

	MOV		DL,CL
	AND		DL,3
	SHR		CX,2
	REP;	DB _386;STOSW     {REP STOSD}
	MOV		CL,DL
	REP		STOSB

	JMP		@FIN

@LINE_V:
	CMP		AX,CX
	JBE		@MENOR
	XCHG	AX,CX

@MENOR:
	MOV		DI,AX		{AX=y2,CX=y1}
	ADD		DI,DI
	MOV		DI,WORD(MultByWidth[DI])
	ADD		DI,BX		{BX=x1}

	SUB		CX,AX
	INC		CX

	MOV		AL,color

	PUSH	DS
	MOV		DS,vRAM

	MOV		BX,LINE_WIDTH

@BUCLE_V:             		{ALIGN 16}
	MOV		[DI],AL
	ADD		DI,BX
	DEC		CX
	JNZ		@BUCLE_V

	POP		DS

@FIN:
	POP		BP
END;

procedure DrawH(x1,y,x2:integer;color:byte);ASSEMBLER;
ASM
	MOV			ES,vRAM

	MOV			BX,region.xul
	MOV			DX,region.xlr

	MOV			AX,x1
	MOV			CX,x2

	CMP			AX,CX
	JLE			@SIGUE
	XCHG		AX,CX     {if x1>x2 then swap(x1,x2);}

@SIGUE:
	CMP			AX,DX
	JG			@SALIR		{if x1>region.xlr then goto fin}

	CMP			AX,BX
	JGE			@SIGUE1
	MOV			AX,BX     {if x1<region.xul then x1:=region.xul}

@SIGUE1:
	CMP			CX,BX
	JL			@SALIR    {if x2<region.xul then goto salir}

	CMP			CX,DX
	JLE			@SIGUE2
	MOV			CX,DX     {if x2>region.xlr then x2:=region.xlr}

@SIGUE2:
	MOV			BX,y
	CMP			BX,region.ylr
	JG			@SALIR    {if y>region.ylr then goto fin}

	CMP			BX,region.yul
	JL			@SALIR		{if y<region.yul then goto fin}

	ADD			BX,BX
	MOV			DI,AX
	ADD			DI,WORD(MultByWidth[BX])

	SUB			CX,AX
	JL			@SALIR
	INC			CX

	MOV			AL,color
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL		AX,16
	MOV			AX,BX

	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;STOSW     {REP STOSD}
	MOV			CL,DL
	REP			STOSB

@SALIR:
END;

procedure DrawV(x,y1,y2:integer;color:byte);ASSEMBLER;
ASM
	PUSH		DS

	MOV			DI,y1
	MOV			CX,y2

	CMP			DI,CX
	JLE			@SIGUE
	XCHG		DI,CX

@SIGUE:
	MOV			BX,region.yul
	MOV			DX,region.ylr

	CMP			DI,DX
	JG			@SALIR		{if y1>region.ylr then goto fin}

	CMP			CX,BX
	JL			@SALIR    {if y2<region.yul then goto salir}

	CMP			DI,BX
	JGE			@SIGUE1
	MOV			DI,BX     {if y1<region.yul then y1:=region.yul}

@SIGUE1:
	CMP			CX,DX			{if y2>region.ylr then y2:=region.ylr}
	JLE			@SIGUE2
	MOV			CX,DX

@SIGUE2:
	MOV			BX,x
	CMP			BX,region.xlr
	JG			@SALIR        {if x>region.xlr then goto fin}

	CMP			BX,region.xul	{if x<region.xul then goto fin}
	JL			@SALIR

	SUB			CX,DI
	JL			@SALIR
	INC			CX

	ADD			DI,DI
	MOV			DI,WORD(MultByWidth[DI])
	ADD			DI,BX

	MOV			AL,color
	MOV			DX,LINE_WIDTH
	MOV			DS,vRAM

@BUCLE:                 {ALIGN 16}
	MOV			[DI],AL
	ADD			DI,DX
	DEC			CX
	JNZ			@BUCLE

@SALIR:
	POP			DS
END;

procedure circle(x,y,radio:integer;color:byte);

	procedure Set4Pixels(x,y,xx,yy:integer;col:byte);
begin
	plot(x+xx,y+yy,color);
	plot(x-xx,y+yy,color);
	plot(x+xx,y-yy,color);
	plot(x-xx,y-yy,color);
end;

var
	xl,yl:integer;

Begin
	xl:=0;
	yl:=radio;
	radio:=sqr(radio)+1;

	repeat
		Set4Pixels(x,y,xl,yl,color);

		if sqr(xl)+sqr(yl)>=radio then
			dec(yl)
		else
			inc(xl);

	until yl=0;

	Set4Pixels(x,y,xl,yl,color);
end;

procedure ellipse(xx,yy,a0,b0:integer;color:byte);

	procedure Set4Pixels(x,y,xx,yy:integer;col:byte);
begin
	plot(x+xx,y+yy,color);
	plot(x-xx,y+yy,color);
	plot(x+xx,y-yy,color);
	plot(x-xx,y-yy,color);
end;

var
	x,y:integer;
	a,b,asquared,TwoAsquared,BSquared,TwoBSquared,d,dx,dy:LongInt;

begin
	x:=0;y:=b0;
	a:=a0;b:=b0;
	asquared:=sqr(a);
	TwoAsquared:=2*asquared;
	BSquared:=sqr(b);
	TwoBSquared:=2*BSquared;
	d:=BSquared-asquared*b+asquared div 4;
	dx:=0;
	dy:=TwoAsquared*b;

	while dx<dy do
		begin
			Set4Pixels(x,y,xx,yy,color);
			if d>0 then
				begin
					dec(y);
					dec(dy,TwoAsquared);
					dec(d,dy);
				end;

			inc(x);
			inc(dx,TwoBSquared);
			inc(d,BSquared+dx);
		end;

	inc(d,(3*(asquared-BSquared) div 2-(dx+dy)) div 2);
	while y>=0 do
		begin
			Set4Pixels(x,y,xx,yy,color);
			if d<0 then
				begin
					inc(x);
					inc(dx,TwoBSquared);
					inc(d,dx);
				end;
			dec(y);
			dec(dy,TwoAsquared);
			inc(d,asquared-dy);
		end;
end;

procedure rectangle(x1,y1,x2,y2:integer;color:byte);ASSEMBLER;
ASM
	MOV			ES,vRAM

	MOV			BX,region.xul
	MOV			DX,region.xlr

	MOV			DI,x1
	MOV			CX,x2
	CMP			DI,CX
	JLE			@SIGUE
	XCHG		DI,CX     {if x1>x2 then swap(x1,x2);}

@SIGUE:
	CMP			DI,DX
	JG			@SALIR		{if x1>region.xlr then goto fin}

	CMP			DI,BX
	JGE			@SIGUE1
	MOV			DI,BX     {if x1<region.xul then x1:=region.xul}

@SIGUE1:
	CMP			CX,BX
	JL			@SALIR    {if x2<region.xul then goto salir}

	CMP			CX,DX
	JLE			@SIGUE2
	MOV			CX,DX     {if x2>region.xlr then x2:=region.xlr}

@SIGUE2:
	MOV			BX,y1
	MOV			SI,y2
	CMP			BX,SI
	JLE			@SIGUE3
	XCHG		BX,SI     {if y1<y2 then swap(y1,y2)}

@SIGUE3:
	MOV			DX,region.ylr

	CMP			BX,DX
	JG			@SALIR    {if y1>region.ylr then goto fin}

	CMP			BX,region.yul
	JL			@SALIR		{if y1<region.yul then goto fin}

	CMP			SI,region.yul
	JL			@SALIR		{if y2<region.yul then goto fin}

	CMP			SI,DX
	JLE			@SIGUE4		{if y2>region.ylr then y2:=region.ylr}
	MOV			SI,DX

@SIGUE4:
	SUB			SI,BX
	JL			@SALIR
	INC			SI

	SUB			CX,DI
	JL			@SALIR
	INC			CX

	ADD			BX,BX
	ADD			DI,WORD(MultByWidth[BX])

	MOV			AL,color
	MOV			AH,AL
	MOV			BX,AX
	DB			_386;SHL		AX,16
	MOV			AX,BX

	PUSH		BP
	MOV			BP,320
	SUB			BP,CX
	MOV			BX,CX

@Y:
	MOV			CX,BX
	MOV			DL,CL
	AND			DL,3
	SHR			CX,2
	REP;		DB _386;STOSW     {REP STOSD}
	MOV			CL,DL
	REP			STOSB

	ADD			DI,BP
	DEC			SI
	JNZ			@Y
	POP			BP

@SALIR:
END;

procedure box(x1,y1,x2,y2:integer;color:byte);
begin
	DrawH(x1,y1,x2,color);
	DrawH(x1,y2,x2,color);

	DrawV(x1,y1,y2,color);
	DrawV(x2,y1,y2,color);
end;

{function Clip2D(var x1,y1,x2,y2:integer):boolean;
type
	OcsRec=record
		code0,code1,code2,code3:boolean;
	end;

	OutCodeRec=record
		case boolean of
			0:(OutCodes:LongInt);
			1:(ocs:OcsRec);
		end;

procedure SetOutCodes(var u:OutCodeRec;x,y:integer);
begin
	u.OutCodes:=0;
	u.ocs.code0:=(x<region.xul);
	u.ocs.code1:=(y<region.yul);
	u.ocs.code2:=(x>region.xlr);
	u.ocs.code3:=(y>region.ylr);
end;

procedure Swap(var pa,pb:integer);
var
	t:integer;

begin
	t:=pa;
	pa:=pb;
	pb:=t
end;

var
	ocu1,ocu2,ocu3:OutCodeRec;
	Inside,Outside:boolean;

begin
	SetOutCodes(ocu1,x1,y1);
	SetOutCodes(ocu2,x2,y2);

	Inside:=(ocu1.OutCodes or ocu2.OutCodes)=0;
	Outside:=(ocu1.OutCodes and ocu2.OutCodes)<>0;

	while (not OutSide) and (not InSide) do
		begin
			if ocu1.OutCodes=0 then
				begin
					swap(x1,x2);
					swap(y1,y2);

					ocu3:=ocu1;
					ocu1:=ocu2;
					ocu2:=ocu3
				end;

			if ocu1.ocs.code0 then
				begin
					y1:=y1+(y2-y1)*(region.xul-x1) div (x2-x1);
					x1:=region.xul;
				end else if ocu1.ocs.code1 then
					begin
						x1:=x1+(x2-x1)*(region.yul-y1) div (y2-y1);
						y1:=region.yul;
					end else if ocu1.ocs.code2 then
						begin
							y1:=y1+(y2-y1)*(region.xlr-x1) div (x2-x1);
							x1:=region.xlr;
						end else if ocu1.ocs.code3 then
							begin
								x1:=x1+(x2-x1)*(region.ylr-y1) div (y2-y1);
								y1:=region.ylr;
							end;

			SetOutCodes(ocu1,x1,y1);
			Inside:=(ocu1.OutCodes or ocu2.OutCodes)=0;
			Outside:=(ocu1.OutCodes and ocu2.OutCodes)<>0;
		end;

	Clip2D:=inside
end;}

function Clip2D(x1,y1,x2,y2:integer):boolean;ASSEMBLER;
ASM
	push	bp

	mov		bx,x1
	mov		cx,y1
	mov		si,x2
	mov		di,y2

@@doclip:
	cmp	bx,si			{is the line vertical?}
	je	@@vert

	cmp	cx,di
	je	@@horz		{or horizontal?}

{------------------------------}
	xor	al,al

	test	cx,cx
	jns	@no1
	or	al,0001b
	jmp	@dox

@no1:
	cmp	cx,200
	jl	@dox
	or	al,0010b

@dox:
	test	bx,bx
	jns	@no2
	or	al,0100b
	jmp	@no3

@no2:
	cmp	bx,LINE_WIDTH
	jl	@no3
	or	al,1000b

@no3:

{----------------------------}

	xor	ah,ah

	test di,di
	jns	@no1_
	or	ah,0001b
	jmp	@dox_

@no1_:
	cmp	di,199
	jl	@dox_
	or	ah,0010b

@dox_:
	test	si,si
	jns	@no2_
	or	ah,0100b
	jmp	@no3_

@no2_:
	cmp	si,LINE_WIDTH
	jl	@no3_
	or	ah,1000b

@no3_:
{----------------------------}

	mov	dl,al			{don't draw if the line is fully}
	and	dl,ah			{outside the screen (outcodes}
	jnz	@@outside		{have at least 1 same bit set}

	mov	dl,al
	or	dl,ah			{if both outcodes are zero, the line}
	jz	@@done			 {is completely on screen}

	test	al,al
	jnz	@@cp1
	mov	al,ah			{ swap points if point 1 doesn't need}
	xchg	bx,si		{	 clipping}
	xchg	cx,di

@@cp1:
	mov	bp,ax			{ bp = outcode for point 1}

	test	al,0001b
	jz	@@no11

	mov	ax,si			{ outcode AND 1 != 0 --> point is}
	sub	ax,bx			{ above the window}
	neg	cx
	imul	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (0-y1) / (y2-y1)}
	idiv	cx
	add	bx,ax

	xor	cx,cx			{ y1 = 0}

	jmp	@@no12


@@no11:
	test	bp,0010b
	jz	@@no12

	mov	ax,si			{ outcode AND 2 != 0 --> point is}
	sub	ax,bx			{below the window}
	mov	dx,199
	sub	dx,cx
	imul	dx
	neg	cx
	add	cx,di			{ x1 = x1 + (x2-x1) * (yMax-y1)}
	idiv	cx			{	/ (y2-y1)}
	add	bx,ax

	mov	cx,199		{ y1 = yMax}


@@no12:
	cmp	bx,si
	je	@@horz

	test	bp,0100b
	jz	@@no13

	mov	ax,di			{ outcode AND 4 != 0 --> point is}
	sub	ax,cx			{ to left of the window}
	neg	bx
	imul	bx
	add	bx,si
	idiv	bx			{y1 = y1 + (y2-y1) * (0-x1) / (x2-x1)}
	add	cx,ax

	xor	bx,bx			{x1 = 0}

	jmp	@@doclip


@@no13:
	test	bp,1000b
	jz	@@doclip

	mov	ax,di			{ outcode AND 8 != 0 --> point is}
	sub	ax,cx			{ to right of the window}
	mov	dx,319
	sub	dx,bx
	imul	dx
	neg	bx
	add	bx,si
	idiv	bx			{ y1 = y1 + (y2-y1) * (xMax-x1)}
	add	cx,ax			{	/ (x2-x1)}

	mov	bx,319		{x1 = xMax}

	jmp	@@doclip

@@outside:
	mov	ax,FALSE
	pop bp
	jmp	@@exit

@@vert:
	{ vertical line}
	cmp	cx,di
	jle	@@v1			{swap endpoints if y2<y1}
	xchg	cx,di
	xchg	bx,si

@@v1:
	test	di,di
	js	@@outside		{is the line completely outside the}
	cmp	cx,200		{ screen?}
	jge	@@outside
	cmp	bx,LINE_WIDTH		{ in X direction?}
	jae	@@outside

	cmp	di,200
	jl	@@v2
	mov	di,199

@@v2:
	test	cx,cx
	jns	@@done
	xor	cx,cx
	jmp	@@done


@@horz:
	{ horizontal line}
	cmp	bx,si
	jle	@@h1			{swap endpoints if x2<x1}

	xchg	bx,si
	xchg	cx,di

@@h1:
	test	si,si
	js	@@outside		{is the line completely outside the}
	cmp	bx,LINE_WIDTH			{ screen?}
	jge	@@outside
	cmp	cx,200		{in Y direction?}
	jae	@@outside

	cmp	si,LINE_WIDTH
	jl	@@h2
	mov	si,319

@@h2:
	test	bx,bx
	jns	@@done
	xor	bx,bx


@@done:
	pop		bp

	mov		c_x1,bx
	mov		c_y1,cx
	mov		c_x2,si
	mov		c_y2,di

	mov al,TRUE

@@exit:
END;

{$F+}

procedure FCopy;
begin
	frame;
	if Test8087>0 then
		ASM
			PUSH	DS
			MOV		CX,vRAMSize
			SHR		CX,6 {/64}
			LES		DI,VGA
			LDS		SI,PvRAM

@1:
			FILD	QWORD([SI])
			FILD	QWORD([SI+8])
			FILD	QWORD([SI+16])
			FILD	QWORD([SI+24])
			FILD	QWORD([SI+32])
			FILD	QWORD([SI+40])
			FILD	QWORD([SI+48])
			FILD	QWORD([SI+56])
			FXCH
			FISTP	QWORD(ES:[DI+48])
			FISTP	QWORD(ES:[DI+56])
			FISTP	QWORD(ES:[DI+40])
			FISTP	QWORD(ES:[DI+32])
			FISTP	QWORD(ES:[DI+24])
			FISTP	QWORD(ES:[DI+16])
			FISTP	QWORD(ES:[DI+8])
			FISTP	QWORD(ES:[DI])

			ADD		SI,64
			ADD		DI,64
			DEC		CX
			JNZ		@1
			POP		DS
		END
	else
		ASM
			PUSH		DS
			CLD
			MOV			CX,vRAMSize
			SHR			CX,2
			LES			DI,VGA
			LDS			SI,PvRAM
			REP;		DB _386;MOVSW
			POP			DS
	 END;
end;

var
	index:word;

procedure FCopyHalf;
begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			DI,index
		ADD			DI,DI
		MOV			DI,WORD(MultByWidth[DI])

		MOV			ES,SegA000
		MOV			DS,vRAM

		MOV			DX,200/2{}
		MOV			SI,4
		MOV			BP,LINE_WIDTH

@Y:
		MOV			CX,LINE_WIDTH/4

@X:                   {ALIGN 16}
		DB			_386;MOV		AX,[DI]
		DB			_386;MOV		ES:[DI],AX

		ADD			DI,SI
		DEC			CX
		JNZ			@X

		ADD			DI,BP
		DEC			DX
		JNZ			@Y

		POP			DS
		POP			BP

		XOR			index,1
	END;
end;

procedure FCopyClear;
begin
	frame;

	ASM
		PUSH		DS

		DB			_386;MOV	 	BX,WORD(BackGroundColor)
		MOV			CX,vRAMSize
		SHR			CX,2
		MOV			DX,4

		MOV			ES,SegA000
		LDS			SI,PvRAM

@BUCLE:               {ALIGN 16}
		DB			_386;MOV		AX,[SI]
		DB			_386;MOV		[SI],BX
		DB			_386;MOV		ES:[SI],AX

		ADD			SI,DX

		DEC			CX
		JNZ			@BUCLE

		POP			DS
	END;
end;

procedure FCopyClearBack;
begin
	frame;

	ASM
		PUSH		DS

		MOV			CX,vRAMSize
		SHR			CX,2
		MOV			DX,4
		MOV			BX,0

		MOV			ES,SegA000
		MOV			AX,BackPage
		DW			MOV_GS_AX
		MOV			DS,vRAM

@BUCLE:               {ALIGN 16}
		DB			_386;MOV		AX,[BX]
		DB			_386;MOV    ES:[BX],AX
		DW			GS_386;MOV	AX,[BX]
		DB			_386;MOV		[BX],AX

		ADD			BX,DX
		DEC			CX
		JNZ			@BUCLE

		POP			DS
	END;
end;

procedure FHalfCopyClearBack;
begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			BX,index
		ADD			BX,BX
		MOV			BX,WORD(MultByWidth[BX])

		MOV			ES,SegA000
		MOV			AX,BackPage
		DW			MOV_GS_AX
		MOV			DS,vRAM

		MOV			CH,200/2{}
		MOV			DX,4
		MOV			BP,LINE_WIDTH

@Y:
		MOV			CL,LINE_WIDTH/4

@X:               {ALIGN 16}
		DB			_386;MOV		AX,[BX]
		DB			_386;MOV    ES:[BX],AX
		DW			GS_386;MOV	AX,[BX]
		DB			_386;MOV		[BX],AX

		ADD			BX,DX
		DEC			CL
		JNZ			@X

		ADD			BX,BP
		DEC			CH
		JNZ			@Y

		POP			DS
		POP			BP

		XOR			index,1
	END;
end;

procedure FCopyClearHalf;
begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			DI,index
		ADD			DI,DI
		MOV			DI,WORD(MultByWidth[DI])

		DB			_386;MOV		 BX,WORD(BackGroundColor)

		MOV			ES,SegA000
		MOV			DS,vRAM

		MOV			DX,200/2{}
		MOV			SI,4
		MOV			BP,LINE_WIDTH

@Y:
		MOV			CX,LINE_WIDTH/4

@X:                   {ALIGN 16}
		DB			_386;MOV		AX,[DI]
		DB			_386;MOV		[DI],BX
		DB			_386;MOV		ES:[DI],AX

		ADD			DI,SI
		DEC			CX
		JNZ			@X

		ADD			DI,BP
		DEC			DX
		JNZ			@Y

		POP			DS
		POP			BP

		XOR			index,1
	END;
end;

procedure FShade;ASSEMBLER;
ASM
	LES			DI,PvRAM
	MOV			CX,vRAMSize
	SHR			CX,2
	MOV			DX,4
	MOV			BH,0

@BUCLE:               {ALIGN 16}
	MOV			BL,BYTE(ES:[DI+2])
	MOV			AL,BYTE(ShadeTable[BX])

	MOV			BL,BYTE(ES:[DI+3])
	MOV			AH,BYTE(ShadeTable[BX])

	DB			_386;SHL		AX,16

	MOV			BL,BYTE(ES:[DI])
	MOV			AL,BYTE(ShadeTable[BX])

	MOV			BL,BYTE(ES:[DI+1])
	MOV			AH,BYTE(ShadeTable[BX])

	DB			_386;MOV		ES:[DI],AX
	ADD			DI,DX

	DEC			CX
	JNZ			@BUCLE
END;

procedure FHalfShade;ASSEMBLER;
ASM
	PUSH		BP

	MOV			ES,vRAM

	MOV			DI,index
	ADD			DI,DI
	MOV			DI,WORD(MultByWidth[DI])

	MOV			DX,4
	MOV			BH,0
	MOV			BP,LINE_WIDTH
	MOV			CH,200/2{}

@Y:
	MOV			CL,LINE_WIDTH/4

@X:                    {ALIGN 16}
	MOV			BL,BYTE(ES:[DI+2])
	MOV			AL,BYTE(ShadeTable[BX])

	MOV			BL,BYTE(ES:[DI+3])
	MOV			AH,BYTE(ShadeTable[BX])

	DB			_386;SHL		AX,16

	MOV			BL,BYTE(ES:[DI])
	MOV			AL,BYTE(ShadeTable[BX])

	MOV			BL,BYTE(ES:[DI+1])
	MOV			AH,BYTE(ShadeTable[BX])

	DB			_386;MOV		ES:[DI],AX
	ADD			DI,DX

	DEC			CL
	JNZ			@X

	ADD			DI,BP

	DEC			CH
	JNZ			@Y

	POP			BP

	XOR			index,1
END;

procedure FFlame;ASSEMBLER;
ASM
	PUSH		DS
	MOV			DI,LINE_WIDTH
	MOV			CX,vRAMSize
	SUB			CX,LINE_WIDTH*2
	MOV			AH,0

	MOV			DS,vRAM

@BUCLE:                  {ALIGN 16}
	MOV			AL,[DI-1]
	MOV			BX,AX
	MOV			AL,[DI+1]
	ADD			BX,AX
	MOV			AL,[DI+LINE_WIDTH]
	ADD			BX,AX
	MOV			AL,[DI-LINE_WIDTH]
	ADD			BX,AX
	SHR			BX,2
	JZ			@CERO
	DEC			BL

@CERO:
{	MOV			BL,BYTE(ShadeTable[BX])}
	MOV			[DI],BL
	INC			DI

	DEC			CX
	JNZ			@BUCLE

	POP			DS
END;

procedure FHalfFlame;ASSEMBLER;
ASM
	PUSH		DS

	MOV			DI,index
	INC			DI
	ADD			DI,DI
	MOV			DI,WORD(MultByWidth[DI])

	MOV			DS,vRAM

	MOV			AH,0
	MOV			DX,(200/2)-1

@Y:
	MOV			CX,LINE_WIDTH{}

@X:                    {ALIGN 16}
	MOV			AL,[DI-1]
	MOV			BX,AX
	MOV			AL,[DI+1]
	ADD			BX,AX
	MOV			AL,[DI+LINE_WIDTH]
	ADD			BX,AX
	MOV			AL,[DI-LINE_WIDTH]
	ADD			AX,BX
	SHR			AX,2
	JZ			@CERO
	DEC			AL

@CERO:
	MOV			[DI],AL
	INC			DI

	DEC			CX
	JNZ			@X

	ADD			DI,LINE_WIDTH
	DEC			DX
	JNZ			@Y

	POP			DS

	XOR			index,1
END;

var
	index1:word;

procedure FCopyMesh;
const
	mask:LongInt=$00ff00ff;

begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			ES,SegA000

		MOV			AX,DS
		DW			MOV_GS_AX

		DB			_386;MOV		BP,WORD(mask)

		MOV			DS,vRAM

		MOV			BX,0
		MOV			CH,200{}
		MOV			SI,4

@Y:
		MOV			CL,LINE_WIDTH/4

		DB			GS;XOR			index1,1
		MOV			DI,BX
		DB			GS;ADD			DI,index1

@X:
		DB			_386;MOV		AX,[DI]
		DB			_386;AND		AX,BP
		DB			_386;MOV		ES:[DI],AX

		ADD			DI,SI
		DEC			CL
		JNZ			@X

		ADD			BX,LINE_WIDTH

		DEC			CH
		JNZ			@Y

		POP			DS
		POP			BP

		DB			_386;NOT		WORD(mask)
	END;
end;

procedure FCopyClearMesh;
const
	mask:LongInt=$00ff00ff;

begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			ES,SegA000

		MOV			AX,DS
		DW			MOV_GS_AX

		DB			_386;MOV		DX,WORD(BackGroundColor)
		DB			_386;MOV		BP,WORD(mask)

		MOV			DS,vRAM

		MOV			BX,0
		MOV			CH,200{}
		MOV			SI,4

@Y:
		MOV			CL,LINE_WIDTH/4

		DB			GS;XOR			index1,1
		MOV			DI,BX
		DB			GS;ADD			DI,index1

@X:
		DB			_386;MOV		AX,[DI]
		DB			_386;MOV		[DI],DX
		DB			_386;AND		AX,BP
		DB			_386;MOV		ES:[DI],AX

		ADD			DI,SI
		DEC			CL
		JNZ			@X

		ADD			BX,LINE_WIDTH

		DEC			CH
		JNZ			@Y

		POP			DS
		POP			BP

		DB			_386;NOT		WORD(mask)
	END;
end;

procedure FCopyBackMesh;
const
	mask:LongInt=$00ff00ff;

begin
	frame;

	ASM
		PUSH		BP
		PUSH		DS

		MOV			ES,SegA000

		MOV			AX,DS
		DW			MOV_GS_AX

		MOV			AX,BackPage
		DW			MOV_FS_AX

		DB			_386;MOV		BP,WORD(mask)
		DB			_386;MOV		DX,WORD(BackGroundColor)

		MOV			DS,vRAM

		MOV			BX,0
		MOV			CH,200{}
		MOV			SI,4

@Y:
		MOV			CL,LINE_WIDTH/4

		DB			GS;XOR			index1,1
		MOV			DI,BX
		DB			GS;ADD			DI,index1

@X:
		DB			_386;MOV		AX,[DI]
		DB			_386;MOV		ES:[DI],AX
		DW			FS_386;MOV	AX,[DI]
		DB			_386;AND		AX,BP
		DB			_386;MOV		[DI],AX

		ADD			DI,SI
		DEC			CL
		JNZ			@X

		ADD			BX,LINE_WIDTH

		DEC			CH
		JNZ			@Y

		POP			DS
		POP			BP
		DB			_386;NOT		WORD(mask)
	END;
end;

procedure nothing;
begin
	frame;
end;

procedure FCopyScroll;
var
	m:Pmap;
	a,n:integer;

begin
	ProcessAnimations;

	a:=GetNumOfScrollsFront;
	for n:=a DownTo 1 do
		begin
			m:=GetMapFront(n);
			with m^ do
				if TotalTiles>0 then
					if position=REPEAT_FRONT then
						MakeScroll(m,(n=a) and (a>1))
					else
						if (word(px)<=sx) and (word(py)<=sy) then MakeScroll(m,(n=a) and (a>1));
		end;

	OverScroll;
	FCopy;

	a:=GetNumOfScrollsBack;
	for n:=a DownTo 1 do
		begin
			m:=GetMapBack(n);
			with m^ do
				if TotalTiles>0 then
					if position=REPEAT_BACK then
						MakeScroll(m,(n=a) and (a>1))
					else
						if (word(px)<=sx) and (word(py)<=sy) then MakeScroll(m,(n=a) and (a>1));
		end;
end;

procedure FCopyClearScroll;
var
	m:Pmap;
	a,n:integer;

begin
	ProcessAnimations;

	a:=GetNumOfScrollsFront;
	for n:=a DownTo 1 do
		begin
			m:=GetMapFront(n);
			with m^ do
				if TotalTiles>0 then
					if position=REPEAT_FRONT then
						MakeScroll(m,(n=a) and (a>1))
					else
						if (word(px)<=sx) and (word(py)<=sy) then MakeScroll(m,(n=a) and (a>1));
		end;

	OverScroll;
	FCopyClear;

	a:=GetNumOfScrollsBack;
	for n:=a DownTo 1 do
		begin
			m:=GetMapBack(n);
			with m^ do
				if TotalTiles>0 then
					if position=REPEAT_BACK then
						MakeScroll(m,(n=a) and (a>1))
					else
						if (word(px)<=sx) and (word(py)<=sy) then MakeScroll(m,(n=a) and (a>1));
		end;
end;

procedure FCopyShade;
begin
	FCopy;
	FShade;
end;

procedure FHalfCopyShade;
begin
	Fcopy;
	FHalfShade;
end;

procedure FFlamed;
begin
	FCopy;
	FFlame;
end;

procedure FHalfFlamed;
begin
	FCopy;
	FHalfFlame;
end;

procedure FCopyBlur;
begin
	FFlame;
	FCopy;
end;

procedure FClearBlur;
begin
	FFlame;
	FCopyClear;
end;

procedure FCopyBackBlur;
begin
	frame;

	ASM
		PUSH		DS
		MOV			AH,0
		MOV			DI,LINE_WIDTH
		MOV			CX,vRAMSize
		SUB			CX,LINE_WIDTH*2

		MOV			ES,SegA000
		MOV			DS,vRAM

@BUCLE:                  {ALIGN 16}
		MOV			AL,[DI-1]
		MOV			BX,AX
		MOV			AL,[DI+1]
		ADD			BX,AX
		MOV			AL,[DI+LINE_WIDTH]
		ADD			BX,AX
		MOV			AL,[DI-LINE_WIDTH]
		ADD			AX,BX
		SHR			AX,2
		JZ			@CERO{}
		MOV			ES:[DI],AL

@CERO:
		INC			DI
		DEC			CX
		JNZ			@BUCLE

		POP			DS
	END;

	move(PBackPage^,PvRAM^,vRAMSize);
end;

const
	M_RND=1023;

	dir:array[0..8] of integer=(
		-(LINE_WIDTH+1),-LINE_WIDTH,-LINE_WIDTH-1,
		-1,0,1,
		(LINE_WIDTH-1),LINE_WIDTH,LINE_WIDTH+1);

var
	semilla1,semilla2:word;
	rnd:array[0..M_RND+1] of byte;

procedure FCopyClearGranu;
begin
	frame;

	ASM
		PUSH	BP

		MOV		DX,semilla2
		MOV		DI,semilla1
		AND		DI,M_RND
		LES		BP,PvRAM
		ADD		BP,LINE_WIDTH+1

		MOV		AX,SegA000
		DW		MOV_GS_AX

		MOV		AH,200-3{}
		MOV		BH,0

@Y:
		MOV		CX,LINE_WIDTH-2

@X:
		MOV		SI,BP
		MOV		BL,BYTE(rnd[DI])
		ADD		BX,BX
		ADD	 	SI,WORD(dir[BX])

		INC		DI
		AND		DI,M_RND

		MOV		AL,ES:[SI]
		DB		GS;MOV		[BP],AL

		INC		BP
		DEC		CX
		JNZ		@X

		ADD		BP,2
		DEC		AH
		JNZ		@Y

		MOV		BH,AL
		XOR		BX,DI
		ADD		DX,AX
		XOR		BX,DX
		XOR		DX,SI
		MOV		semilla1,BX
		MOV		semilla2,DX

		POP		BP
	END;

	FillChar(PvRAM^,vRAMSize,GetBackgroundColor);
end;

procedure FCopyBackGranu;
begin
	frame;

	ASM
		PUSH	BP

		MOV		DX,semilla2
		MOV		DI,semilla1
		AND		DI,M_RND
		LES		BP,PvRAM
		ADD		BP,321

		MOV		AX,SegA000
		DW		MOV_GS_AX

		MOV		AH,200-3
		MOV		BH,0

@Y:
		MOV		CX,LINE_WIDTH-2

@X:
		MOV		SI,BP
		MOV		BL,BYTE(rnd[DI])
		ADD		BX,BX
		ADD	 	SI,WORD(dir[BX])

		INC		DI
		AND		DI,M_RND

		MOV		AL,ES:[SI]
		DB		GS;MOV		[BP],AL

		INC		BP
		DEC		CX
		JNZ		@X

		ADD		BP,2
		DEC		AH
		JNZ		@Y

		MOV		BH,AL
		XOR		BX,DI
		ADD		DX,AX
		XOR		BX,DX
		XOR		DX,SI
		MOV		semilla1,BX
		MOV		semilla2,DX

		POP		BP
	END;

	move(PBackPage^,PvRAM^,vRAMSize);
end;

procedure FCopyGranu;
begin
	frame;

	ASM
		PUSH	BP

		MOV		DX,semilla2
		MOV		DI,semilla1
		AND		DI,M_RND
		LES		BP,PvRAM
		ADD		BP,321

		MOV		AX,SegA000
		DW		MOV_GS_AX

		MOV		AH,200-3{}
		MOV		BH,0

@Y:
		MOV		CX,LINE_WIDTH-2

@X:
		MOV		SI,BP
		MOV		BL,BYTE(rnd[DI])
		ADD		BX,BX
		ADD	 	SI,WORD(dir[BX])

		INC		DI
		AND		DI,M_RND

		MOV		AL,ES:[SI]
		DB		GS;MOV		[BP],AL

		INC		BP
		DEC		CX
		JNZ		@X

		ADD		BP,2
		DEC		AH
		JNZ		@Y

		MOV		BH,AL
		XOR		BX,DI
		ADD		DX,AX
		XOR		BX,DX
		XOR		DX,SI
		MOV		semilla1,BX
		MOV		semilla2,DX

		POP		BP
	END;
end;

var
	XArray:array[0..XMAX] of word;
	YArray:array[0..YMAX*2+1] of word;

procedure FDesintegrate;
var
	s:word;

begin
	Fflame;

	ASM
		PUSH	BP

		MOV		AX,BackPage
		DW		MOV_GS_AX

		MOV		ES,vRAM
		MOV		DI,0
		LEA		BP,YArray

		MOV		CH,200

@Y:
		MOV		CL,LINE_WIDTH/2
		LEA		SI,XArray
		DB		_386;MOV	DX,DS:[BP]

@X:        {ALIGN 16}
		DB		_386;MOV	BX,DX
		DB		_386;ADD	BX,[SI]
		MOV		AH,ES:[BX]
		DB		_386;SHR	BX,16
		MOV		AL,ES:[BX]
		DB		GS;MOV	 	[DI],AX

		ADD		DI,2
		ADD		SI,4
		DEC		CL
		JNZ		@X

		ADD		BP,4
		DEC		CH
		JNZ		@Y

		POP		BP
	END;

	s:=vRAM;
	vRAM:=BackPage;
	BackPage:=s;

	frame;
	move(ptr(BackPage,0)^,VGA^,vRAMSize);
end;

procedure FShadeBlur;
begin
	ASM
		PUSH		DS
		MOV			DI,LINE_WIDTH
		MOV			CX,vRAMSize
		SUB			CX,LINE_WIDTH*2
		MOV			AH,0

		MOV			DX,DS
		MOV			ES,DX
		MOV			DS,vRAM

@BUCLE:                  {ALIGN 16}
		MOV			AL,[DI-1]
		MOV			BX,AX
		MOV			AL,[DI+1]
		ADD			BX,AX
		MOV			AL,[DI+LINE_WIDTH]
		ADD			BX,AX
		MOV			AL,[DI-LINE_WIDTH]
		ADD			BX,AX
		SHR			BX,2
		JZ			@CERO
		DEC			AL

@CERO:
		MOV			AL,BYTE(ES:ShadeTable[BX])
		MOV			[DI],AL
		INC			DI

		DEC			CX
		JNZ			@BUCLE

		POP			DS
	END;

	FCopy;
end;

const
	xxa:integer=320;yya:integer=200;

procedure FCopyZoom;
var
	_ax,_ay,
	ancho:integer;
	alto:byte;
	salto:word;

begin
	frame;
	ancho:=320 div xxa;
	alto:=200 div yya;
	_ax:=xxa;
	_ay:=yya;
	ASM
		PUSH	DS

		MOV		SI,ancho
		MOV		BH,0
		MOV		BL,alto
		ADD		BX,BX
		MOV		AX,WORD(MultByWidth[BX])
		MOV		salto,AX

		LES		DI,PvRAM
		MOV		DS,WORD(VGA+2)

		MOV		DX,_ay

@Y:
		PUSH	DX
		PUSH	DI
		MOV		CX,_ax

@X:
		PUSH	CX
		MOV		CX,0
		MOV		DX,SI
		MOV		DH,alto
		MOV		AL,ES:[DI]

@XX:
		MOV		AH,DH
		MOV		BX,CX

@YY:
		MOV		[DI+BX],AL
		ADD		BX,320
		DEC		AH
		JNZ		@YY

		INC		CX
		DEC		DL
		JNZ		@XX

		ADD		DI,SI
		POP		CX
		DEC		CX
		JNZ		@X

		POP		DI
		ADD		DI,salto
		POP		DX
		DEC		DX
		JNZ		@Y

@FIN:
		POP		DS
	END;
end;

procedure FClearZoom;
var
	_ax,_ay,
	ancho:integer;
	alto:byte;
	salto:word;

begin
	frame;
	ancho:=320 div xxa;
	alto:=200 div yya;
	_ax:=xxa;
	_ay:=yya;
	ASM
		PUSH	DS

		MOV		SI,ancho

		MOV		BH,0
		MOV		BL,alto
		ADD		BX,BX
		MOV		AX,WORD(MultByWidth[BX])
		MOV		salto,AX

		LES		DI,PvRAM
		MOV		DS,WORD(VGA+2)

		MOV		DX,_ay

@Y:
		PUSH	DX
		PUSH	DI
		MOV		CX,_ax

@X:
		PUSH	CX
		MOV		CX,0
		MOV		DX,SI
		MOV		DH,alto
		MOV		AL,ES:[DI]

@XX:
		MOV		AH,DH
		MOV		BX,CX

@YY:
		MOV		[DI+BX],AL
		ADD		BX,320
		DEC		AH
		JNZ		@YY

		INC		CX
		DEC		DL
		JNZ		@XX

		ADD		DI,SI
		POP		CX
		DEC		CX
		JNZ		@X

		POP		DI
		ADD		DI,salto
		POP		DX
		DEC		DX
		JNZ		@Y

@FIN:
		POP		DS
	END;
	FillChar(PvRAM^,vRAMSize,0)
end;

procedure FShadeBack;{}
begin
	fShade;
	move(PBackPage^,VGA^,vRAMSize);
	frame;
	ASM
		PUSH	DS
		LES		DI,VGA
		LDS		SI,PvRAM
		MOV		CX,64000

@BUCLE:
		MOV		AL,[SI]
		TEST	AL,AL
		JZ		@CERO
		MOV		ES:[SI],AL

@CERO:
		INC		SI
		DEC		CX
		JNZ		@BUCLE

		POP		DS
	END;
end;

var
	TT:PTransparency;

procedure FSuperBlur;
var
	s:word;

begin
	frame;
	ASM
		PUSH	DS
		LES		DI,TT               {ES=TT}
		MOV		AX,vRAM
		DW		MOV_FS_AX           {FS=PvRAM}
		MOV		DI,0
		MOV		AX,BackPage					{GS=PBackPage}
		DW		MOV_GS_AX
		MOV		DS,SegA000					{DS=SegA000}
		MOV		SI,64000/2

@BUCLE:
		DB		GS;MOV		AX,[DI]
		DB		FS;MOV		DX,[DI]

		MOV		BH,0
		MOV		BL,AL
		MOV		CL,ES:[BX]
		MOV		BL,AH
		MOV		CH,ES:[BX]
		DB		FS;MOV		[DI],CX

		MOV		BL,AL
		MOV		BH,DL
		MOV		CL,ES:[BX]
		MOV		BL,AH
		MOV		BH,DH
		MOV		CH,ES:[BX]
		DB		GS;MOV		[DI],CX

		MOV		[DI],CX
		ADD		DI,2
		DEC		SI
		JNZ		@BUCLE

		POP		DS
	END;

	s:=vRAM;
	vRAM:=BackPage;
	BackPage:=s;

{	PvRAM:=ptr(vRAM,0);
	PBackPage:=ptr(BackPage,0);}
end;

procedure FCopyBig;
const
	ANCHO=5;ALTO=5;

begin
	frame;
	ASM
		PUSH	DS
		LES		DI,VGA
		LDS		SI,pVRAM

		MOV		DX,200/ALTO

@Y:
		PUSH	DI
		MOV		CX,320/ANCHO

@X:
		MOV		AL,[SI]
		ADD		SI,ANCHO

		MOV		ES:[DI+(320*0)+2],AL  {O}

		MOV		ES:[DI+(320*1)+1],AL
		MOV		ES:[DI+(320*1)+2],AL
		MOV		ES:[DI+(320*1)+3],AL  {OOO}

		MOV		ES:[DI+(320*2)+0],AL
		MOV		ES:[DI+(320*2)+1],AL
		MOV		ES:[DI+(320*2)+3],AL
		MOV		ES:[DI+(320*2)+4],AL	{OOOO}

		MOV		ES:[DI+(320*3)+1],AL
		MOV		ES:[DI+(320*3)+2],AL
		MOV		ES:[DI+(320*3)+3],AL  {OOO}

		MOV		ES:[DI+(320*4)+2],AL  {O}

		ADD		DI,ANCHO
		DEC		CX
		JNZ		@X

		POP		DI
		ADD		DI,320*5
		ADD		SI,320*4
		DEC		DX
		JNZ		@Y

		POP		DS
	END;
end;

procedure FCopyClearBig;
const
	ANCHO=5;ALTO=5;

begin
	frame;
	ASM
		PUSH	DS
		MOV		AH,BYTE(BackGroundColor)
		LES		DI,VGA
		LDS		SI,pVRAM

		MOV		DX,200/ALTO

@Y:
		PUSH	DI
		MOV		CX,320/ANCHO

@X:
		MOV		AL,[SI]
		MOV		[SI],AH
		ADD		SI,ANCHO

		MOV		ES:[DI+(320*0)+2],AL  {O}

		MOV		ES:[DI+(320*1)+1],AL
		MOV		ES:[DI+(320*1)+2],AL
		MOV		ES:[DI+(320*1)+3],AL  {OOO}

		MOV		ES:[DI+(320*2)+0],AL
		MOV		ES:[DI+(320*2)+1],AL
		MOV		ES:[DI+(320*2)+3],AL
		MOV		ES:[DI+(320*2)+4],AL	{OOOO}

		MOV		ES:[DI+(320*3)+1],AL
		MOV		ES:[DI+(320*3)+2],AL
		MOV		ES:[DI+(320*3)+3],AL  {OOO}

		MOV		ES:[DI+(320*4)+2],AL  {O}

		ADD		DI,ANCHO
		DEC		CX
		JNZ		@X

		POP		DI
		ADD		DI,320*5
		ADD		SI,320*4
		DEC		DX
		JNZ		@Y

		POP		DS
	END;
end;

{$F-}

var
	old:LongInt;

function StartFrame:integer;
begin
{$IFDEF _SYNCRO_}
	old:=frames;
{$ENDIF}
	MyFrames:=0;
	StartFrame:=1;
end;

function anima:integer;
const
	call:array[TMode] of procedure=(
		nothing,
		FCopy,
		FCopyHalf,
		FCopyClearBack,
		FHalfCopyClearBack,
		FCopyScroll,
		FCopyClearScroll,
		FCopyClear,
		FCopyClearHalf,
		FCopyShade,
		FHalfCopyShade,
		FShadeBack,
		FCopyZoom,
		FClearZoom,
		FFlamed,
		FHalfFlamed,
		FCopyMesh,
		FCopyClearMesh,
		FCopyBackMesh,
		FCopyBlur,
		FClearBlur,
		FCopyBackBlur,
		FCopyGranu,
		FCopyClearGranu,
		FCopyBackGranu,
		FDesintegrate,
		FShadeBlur,
		FSuperBlur,
		FCopyBig,
		FCopyClearBig
		);

var
	g:word;

begin
	call[TransferMode];
{$IFNDEF _SYNCRO_}
	{$IFDEF _DEBUG_}
	{$ENDIF}
{$ENDIF}
	inc(MyFrames);

{$IFDEF _SYNCRO_}
	{$IFDEF _DEBUG_}
	OutNumXY(0,0,15,frames-old);
	{$ENDIF}
	anima:=frames-old;
	old:=frames;
{$ELSE}
	anima:=1;
{$ENDIF}
end;

procedure InitSuperBlur(t:PTransparency);
begin
	TT:=t;
end;

var
	SvRAM,SBack:word;

procedure SetTransferMode(t:TMode);
begin
	if GetTransferMode=DESINTEGRATE then
		begin
			vRAM:=SvRAM;
			BackPage:=SBack;
		end;
	TransferMode:=t;

	if t=DESINTEGRATE then
		begin
			SvRAM:=vRAM;
			SBack:=BackPage;
		end;
	if t=NOP then
		vRAM:=SegA000
	else
		vRAM:=seg(PvRAM^);
end;

function GetTransferMode:TMode;
begin
	GetTransferMode:=TransferMode;
end;

function LoadPCX(n:string;s:pointer;var p:Tpal):boolean;
type
	TPCX=record
		manufacturer,version,encoding,BitsPerPixel:byte;
		XMin,YMin,XMax,YMax,HRes,VRes:word;
		palette:array[0..47] of byte;
		reserved:byte;
		ColorPlanes:byte;
		BytesPerLine:word;
		PalleteType:word;
		filler:array[0..57] of byte;
	end;

var
	f:Tfile;
	header:TPCX;
	VirScr:^byte;

procedure SetPal;
var
	n:integer;
	l:word;

begin
	seek(f,FileSize(f)-SizeOf(p));
	read(f,p,SizeOf(p),l);

	for n:=0 to 255 do with p[n] do
		begin
			red:=(red div 4) and 63;
			green:=(green div 4) and 63;
			blue:=(blue div 4) and 63;
		end;
end;

function ReadPCX:word;
var
	l:word;

begin
	seek(f,SizeOf(TPCX));
	read(f,VirScr^,FileSize(f)-SizeOf(Tpal)-SizeOf(TPCX),l);
	close(f);
	ReadPCX:=l;
end;

function ValidPCX:boolean;
var
	l:word;

begin
	seek(f,0);
	read(f,header,SizeOf(header),l);

	with header do ValidPCX:=(manufacturer=10) and (version=5) and (BitsPerPixel=8) and (ColorPlanes=1);
end;

function ValidPal:boolean;
var
	v:byte;
	l:word;

begin
	seek(f,FileSize(f)-SizeOf(Tpal)-1);
	read(f,v,1,l);

	validPal:=v=$c;
end;

var
	real:word;

begin
	LoadPCX:=FALSE;

	if pos('.',n)=0 then n:=n+'.PCX';
	if (open(f,n,RO)>0) or (not ValidPCX) or (not ValidPal) then close(f);

	if not GetMem(VirScr,vRAMSize) then exit;
	SetPal;
	real:=ReadPCX;
	RLE.decode(VirScr^,s^,real);
	FreeMem(VirScr,vRAMSize);

	if PBackPage<>VGA then move(PBackPage^,PvRAM^,vRAMSize);

	LoadPCX:=TRUE;
end;

function LoadLBM(n:string;d:pointer;var c:Tpal):boolean;
var
	LBMB:byte;
	LBMW:integer;
	LBMFile:Tfile;
	LBMBuffer:array[0..999] of byte;
	LBM_BufferPos,LBM_FinalPos,
	LBMX,LBMY,
	l:word;
	destination:^byte;

 procedure LBM_scanfor(ScanString:string);
 var
	MainPos,ScanPos:word;
	FoundPos:boolean;

 begin
	FoundPos:=FALSE;
	seek(LBMFile,0);
	MainPos:= 0;
	ScanPos:=$ffff;
	read(LBMfile,LBMbuffer,504,l);
	while not FoundPos do
		begin
			inc(ScanPos);
			FoundPos:=(LBMbuffer[ScanPos]=ord(ScanString[1])) and
								(LBMbuffer[ScanPos+1]=ord(ScanString[2])) and
								(LBMbuffer[ScanPos+2]=ord(ScanString[3])) and
								(LBMbuffer[ScanPos+3]=ord(ScanString[4]));

			if (not FoundPos) and (ScanPos>=500) then
				begin
				 seek(LBMfile,FilePos(LBMfile)-4);
				 inc(MainPos,500);
				 ScanPos := $ffff;
				 read(LBMfile,LBMbuffer,504,l);
				end;
		end;

	seek(LBMfile,MainPos+ScanPos+4);
 end;

 procedure LBMGetByte(var DestByte:byte);
 begin
	if LBM_BufferPos>999 then
		begin
			LBM_BufferPos := 1;
			read(LBMfile,LBMbuffer,1000,l);
			Destbyte:=LBMbuffer[0];
		end
	else
		begin
			Destbyte:=LBMbuffer[LBM_BufferPos];
			inc(LBM_BufferPos);
		end;
 end;

begin
	LoadLBM:=FALSE;
	if pos('.',n)=0 then n:=n+'.LBM';
	if open(LBMFile,n,RO)>0 then exit;

	read(LBMfile,LBMbuffer,$18,l);
	move(LBMbuffer[$14],LBMx,2);
	move(LBMbuffer[$16],LBMy,2);
	LBMx:=swap(LBMx);
	LBMy:=swap(LBMy);

	LBM_ScanFor('CMAP');
	seek(LBMfile,filepos(LBMfile)+4);
	read(LBMfile,c,SizeOf(Tpal),l);
	for LBMw:=0 to 255 do
		begin
			c[LBMw].red:=c[LBMW].red shr 2;
			c[LBMw].green:=c[LBMW].green shr 2;
			c[LBMw].blue:=c[LBMW].blue shr 2;
		end;

	LBM_ScanFor('BODY');
	seek(LBMfile,FilePos(LBMfile)+4);

	LBM_FinalPos:=(LBMx+LBMy*LBMx)-320;
	LBM_Bufferpos:=$ffff;

	destination:=d;
	while ofs(destination^)<64000 do
		begin
			LBMGetByte(LBMb);
			if LBMb>=$80 then
				begin
					LBMW:=LBMB;
					LBMGetByte(LBMb);
					for LBMW:=LBMW to $100 do
						begin
							destination^:=LBMb;
							inc(destination);
						end;
				end
			else
				begin
					LBMW:=LBMB;
					while LBMw>=0 do
						begin
							LBMGetByte(LBMB);
							destination^:=LBMb;
							inc(destination);
							dec(LBMw);
						end;
				end;
		end;
	LoadLBM:=TRUE;
end;

procedure FillEllipse(x,y,rx,ry,color:integer);
var
	n,cx1,cx2,xx,yy:integer;

begin
	for n:=DEG-(DEG div 4) to DEG do
		begin
			xx:=round(rx*sin(n*RAD));
			cx1:=x+xx;
			yy:=round(ry*cos(n*RAD));
			cx2:=x-xx;
			DrawH(cx1,y+yy,cx2,color);
			DrawH(cx1,y-yy,cx2,color);
		end;
end;

procedure SetNormalShade;
var
	n:integer;

begin
	for n:=0 to 127 do ShadeTable[n]:=round(n/1.4);
	for n:=0 to 127 do ShadeTable[n+128]:=128+round(n/1.4);
	ShadeTable[1]:=0;
	ShadeTable[129]:=0;
end;

procedure SetShade(factor:double;var palette:Tpal);
var
	fr,fg,fb:double;

	ir, ig, ib,
	absr, absg, absb,
	lowest,coldif:LongInt;
	BestFit:word;
	col,FindCol:integer;

begin
 for col:=0 to 255 do
	 begin
		 fr:=palette[col].red*factor;
		 if fr>63 then fr:=63;

		 fg:=palette[col].green*factor;
		 if fg>63 then fg:=63;

		 fb:=palette[col].blue*factor;
		 if fb>63 then fb:=63;

		 ir:=round(fr);
		 ig:=round(fg);
		 ib:=round(fb);
		 lowest:=655350;
		 for FindCol:=0 to 255 do
			 begin
				 absr:=abs(LongInt(palette[FindCol].red-ir));
				 absg:=abs(LongInt(palette[FindCol].green-ig));
				 absb:=abs(LongInt(palette[FindCol].blue-ib));

				 ColDif:=round(sqrt(sqr(absr)+sqr(absg)+sqr(absb)));
				 if (ColDif<lowest) and (FindCol<>col) then
					 begin
						 lowest:=ColDif;
						 BestFit:=FindCol;
					 end;
			 end;

		 ShadeTable[col]:=BestFit;
	 end;

	ShadeTable[0]:=0;
end;

const
	WaitRaster:boolean=TRUE;

procedure SetSyncro(w:boolean);
begin
	WaitRaster:=w;
end;

function GetSyncro:boolean;
begin
	GetSyncro:=WaitRaster;
end;

const
	INPUT_1=$3DA;

{$IFNDEF _SYNCRO_}
procedure frame;ASSEMBLER;
ASM
	CMP			WaitRaster,FALSE
	JZ			@COL
	MOV			DX,INPUT_1

@RASTER_LO:
	IN			AL,DX
	TEST		AL,8
	JNZ			@RASTER_LO

@RASTER_HI:
	IN			AL,DX
	TEST		AL,8
	JZ			@RASTER_HI

@COL:
	CMP			Pcolors,TRUE
	JNZ			@FIN
	CALL		colors.SetColors
	MOV			Pcolors,FALSE

@FIN:
END;
{$ENDIF}

procedure WaitVR;ASSEMBLER;
ASM
	MOV			DX,INPUT_1

@RASTER_HI:
	IN			AL,DX
	TEST		AL,8
	JZ			@RASTER_HI
END;

procedure WaitDE;ASSEMBLER;
ASM
	MOV			DX,INPUT_1

@RASTER:
	IN			AL,DX
	TEST		AL,8
	JNZ			@RASTER
END;

const
	SC_INDEX=$3C4;

procedure VGAOn;ASSEMBLER;
ASM
	MOV			DX,SC_INDEX
	MOV			AX,$101
	OUT			DX,AX
END;

procedure VGAOff;ASSEMBLER;
ASM
	MOV			DX,SC_INDEX
	MOV			AX,$2101
	OUT			DX,AX
END;

function VGAExist:boolean;ASSEMBLER;
ASM
	MOV			AX,$1A00
	INT			$10

	CMP			AL,$1A
	JNZ			@NO
	MOV			AL,TRUE
	JMP			@FIN

@NO:
	MOV			AL,FALSE

@FIN:
END;

function LoadIMG(n:string;segment:pointer;var p:Tpal):boolean;
var
	cab:array[0..2] of char;
	f:Tfile;
	l:word;

begin
	LoadIMG:=FALSE;

	if pos('.',n)=0 then n:=n+'.IMG';
	if open(f,n,RO)>0 then exit;

	read(f,cab,SizeOf(cab),l);
	if cab<>'IMG' then
		begin
			close(f);
			exit;
		end;

	read(f,p,SizeOf(p),l);
	for l:=0 to 255 do with p[l] do
		begin
			red:=red and 63;
			green:=green and 63;
			blue:=blue and 63;
		end;
	read(f,segment^,320*200,l);
	close(f);

	LoadIMG:=TRUE;
end;

function LoadTransparency(var t:PTransparency;n:string):boolean;
var
	cab:array[0..11] of char;
	f:Tfile;
	l:word;

begin
	LoadTransparency:=FALSE;

	if pos('.',n)=0 then n:=n+'.TRN';
	if open(f,n,RO)>0 then exit;


	if not GetMem(t,SizeOf(Tsegment)) then
		begin
			close(f);
			exit;
		end;

	read(f,cab,SizeOf(cab),l);
	if cab<>'TRANSPARENCY' then
		begin
			close(f);
			exit;
		end;

	read(f,t^,SizeOf(Tsegment),l);
	close(f);

	for l:=0 to 255 do
		begin
{			t^[l,l]:=l;
			t^[l,0]:=l;}
			t^[0,l]:=l;
		end;

	LoadTransparency:=TRUE;
end;

procedure FreeTransparency(var t:PTransparency);
begin
	FreeMem(t,SizeOf(Tsegment));
end;

procedure SetBackgroundColor(n:byte);
var
	tmp:LongInt;

begin
	tmp:=word(n shl 8)+n;
	BackGroundColor:=LongInt(tmp shl 16)+tmp;
end;

function GetBackgroundColor:byte;
begin
	GetBackGroundColor:=byte(BackGroundColor);
end;

procedure SetDesintegrate(f:integer);
var
	n:integer;

begin
	if f<0 then exit;

	for n:=0 to XMAX do 
		Xarray[n]:=round(n/XMAX*(XMAX-(2*f))+f);
	for n:=0 to YMAX do
		begin
			Yarray[n*2]:=round(n/YMAX*(YMAX-(2*f))+f)*LINE_WIDTH;
			Yarray[n*2+1]:=round(n/YMAX*(YMAX-(2*f))+f)*LINE_WIDTH;
		end;
end;

procedure delay(m:double);
const
	MAGIC=70/1000;

var
	n:integer;

begin
	for n:=1 to round(m*MAGIC) do
		begin
			WaitDE;
			WaitVR;
		end;
end;

procedure SetZoom(x:integer);
const
	d:array[1..7] of integer=(5,10,20,40,80,160,320);

var
	n:integer;
	ok:boolean;

begin
	ok:=FALSE;
	for n:=1 to high(d) do if x=d[n] then
		begin
			ok:=TRUE;
			break;
		end;
	if not ok then exit;

	xxa:=x;
	yya:=round(x*0.625);
end;

procedure SortPal(var p:Tpal);
var
	n,m:integer;
	x:double;
	xx:byte;
	tmp:array[0..255] of double;

begin
	for n:=0 to 255 do
		begin
			tmp[n]:=sqrt(sqr(p[n].red)+sqr(p[n].green)+sqr(p[n].blue));
			ShadeTable[n]:=n;
		end;
	for m:=0 to 255 do
		for n:=m+1 to 255 do
			begin
				if tmp[n]<tmp[m] then
					begin
						x:=tmp[m];
						tmp[m]:=tmp[n];
						tmp[n]:=x;

						xx:=ShadeTable[m];
						ShadeTable[m]:=ShadeTable[n];
						ShadeTable[n]:=xx;
					end;
			end;
end;

const
	save:pointer=NIL;

procedure SetDirect(b:boolean);
begin
	if b then
		begin
			save:=PvRAM;
			PvRAM:=VGA;
			vRAM:=SegA000;
		end
	else if save<>NIL then
		begin
			PvRAM:=save;
			vRAM:=seg(save^);
		end;
end;

const
	FPS=70;

	TIMEOUT:word=5; 	 							{ number of interrupts per frame}
	TIMESLACK:integer=-20;    			{ interrupt timer slack}
	EXECBIOSTIMER:boolean=TRUE; 		{ still execute bios timer interrupt?}
	TimerProc:procedure=NIL;

var
	TimerCount:integer;
	TimeSet,BiosCount:word;
	Int08Save:procedure;
	TimerInstalled:boolean;

procedure TimerHandler;INTERRUPT;ASSEMBLER;
asm
	cli
	inc		timercount
	mov		ax,TIMEOUT
	cmp		timercount,ax
	jb		@noretrace
	mov		timercount,0

	{wait for a vertical retrace}
	mov		dx,$3DA
@vblank:
	in		al,dx
	test	al,8
	jz		@vblank

	{set timer again}
	mov		al,$36
	out		$43,al
	jmp		@1

@1:
	mov		ax,TimeSet
	out		$40,al
	jmp		@2

@2:
	mov		al,ah
	out		$40,al

	{should we call user-defined hook?}
	mov		ax,WORD PTR TimerProc
	or		ax,WORD PTR TimerProc+2
	jz		@nouserproc
	sti
	call	DWORD PTR TimerProc
	cli
@nouserproc:

	cmp		execbiostimer,FALSE
	je		@nobiostimer
	mov		ax,TimeSet
	add		BiosCount,ax
	jno		@nobiostimer
	sti
	pushf
	call	DWORD PTR Int08Save
	jmp		NEAR PTR @xit
@nobiostimer:

@noretrace:
	mov		al,$20
	out		$20,al
	sti
@xit:
end;

function GetTime : word; assembler;
{Find time between two vertical retraces...}
asm
	mov		dx,$3DA   {wait for a vertical retrace to begin}
@wait1a:
	in		al,dx
	test	al,8
	jnz		@wait1a

@wait1b:
	in		al,dx
	test	al,8
	jz		@wait1b

	mov		al,$36
	out		$43,al
	xor		al,al		{ reset the timer }
	out		$40,al
	out		$40,al

	mov		dx,$3DA   {wait for a new vertical retrace to begin}
@wait2a:
	in		al,dx
	test	al,8
	jnz		@wait2a

@wait2b:
	in		al,dx
	test	al,8
	jz		@wait2b

	xor		al,al
	out		$43,al
	in		al,$40
	mov		ah,al
	in		al,$40		{ read timer count - time between }
	xchg	al,ah       { two Vertical Retraces }
	neg		ax
end;

function SyncTimerToVBLANK : word; assembler;
const
	FRAMEPERCENT=950; 		{returned time will be 97.5% of measured value}

asm
@GetFrameTime:
	cli										{ Don't bother us while timing things }
	call	GetTime
	push	ax
	call	GetTime
	pop		dx
	sti
	sub		dx,ax
	cmp  	dx,5            { If the difference between the two }
	jg		@GetFrameTime   { values read was >5, read again }
	cmp		dx,-5
	jl		@GetFrameTime

	mov		bx,FRAMEPERCENT
	mul		bx
	mov		bx,1000
	div		bx
	shr		ax,1
end;

procedure SetTimerInterrupt;
BEGIN
	timercount:=0;
	TimeSet:=$FFFF;
	GetIntVec($08,@Int08Save);
	SetIntVec($08,@TimerHandler);
	if TIMEOUT<>0 then
		TimeSet:=($1234DD div FPS div TIMEOUT)+TIMESLACK
	else
		TimeSet:=SyncTimerToVBLANK;
	SetTimer(TimeSet);
	TimerInstalled:=TRUE;
	WaitRaster:=FALSE;
end;

procedure RestoreTimerInterrupt;
begin
	if not TimerInstalled then exit;
	SetIntVec($08,@Int08Save);
	SetTimer(0);
	TimerInstalled:=FALSE;
	WaitRaster:=TRUE;
end;

procedure ScanLines(n:word);ASSEMBLER;
ASM
	MOV	DX,$3D4
	MOV	AX,9
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	AND	AL,$E0
	ADD	AX,n
	OUT	DX,AL
END;

var
	n:word;

begin
	VGA:=ptr(SegA000,0);
	PvRAM:=VGA;PBackPage:=VGA;
	vRAM:=seg(PvRAM^);BackPage:=seg(PBackPage^);

	for n:=0 to high(rnd) do rnd[n]:=random(9);
	semilla1:=random(high(rnd));
	semilla2:=random(high(rnd));

	SetNormalShade;
	SetDesintegrate(15);
end.