unit mouse;

INTERFACE

const
	MCGACursor:array[0..1,0..15] of word=
		(
			(	$0FFF,$07FF,$03FF,$01FF,$00FF,$007F,
				$007F,$007F,$007F,$C0FF,$E0FF,$E0FF,
				$FFFF,$FFFF,$FFFF,$FFFF),

			(	$0000,$6000,$5000,$4800,$4400,$4200,
				$4100,$7700,$1200,$0A00,$0E00,$0000,
				$0000,$0000,$0000,$0000));

	PointingHandCursor:array[0..1,0..15] of word=
		(
			(	$F2FF,$E1FF,$E1FF,$E1FF,$E1FE,$E000,
				$E000,$E000,$8000,$0000,$0000,$0000,
				$0000,$0000,$0000,$8001),

			(	$0C00,$1200,$1200,$1200,$1200,$13FE,
				$1249,$1249,$7249,$9001,$9001,$9001,$8001,
				$8001,$8001,$7FFE));

	MOUSE_MOVED=1;
	LEFT_BUTTON_PRESSED=2;LEFT_BUTTON_UNPRESSED=4;
	RIGHT_BUTTON_PRESSED=8;RIGHT_BUTTON_UNPRESSED=16;
	MIDDLE_BUTTON_PRESSED=32;MIDDLE_BUTTON_UNPRESSED=64;

type
	TButton=(M_NOP,M_LEFT,M_RIGHT,M_DUAL);

function init:boolean;
{devuelve FALSE si no hay ratn}

procedure on;
{muestra el cursor del ratn}

procedure off;
{oculta el cursor del ratn}

procedure read(var x,y:integer;var estado:TButton);
{devuelve las coordenadas X e Y y el estado de los botones}

procedure XY(x,y:integer);
{pone el cursor del ratn en la posicin XY}

procedure info(boton:integer;var pulsaciones,x,y:integer;var estado:TButton);
{devuelve las coordenadas XY y los valores del BOTON, nmero de veces pulsado y estado}

procedure window(x,y,x1,y1:integer);
{crea una ventana de lmites para el ratn}

procedure graph(x,y:integer;var sprite);
{cambia la forma del cursor del ratn en modo grfico dir=direccin del grafico}

procedure count(var x,y:integer);

procedure success(mascara:integer;rutina:pointer);

procedure SetMickeys(x,y:integer);

function MouseExist:boolean;

IMPLEMENTATION

const
	me:boolean=FALSE;

function init:boolean;ASSEMBLER;
ASM
	MOV		AX,0
	INT		$33
	CMP		AX,$FFFF
	JE		@SIGUE
	MOV		AL,FALSE

@SIGUE:
	MOV   me,AL
END;

procedure on;ASSEMBLER;
ASM
	MOV		AX,1
	INT		$33
END;

procedure Off;ASSEMBLER;
ASM
	MOV		AX,2
	INT		$33
END;

procedure read(var x,y:integer;var estado:TButton);ASSEMBLER;
ASM
	MOV		AX,3
	INT		$33

	LES		DI,x
	MOV		ES:[DI],CX

	LES		DI,y
	MOV		ES:[DI],DX

	LES		DI,estado
	MOV		ES:[DI],BL
END;

procedure XY(x,y:integer);ASSEMBLER;
ASM
	MOV		AX,4
	MOV		CX,x
	MOV		DX,y
	INT		$33
END;

procedure info(boton:integer;var pulsaciones,x,y:integer;var estado:TButton);ASSEMBLER;
ASM
	MOV		AX,5
	MOV		BX,5
	INT		$33

	LES		DI,estado
	MOV		ES:[DI],AL

	LES		DI,pulsaciones
	MOV		ES:[DI],BX

	LES		DI,x
	MOV		ES:[DI],CX

	LES		DI,y
	MOV		ES:[DI],DX
END;

procedure window(x,y,x1,y1:integer);ASSEMBLER;
ASM
	MOV		AX,7
	MOV		CX,x
	MOV		DX,x1
	INT		$33

	MOV		AX,8
	MOV		CX,y
	MOV		DX,y1
	INT		$33
END;

procedure graph(x,y:integer;var sprite);ASSEMBLER;
ASM
	MOV		AX,9
	MOV		BX,x
	MOV		CX,y
	LES		DX,sprite
	INT		$33
end;

procedure count(var x,y:integer);ASSEMBLER;
ASM
	MOV		AX,$b
	INT		$33

	LES		DI,x
	MOV		ES:[DI],CX

	LES		DI,y
	MOV		ES:[DI],BX
END;

procedure success(mascara:integer;rutina:pointer);ASSEMBLER;
ASM
	MOV			AX,$c
	MOV			CX,mascara
	LES			DX,rutina
	INT			$33
END;

procedure SetMickeys(x,y:integer);ASSEMBLER;
ASM
	MOV			AX,$f
	MOV			CX,x
	MOV			DX,y
	INT			$33
END;

function MouseExist:boolean;
begin
	MouseExist:=me;
end;

end.