unit MyMidas;

INTERFACE

uses colors;

const
	NO_COMMAND=0;
	FLASH=1;
	NEXT_EFFECT=2;
	BEGIN_MODULE=3;
	END_MODULE=4;
	FADE=5;

	frames:LongInt=0;
	IsPlaying:boolean=FALSE;

type
	Tsample=record
		handle,channel,frequency:word;
		volume:0..64;
		panning:-40..40;
	end;

function init(c:integer):boolean;
{Elige tarjeta de sonido y se le pasa el total decanales,
si se apret ESC o tarjeta incorrecta, devuelve FALSE}

procedure done;
{Libera la memoria e interrupciones}

function LoadModule(n:string):boolean;
{Lee el mdulo n}

function PlayModule:boolean;
{Toca el mdulo}

procedure StopModule;
{Para la msica y libera el mdulo}


procedure SetScreenSyncro(temp:word);
{Cambia la frecuencia del timer a la indicada}

function GetScreenSyncro:word;
{Devuelve la frecuencia actual de la pantalla}

procedure StopScreenSyncro;
{Para la sincronizacin del timer con la pantalla}


procedure InkAllRGB(p,u:integer;var c:Tpal);
{Cambia los colores antes del barrido}

function GetSemaphore(c:integer):integer;
{Devuelve el semaforo del pattern actual, c=0..NumChannelsModule-1, si se devuelve -1 no hay semforo}

function GetPattern:integer;

procedure delay(s:double);
{Hace una espera de s segundos}


function LoadSample(var s:Tsample;n:string):boolean;
{Carga un sample}

procedure FreeSample(var s:Tsample);
{Libera el handle ocupado por un sample}

procedure PlaySample(var s:Tsample);
{Toca un sample}


procedure GeneralVolume(v:integer);
{Cambia el volumen global}

IMPLEMENTATION

uses
{$IFDEF _LZ_}
	LZFiles,
{$ELSE}
	{$IFDEF _RLE_}
	RLEFiles,
	{$ELSE}
	files,
{$ENDIF}
{$ENDIF}
	midas,Mplayer,Mconfig,timer,Sdevice,
{$IFDEF _MOD_}
	ModP,
{$ELSE}
{$IFDEF _S3M_}
	S3M,
{$ELSE}
{$IFDEF _MTM_}
	MTM,
{$ENDIF}
{$ENDIF}
{$ENDIF}
	strings,DOS;

const
	TotalChannels:word=4;

type
	TRWAV=record
		magic:array[0..3] of char;	{RIFF}
		LengthOfNextChunk:LongInt;

		dID:array[0..3] of char;   	{WAVE}
		fID,												{fmt}
		ChunkLength:LongInt;
		tag,
		channels,
		frequency,f,
		align,
		format:word;

		id:array[0..3] of char;			{data}
		length:LongInt;
	end;

var
	module:PmpModule;
	info:PmpInformation;
	MP:PModulePlayer;
	SD:PSoundDevice;

	NumTicks:word;
	AnteriorDelay:pointer;

procedure ChangePage;FAR;
begin
	inc(frames);
end;

procedure ChangeColors;FAR;
begin
	if PColors then
		begin
			SetColors;
			Pcolors:=FALSE;
		end;
end;


function init(c:integer):boolean;
begin
	init:=FALSE;

	MidasSetDefaults;                   {set MIDAS defaults}
	if MidasConfig=0 then exit;         {set configuration, 0=ESC}

	TotalChannels:=c;
	MidasInit;
	SD:=MidasSD;                        {copy Sound Device pointer}
	MidasOpenChannels(TotalChannels);

	init:=TRUE;
end;

procedure done;
begin
{$IFDEF _SYNCRO_}
	TmrStopScrSync;
{$ENDIF}
	TmrClose;
	MidasClose;                         {uninitialize MIDAS}
end;

function LoadModule(n:string):boolean;
var
	str:array[0..256] of char;

begin
	StrPCopy(str,n);

{$IFDEF _MOD_}
	module:=MidasLoadModule(str,@mpMOD,NIL);
{$ELSE}

	{$IFDEF _S3M_}
	module:=MidasLoadModule(str,@mpS3M,NIL);
	{$ELSE}

		{$IFDEF _MTM_}
	module:=MidasLoadModule(str,@mpMTM,NIL);
		{$ENDIF}
	{$ENDIF}
{$ENDIF}

	LoadModule:=module<>NIL;
end;

function PlayModule:boolean;
begin
	PlayModule:=FALSE;
	MidasPlayModule(module,0);         	{ start playing }
	MP:=MidasMP;
	if MP=NIL then exit;

{$IFDEF _SYNCRO_}
	SetScreenSyncro(GetScreenSyncro);
{$ENDIF}
	IsPlaying:=TRUE;
	PlayModule:=TRUE;
end;

procedure StopModule;
begin
	MidasStopModule(module);            { stop playing }
	MidasFreeModule(module);            { deallocate module }
	IsPlaying:=FALSE;
end;


procedure SetScreenSyncro(temp:word);
begin
	TmrSyncScr(temp,@ChangePage,NIL,@ChangeColors);
end;

function GetScreenSyncro:word;
var
	temp:word;

begin
	TmrGetScrSync(@temp);
	GetScreenSyncro:=temp;
end;

procedure StopScreenSyncro;
begin
	TmrStopScrSync;
end;


function GetSemaphore(c:integer):integer;
const
	CI=#8;

begin
	MP^.GetInformation(@info);

	with info^,chans^[c] do
		if command=CI then
			GetSemaphore:=InfoByte
		else
			GetSemaphore:=-1;
end;

function GetPattern:integer;
begin
	MP^.GetInformation(@info);
	GetPattern:=info^.pattern;
end;


procedure InkAllRGB(p,u:integer;var c:Tpal);
begin
{$IFDEF _SYNCRO_}
	PFrom:=p;PTo:=u;
	PTPal:=@c;
	Pcolors:=TRUE;
{$ELSE}
	colors.InkAllRGB(0,255,c);
{$ENDIF}
end;


procedure MyDelay;INTERRUPT;ASSEMBLER;
ASM
	PUSHF
	CALL		AnteriorDelay
	INC			NumTicks
END;

procedure delay(s:double);
var
	r:word;

begin
	NumTicks:=0;

	MP^.GetInformation(@info);
	r:=round(info^.BPM*s);

	GetIntVec(8,AnteriorDelay);
	SetIntVec(8,@MyDelay);

	while NumTicks<r do;

	SetIntVec(8,AnteriorDelay);
end;

function LoadSample(var s:Tsample;n:string):boolean;
var
	a,l,handle:word;
	f:Tfile;
	buffer:^byte;
	cab:TRWAV;

begin
	LoadSample:=FALSE;

	if pos('.WAV',n)=0 then n:=n+'.WAV';
	if open(f,n,RO)>0 then exit;

	read(f,cab,SizeOf(cab),l);
	if cab.magic<>'RIFF' then
		begin
			close(f);
			exit;
		end;

	l:=FileSize(f)-SizeOf(cab);
	GetMem(buffer,l);
	read(f,buffer^,l,a);
	close(f);

	SD^.AddInstrument(buffer,1,l,0,0,64,0,1,@handle);
	FreeMem(buffer,l);

	s.handle:=handle;
	s.frequency:=cab.frequency;
	s.volume:=63;
	s.panning:=0;
	s.channel:=TotalChannels-1;

	LoadSample:=TRUE;
end;

procedure FreeSample(var s:Tsample);
begin
	SD^.RemInstrument(s.handle);
end;

procedure PlaySample(var s:Tsample);
begin
	with SD^,s do
		begin
			SetInstrument(channel,handle);
			SetVolume(channel,volume);
			SetPanning(channel,panning);
			PlaySound(channel,frequency);
		end;
end;


procedure GeneralVolume(v:integer);
begin
	MP^.SetMasterVolume(v);
end;

end.